
/* --------------------------------------------- */
/*  H8-3069F File access (FAT16/32) function     */
/*                (c) KAZ.Imamura                */
/* --------------------------------------------- */

#ifndef __FAT_H__
#define __FAT_H__

#include "common.h"
#include "ui.h"
#include "usb_ms.h"

extern void fat_20ms_handler(void);
extern int  fat_initialize(void);
extern int  fat_process(void);
extern int  ui_function_fat(UI_COMMAND uicmd);


typedef struct {
	unsigned char fat_type;
	unsigned long fat_BPB_sector;
} MBR_INFORMARION, *P_MBR_INFORMATION;

typedef struct {
	unsigned int  ResvdSecCnt;				// Offset 24 Size 2  
	unsigned int  BytsPerSec;				// Offset 11 Size 2
	unsigned char NumFATs;					// Offset 16 Size 1
	unsigned int  RootEntCnt;				// Offset 17 Size 2 (Only FAT16 has valid data, FAT32 has 0.)
	unsigned int  FATSz16;					// Offset 22 Size 2 FAT size for FAT16
	unsigned int  TotSec16;					// Offset 19 Size 2
	unsigned long TotSec32;					// Offset 32 Size 4
	unsigned char SecPerClus;				// Offset 13 Size 1
											// Only for FAT32
	unsigned long FATSz32;					// Offset 36 Size 2 FAT size for FAT32
} BPB_INFORMARION, *P_BPB_INFORMATION;

#endif
