
/* --------------------------------------------- */
/*  H8-3069F SC-1602 control function            */
/*                (c) KAZ.Imamura                */
/* --------------------------------------------- */

#ifndef __SC1602_H__
#define __SC1602_H__

#include "common.h"

#define MAX_COLUMN 16
#define MAX_LINE   2

extern void sc1602_1ms_handler(void);
extern int sc1602_initialize(void);
extern int sc1602_process(void);
extern int sc1602_set_buffer(unsigned char buf, char *data);
extern int sc1602_set_buffer_cursol(unsigned char buf, char *data);
extern int sc1602_set_buffer_uint8(unsigned char buf, char *data, unsigned char uint8);
extern int sc1602_set_buffer_ulong(unsigned char buf, char *data, unsigned long val);
extern int sc1602_set_buffer_dump (unsigned char buf, unsigned char *data);
extern int sc1602_set_buffer_variable1 (unsigned char buf, unsigned char *data);
extern int sc1602_set_buffer_variable2 (unsigned char buf, unsigned short *data);
extern int sc1602_set_buffer_variable3 (unsigned char buf, unsigned long *data);
extern int sc1602_set_buffer_version (unsigned char buf, unsigned char major, unsigned char minor, unsigned char build);

extern char sc1602_buffer[MAX_LINE][MAX_COLUMN];
extern int  sc1602_buffer_updates[MAX_LINE];


#endif 

