
/* --------------------------------------------- */
/*  H8-3069F SL811HS control function            */
/*                (c) KAZ.Imamura                */
/* --------------------------------------------- */

#ifndef __SL811_H__
#define __SL811_H__

#include "common.h"
#include "ui.h"
#include "key.h"

// ėp`
#define PID_SETUP   0xd0
#define PID_SOF     0x50
#define PID_IN      0x90
#define PID_OUT     0x10


#define DATA0_WR    0x07   // (Arm+Enable+tranmist to Host+DATA0)
#define DATA1_WR    0x47   // (Arm+Enable+tranmist to Host on DATA1)
#define ZDATA0_WR   0x05   // (Arm+Transaction Ignored+tranmist to Host+DATA0)
#define ZDATA1_WR   0x45   // (Arm+Transaction Ignored+tranmist to Host+DATA1)
#define DATA0_RD    0x03   // (Arm+Enable+received from Host+DATA0)
#define DATA1_RD    0x43   // (Arm+Enable+received from Host+DATA1)


#define USB_ACK		1
#define USB_NAK		2
#define USB_STALL	4


#define USB_EP		1
#define USB_TOGGLE	2
#define USB_HDRSIZ	2

#define SL_NUM	1

#define USB_RESET	46
#define USB_SETUP	47
#define USB_GETSPEED	48

#define USB_LOW		1
#define USB_FULL	2

#define DEFAULT_DEVICE_ADDRESS	2




// ----------------------------------------------------
//   Characteristics of request (for bmRequest)
// ----------------------------------------------------
#define DIR_HOST2DEV				0x00
#define DIR_DEV2HOST				0x80

#define USB_REQUEST_TYPE_STANDARD	0x00
#define USB_REQUEST_TYPE_CLASS		0x20

#define RECEIPIENT_DEVICE			0x00
#define RECEIPIENT_INTERFACE		0x01
#define RECEIPIENT_ENDPOINT			0x02

// ----------------------------------------------------
//   Standard Request Codes (for bRequest)
// ----------------------------------------------------
#define REQ_TYPE_GET_STATUS						0x00
#define REQ_TYPE_CLEAR_FEATURE					0x01
#define REQ_TYPE_SET_FEATURE					0x03
#define REQ_TYPE_SET_ADDRESS					0x05
#define REQ_TYPE_GET_DESCRIPTOR					0x06
#define REQ_TYPE_SET_DESCRIPTOR					0x07
#define REQ_TYPE_GET_CONFIG						0x08
#define REQ_TYPE_SET_CONFIG						0x09
#define REQ_TYPE_GET_INTERFACE					0x0a
#define REQ_TYPE_SET_INTERFACE					0x0b
#define REQ_TYPE_SYNCH_FRAME					0x0c

#define REQ_TYPE_GET_MAX_LUN					0xfe
#define REQ_TYPE_MS_RESET						0xff

// ----------------------------------------------------
//   Descriptor Types
// ----------------------------------------------------
#define DESCRIPTOR_TYPE_DEVICE					0x01
#define DESCRIPTOR_TYPE_CONFIG					0x02
#define DESCRIPTOR_TYPE_STRING					0x03
#define DESCRIPTOR_TYPE_INTERFACE				0x04
#define DESCRIPTOR_TYPE_ENDPOINT				0x05
#define DESCRIPTOR_TYPE_DEVICE_QUALIFIER		0x06


// SL811HSWX^
#define SL811HS_USBA_HOSTCTRL		0x00
#define SL811HS_USBA_HOSTBASEADDR	0x01
#define SL811HS_USBA_HOSTBASEDLEN	0x02
#define SL811HS_USBA_HOSTPID		0x03	// ݎ
#define SL811HS_USBA_HOSTSTATUS		0x03	// ǂݏo
#define SL811HS_USBA_HOSTDEVADDR	0x04	// ݎ
#define SL811HS_USBA_HOSTSTLEN		0x04	// ǂݏo
#define SL811HS_CONTROL1			0x05
#define SL811HS_INTENV				0x06
#define SL811HS_USBB_HOSTCTRL		0x08
#define SL811HS_USBB_HOSTBASEADDR	0x09
#define SL811HS_USBB_HOSTBASEDLEN	0x0A
#define SL811HS_USBB_HOSTPID		0x0B	// ݎ
#define SL811HS_USBB_HOSTSTATUS		0x0B	// ǂݏo
#define SL811HS_USBB_HOSTDEVADDR	0x0C	// ݎ
#define SL811HS_USBB_HOSTSTLEN		0x0C	// ǂݏo
#define SL811HS_STATUS				0x0D
#define SL811HS_SOFCOUNTL			0x0E	// ݎ
#define SL811HS_REVISION			0x0E	// ǂݏo
#define SL811HS_SOFCOUNTH			0x0F
#define SL811HS_MEMBUFF				0x10

/*
 * SL811HS WX^erbg
 */
// SL811HS_USB[AB]_HOSTCTRL(0x00,0x08)
#define SL811HS_HOSTCTRL_BIT_ARM	0x01
#define SL811HS_HOSTCTRL_BIT_ENV	0x02
#define SL811HS_HOSTCTRL_BIT_DIR	0x04
#define SL811HS_HOSTCTRL_BIT_ISO	0x10
#define SL811HS_HOSTCTRL_BIT_SOF	0x20
#define SL811HS_HOSTCTRL_BIT_DTB	0x40
#define SL811HS_HOSTCTRL_BIT_PRE	0x80

// SL811HS_USB[AB]_HOSTSTATUS(0x03,0x0B) ǂݏo
#define SL811HS_HOSTSTATUS_BIT_ACK	0x01
#define SL811HS_HOSTSTATUS_BIT_ERR	0x02
#define SL811HS_HOSTSTATUS_BIT_TOUT	0x04
#define SL811HS_HOSTSTATUS_BIT_SEQ	0x08
#define SL811HS_HOSTSTATUS_BIT_SETUP	0x10
#define SL811HS_HOSTSTATUS_BIT_OVF	0x20
#define SL811HS_HOSTSTATUS_BIT_NAK	0x40
#define SL811HS_HOSTSTATUS_BIT_STALL	0x80

// SL811HS_USB[AB]_HOSTPID(0x03,0x0B) Bit7-4 ݎ
#define SL811HS_HOSTPID_BIT_SETUP	0xD0
#define SL811HS_HOSTPID_BIT_IN		0x90
#define SL811HS_HOSTPID_BIT_OUT		0x10
#define SL811HS_HOSTPID_BIT_SOF		0x50
#define SL811HS_HOSTPID_BIT_PRE		0xC0
#define SL811HS_HOSTPID_BIT_NAK		0xA0
#define SL811HS_HOSTPID_BIT_STALL	0xE0
#define SL811HS_HOSTPID_BIT_DATA0	0x30
#define SL811HS_HOSTPID_BIT_DATA1	0xB0

// SL811HS_CONTROL1(0x05)
#define SL811HS_CONTROL1_BIT_SOF	0x01
#define SL811HS_CONTROL1_BIT_NORMAL	0x00	// Bit3:4
#define SL811HS_CONTROL1_BIT_RESET	0x08	// Bit3:4
#define SL811HS_CONTROL1_BIT_JKSTAT	0x10	// Bit3:4
#define SL811HS_CONTROL1_BIT_KJSTAT	0x18	// Bit3:4
#define SL811HS_CONTROL1_BIT_LOWSPD	0x20
#define SL811HS_CONTROL1_BIT_SUSPEND	0x40

// SL811HS_INTENV(0x06)
#define SL811HS_INTENV_BIT_USBA		0x01
#define SL811HS_INTENV_BIT_USBB		0x02
#define SL811HS_INTENV_BIT_SOFTIMER	0x10
#define SL811HS_INTENV_BIT_INSRMV	0x20
#define SL811HS_INTENV_BIT_DEVDTC	0x40
#define SL811HS_INTENV_BIT_DPLUS	0x80

// SL811HS_STATUS(0x0D)
#define SL811HS_STATUS_BIT_USBA		0x01
#define SL811HS_STATUS_BIT_USBB		0x02
#define SL811HS_STATUS_BIT_SOFTIMER	0x10
#define SL811HS_STATUS_BIT_INSRMV	0x20
#define SL811HS_STATUS_BIT_DEVDTC	0x40
#define SL811HS_STATUS_BIT_DPLUS	0x80

// SL811HS_REVISION(0x0E)
#define SL811HS_REVISION_BIT_REV12	0x10
#define SL811HS_REVISION_BIT_REV15	0x20

// SL811HS_SOFCOUNTH(0x0F)
#define SL811HS_SOFCOUNTH_BIT_PLTYSWAP	0x40
#define SL811HS_SOFCOUNTH_BIT_MSTRSLV	0x80

#define	MAX_EP	8

// ----------------------------------------------------
//   Descriptor information (DEVICE)
// ----------------------------------------------------
typedef struct {
	unsigned char	bLength;
	unsigned char	bDescriptorType;
	unsigned short	bcdUSB;
	unsigned char	bDeviceClass;
	unsigned char	bDeviceSubClass;
	unsigned char	bDeviceProtocol;
	unsigned char	bMaxPacketSize0;
	unsigned short	idVendor;
	unsigned short	idProduct;
	unsigned short	bcdDevice;
	unsigned char	iManufacturer;
	unsigned char	iProduct;
	unsigned char	iSerialNumber;
	unsigned char	bNumConfigurations;
} DESCRIPTOR_DEVICE, *P_DESCRIPTOR_DEVICE;

// ----------------------------------------------------
//   Descriptor information (CONFIG)
// ----------------------------------------------------
typedef struct {
	unsigned char	bLength;
	unsigned char	bDescriptorType;
	unsigned short	wTotalLength;
	unsigned char	bNumInterface;
	unsigned char	bConfigurationValue;
	unsigned char	iConfiguration;
	unsigned char	bmAttributes;
	unsigned char	bMaxPower;
} DESCRIPTOR_CONFIG, *P_DESCRIPTOR_CONFIG;

// ----------------------------------------------------
//   Descriptor information (INTERFACE)
// ----------------------------------------------------
typedef struct {
	unsigned char	bLength;
	unsigned char	bDescriptorType;
	unsigned char	bInterfaceNumber;
	unsigned char	bAlternateSetting;
	unsigned char	bNumEndpoints;
	unsigned char	bInterfaceClass;
	unsigned char	bInterfaceSubClass;
	unsigned char	bInterfaceProtocol;
	unsigned char	iInterface;
} DESCRIPTOR_INTERFACE, *P_DESCRIPTOR_INTERFACE;

// ----------------------------------------------------
//   Descriptor information (ENDPOINT)
// ----------------------------------------------------
typedef struct {
	unsigned char	bLength;
	unsigned char	bDescriptorType;
	unsigned char	bEndpointAddress;
	unsigned char	bmAttributes;
	unsigned short	wMaxPacketSize;
	unsigned char	bInterval;
} DESCRIPTOR_ENDPOINT, *P_DESCRIPTOR_ENDPOINT;


// ----------------------------------------------------
//   SETUP command format
// ----------------------------------------------------
typedef struct {
	unsigned char	bmRequestType;
	unsigned char	bRequest;
	unsigned short	wValue;
	unsigned short	wIndex;
	unsigned short	wLength;
} SETUP_FORMAT, *P_SETUP_FORMAT;

// ----------------------------------------------------
//   Endpoints information
// ----------------------------------------------------
typedef struct {
	int				host_buf_size;
	unsigned char*	p_host_buf;
	unsigned char	address;
	unsigned char	size;
	unsigned char	toggle;
} EP_INFO, *P_EP_INFOs;


extern void sl811_1ms_handler(void);
extern void sl811_chip_irq(void);
extern int sl811_initialize(void);
extern int sl811_process(void);
extern int ui_function_usb(UI_COMMAND uicmd);
extern unsigned char sl811_status(unsigned char cmd);
extern unsigned char sl811_ctrl_receive(P_SETUP_FORMAT p_fmt);
extern void sl811_buffer_copy( unsigned char* p_buf, int size);
extern unsigned char sl811_bulk_out_request( unsigned char* p_buf, int size );
extern unsigned char sl811_bulk_in_request( unsigned char* p_buf, int size );
extern unsigned char IsBulkInEP( void );
extern unsigned char IsBulkOutEP( void );
extern unsigned char IsPacketStatus(void);

#endif 

