
/* --------------------------------------------- */
/*  H8-3069F User interface function             */
/*                (c) KAZ.Imamura                */
/* --------------------------------------------- */

#ifndef __UI_H__
#define __UI_H__

#include "sc1602.h"

#define MAX_CMD_QUEUE 0x0F

// UI Command format

typedef struct {
	unsigned char cmd;
	unsigned char param;
} UI_COMMAND;

typedef struct {
	int          num;
	int          (*pExecFunc)(UI_COMMAND uicmd);
	char         display[MAX_COLUMN];
	unsigned int interval_time;
} UI_APP_TABLE;


enum {
	UI_CMD_NOP,
	UI_CMD_INTEVAL,
	UI_CMD_STARTED,
	UI_CMD_KEY_PRESS_UP,
	UI_CMD_KEY_PRESS_DOWN,
	UI_CMD_KEY_PRESS_BACK,
	UI_CMD_KEY_PRESS_OK,
};

enum {
	UI_RET_READY,
	UI_RET_BUSY,
	UI_RET_ERROR,
	UI_RET_QUIT,
};

extern int ui_cmdset(UI_COMMAND uicmd);

#endif // __UI_H__
