﻿//
//  TransmissionType.cs
//
//  Author:
//       tsntsumi <tsntsumi at tsntsumi.com>
//
//  Copyright (c) 2015 tsntsumi
//
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU Lesser General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.

/// @file
/// <summary>
/// 転送タイプを実装します。
/// </summary>
/// @since 2015.8.15
using System;

namespace SocketNet
{
	/// <summary>
	/// 転送のタイプ。
	/// </summary>
	public enum TransmissionType
	{
		/// <summary>
		/// 登録されたクライアントだけに転送します。ハートビートイクスチェンジを含みます。
		/// </summary>
		Unicast,

		/// <summary>
		/// Udp マルチキャストにより転送します。ハートビートイクスチェンジを含みません。
		/// </summary>
		Multicast,

		/// <summary>
		/// Udp ブロードキャストにより転送します。ハートビートイクスチェンジを含みません。
		/// </summary>
		Broadcast,

		/// <summary>
		/// ローカルな登録されていないユニキャストもしくはハートビートイクスチェンジです。
		/// </summary>
		LocalBroadcast
	}
}
