#include<stdio.h>
#include<comp/comp_lz.h>

int main(int argc, char *argv[]) {
    int c, ret = 0;
    unsigned long int size;
    FILE *infile = NULL, *outfile = NULL;
    COMP_lz *lz = NULL;
    COMP_result result;

    if (argc != 4) {
        fprintf(stderr, 
            "usage: %s E|e|D|d input_file output_file\n", argv[0]);
        ret = -1;
        goto err;
    }
    infile = fopen(argv[2], "rb");
    if (infile == NULL) {
        fprintf(stderr, "can't open input file\n");
        ret = -1;
        goto err;
    }
    outfile = fopen(argv[3], "wb");
    if (outfile == NULL) {
        fprintf(stderr, "can't open output file\n");
        ret = -1;
        goto err;
    }
    c = *argv[1];
    switch(c) {
    case 'E':
    case 'e':
        result = COMP_createLz(&lz);
        if (result != COMP_ok) {
            fprintf(stderr, "COMP_createLz error\n");
            ret = -1;
            goto err;
        }
        lz->inbuf_data_size = 
            fread(lz->inbuf, 1, COMP_INBUF_SIZE, infile);
        result = COMP_encodeLzSlideDic(lz);
        if (result != COMP_ok) {
            fprintf(stderr, "COMP_encodeHuffman error\n");
            ret = -1;
            goto err;
        }
        size = fwrite(lz->outbuf, 1, lz->outbuf_data_size, outfile);
        break;
    case 'D':
    case 'd':
        result = COMP_createLz(&lz);
        if (result != COMP_ok) {
            fprintf(stderr, "COMP_createHuffman error\n");
            ret = -1;
            goto err;
        }
        size = fread(lz->inbuf, 1, COMP_INBUF_SIZE, infile);
        result = COMP_decodeLzSlideDic(lz);
        if (result != COMP_ok) {
            fprintf(stderr, "COMP_encodeHuffman error\n");
            ret = -1;
            goto err;
        }
        size = fwrite(lz->outbuf, 1, lz->outbuf_data_size, outfile);
        break;
    default:
        fprintf(stderr, "refer how to use\n");
        ret = -1;
        goto err;
    }

err:
no_err:
    if (lz != NULL) {
        COMP_disposeLz(lz);
    }
    if (infile != NULL) {
        fclose(infile);
    }
    if (outfile != NULL) {
        fclose(outfile);
    }
    return ret;
}

