#ifndef _COMP_H_
#define _COMP_H_

#include<stdlib.h>
#include<string.h>

#define COMP_memset memset
#define COMP_malloc malloc
#define COMP_free free
#define COMP_memcpy memcpy
#define COMP_CODE_PATTERN_MAX 256
#define COMP_INBUF_SIZE 1024
#define COMP_OUTBUF_SIZE 1024

typedef enum {
	COMP_FALSE,
	COMP_TRUE
} COMP_bool;

typedef enum {
	COMP_ok,
	COMP_err
} COMP_result;

typedef struct comp_huffman COMP_huffman;
struct comp_huffman {
    int tree_parent[2 * COMP_CODE_PATTERN_MAX - 1];
    int tree_left[2 * COMP_CODE_PATTERN_MAX - 1];
    int tree_right[2 * COMP_CODE_PATTERN_MAX - 1];
    unsigned long int freq[2 * COMP_CODE_PATTERN_MAX - 1];
    int heap[2 * COMP_CODE_PATTERN_MAX - 1];
    size_t heap_size;
    unsigned char inbuf[COMP_INBUF_SIZE];
    size_t inbuf_data_size;
    size_t inbuf_byte_pos;
    size_t inbuf_bit_space;
    unsigned char outbuf[COMP_OUTBUF_SIZE];
    size_t outbuf_data_size;
    size_t outbuf_byte_pos;
    size_t outbuf_bit_space;
    size_t decoded_size;
};

extern COMP_result COMP_createHuffman(COMP_huffman **huffman);
extern void COMP_disposeHuffman(COMP_huffman *huffman);
extern COMP_result COMP_encodeHuffman(COMP_huffman *huffman);
extern COMP_result COMP_decodeHuffman(COMP_huffman *huffman);

#endif /* _COMP_H_ */
