#include<VaneOS.h>
#include<GDT_IDT.h>

IDTR idtr;
GATE_DESCRIPTOR	idt[ NUM_IDT ];
SEGMENT_DESCRIPTOR	gdt[ NUM_GDT ];
GDTR gdtr;

void setupInterruptGate( int int_num, void *interrupt_handler )
{
	setupGateDescriptor( int_num,
		( int )interrupt_handler,
		DEF_IDT_INT_SELECTOR,
		DEF_IDT_FLAGS_PRESENT | DEF_IDT_FLAGS_INTGATE_32BIT );
}

void setupGateDescriptor( int int_num,int base,unsigned short selector,unsigned char flags )
{
	idt[ int_num ].baseLo	= ( unsigned short )(   base & 0x0000FFFF );
	idt[ int_num ].selector	= selector;
	idt[ int_num ].reserved	= 0x00;
	idt[ int_num ].flags	= flags;
	idt[ int_num ].baseHi	= ( unsigned short )( ( base & 0xFFFF0000 ) >> 16 );
}

void load_gdt(void)
{
    __asm__ __volatile__ ( "lgdt gdtr" );
    __asm__ __volatile__ ( "mov %ax, 0x10" );
    __asm__ __volatile__ ( "mov %ds, %ax" );
    __asm__ __volatile__ ( "mov %es, %ax" );
    __asm__ __volatile__ ( "mov %fs, %ax" );
    __asm__ __volatile__ ( "mov %gs, %ax" );
    __asm__ __volatile__ ( "mov %ss, %ax" );
    
    clear_state();
}

void load_idt(void)
{
	__asm__ __volatile__ ("lidt idtr");
}
