/*
*System Functions
*(C) 2014 VOSystems.
*/
#include <stdio.h>

int vram_start_address;
char vmode;
short scrnX,scrnY;
void init_qemuvga0(int x, int y, int c, int flag);
/*int Check_VESA(void)
{
	in_virtual86mode();
	if(VESA_Check()==0){
		out_virtual86mode();
		return 0;
	}else{
		out_virtual86mode();
		return 1;
	}
}

void ScreenVGA_Graphic(void)
{/*
	in_virtual86mode();
	scrn320();
	out_virtual86mode();
	vram_start_address=0x000a0000;
	scrnX=320;
	scrnY=200;
	init_qemuvga0(1024,600,32,0x41);
}*/

void set_qemuvga0reg(int reg, int dat)
{
    io_out16(0x01ce, reg);
    io_out16(0x01cf, dat);
    return;
}

void init_qemuvga0(int x, int y, int c, int flag)
{
    set_qemuvga0reg(0x0004, 0x0000);
    set_qemuvga0reg(0x0001, x);
    set_qemuvga0reg(0x0002, y);
    set_qemuvga0reg(0x0003, c); /* 4, 8, 15, 16, 24, 32 */
    set_qemuvga0reg(0x0005, 0x0000);
    set_qemuvga0reg(0x0004, flag); /* リニアアクセスモードでVRAMの初期化をするなら0x41 */
        /* bit7 : VRAM初期化抑制, bit6 : リニアアクセスモード, bit0 : 設定有効 */
    scrnX = x;
    scrnY = y;
    vmode = c;
    if ((flag & 0x40) == 0) {
        vram_start_address = 0x000a0000;
    } else {
        vram_start_address = 0xe0000000;
    }
    return;
}

void readrtc(unsigned char *t)
{
    char err;
    static unsigned char adr[7] = { 0x00, 0x02, 0x04, 0x07, 0x08, 0x09, 0x32 };
    static unsigned char max[7] = { 0x60, 0x59, 0x23, 0x31, 0x12, 0x99, 0x99 };
    int i;
    for (;;) { /* 読み込みが成功するまで繰り返す */
        err = 0;
        for (i = 0; i < 7; i++) {
            io_out8(0x70, adr[i]);
            t[i] = io_in8(0x71);
        }
        for (i = 0; i < 7; i++) {
            io_out8(0x70, adr[i]);
            if (t[i] != io_in8(0x71) || (t[i] & 0x0f) > 9 || t[i] > max[i]) {
                err = 1;
            }
        }
        if (err == 0) {
            return;
        }
    }
}

void printtime(void)
{
    unsigned char s[24], t[7];
    readrtc(t);
    printf("%X%X/%X/%X %X:%X:%X", t[6], t[5], t[4], t[3], t[2], t[1], t[0]);
}
