package jp.gr.java_conf.wutse.purewiki.syntax.block;

import jp.gr.java_conf.wutse.purewiki.PureWikiContext;
import jp.gr.java_conf.wutse.purewiki.syntax.BlockSyntax;

public class HtmlBlockSyntax implements BlockSyntax {
	@Override
	public String getName() {
		return "HTML";
	}
	@Override
	public String begin(PureWikiContext context) {
		context.setEnableHtmlEncode(false);
		context.setEnableLineSyntax(false);
		return "";
	}
	@Override
	public String line(PureWikiContext context) {
		return context.getLine();
	}
	@Override
	public String end(PureWikiContext context) {
		context.setEnableHtmlEncode(true);
		context.setEnableLineSyntax(true);
		return "";
	}
}
