package jp.gr.java_conf.wutse.purewiki.syntax.line;

import java.io.File;
import java.io.IOException;

import jp.gr.java_conf.wutse.purewiki.PureWikiContext;
import jp.gr.java_conf.wutse.purewiki.PureWikiEngine;
import jp.gr.java_conf.wutse.purewiki.syntax.LineSyntax;
import jp.gr.java_conf.wutse.purewiki.util.PureWikiUtil;

public class ImageSyntax implements LineSyntax {
	@Override
	public boolean condition(PureWikiContext context) {
		String line = context.getLine();
		if (line.startsWith("& ")) {
			return true;
		}
		return false;
	}

	@Override
	public String begin(PureWikiContext context) {
		return "";
	}

	@Override
	public String line(PureWikiContext context) {
		String line = context.getOriginalLine();
		line = line.substring("& ".length());
		PureWikiEngine engine = context.getEngine();
		String srcPath = engine.getConfig().getSrcDirPath() + "\\" + line.replace("/", "\\");
		File srcFile = new File(srcPath);
		if (srcFile.exists()) {
			try {
				File outFile = engine.getOutputFile(srcFile);
				PureWikiUtil.copyFile(srcFile, outFile);
				line = "<img src=\"" + outFile.getAbsolutePath() + "\" />";
			} catch (IOException e) {
				line = "File copy error.";
			}
		} else {
			line = "File not found.";
		}

		return line;
	}

	@Override
	public String end(PureWikiContext context) {
		return "";
	}
}
