package jp.gr.java_conf.wutse.purewiki.syntax.word;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import jp.gr.java_conf.wutse.purewiki.PureWikiContext;
import jp.gr.java_conf.wutse.purewiki.syntax.WordSyntax;

public class RegExpSyntax implements WordSyntax {
	private String[][] regexps = new String[][]{
		{"\\[\\[([^:\\]]+)\\]\\]", "<a href=\"$1.html\">$1</a>"},
		{"\\[\\[([^:]+):([^\\]]+)\\]\\]", "<a href=\"$2.html\">$1</a>"}
	};
	@Override
	public String line(PureWikiContext context) {
		if (PureWikiContext.END.equals(context.getStatus())) {
			return "";
		}
		String line = context.getLine();
		for (String[] regexp: regexps) {
			Pattern p = Pattern.compile(regexp[0]);
			Matcher m = p.matcher(line);
			line = m.replaceAll(regexp[1]);
		}
		return line;
	}
}
