//! @file objectmanager.cpp
//! @brief ObjectManagerNX̒`

//--------------------------------------------------------------------------------
// 
// OpenXOPS
// Copyright (c) 2014-2016, OpenXOPS Project / [-_-;](mikan) All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
// * Redistributions of source code must retain the above copyright notice, 
//   this list of conditions and the following disclaimer.
// * Redistributions in binary form must reproduce the above copyright notice, 
//   this list of conditions and the following disclaimer in the documentation 
//   and/or other materials provided with the distribution.
// * Neither the name of the OpenXOPS Project nor the names of its contributors 
//   may be used to endorse or promote products derived from this software 
//   without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL OpenXOPS Project BE LIABLE FOR ANY
// DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
// LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
// ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//--------------------------------------------------------------------------------

#include "objectmanager.h"

//! @brief RXgN^
ObjectManager::ObjectManager()
{
	HumanIndex = new human[MAX_HUMAN];
	WeaponIndex = new weapon[MAX_WEAPON];
	SmallObjectIndex = new smallobject[MAX_SMALLOBJECT];
	BulletIndex = new bullet[MAX_BULLET];
	GrenadeIndex = new grenade[MAX_GRENADE];
	EffectIndex = new effect[MAX_EFFECT];

	framecnt = 0;
	Human_ontarget = new int[MAX_HUMAN];
	Human_kill = new int[MAX_HUMAN];
	Human_headshot = new int[MAX_HUMAN];
	Human_ShotFlag = new bool[MAX_HUMAN];
	FriendlyFire = false;
	Player_HumanID = 0;
	AddHumanIndex_TextureID = -1;

	GameParamInfo = NULL;
	d3dg = NULL;
	Resource = NULL;
	BlockData = NULL;
	PointData = NULL;
	CollD = NULL;
}

//! @brief fBXgN^
ObjectManager::~ObjectManager()
{
	Cleanup();

	if( HumanIndex != NULL ){ delete [] HumanIndex; }
	if( WeaponIndex != NULL ){ delete [] WeaponIndex; }
	if( SmallObjectIndex != NULL ){ delete [] SmallObjectIndex; }
	if( BulletIndex != NULL ){ delete [] BulletIndex; }
	if( GrenadeIndex != NULL ){ delete [] GrenadeIndex; }
	if( EffectIndex != NULL ){ delete [] EffectIndex; }

	if( Human_ontarget != NULL ){ delete [] Human_ontarget; }
	if( Human_kill != NULL ){ delete [] Human_kill; }
	if( Human_headshot != NULL ){ delete [] Human_headshot; }
	if( Human_ShotFlag != NULL ){ delete [] Human_ShotFlag; }
}

//! @brief QƂNXݒ
//! @param in_GameParamInfo Q[ݒf[^ǗNX
//! @param in_d3dg `揈NX
//! @param in_Resource \[XǗNX
//! @param in_BlockData ubNf[^ǗNX
//! @param in_PointData |Cgf[^ǗNX
//! @param in_CollD 蔻菈NX
//! @param in_GameSound ʉĐNX
//! @param in_MIFdata MIFRg[NX
//! @attention ̊֐ŐݒsȂƁANX̂@\܂B
void ObjectManager::SetClass(ParameterInfo *in_GameParamInfo, D3DGraphics *in_d3dg, ResourceManager *in_Resource, BlockDataInterface *in_BlockData, PointDataInterface *in_PointData, Collision *in_CollD, SoundManager *in_GameSound, MIFInterface *in_MIFdata)
{
	GameParamInfo = in_GameParamInfo;
	d3dg = in_d3dg;
	Resource = in_Resource;
	BlockData = in_BlockData;
	PointData = in_PointData;
	CollD = in_CollD;
	GameSound = in_GameSound;
	MIFdata = in_MIFdata;

	for(int i=0; i<MAX_HUMAN; i++){
		HumanIndex[i].SetParameterInfoClass(GameParamInfo);
	}
	for(int i=0; i<MAX_WEAPON; i++){
		WeaponIndex[i].SetParameterInfoClass(GameParamInfo);
	}
	for(int i=0; i<MAX_SMALLOBJECT; i++){
		SmallObjectIndex[i].SetParameterInfoClass(GameParamInfo);
		SmallObjectIndex[i].SetMIFInterfaceClass(MIFdata);
	}
	for(int i=0; i<MAX_GRENADE; i++){
		GrenadeIndex[i].SetParameterInfoClass(GameParamInfo);
	}

	int bulletmodel, bullettexture;
	Resource->GetBulletModelTexture(&bulletmodel, &bullettexture);
	for(int i=0; i<MAX_BULLET; i++){
		BulletIndex[i].SetModel(bulletmodel, BULLET_SCALE);
		BulletIndex[i].SetTexture(bullettexture);
	}

	int grenademodel, grenadetexture;
	float model_size = 1.0f;
	WeaponParameter ParamData;

	//\[XƃfTCY擾
	Resource->GetWeaponModelTexture(ID_WEAPON_GRENADE, &grenademodel, &grenadetexture);
	if( GameParamInfo->GetWeapon(ID_WEAPON_GRENADE, &ParamData) == 0 ){
		model_size = ParamData.size;
	}

	//Kp
	for(int i=0; i<MAX_GRENADE; i++){
		GrenadeIndex[i].SetModel(grenademodel, model_size);
		GrenadeIndex[i].SetTexture(grenadetexture);
	}
}

//! @brief lǉ
//! @param data l̃|Cgf[^@ipointdata\́j
//! @param infodata QƂl̃|Cgf[^@iVj
//! @return Ff[^ԍi0ȏj@sF-1
//! @attention Ȑl̎ޔԍw肳ꂽꍇ ʏ́Fl oꂵ܂BeNX`̓}bveNX`0ԂgpAHP 0 wij܂B
int ObjectManager::AddHumanIndex(pointdata data, pointdata infodata)
{
	int GetHumanFlag;
	HumanParameter HumanParam;
	GetHumanFlag = GameParamInfo->GetHuman(infodata.p2, &HumanParam);
	int Humanindexid = -1;
	int Weaponindexid = -1;
	class weapon *Weapon[TOTAL_HAVEWEAPON];
	for(int i=0; i<TOTAL_HAVEWEAPON; i++){
		Weapon[i] = NULL;
	}

	//l̃fԍ擾
	int upmodel[TOTAL_UPMODE];
	int armmodel[TOTAL_ARMMODE];
	int legmodel;
	int walkmodel[TOTAL_WALKMODE];
	int runmodel[TOTAL_RUNMODE];
	Resource->GetHumanModel(upmodel, armmodel, &legmodel, walkmodel, runmodel);

	for(int j=0; j<MAX_HUMAN; j++){
		if( HumanIndex[j].GetEnableFlag() == false ){
			//
			HumanIndex[j].SetPosData(data.x, data.y, data.z, data.r);
			HumanIndex[j].SetParamData(infodata.p2, data.id, data.p4, infodata.p3, true);
			if( GetHumanFlag == 0 ){
				int id = Resource->GetHumanTexture(infodata.p2);
				if( id == -1 ){
					id = AddHumanIndex_TextureID;
				}
				else{
					AddHumanIndex_TextureID = id;
				}

				HumanIndex[j].SetTexture(id);
				HumanIndex[j].SetModel(upmodel[ HumanParam.model ], armmodel, legmodel, walkmodel, runmodel);
			}
			else{
				AddHumanIndex_TextureID = d3dg->GetMapTextureID(0);

				HumanIndex[j].SetTexture(AddHumanIndex_TextureID);
				HumanIndex[j].SetModel(upmodel[0], armmodel, legmodel, walkmodel, runmodel);
			}
			HumanIndex[j].SetEnableFlag(true);
			Humanindexid = j;
			break;
		}
	}

	//łȂG[ƂĕԂ
	if( Humanindexid == -1 ){
		return -1;
	}

	//l̐ݒf[^ǂ߂Ă΁`
	if( GetHumanFlag == 0 ){
		//BzƂĒǉ
		Weaponindexid = AddVisualWeaponIndex(HumanParam.Weapon[0], true);
		if( Weaponindexid != -1 ){
			//ΔzɋL^
			Weapon[0] = &WeaponIndex[Weaponindexid];
		}
		if( data.p1 == 1 ){
			//ẢzƂĒǉ
			Weaponindexid = AddVisualWeaponIndex(HumanParam.Weapon[1], true);
			if( Weaponindexid != -1 ){
				//ΔzɋL^
				Weapon[1] = &WeaponIndex[Weaponindexid];
			}
		}

		//lɎ
		HumanIndex[Humanindexid].SetWeapon(Weapon);
	}

	//CtO
	Human_ShotFlag[Humanindexid] = false;

	//vC[Ȃ΁AԍL^
	if( ( (data.p1 == 1)||(data.p1 == 6) )&&(data.p4 == 0) ){
		Player_HumanID = Humanindexid;
	}

	return Humanindexid;
}

//! @brief lǉiQ[pj
//! @param px XW
//! @param py YW
//! @param pz ZW
//! @param rx X
//! @param paramID ޔԍ
//! @param TeamID `[ԍ
//! @param WeaponID ޔԍ̔zivfFTOTAL_HAVEWEAPONj
//! @return Ff[^ԍi0ȏj@sF-1
//! @attention Ȑl̎ޔԍw肳ꂽꍇ ʏ́Fl oꂵ܂BeNX`̓}bveNX`0ԂgpAHP 0 wij܂B
int ObjectManager::AddHumanIndex(float px, float py, float pz, float rx, int paramID, int TeamID, int WeaponID[])
{
	int GetHumanFlag;
	HumanParameter HumanParam;
	GetHumanFlag = GameParamInfo->GetHuman(paramID, &HumanParam);
	int Humanindexid = -1;
	int Weaponindexid = -1;
	class weapon *Weapon[TOTAL_HAVEWEAPON];
	for(int i=0; i<TOTAL_HAVEWEAPON; i++){
		Weapon[i] = NULL;
	}

	//l̃fԍ擾
	int upmodel[TOTAL_UPMODE];
	int armmodel[TOTAL_ARMMODE];
	int legmodel;
	int walkmodel[TOTAL_WALKMODE];
	int runmodel[TOTAL_RUNMODE];
	Resource->GetHumanModel(upmodel, armmodel, &legmodel, walkmodel, runmodel);

	for(int i=0; i<MAX_HUMAN; i++){
		if( HumanIndex[i].GetEnableFlag() == false ){
			//
			HumanIndex[i].SetPosData(px, py, pz, rx);
			HumanIndex[i].SetParamData(paramID, -1, 0, TeamID, true);
			if( GetHumanFlag == 0 ){
				//ǂݍ߂Ȃ΁AOǂݍ񂾃eNX`ԍ𗘗p
				//ǂݍ߂΁AǂݍރeNX`ԍ㏑
				int id = Resource->GetHumanTexture(paramID);
				if( id == -1 ){
					id = AddHumanIndex_TextureID;
				}
				else{
					AddHumanIndex_TextureID = id;
				}

				HumanIndex[i].SetTexture(id);
				HumanIndex[i].SetModel(upmodel[ HumanParam.model ], armmodel, legmodel, walkmodel, runmodel);
			}
			else{
				//ǂݍރeNX`ԍ㏑
				AddHumanIndex_TextureID = d3dg->GetMapTextureID(0);

				HumanIndex[i].SetTexture(AddHumanIndex_TextureID);
				HumanIndex[i].SetModel(upmodel[0], armmodel, legmodel, walkmodel, runmodel);
			}
			HumanIndex[i].SetEnableFlag(true);
			Humanindexid = i;
			break;
		}
	}

	//łȂG[ƂĕԂ
	if( Humanindexid == -1 ){
		return -1;
	}

	if( GetHumanFlag == 0 ){
		//zǉ
		for(int i=0; i<TOTAL_HAVEWEAPON; i++){
			Weaponindexid = AddVisualWeaponIndex(WeaponID[i], true);
			if( Weaponindexid != -1 ){
				//ΔzɋL^
				Weapon[i] = &WeaponIndex[Weaponindexid];
			}
		}

		//lɎ
		HumanIndex[Humanindexid].SetWeapon(Weapon);
	}

	return Humanindexid;
}

//! @brief ǉ
//! @param data ̃|Cgf[^@ipointdata\́j
//! @return Ff[^ԍi0ȏj@sF-1
int ObjectManager::AddWeaponIndex(pointdata data)
{
	//ԍƒeo^
	int WeaponID = data.p2;
	int nbs = (unsigned char)data.p3;

	//_ȕȂ
	if( data.p1 == 7 ){
		WeaponParameter WeaponParam;

		if( GetRand(2) == 0 ){
			if( GameParamInfo->GetWeapon(data.p2, &WeaponParam) == 1 ){ return -1; }
			nbs = (int)WeaponParam.nbsmax * TOTAL_WEAPON_AUTOBULLET;		//e㏑
		}
		else{
			if( GameParamInfo->GetWeapon(data.p3, &WeaponParam) == 1 ){ return -1; }
			WeaponID = data.p3;						//ԍ㏑
			nbs = (int)WeaponParam.nbsmax * TOTAL_WEAPON_AUTOBULLET;		//e㏑
		}
	}

	//NONEȂΎs
	if( WeaponID == ID_WEAPON_NONE ){ return -1; }

	//fƃeNX`擾
	int model, texture;
	if( Resource->GetWeaponModelTexture(WeaponID, &model, &texture) == 1 ){
		return -1;
	}

	//ݒl擾
	WeaponParameter WeaponParam;
	if( GameParamInfo->GetWeapon(data.p2, &WeaponParam) == 1 ){ return -1; }

	for(int i=0; i<MAX_WEAPON; i++){
		if( WeaponIndex[i].GetEnableFlag() == false ){
			//
			WeaponIndex[i].SetPosData(data.x, data.y, data.z, data.r);
			WeaponIndex[i].SetParamData(WeaponID, 0, nbs, true);
			WeaponIndex[i].SetModel(model, WeaponParam.size);
			WeaponIndex[i].SetTexture(texture);
			WeaponIndex[i].SetEnableFlag(true);
			WeaponIndex[i].RunReload();
			return i;
		}
	}
	return -1;
}

//! @brief zǉ
//! @param WeaponID ̎ޔԍ
//! @param loadbullet e[h
//! @return Ff[^ԍi0ȏj@sF-1
//! @attention lŏ珊Ă镐Af[^iIuWFNgjƂĒǉ邽߂̊֐łB
//! @attention P̂ƂĔzuꍇ́AAddWeaponIndex()֐gpĂB
int ObjectManager::AddVisualWeaponIndex(int WeaponID, bool loadbullet)
{
	//NONEȂΎs
	if( WeaponID == ID_WEAPON_NONE ){ return -1; }

	//擾
	WeaponParameter WeaponParam;
	if( GameParamInfo->GetWeapon(WeaponID, &WeaponParam) == 1 ){ return -1; }

	//fƃeNX`擾
	int model, texture;
	if( Resource->GetWeaponModelTexture(WeaponID, &model, &texture) == 1 ){
		return -1;
	}

	for(int i=0; i<MAX_WEAPON; i++){
		if( WeaponIndex[i].GetEnableFlag() == false ){
			//
			WeaponIndex[i].SetPosData(0.0f, 0.0f, 0.0f, 0.0f);
			if( loadbullet == false ){
				WeaponIndex[i].SetParamData(WeaponID, 0, 0, true);
			}
			else{
				WeaponIndex[i].SetParamData(WeaponID, WeaponParam.nbsmax, WeaponParam.nbsmax * TOTAL_WEAPON_AUTOBULLET, true);
			}
			WeaponIndex[i].SetModel(model, WeaponParam.size);
			WeaponIndex[i].SetTexture(texture);
			WeaponIndex[i].SetEnableFlag(true);
			return i;
		}
	}
	return -1;
}

//! @brief ǉ
//! @param data ̃|Cgf[^@ipointdata\́j
//! @return Ff[^ԍi0ȏj@sF-1
int ObjectManager::AddSmallObjectIndex(pointdata data)
{
	//fƃeNX`擾
	int model, texture;
	if( Resource->GetSmallObjectModelTexture(data.p2, &model, &texture) == 1 ){
		return -1;
	}

	for(int i=0; i<MAX_SMALLOBJECT; i++){
		if( SmallObjectIndex[i].GetEnableFlag() == false ){
			//
			SmallObjectIndex[i].SetPosData(data.x, data.y, data.z, data.r);
			SmallObjectIndex[i].SetParamData(data.p2, data.p4, true);
			SmallObjectIndex[i].SetModel(model, SMALLOBJECT_SCALE);
			SmallObjectIndex[i].SetTexture(texture);
			SmallObjectIndex[i].SetEnableFlag(true);

			//ʒuCtOLȂ΁A}bvƔ
			if( data.p3 !=0 ){
				SmallObjectIndex[i].CollisionMap(CollD);
			}
			return i;
		}
	}
	return -1;
}

//! @brief ǉiQ[pj
//! @param px XW
//! @param py YW
//! @param pz ZW
//! @param rx X
//! @param paramID ޔԍ
//! @param MapColl ʒuCtO
//! @return Ff[^ԍi0ȏj@sF-1
int ObjectManager::AddSmallObjectIndex(float px, float py, float pz, float rx, int paramID, bool MapColl)
{
	//fƃeNX`擾
	int model, texture;
	if( Resource->GetSmallObjectModelTexture(paramID, &model, &texture) == 1 ){
		return -1;
	}

	for(int j=0; j<MAX_SMALLOBJECT; j++){
		if( SmallObjectIndex[j].GetEnableFlag() == false ){
			//
			SmallObjectIndex[j].SetPosData(px, py, pz, rx);
			SmallObjectIndex[j].SetParamData(paramID, 0, true);
			SmallObjectIndex[j].SetModel(model, SMALLOBJECT_SCALE);
			SmallObjectIndex[j].SetTexture(texture);
			SmallObjectIndex[j].SetEnableFlag(true);

			//ʒuCtOLȂ΁A}bvƔ
			if( MapColl == true ){
				SmallObjectIndex[j].CollisionMap(CollD);
			}
			return j;
		}
	}
	return -1;
}

//! @brief GtFNgǉ
//! @param pos_x XW
//! @param pos_y YW
//! @param pos_z ZW
//! @param move_x Xړ
//! @param move_y Yړ
//! @param move_z Zړ
//! @param size \{
//! @param rotation ]px
//! @param count \t[
//! @param texture eNX`̔Fԍ
//! @param settype GtFNg̎ށ@iEffect_Type gݍj
//! @return Ff[^ԍi0ȏj@sF-1
int ObjectManager::AddEffect(float pos_x, float pos_y, float pos_z, float move_x, float move_y, float move_z, float size, float rotation, int count, int texture, int settype)
{
	for(int i=0; i<MAX_EFFECT; i++){
		if( EffectIndex[i].GetEnableFlag() == false ){
			EffectIndex[i].SetPosData(pos_x, pos_y, pos_z, 0.0f);
			EffectIndex[i].SetParamData(move_x, move_y, move_z, size, rotation, count, texture, settype, true);
			EffectIndex[i].SetEnableFlag(true);
			return i;
		}
	}

	return -1;
}

//! @brief ir{[hłȂjGtFNgǉ
//! @param id ubNԍ
//! @param face ʔԍ
//! @param pos_x XW
//! @param pos_y YW
//! @param pos_z ZW
//! @param size \{
//! @param rotation ]px
//! @param count \t[
//! @param texture eNX`̔Fԍ
//! @return Ff[^ԍi0ȏj@sF-1
int ObjectManager::AddMapEffect(int id, int face, float pos_x, float pos_y, float pos_z, float size, float rotation, int count, int texture)
{
	blockdata data;
	float vx, vy, vz;
	float rx, ry;

	//ubN̖ʂ̏擾
	BlockData->Getdata(&data, id);
	vx = data.material[face].vx;
	vy = data.material[face].vy;
	vz = data.material[face].vz;

	//px߂
	rx = atan2(vz, vx) + (float)M_PI;
	ry = atan2(vy, sqrt(vx*vx + vz*vz)) + (float)M_PI;

	//GtFNg쐬
	for(int i=0; i<MAX_EFFECT; i++){
		if( EffectIndex[i].GetEnableFlag() == false ){
			EffectIndex[i].SetPosData(pos_x, pos_y, pos_z, 0.0f);
			EffectIndex[i].SetParamData(0.0f, 0.0f, 0.0f, size, rotation, count, texture, EFFECT_DISAPPEARHALF | EFFECT_NOBILLBOARD, true);
			EffectIndex[i].SetRxRy(rx, ry);
			EffectIndex[i].SetEnableFlag(true);
			return i;
		}
	}

	return -1;
}

//! @brief o
//! @param x XW
//! @param y YW
//! @param z ZW
//! @param damage _[W
void ObjectManager::SetHumanBlood(float x, float y, float z, int damage)
{
	if( GameConfig.GetBloodFlag() == true ){
		AddEffect(x, y, z, 0.0f, 0.0f, 0.0f, 10.0f, DegreeToRadian(10)*GetRand(18), (int)(GAMEFPS * 0.4f), Resource->GetEffectBloodTexture(), EFFECT_DISAPPEAR | EFFECT_MAGNIFY | EFFECT_TRANSLUCENT);
		for(int i=0; i<(damage/10); i++){
			float rx = DegreeToRadian(10)*GetRand(36);
			AddEffect(x + cos(rx)*1.0f, y + (float)(GetRand(20)-10)/10, z + sin(rx)*1.0f, cos(rx)*0.5f, GetRand(5)*0.1f + 0.5f, sin(rx)*0.5f, 5.0f, DegreeToRadian(10)*GetRand(18), (int)(GAMEFPS * 0.5f), Resource->GetEffectBloodTexture(), EFFECT_FALL | EFFECT_TRANSLUCENT);
		}
	}
}

//! @brief lm̓蔻
//! @param in_humanA Ώۂ̐lIuWFNgA
//! @param in_humanB Ώۂ̐lIuWFNgB
//! @return ĂFtrue@ĂȂFfalse
//! @warning in_humanAin_humanBŋʂ͂܂B
//! @warning in_humanAin_humanBł̑gݍ́A1t[Ԃ1xsĂB
//! @attention NX͎IAddPosOrder()pāA݂܂B
bool ObjectManager::CollideHuman(human *in_humanA, human *in_humanB)
{
	float h1_x, h1_y, h1_z;
	float h2_x, h2_y, h2_z;
	float angle, length;

	//ĂȂASēΔ肵Ȃ
	if( in_humanA->GetEnableFlag() == false ){ return false; }
	if( in_humanB->GetEnableFlag() == false ){ return false; }
	if( in_humanA->GetHP() <= 0 ){ return false; }
	if( in_humanB->GetHP() <= 0 ){ return false; }

	//݂̍W擾
	in_humanA->GetPosData(&h1_x, &h1_y, &h1_z, NULL);
	in_humanB->GetPosData(&h2_x, &h2_y, &h2_z, NULL);

	//~̓蔻
	if( CollideCylinder(h1_x, h1_y, h1_z, 3.0f, HUMAN_HEIGTH-0.5f, h2_x, h2_y, h2_z, 3.0f, HUMAN_HEIGTH-0.5f, &angle, &length) == true ){
		//߂荞񂾕o
		in_humanA->AddPosOrder(angle, 0.0f, length/2);
		in_humanB->AddPosOrder(angle + (float)M_PI, 0.0f, length/2);
		return true;
	}

	return false;
}

//! @brief e̓蔻Ə
//! @param in_bullet Ώۂ̒eIuWFNg
//! @return Ftrue@ĂȂFfalse
//! @attention sΏۂ́u}bvvuliE㔼gEgjvuvłB
//! @attention Ɍ炸A_[WvZʉĐ܂ňтčs܂B
bool ObjectManager::CollideBullet(bullet *in_bullet)
{
	//gpĂȂeۂȂ΁AɕԂB
	if( in_bullet->GetEnableFlag() == false ){ return false; }

	float bx, by, bz;
	float brx, bry;
	int attacks;
	int penetration;
	int speed;
	int teamid;
	int humanid;
	float vx, vy, vz;
	int HumanHead_id;
	int HumanUp_id;
	int HumanLeg_id;
	int SmallObject_id;
	float map_Dist;
	float HumanHead_Dist;
	float HumanUp_Dist;
	float HumanLeg_Dist;
	float SmallObject_Dist;
	float CheckDist;
	bool CollideFlag;

	int id, face;
	float Dist;

	//eۂ̍W擾AxNgZoB
	in_bullet->GetPosData(&bx, &by, &bz, &brx, &bry);
	in_bullet->GetParamData(&attacks, &penetration, &speed, &teamid, &humanid);
	vx = cos(brx)*cos(bry);
	vy = sin(bry);
	vz = sin(brx)*cos(bry);

	CheckDist = 0;
	CollideFlag = false;

	for(float TotalDist=0.0f; TotalDist<speed; TotalDist+=CheckDist){
		CheckDist = speed - TotalDist;

		//ђʗ͂cĂȂ
		if( penetration < 0 ){
			//e͖ɂ
			in_bullet->SetEnableFlag(false);
			break;
		}

		float bvx, bvy, bvz;
		bvx = bx + vx*TotalDist;
		bvy = by + vy*TotalDist;
		bvz = bz + vz*TotalDist;

		HumanHead_id = -1;
		HumanUp_id = -1;
		HumanLeg_id = -1;
		SmallObject_id = -1;
		map_Dist = (float)speed - TotalDist + 1;
		HumanHead_Dist = (float)speed - TotalDist + 1;
		HumanUp_Dist = (float)speed - TotalDist + 1;
		HumanLeg_Dist = (float)speed - TotalDist + 1;
		SmallObject_Dist = (float)speed - TotalDist + 1;

		//}bvƂ̓蔻
		if( CollD->CheckALLBlockIntersectRay(bvx, bvy, bvz, vx, vy, vz, &id, &face, &Dist, (float)speed - TotalDist) == true ){
			map_Dist = Dist;
		}

		//lƂ̓蔻
		for(int i=0; i<MAX_HUMAN; i++){
			//̐lgCeȂ珈ȂB
			if( i == humanid ){ continue; }

			//gpĂȂASĂΏȂB
			if( HumanIndex[i].GetEnableFlag() == false ){ continue; }
			if( HumanIndex[i].GetHP() <= 0 ){ continue; }

			//W擾
			float ox, oy, oz;
			int h_teamid;
			HumanIndex[i].GetPosData(&ox, &oy, &oz, NULL);
			HumanIndex[i].GetParamData(NULL, NULL, NULL, &h_teamid);

			if( FriendlyFire == false ){
				//`[ԍijȂ珈Ȃ
				if( h_teamid == teamid ){ continue; }
			}

			//̓蔻
			if( CollideCylinderRay(ox, oy + HUMAN_BULLETCOLLISION_LEG_H + HUMAN_BULLETCOLLISION_UP_H, oz, HUMAN_BULLETCOLLISION_HEAD_R, HUMAN_BULLETCOLLISION_HEAD_H, bvx, bvy, bvz, vx, vy, vz, &Dist, (float)speed - TotalDist) == true ){
				if( Dist < HumanHead_Dist ){
					HumanHead_id = i;
					HumanHead_Dist = Dist;
				}
			}

			//㔼gƓ蔻
			if( CollideCylinderRay(ox, oy + HUMAN_BULLETCOLLISION_LEG_H, oz, HUMAN_BULLETCOLLISION_UP_R, HUMAN_BULLETCOLLISION_UP_H, bvx, bvy, bvz, vx, vy, vz, &Dist, (float)speed - TotalDist) == true ){
				if( Dist < HumanUp_Dist ){
					HumanUp_id = i;
					HumanUp_Dist = Dist;
				}
			}

			//Ɠ蔻
			if( CollideCylinderRay(ox, oy, oz, HUMAN_BULLETCOLLISION_LEG_R, HUMAN_BULLETCOLLISION_LEG_H, bvx, bvy, bvz, vx, vy, vz, &Dist, (float)speed - TotalDist) == true ){
				if( Dist < HumanLeg_Dist ){
					HumanLeg_id = i;
					HumanLeg_Dist = Dist;
				}
			}
		}

		//Ƃ̓蔻
		for(int i=0; i<MAX_SMALLOBJECT; i++){
			//gpĂȂΏȂ
			if( SmallObjectIndex[i].GetEnableFlag() == false ){ continue; }

			//W擾
			float ox, oy, oz;
			int id;
			float decide;
			SmallObjectIndex[i].GetPosData(&ox, &oy, &oz, NULL);
			SmallObjectIndex[i].GetParamData(&id, NULL);

			//蔻̑傫擾
			if( id == TOTAL_PARAMETERINFO_SMALLOBJECT+1 -1 ){
				decide = (float)MIFdata->GetAddSmallobjectDecide()*SMALLOBJECT_COLLISIONSCALE;
			}
			else{
				SmallObjectParameter Param;
				GameParamInfo->GetSmallObject(id, &Param);
				decide = (float)Param.decide*SMALLOBJECT_COLLISIONSCALE;
			}

			//蔻
			if( CollideSphereRay(ox, oy, oz, decide, bvx, bvy, bvz, vx, vy, vz, &Dist, (float)speed - TotalDist) == true ){
				if( Dist < SmallObject_Dist ){
					SmallObject_id = i;
					SmallObject_Dist = Dist;
				}
			}
		}

		//}bvƂ̏ՓˋŒZȂ΁`
		if( (map_Dist <= speed)&&(map_Dist < HumanHead_Dist)&&(map_Dist < HumanUp_Dist)&&(map_Dist < HumanLeg_Dist)&&(map_Dist < SmallObject_Dist) ){
			//e}bvɓ
			HitBulletMap(bx + vx*(map_Dist+TotalDist), by + vy*(map_Dist+TotalDist), bz + vz*(map_Dist+TotalDist));

			int Penetration_Dist;

			//}bvɂ߂荞łʂ𒲂ׂ
			//@@ŏIn_}bvɂ߂荞łȂ
			if( CollD->CheckALLBlockIntersectRay(bx + vx*speed, by + vy*speed, bz + vz*speed, vx*-1, vy*-1, vz*-1, &id, &face, &Dist, (float)speed - map_Dist+TotalDist) == true ){
				//˒n_ƍŏIn_Aꂼꂩ̌˓_ђʋ߂
				Penetration_Dist = (int)( ((float)speed - map_Dist+TotalDist - Dist) / 2 );
			}
			else{
				//Փ˓_ŏIn_܂ňړ
				Penetration_Dist = (int)( ((float)speed - map_Dist+TotalDist) / 2 );
			}

			//U͂Ɗђʗ͂vZ
			for(int i=0; i<Penetration_Dist; i++){
				attacks = (int)((float)attacks * 0.6f);
			}
			penetration -= Penetration_Dist;

			CheckDist = map_Dist + 1.0f;
		}

		//l̓Ƃ̏ՓˋŒZȂ΁`
		if( (HumanHead_Dist <= speed)&&(HumanHead_Dist < map_Dist)&&(HumanHead_Dist < HumanUp_Dist)&&(HumanHead_Dist < HumanLeg_Dist)&&(HumanHead_Dist < SmallObject_Dist) ){
			//lɓ
			HitBulletHuman(HumanHead_id, 0, bx + vx*(HumanHead_Dist+TotalDist), by + vy*(HumanHead_Dist+TotalDist), bz + vz*(HumanHead_Dist+TotalDist), brx, attacks, humanid);

			//U͂Ɗђʗ͂vZ
			attacks = (int)((float)attacks * 0.6f);
			penetration -= 1;

			CheckDist = HumanHead_Dist + 1.0f;
		}

		//l̏㔼gƂ̏ՓˋŒZȂ΁`
		if( (HumanUp_Dist <= speed)&&(HumanUp_Dist < map_Dist)&&(HumanUp_Dist < HumanHead_Dist)&&(HumanUp_Dist < HumanLeg_Dist)&&(HumanUp_Dist < SmallObject_Dist) ){
			//lɓ
			HitBulletHuman(HumanUp_id, 1, bx + vx*(HumanUp_Dist+TotalDist), by + vy*(HumanUp_Dist+TotalDist), bz + vz*(HumanUp_Dist+TotalDist), brx, attacks, humanid);

			//U͂Ɗђʗ͂vZ
			attacks = (int)((float)attacks * 0.6f);
			penetration -= 1;

			CheckDist = HumanUp_Dist + 1.0f;
		}

		//l̑Ƃ̏ՓˋŒZȂ΁`
		if( (HumanLeg_Dist <= speed)&&(HumanLeg_Dist < map_Dist)&&(HumanLeg_Dist < HumanHead_Dist)&&(HumanLeg_Dist < HumanUp_Dist)&&(HumanLeg_Dist < SmallObject_Dist) ){
			//lɓ
			HitBulletHuman(HumanLeg_id, 2, bx + vx*(HumanLeg_Dist+TotalDist), by + vy*(HumanLeg_Dist+TotalDist), bz + vz*(HumanLeg_Dist+TotalDist), brx, attacks, humanid);

			//U͂Ɗђʗ͂vZ
			attacks = (int)((float)attacks * 0.7f);
			penetration -= 1;

			CheckDist = HumanLeg_Dist + 1.0f;
		}

		//Ƃ̏ՓˋŒZȂ΁`
		if( (SmallObject_Dist <= speed)&&(SmallObject_Dist < map_Dist)&&(SmallObject_Dist < HumanHead_Dist)&&(SmallObject_Dist < HumanUp_Dist)&&(SmallObject_Dist < HumanLeg_Dist) ){
			//ɓ
			HitBulletSmallObject(SmallObject_id, bx + vx*(SmallObject_Dist+TotalDist), by + vy*(SmallObject_Dist+TotalDist), bz + vz*(SmallObject_Dist+TotalDist), attacks);

			//̎ޔԍ擾
			int id;
			int decide;
			SmallObjectIndex[SmallObject_id].GetParamData(&id, NULL);

			//蔻̑傫擾
			if( id == TOTAL_PARAMETERINFO_SMALLOBJECT+1 -1 ){
				decide = (int)( (float)MIFdata->GetAddSmallobjectDecide()*SMALLOBJECT_COLLISIONSCALE );
			}
			else{
				SmallObjectParameter Param;
				GameParamInfo->GetSmallObject(id, &Param);
				decide = (int)( (float)Param.decide*SMALLOBJECT_COLLISIONSCALE );
			}	

			//ђʗ͂vZ
			for(int i=0; i<decide; i++){
				attacks = (int)((float)attacks * 0.7f);
			}

			CheckDist = SmallObject_Dist + 1.0f;
		}

		//ݒKpiɍÚEђʗ́j
		in_bullet->SetParamData(attacks, penetration, speed, teamid, humanid, false);
	}

	return CollideFlag;
}

//! @brief e}bvɓ
//! @param x eXW
//! @param y eYW
//! @param z eZW
void ObjectManager::HitBulletMap(float x, float y, float z)
{
	//GtFNgij\
	AddEffect(x, y, z, 0.0f, 0.05f, 0.0f, 5.0f, DegreeToRadian(10)*GetRand(18), (int)(GAMEFPS * 0.5f), Resource->GetEffectSmokeTexture(), EFFECT_DISAPPEAR | EFFECT_MAGNIFY);

	//ʉĐ
	GameSound->HitMap(x, y, z);
}

//! @brief elɓ
//! @param HitHuman_id l̔ԍ
//! @param Hit_id eӏiF0@́F1@F2j
//! @param x eXW
//! @param y eYW
//! @param z eZW
//! @param brx px
//! @param attacks U
//! @param Shothuman_id ˂l̔ԍ
void ObjectManager::HitBulletHuman(int HitHuman_id, int Hit_id, float x, float y, float z, float brx, int attacks, int Shothuman_id)
{
	int damage = 0;

	//gpĂȂASĂΏȂB
	if( HumanIndex[HitHuman_id].GetEnableFlag() == false ){ return; }
	if( HumanIndex[HitHuman_id].GetHP() <= 0 ){ return; }

	//lɃ_[WƏՌ^
	if( Hit_id == 0 ){ HumanIndex[HitHuman_id].HitBulletHead(attacks); }
	if( Hit_id == 1 ){ HumanIndex[HitHuman_id].HitBulletUp(attacks); }
	if( Hit_id == 2 ){ HumanIndex[HitHuman_id].HitBulletLeg(attacks); }
	HumanIndex[HitHuman_id].AddPosOrder(brx, 0.0f, 1.0f);

	//GtFNgij\
	if( Hit_id == 0 ){ damage = (int)((float)attacks * HUMAN_DAMAGE_HEAD); }
	if( Hit_id == 1 ){ damage = (int)((float)attacks * HUMAN_DAMAGE_UP); }
	if( Hit_id == 2 ){ damage = (int)((float)attacks * HUMAN_DAMAGE_LEG); }
	SetHumanBlood(x, y, z, damage);

	//ʉĐ
	GameSound->HitHuman(x, y, z);

	//e𔭎˂l̐ʂɉZ
	Human_ontarget[Shothuman_id] += 1;
	if( Hit_id == 0 ){ Human_headshot[Shothuman_id] += 1; }
	if( HumanIndex[HitHuman_id].GetHP() <= 0 ){
		Human_kill[Shothuman_id] += 1;
	}
}

//! @brief eɓ
//! @param HitSmallObject_id ̔ԍ
//! @param x eXW
//! @param y eYW
//! @param z eZW
//! @param attacks U
void ObjectManager::HitBulletSmallObject(int HitSmallObject_id, float x, float y, float z, int attacks)
{
	int hp;

	//gpĂȂΏȂB
	if( SmallObjectIndex[HitSmallObject_id].GetEnableFlag() == false ){ return; }

	//̗͂ȂΏȂ
	hp = SmallObjectIndex[HitSmallObject_id].GetHP();
	if( hp <= 0 ){ return; }

	//Ƀ_[W^
	SmallObjectIndex[HitSmallObject_id].HitBullet(attacks);

	//GtFNgij\
	AddEffect(x, y, z, 0.0f, 0.05f, 0.0f, 5.0f, DegreeToRadian(10)*GetRand(18), (int)(GAMEFPS * 0.5f), Resource->GetEffectSmokeTexture(), EFFECT_DISAPPEAR | EFFECT_MAGNIFY);

	//ʉĐ
	int id;
	SmallObjectIndex[HitSmallObject_id].GetParamData(&id, NULL);
	GameSound->HitSmallObject(x, y, z, id);
}

//! @brief ֒ẽ_[WƏ
//! @param in_grenade Ώۂ̎֒eIuWFNg
//! @return Ftrue@ĂȂFfalse
//! @attention sΏۂ́ulvƁuvłB
//! @attention _[WɌ炸A_[WvZʉĐ܂ňтčs܂B
bool ObjectManager::GrenadeExplosion(grenade *in_grenade)
{
	bool returnflag = false;

	//W擾
	float gx, gy, gz;
	int humanid;
	in_grenade->GetPosData(&gx, &gy, &gz, NULL, NULL);
	in_grenade->GetParamData(NULL, NULL, NULL, NULL, &humanid);

	//lɔ̓蔻
	for(int i=0; i<MAX_HUMAN; i++){
		//ĂȂASĂΏȂB
		if( HumanIndex[i].GetEnableFlag() == false ){ continue; }
		if( HumanIndex[i].GetHP() <= 0 ){ continue; }

		float hx, hy, hz;
		float x, y, z, r;

		//l̍W擾AvZ
		HumanIndex[i].GetPosData(&hx, &hy, &hz, NULL);
		x = hx - gx;
		y = hy - gy;
		z = hz - gz;
		r = sqrt(x*x + y*y + z*z);

		//100.0艓ΌvZȂ
		if( r > MAX_DAMAGE_GRENADE_DISTANCE + HUMAN_HEIGTH ){ continue; }

		float dummy = 0.0f;
		int total_damage = 0;
		int damage;

		//ɓ蔻
		y = hy + 2.0f - gy;
		r = sqrt(x*x + y*y + z*z);
		//ubNՂĂȂ΁@iCœ蔻sAĂȂ΁j
		if( CollD->CheckALLBlockIntersectRay(gx, gy, gz, x/r, y/r, z/r, NULL, NULL, &dummy, r) == false ){
			//_[WʂvZ
			damage = HUMAN_DAMAGE_GRENADE_LEG - (int)((float)HUMAN_DAMAGE_GRENADE_LEG/MAX_DAMAGE_GRENADE_DISTANCE * r);
			if( damage > 0 ){
				total_damage += damage;
			}
		}

		//ɓ蔻
		y = hy + 18.0f - gy;
		r = sqrt(x*x + y*y + z*z);
		//ubNՂĂȂ΁@iCœ蔻sAĂȂ΁j
		if( CollD->CheckALLBlockIntersectRay(gx, gy, gz, x/r, y/r, z/r, NULL, NULL, &dummy, r) == false ){
			//_[WʂvZ
			damage = HUMAN_DAMAGE_GRENADE_HEAD - (int)((float)HUMAN_DAMAGE_GRENADE_HEAD/MAX_DAMAGE_GRENADE_DISTANCE * r);
			if( damage > 0 ){
				total_damage += damage;
			}
		}

		if( total_damage > 0 ){
			//_[W𔽉f
			HumanIndex[i].HitGrenadeExplosion(total_damage);

			float y2;
			float arx, ary;

			//|Ă΁A˂l̐ʂɉZ
			if( HumanIndex[i].GetHP() <= 0 ){
				Human_kill[humanid] += 1;
			}

			//GtFNgij\
			SetHumanBlood(hx, hy+15.0f, hz, total_damage);

			//lƎ֒e̋Zo
			x = gx - hx;
			y = gy - (hy + 1.0f);
			z = gz - hz;

			//px߂
			arx = atan2(z, x);

			if( sin(atan2(y, sqrt(x*x + z*z))) < 0.0f ){		//ɔԂȂApxvZ
				y2 = gy - (hy + HUMAN_HEIGTH);
				ary = atan2(y2, sqrt(x*x + z*z)) + (float)M_PI;
			}
			else{		//ɔԂȂApx͖BiŒnʂɂ߂荞ނ̂h~j
				ary = 0.0f;
			}

			//ɂ镗
			HumanIndex[i].AddPosOrder(arx, ary, 2.2f/MAX_DAMAGE_GRENADE_DISTANCE * (MAX_DAMAGE_GRENADE_DISTANCE - sqrt(x*x + y*y + z*z)));

			returnflag = true;
		}
	}

	//ɔ̓蔻
	for(int i=0; i<MAX_SMALLOBJECT; i++){
		//gpĂΏȂ
		if( SmallObjectIndex[i].GetEnableFlag() == false ){ continue; }

		float sx, sy, sz;
		float x, y, z, r;

		//̍W擾AvZ
		SmallObjectIndex[i].GetPosData(&sx, &sy, &sz, NULL);
		x = sx - gx;
		y = sy - gy;
		z = sz - gz;
		r = sqrt(x*x + y*y + z*z);

		//100.0艓ΌvZȂ
		if( r > MAX_DAMAGE_GRENADE_DISTANCE ){ continue; }

		float dummy = 0.0f;

		//ubNՂĂȂ΁@iCœ蔻sAĂȂ΁j
		if( CollD->CheckALLBlockIntersectRay(gx, gy, gz, x/r, y/r, z/r, NULL, NULL, &dummy, r) == false ){
			int id, damage;
			SmallObjectIndex[i].GetParamData(&id, NULL);

			//_[WʂvZAf
			damage = SMALLOBJECT_DAMAGE_GRENADE - (int)((float)SMALLOBJECT_DAMAGE_GRENADE/MAX_DAMAGE_GRENADE_DISTANCE * r);
			SmallObjectIndex[i].HitGrenadeExplosion(damage);

			//ʉ𔭂
			GameSound->HitSmallObject(sx, sy, sz, id);

			returnflag = true;
		}
	}

	//GtFNgitbVj̕\
	AddEffect(gx, gy, gz, 0.0f, 0.0f, 0.0f, 30.0f, 0.0f, 2, Resource->GetEffectMflashTexture(), EFFECT_NORMAL);

	//GtFNgij̕\
	float rnd = DegreeToRadian(10)*GetRand(18);
	AddEffect(gx+1.0f, gy+1.0f, gz+1.0f, 0.1f, 0.2f, 0.1f, 50.0f, rnd, (int)GAMEFPS * 3, Resource->GetEffectSmokeTexture(), EFFECT_DISAPPEAR | EFFECT_ROTATION | EFFECT_TRANSLUCENT);
	AddEffect(gx-1.0f, gy-1.0f, gz-1.0f, -0.1f, 0.2f, -0.1f, 50.0f, rnd*-1, (int)GAMEFPS * 3, Resource->GetEffectSmokeTexture(), EFFECT_DISAPPEAR | EFFECT_ROTATION | EFFECT_TRANSLUCENT);
	AddEffect(gx-1.0f, gy-1.0f, gz+1.0f, -0.1f, 0.2f, 0.1f, 50.0f, rnd, (int)GAMEFPS * 3, Resource->GetEffectSmokeTexture(), EFFECT_DISAPPEAR | EFFECT_ROTATION | EFFECT_TRANSLUCENT);
	AddEffect(gx+1.0f, gy+1.0f, gz-1.0f, 0.1f, 0.2f, -0.1f, 50.0f, rnd*-1, (int)GAMEFPS * 3, Resource->GetEffectSmokeTexture(), EFFECT_DISAPPEAR | EFFECT_ROTATION | EFFECT_TRANSLUCENT);

	//ʉĐ
	GameSound->GrenadeExplosion(gx, gy, gz);

	return returnflag;
}

//! @brief |ꂽۂ̃GtFNgݒ
//! @param in_human Ώۂ̐lIuWFNg
void ObjectManager::DeadEffect(human *in_human)
{
	if( in_human == NULL ){ return; }

	int paramid;
	float hx, hy, hz, hrx, hry;
	HumanParameter data;

	//ep[^[擾
	in_human->GetParamData(&paramid, NULL, NULL, NULL);
	in_human->GetPosData(&hx, &hy, &hz, &hrx);
	hry = in_human->GetDeadRy();

	//ݒl擾
	if( GameParamInfo->GetHuman(paramid, &data) != 0 ){ return; }

	//{bgȂ
	if( data.type == 1 ){

		//ӂ̍WZo
		hx += cos(hrx*-1 - (float)M_PI/2) * sin(hry) * HUMAN_HEIGTH/2;
		hz += sin(hrx*-1 - (float)M_PI/2) * sin(hry) * HUMAN_HEIGTH/2;

		//GtFNgij̕\
		float rnd = DegreeToRadian(10)*GetRand(18);
		AddEffect(hx+1.0f, hy+1.0f, hz+1.0f, 0.0f, 0.05f, 0.0f, 10.0f, rnd, (int)GAMEFPS * 3, Resource->GetEffectSmokeTexture(), EFFECT_DISAPPEAR | EFFECT_MAGNIFY | EFFECT_ROTATION);
		AddEffect(hx-1.0f, hy-1.0f, hz-1.0f, 0.0f, 0.05f, 0.0f, 10.0f, rnd*-1, (int)GAMEFPS * 3, Resource->GetEffectSmokeTexture(), EFFECT_DISAPPEAR | EFFECT_MAGNIFY | EFFECT_ROTATION);
		AddEffect(hx-1.0f, hy-1.0f, hz+1.0f, 0.0f, 0.05f, 0.0f, 10.0f, rnd, (int)GAMEFPS * 3, Resource->GetEffectSmokeTexture(), EFFECT_DISAPPEAR | EFFECT_MAGNIFY | EFFECT_ROTATION);
		AddEffect(hx+1.0f, hy+1.0f, hz-1.0f, 0.0f, 0.05f, 0.0f, 10.0f, rnd*-1, (int)GAMEFPS * 3, Resource->GetEffectSmokeTexture(), EFFECT_DISAPPEAR | EFFECT_MAGNIFY | EFFECT_ROTATION);
	}
}

//! }bvɌt邩
//! @param in_effect Ώۂ̃GtFNgIuWFNg
//! @param id tubNԍ󂯎|C^
//! @param face tʔԍ󂯎|C^
//! @param pos_x XW󂯎|C^
//! @param pos_y YW󂯎|C^
//! @param pos_z ZW󂯎|C^
//! @return tFtrue@tȂFfalse
bool ObjectManager::CollideBlood(effect *in_effect, int *id, int *face, float *pos_x, float *pos_y, float *pos_z)
{
	//ȃGtFNgȂΏȂ
	if( in_effect->GetEnableFlag() == false ){ return false; }
	if( in_effect->GetTextureID() != Resource->GetEffectBloodTexture() ){ return false; }

	//oȂݒȂ珈Ȃ
	if( GameConfig.GetBloodFlag() == false ){ return false; }

	float x, y, z;
	float move_x, move_y, move_z;
	float vx, vy, vz, dist, dist2;

	//GtFNg̃p[^[擾
	in_effect->GetPosData(&x, &y, &z, NULL);
	in_effect->GetMove(&move_x, &move_y, &move_z);

	//xNg߂
	dist = sqrt(move_x*move_x + move_y*move_y + move_z*move_z);
	vx = move_x / dist;
	vy = move_y / dist;
	vz = move_z / dist;

	//C̓蔻
	if( CollD->CheckALLBlockIntersectRay(x, y, z, vx, vy, vz, id, face, &dist2, dist) == false ){
		return false;
	}

	//}bv킸ɕ
	dist2 -= 1.0f;

	//tW߂
	*pos_x = x + vx*dist2;
	*pos_y = y + vy*dist2;
	*pos_z = z + vz*dist2;

	return true;
}

//! @brief E
//! @param in_human Ώۂ̐lIuWFNg
//! @param in_weapon Ώۂ̕IuWFNg
void ObjectManager::PickupWeapon(human *in_human, weapon *in_weapon)
{
	//ȐlȂΏȂ
	if( in_human->GetEnableFlag() == false ){ return; }
	if( in_human->GetHP() <= 0 ){ return; }

	//Ă镐ŁANgĂȂȂ΁`
	if( (in_weapon->GetEnableFlag() == true)&&(in_weapon->GetUsingFlag() == false) ){
		float human_x, human_y, human_z;
		float weapon_x, weapon_y, weapon_z;
		float x, z;
		float r;

		//lƕ̍W擾
		in_human->GetPosData(&human_x, &human_y, &human_z, NULL);
		in_weapon->GetPosData(&weapon_x, &weapon_y, &weapon_z, NULL);

		//͈͓Ȃ
		if( (human_y-2.0f <= weapon_y)&&(human_y+16.0f > weapon_y) ){
			//vZ
			x = human_x - weapon_x;
			z = human_z - weapon_z;
			r = x*x + z*z;
			//͈͓Ȃ΁AE킹B
			if( r < (5.0f * 5.0f) ){
				in_human->PickupWeapon(in_weapon);
			}
		}
	}
}

//! @brief IuWFNg
void ObjectManager::CleanupPointDataToObject()
{
	for(int i=0; i<MAX_HUMAN; i++){
		HumanIndex[i].SetEnableFlag(false);
	}

	for(int i=0; i<MAX_WEAPON; i++){
		WeaponIndex[i].SetEnableFlag(false);
	}

	for(int i=0; i<MAX_SMALLOBJECT; i++){
		SmallObjectIndex[i].SetEnableFlag(false);
	}

	for(int i=0; i<MAX_BULLET; i++){
		BulletIndex[i].SetEnableFlag(false);
	}

	for(int i=0; i<MAX_GRENADE; i++){
		GrenadeIndex[i].SetEnableFlag(false);
	}

	for(int i=0; i<MAX_EFFECT; i++){
		EffectIndex[i].SetEnableFlag(false);
	}


	if( Resource != NULL ){
		Resource->CleanupHumanTexture();
	}
}

//! @brief |Cgf[^ɃIuWFNgzu
void ObjectManager::LoadPointData()
{
	FriendlyFire = false;
	Player_HumanID = 0;

	/*
	//l|CgT
	for(int i=0; i<PointData->GetTotaldatas(); i++){
		pointdata data;
		PointData->Getdata(&data, i);

		if( data.p1 == 4 ){
			//l̃eNX`o^
			Resource->AddHumanTexture(data.p2);
		}
	}
	*/

	//lEET
	for(int i=0; i<PointData->GetTotaldatas(); i++){
		pointdata data;
		PointData->Getdata(&data, i);

		//lȂ
		if( (data.p1 == 1)||(data.p1 == 6) ){
			pointdata humaninfodata;

			//l|CgT
			if( PointData->SearchPointdata(&humaninfodata, 0x01 + 0x08, 4, 0, 0, data.p2, 0) == 0 ){
				//continue;

				//l|CgȂAƂ肠u  AvƂĒǉBioO̍Čj

				HumanParameter HumanParam;
				int Weapon[TOTAL_HAVEWEAPON];
				GameParamInfo->GetHuman(0, &HumanParam);
				for(int j=0; j<TOTAL_HAVEWEAPON; j++){
					Weapon[j] = HumanParam.Weapon[j];
				}

				//l̃eNX`o^
				Resource->AddHumanTexture(0);

				//lǉ
				if( data.p1 == 6 ){
					Weapon[1] = ID_WEAPON_NONE;
				}

				//vC[Ȃ΁AԍL^
				if( (data.p4 == 0)&&(Player_HumanID == 0) ){
					Player_HumanID = AddHumanIndex(data.x, data.y, data.z, data.r, 0, i, Weapon);
				}
				else{
					AddHumanIndex(data.x, data.y, data.z, data.r, 0, i, Weapon);
				}
			}
			else{
				//l̃eNX`o^
				Resource->AddHumanTexture(humaninfodata.p2);

				//lƂĒǉ
				AddHumanIndex(data, humaninfodata);
			}
		}

		//Ȃ
		if( (data.p1 == 2)||(data.p1 == 7) ){
			AddWeaponIndex(data);
		}

		//Ȃ
		if( data.p1 == 5 ){
			AddSmallObjectIndex(data);
		}
	}
}

//! @brief \[X̉
//! @todo SẴGtFNgB
void ObjectManager::Recovery()
{
	//l̃fԍ擾
	int upmodel[TOTAL_UPMODE];
	int armmodel[TOTAL_ARMMODE];
	int legmodel;
	int walkmodel[TOTAL_WALKMODE];
	int runmodel[TOTAL_RUNMODE];
	Resource->GetHumanModel(upmodel, armmodel, &legmodel, walkmodel, runmodel);

	//l
	int HumanID;
	int GetHumanFlag;
	HumanParameter HumanParam;
	for(int i=0; i<MAX_HUMAN; i++){
		if( HumanIndex[i].GetEnableFlag() == true ){
			HumanIndex[i].GetParamData(&HumanID, NULL, NULL, NULL);

			GetHumanFlag = GameParamInfo->GetHuman(HumanID, &HumanParam);

			if( GetHumanFlag == 0 ){
				//l̃eNX`o^
				Resource->AddHumanTexture(HumanID);

				//ǂݍ߂Ȃ΁AOǂݍ񂾃eNX`ԍ𗘗p
				//ǂݍ߂΁AǂݍރeNX`ԍ㏑
				int id = Resource->GetHumanTexture(HumanID);
				if( id == -1 ){
					id = AddHumanIndex_TextureID;
				}
				else{
					AddHumanIndex_TextureID = id;
				}

				HumanIndex[i].SetTexture(id);
				HumanIndex[i].SetModel(upmodel[ HumanParam.model ], armmodel, legmodel, walkmodel, runmodel);
			}
			else{
				//ǂݍރeNX`ԍ㏑
				AddHumanIndex_TextureID = d3dg->GetMapTextureID(0);

				HumanIndex[i].SetTexture(AddHumanIndex_TextureID);
				HumanIndex[i].SetModel(upmodel[0], armmodel, legmodel, walkmodel, runmodel);
			}
		}
	}

	//
	int WeaponID;
	int Weaponmodel, Weapontexture;
	for(int i=0; i<MAX_WEAPON; i++){
		if( WeaponIndex[i].GetEnableFlag() == true ){
			//ݒl擾
			WeaponParameter WeaponParam;
			WeaponIndex[i].GetParamData(&WeaponID, NULL, NULL);
			if( Resource->GetWeaponModelTexture(WeaponID, &Weaponmodel, &Weapontexture) == 1 ){ continue; }
			if( GameParamInfo->GetWeapon(WeaponID, &WeaponParam) == 1 ){ continue; }

			//Kp
			WeaponIndex[i].SetModel(Weaponmodel, WeaponParam.size);
			WeaponIndex[i].SetTexture(Weapontexture);
		}
	}

	//
	int SmallObjectID;
	int SmallObjectmodel, SmallObjecttexture;
	for(int i=0; i<MAX_SMALLOBJECT; i++){
		if( SmallObjectIndex[i].GetEnableFlag() == true ){
			//ݒl擾
			SmallObjectIndex[i].GetParamData(&SmallObjectID, NULL);
			if( Resource->GetSmallObjectModelTexture(SmallObjectID, &SmallObjectmodel, &SmallObjecttexture) == 1 ){ continue; }

			//Kp
			SmallObjectIndex[i].SetModel(SmallObjectmodel, SMALLOBJECT_SCALE);
			SmallObjectIndex[i].SetTexture(SmallObjecttexture);
		}
	}

	//eeKp
	int bulletmodel, bullettexture;
	Resource->GetBulletModelTexture(&bulletmodel, &bullettexture);
	for(int i=0; i<MAX_BULLET; i++){
		BulletIndex[i].SetModel(bulletmodel, BULLET_SCALE);
		BulletIndex[i].SetTexture(bullettexture);
	}

	//֒ẽ\[XƃfTCY擾
	int grenademodel, grenadetexture;
	float model_size = 1.0f;
	WeaponParameter ParamData;
	Resource->GetWeaponModelTexture(ID_WEAPON_GRENADE, &grenademodel, &grenadetexture);
	if( GameParamInfo->GetWeapon(ID_WEAPON_GRENADE, &ParamData) == 0 ){
		model_size = ParamData.size;
	}

	//֒eKp
	for(int i=0; i<MAX_GRENADE; i++){
		GrenadeIndex[i].SetModel(grenademodel, model_size);
		GrenadeIndex[i].SetTexture(grenadetexture);
	}

	//SẴGtFNg𖳌
	for(int i=0; i<MAX_EFFECT; i++){
		if( EffectIndex[i].GetEnableFlag() == true ){
			EffectIndex[i].SetEnableFlag(false);
		}
	}
}

//! @brief FFimjLtO擾
//! @return tO
bool ObjectManager::GetFriendlyFireFlag()
{
	return FriendlyFire;
}

//! @brief FFimjLtOݒ
//! @param flag tO
void ObjectManager::SetFriendlyFireFlag(bool flag)
{
	FriendlyFire = flag;
}

//! @brief vC[ԍ擾
//! @return vC[̃f[^ԍ
int ObjectManager::GetPlayerID()
{
	return Player_HumanID;
}

//! @brief vC[ԍݒ
//! @param id vC[̃f[^ԍ
void ObjectManager::SetPlayerID(int id)
{
	Player_HumanID = id;
}

//! @brief w肵f[^ԍhumanNX擾
//! @param id f[^ԍ
//! @return lIuWFNg̃|C^@iȃf[^ԍ NULLj
human* ObjectManager::GeHumanObject(int id)
{
	if( (id < 0)||(MAX_HUMAN-1 < id) ){ return NULL; }
	return &(HumanIndex[id]);
}

//! @brief vC[humanNX擾
//! @return lIuWFNgivC[j̃|C^
human* ObjectManager::GetPlayerHumanObject()
{
	return GeHumanObject(Player_HumanID);
}

//! @brief w肵f[^ԍweaponNX擾
//! @param id f[^ԍ
//! @return IuWFNg̃|C^@iȃf[^ԍ NULLj
weapon* ObjectManager::GetWeaponObject(int id)
{
	if( (id < 0)||(MAX_WEAPON-1 < id) ){ return NULL; }
	return &(WeaponIndex[id]);
}

//! @brief w肵f[^ԍsmallobjectNX擾
//! @param id f[^ԍ
//! @return IuWFNg̃|C^@iȃf[^ԍ NULLj
smallobject* ObjectManager::GetSmallObject(int id)
{
	if( (id < 0)||(MAX_SMALLOBJECT-1 < id) ){ return NULL; }
	return &(SmallObjectIndex[id]);
}

//! @brief w肵f[^ԍbulletNX擾
//! @param id f[^ԍ
//! @return eIuWFNg̃|C^@iȃf[^ԍ NULLj
bullet* ObjectManager::GetBulletObject(int id)
{
	if( (id < 0)||(MAX_BULLET-1 < id) ){ return NULL; }
	return &(BulletIndex[id]);
}

//! @brief gpĂȂbulletNX擾
//! @return ݖgp̒eIuWFNg̃|C^@is NULLj
bullet* ObjectManager::GetNewBulletObject()
{
	for(int i=0; i<MAX_BULLET; i++){
		if( BulletIndex[i].GetEnableFlag() == false ){
			return &(BulletIndex[i]);
		}
	}
	return NULL;
}

//! @brief gpĂȂgrenadeNX擾
//! @return ݖgp̎֒eIuWFNg̃|C^@is NULLj
grenade* ObjectManager::GetNewGrenadeObject()
{
	for(int i=0; i<MAX_GRENADE; i++){
		if( GrenadeIndex[i].GetEnableFlag() == false ){
			return &(GrenadeIndex[i]);
		}
	}
	return NULL;
}

//! @brief l
//! @param p4 Ώۂ̔Fԍ
//! @return YhumanNX̃|C^@iȂꍇNULLj
//! @attention YꍇAŏɊYf[^Ԃ܂B
human* ObjectManager::SearchHuman(signed char p4)
{
	signed char humanp4;

	for(int i=0; i<MAX_HUMAN; i++){
		//gĂȂlȂΏȂ
		if( HumanIndex[i].GetEnableFlag() == false ){ continue; }

		//4p[^擾
		HumanIndex[i].GetParamData(NULL, NULL, &humanp4, NULL);

		//w肳ꂽp4ƈvΕԂ
		if( humanp4 == p4 ){
			return &(HumanIndex[i]);
		}
	}
	return NULL;
}

//! @brief 
//! @param p4 Ώۂ̔Fԍ
//! @return YsmallobjectNX̃|C^@iȂꍇNULLj
//! @attention YꍇAŏɊYf[^Ԃ܂B
smallobject* ObjectManager::SearchSmallobject(signed char p4)
{
	signed char smallobjectp4;

	for(int i=0; i<MAX_SMALLOBJECT; i++){
		//gĂȂlȂΏȂ
		//@yjς݂̃IuWFNg肷邽߁Az
		//if( SmallObjectIndex[i].GetEnableFlag() == false ){ continue; }

		//4p[^擾
		SmallObjectIndex[i].GetParamData(NULL, &smallobjectp4);

		//w肳ꂽp4ƈvΕԂ
		if( smallobjectp4 == p4 ){
			return &(SmallObjectIndex[i]);
		}
	}
	return NULL;
}

//! @brief Oiijs
//! @param human_id l̔ԍi0`MAX_HUMAN-1j
void ObjectManager::MoveForward(int human_id)
{
	//l͈̔͂`FbN
	if( (human_id < 0)||(MAX_HUMAN <= human_id) ){ return; }

	//IuWFNgɃtOݒ
	HumanIndex[human_id].SetMoveForward();
}

//! @brief ނs
//! @param human_id l̔ԍi0`MAX_HUMAN-1j
void ObjectManager::MoveBack(int human_id)
{
	//l͈̔͂`FbN
	if( (human_id < 0)||(MAX_HUMAN <= human_id) ){ return; }

	//IuWFNgɃtOݒ
	HumanIndex[human_id].SetMoveBack();
}

//! @brief s
//! @param human_id l̔ԍi0`MAX_HUMAN-1j
void ObjectManager::MoveLeft(int human_id)
{
	//l͈̔͂`FbN
	if( (human_id < 0)||(MAX_HUMAN <= human_id) ){ return; }

	//IuWFNgɃtOݒ
	HumanIndex[human_id].SetMoveLeft();
}

//! @brief Es
//! @param human_id l̔ԍi0`MAX_HUMAN-1j
void ObjectManager::MoveRight(int human_id)
{
	//l͈̔͂`FbN
	if( (human_id < 0)||(MAX_HUMAN <= human_id) ){ return; }

	//IuWFNgɃtOݒ
	HumanIndex[human_id].SetMoveRight();
}

//! @brief s
//! @param human_id l̔ԍi0`MAX_HUMAN-1j
void ObjectManager::MoveWalk(int human_id)
{
	//l͈̔͂`FbN
	if( (human_id < 0)||(MAX_HUMAN <= human_id) ){ return; }

	//IuWFNgɃtOݒ
	HumanIndex[human_id].SetMoveWalk();
}

//! @brief Wv
//! @param human_id l̔ԍi0`MAX_HUMAN-1j
void ObjectManager::MoveJump(int human_id)
{
	//l͈̔͂`FbN
	if( (human_id < 0)||(MAX_HUMAN <= human_id) ){ return; }

	HumanIndex[human_id].Jump();
}

//! @brief C
//! @param human_id Clԍ
//! @return ʏeˁF1@֒eˁF2@sF0
int ObjectManager::ShotWeapon(int human_id)
{
	//l͈̔͂`FbN
	if( (human_id < 0)||(MAX_HUMAN <= human_id) ){ return 0; }

	human *MyHuman = &(HumanIndex[human_id]);

	float pos_x, pos_y, pos_z;
	int teamid;
	float rotation_x, armrotation_y;
	int weapon_paramid;
	int GunsightErrorRange;
	WeaponParameter ParamData;
	bool playerflag;
	bool grenadeflag;

	//l̍WƊpx擾
	MyHuman->GetPosData(&pos_x, &pos_y, &pos_z, NULL);
	MyHuman->GetParamData(NULL, NULL, NULL, &teamid);
	MyHuman->GetRxRy(&rotation_x, &armrotation_y);

	//Ώێ҂vC[g
	if( MyHuman == &(HumanIndex[Player_HumanID]) ){
		playerflag = true;
	}
	else{
		playerflag = false;
	}

	//e̔˂v
	if( MyHuman->ShotWeapon(&weapon_paramid, &GunsightErrorRange) == false ){ return 0; }

	//̏擾
	if( GameParamInfo->GetWeapon(weapon_paramid, &ParamData) != 0 ){ return 0; }

	//덷͈̔͂vZ
	int ErrorRange;
	ErrorRange = GunsightErrorRange;
	if( ErrorRange < ParamData.ErrorRangeMIN ){ ErrorRange = ParamData.ErrorRangeMIN; }

	//֒e
	if( weapon_paramid == ID_WEAPON_GRENADE ){ grenadeflag = true; }
	else{ grenadeflag = false; }

	class bullet* newbullet;
	class grenade* newgrenade;

	//iVbgKȂǁj˂e̐JԂ
	for(int i=0; i<ParamData.burst; i++){
		//ˊpx
		float rx, ry;
		rx = rotation_x*-1 + (float)M_PI/2;
		ry = armrotation_y;

		//덷 Z
		float a;
		a = DegreeToRadian(1) * GetRand(360);
		rx += cos(a)*ErrorRange * DegreeToRadian(0.15f);
		ry += sin(a)*ErrorRange * DegreeToRadian(0.15f);

		//֒ełȂ
		if( grenadeflag == false ){
			int attacks;

			//iVbgKȂǁj˂e
			if( ParamData.burst > 1 ){
				//1̒e̍U͂Zo
				//@@Se킹āAU͂2{ɂȂ悤ɂB
				attacks = (int)( (float)ParamData.attacks / ((float)ParamData.burst/2) );
			}
			else{
				//̂܂܍U͂֔f
				attacks = ParamData.attacks;
			}

			//˂関gp̃IuWFNg擾
			newbullet = GetNewBulletObject();
			if( newbullet == NULL ){ break; }

			//ee𔭎
			newbullet->SetPosData(pos_x, pos_y + WEAPONSHOT_HEIGHT, pos_z, rx, ry);
			newbullet->SetParamData(attacks, ParamData.penetration, ParamData.speed * BULLET_SPEEDSCALE, teamid, human_id, true);
			newbullet->SetEnableFlag(true);
		}
		else{
			//˂関gp̃IuWFNg擾
			newgrenade = GetNewGrenadeObject();
			if( newgrenade == NULL ){ break; }

			//֒e
			newgrenade->SetPosData(pos_x, pos_y + WEAPONSHOT_HEIGHT, pos_z, rx, ry);
			newgrenade->SetParamData(8.0f, human_id, true);
			newgrenade->SetEnableFlag(true);
		}

		//덷ZiVbgKpj
		ErrorRange += ParamData.ErrorRangeMIN;
	}

	//֒ełȂ
	if( grenadeflag == false ){
		//CtOݒ
		Human_ShotFlag[human_id] = true;
	}

	if( ParamData.soundvolume > 0 ){
		//eĐ
		GameSound->ShotWeapon(pos_x, pos_y + WEAPONSHOT_HEIGHT, pos_z, weapon_paramid, teamid, playerflag);
	}

	if( grenadeflag == true ){
		return 2;
	}
	return 1;
}

//! @brief }YtbVݒ
//! @param humanid l̔ԍ
//! @attention ̊֐̌Ăяo^C~OƁAeɑ΂ă}YtbV܂B
void ObjectManager::ShotWeaponEffect(int humanid)
{
	float pos_x, pos_y, pos_z;
	float rotation_x, armrotation_y;
	int weapon_paramid;
	WeaponParameter ParamData;
	float x, y, z;
	float flashsize, smokesize, yakkyousize;
	float rx, mx, my, mz;

	//l̍WƊpx擾
	HumanIndex[humanid].GetPosData(&pos_x, &pos_y, &pos_z, NULL);
	HumanIndex[humanid].GetRxRy(&rotation_x, &armrotation_y);

	//̏擾
	weapon_paramid = HumanIndex[humanid].GetMainWeaponTypeNO();
	if( GameParamInfo->GetWeapon(weapon_paramid, &ParamData) != 0 ){ return; }

	//}YtbVƉ̃TCY
	flashsize = 0.06f * ParamData.attacks;
	smokesize = flashsize;
	yakkyousize = 0.01f * ParamData.attacks;
	if( ParamData.silencer == true ){
		flashsize /= 2;
	}

	//䰂̈ړʂ
	rx = rotation_x*-1 + (float)M_PI/2;
	mx = cos(rx - (float)M_PI/2) * ParamData.yakkyou_sx /10;
	my = (ParamData.yakkyou_sy + (GetRand(3)-1)) /10;
	mz = sin(rx - (float)M_PI/2) * ParamData.yakkyou_sx /10;

	//sŃGtFNgWvZ
	d3dg->SetWorldTransformHumanWeapon(pos_x, pos_y + 16.0f, pos_z, ParamData.flashx/10, ParamData.flashy/10, ParamData.flashz/10, rotation_x, armrotation_y*-1, 1.0f);
	d3dg->GetWorldTransformPos(&x, &y, &z);
	d3dg->ResetWorldTransform();

	//}YtbV`
	AddEffect(x, y, z, 0.0f, 0.0f, 0.0f, flashsize, DegreeToRadian(10)*GetRand(18), 1, Resource->GetEffectMflashTexture(), EFFECT_NORMAL);

	//sŃGtFNgWvZ
	d3dg->SetWorldTransformHumanWeapon(pos_x, pos_y + 16.0f, pos_z, ParamData.flashx/10, ParamData.flashy/10, ParamData.flashz/10 - 0.1f, rotation_x, armrotation_y*-1, 1.0f);
	d3dg->GetWorldTransformPos(&x, &y, &z);
	d3dg->ResetWorldTransform();

	//GtFNgij̕\
	AddEffect(x, y, z, 0.0f, 0.05f, 0.0f, smokesize, DegreeToRadian(10)*GetRand(18), (int)(GAMEFPS/3), Resource->GetEffectSmokeTexture(), EFFECT_DISAPPEAR | EFFECT_MAGNIFY | EFFECT_ROTATION);

	//sŃGtFNgWvZ
	d3dg->SetWorldTransformHumanWeapon(pos_x, pos_y + 16.0f, pos_z, ParamData.yakkyou_px/10, ParamData.yakkyou_py/10, ParamData.yakkyou_pz/10, rotation_x, armrotation_y*-1, 1.0f);
	d3dg->GetWorldTransformPos(&x, &y, &z);
	d3dg->ResetWorldTransform();

	//䰕`
	AddEffect(x, y, z, mx, my, mz, yakkyousize, DegreeToRadian(10)*GetRand(18), (int)(GAMEFPS/2), Resource->GetEffectYakkyouTexture(), EFFECT_ROTATION | EFFECT_FALL);
}

//! @brief [h
//! @param human_id Ώۂ̐lԍ
void ObjectManager::ReloadWeapon(int human_id)
{
	//l͈̔͂`FbN
	if( (human_id < 0)||(MAX_HUMAN <= human_id) ){ return; }

	//ȐlȂΏȂ
	if( HumanIndex[human_id].GetEnableFlag() == false ){ return; }
	if( HumanIndex[human_id].GetHP() <= 0 ){ return; }

	//[hs
	if( HumanIndex[human_id].ReloadWeapon() == true ){
		float x, y, z;
		int id;

		//l̍Wƃ`[ԍ擾
		HumanIndex[human_id].GetPosData(&x, &y, &z, NULL);
		HumanIndex[human_id].GetParamData(NULL, NULL, NULL, &id);
		y += 16.0f;

		//zu
		GameSound->ReloadWeapon(x, y, z, id);
	}
}

//! @brief ؂ւiւj
//! @param human_id l̔ԍi0`MAX_HUMAN-1j
//! @param id ւ镐@i-1 Ŏ̕j
void ObjectManager::ChangeWeapon(int human_id, int id)
{
	//l͈̔͂`FbN
	if( (human_id < 0)||(MAX_HUMAN <= human_id) ){ return; }

	HumanIndex[human_id].ChangeWeapon(id);
}

//! @brief ̂Ă
//! @param human_id l̔ԍi0`MAX_HUMAN-1j
//! @return Ftrue@sFfalse
bool ObjectManager::DumpWeapon(int human_id)
{
	//l͈̔͂`FbN
	if( (human_id < 0)||(MAX_HUMAN <= human_id) ){ return false; }

	return HumanIndex[human_id].DumpWeapon();
}

//! @brief XR[v[h؂ւ
//! @param human_id l̔ԍi0`MAX_HUMAN-1j
void ObjectManager::ChangeScopeMode(int human_id)
{
	//l͈̔͂`FbN
	if( (human_id < 0)||(MAX_HUMAN <= human_id) ){ return; }

	if( HumanIndex[human_id].GetScopeMode() == 0 ){	//XR[vgpĂȂ΁AXR[vݒ
		HumanIndex[human_id].SetEnableScope();
	}
	else{											//gpȂA
		HumanIndex[human_id].SetDisableScope();
	}
}

//! @brief ̃Vbg[h؂ւ
//! @param human_id l̔ԍi0`MAX_HUMAN-1j
//! @return F0@sF1
int ObjectManager::ChangeShotMode(int human_id)
{
	//l͈̔͂`FbN
	if( (human_id < 0)||(MAX_HUMAN <= human_id) ){ return 1; }

	return HumanIndex[human_id].ChangeShotMode();
}

//! @brief ZEĂ镐̒eǉ
//! @param human_id l̔ԍi0`MAX_HUMAN-1j
//! @return Ftrue@sFfalse
bool ObjectManager::CheatAddBullet(int human_id)
{
	//l͈̔͂`FbN
	if( (human_id < 0)||(MAX_HUMAN <= human_id) ){ return false; }

	int selectweapon;
	weapon *weapon[TOTAL_HAVEWEAPON];
	int id_param, lnbs, nbs;
	WeaponParameter ParamData;

	//Ă镐擾
	for(int i=0; i<TOTAL_HAVEWEAPON; i++){
		weapon[i] = NULL;
	}
	HumanIndex[human_id].GetWeapon(&selectweapon, weapon);

	//̕Ă
	if( weapon[selectweapon] != NULL ){
		//̎ނƒeA̐ݒl擾
		weapon[selectweapon]->GetParamData(&id_param, &lnbs, &nbs);
		if( GameParamInfo->GetWeapon(id_param, &ParamData) == 0 ){
			//őeZAKp
			nbs += ParamData.nbsmax;
			weapon[selectweapon]->ResetWeaponParam(Resource, id_param, lnbs, nbs);
			return true;
		}
	}

	return false;
}

//! @brief ZEĂ镐ύX
//! @param human_id l̔ԍi0`MAX_HUMAN-1j
//! @param new_weaponID Vɐݒ肷镐̎ޔԍ
//! @return Ftrue@sFfalse
bool ObjectManager::CheatNewWeapon(int human_id, int new_weaponID)
{
	//l͈̔͂`FbN
	if( (human_id < 0)||(MAX_HUMAN <= human_id) ){ return false; }
	if( (new_weaponID < 0)||(TOTAL_PARAMETERINFO_WEAPON <= new_weaponID) ){ return false; }

	human *myHuman = &(HumanIndex[human_id]);

	int selectweapon;
	weapon *weapon[TOTAL_HAVEWEAPON];
	int lnbs, nbs;

	//Ă镐擾
	for(int i=0; i<TOTAL_HAVEWEAPON; i++){
		weapon[i] = NULL;
	}
	myHuman->GetWeapon(&selectweapon, weapon);

	//ݕLĂ炸AVɎ镐ȂȂ
	if( (weapon[selectweapon] == NULL)&&(new_weaponID == ID_WEAPON_NONE) ){
		return false;		//̂Ӗ
	}

	if( weapon[selectweapon] == NULL ){		//LĂȂ
		int dataid = -1;

		//Vzu
		dataid = AddVisualWeaponIndex(new_weaponID, false);

		//킪zuł΁A
		if( dataid != -1 ){
			weapon[selectweapon] = &(WeaponIndex[dataid]);
			myHuman->SetWeapon(weapon);
			return true;
		}
	}
	else{									//LĂ
		if( new_weaponID == ID_WEAPON_NONE ){			//Ȃ
			//x̂ĂŁA̕폜
			if( myHuman->DumpWeapon() == true ){
				weapon[selectweapon]->SetEnableFlag(false);
				return true;
			}
		}
		else{											//ύXȂ
			//ݒ擾ieݒp߁j
			weapon[selectweapon]->GetParamData(NULL, &lnbs, &nbs);

			//ݒKp
			weapon[selectweapon]->ResetWeaponParam(Resource, new_weaponID, lnbs, nbs);

			return true;
		}
	}

	return false;
}

//! @brief ]r̍U󂯂邩
//! @param MyHuman UlIuWFNgi]rj̃|C^
//! @param EnemyHuman U󂯂lIuWFNg̃|C^
//! @return Ftrue@sFfalse
//! @warning MyHuman ̓]rȊOwł܂B<b>]rǂ͔肵Ȃ</b>߁A]rł邩\ߊmFĂKv܂B
//! @attention ݂̂{܂B̔肪 HitZombieAttack()֐ ĂяoĂB 
bool ObjectManager::CheckZombieAttack(human* MyHuman, human* EnemyHuman)
{
	if( MyHuman == NULL ){ return false; }
	if( EnemyHuman == NULL ){ return false; }

	//gpĂȂASĂΏȂB
	if( MyHuman->GetEnableFlag() == false ){ return false; }
	if( MyHuman->GetHP() <= 0 ){ return false; }
	if( EnemyHuman->GetEnableFlag() == false ){ return false; }
	if( EnemyHuman->GetHP() <= 0 ){ return false; }

	float mx, my, mz, mrx, tx, ty, tz;
	int mteam, tteam;
	float AttackPoint_x, AttackPoint_y, AttackPoint_z;
	float ax, az;

	MyHuman->GetPosData(&mx, &my, &mz, &mrx);
	MyHuman->GetParamData(NULL, NULL, NULL, &mteam);
	my += VIEW_HEIGHT;
	EnemyHuman->GetPosData(&tx, &ty, &tz, NULL);
	EnemyHuman->GetParamData(NULL, NULL, NULL, &tteam);
	ty += VIEW_HEIGHT;

	//ȂΏȂ
	if( mteam == tteam ){ return false; }

	//U|Cgir̐[j߂
	AttackPoint_x = mx + cos(mrx*-1 + (float)M_PI/2) * 2.0f;
	AttackPoint_y = my + VIEW_HEIGHT - 0.5f;
	AttackPoint_z = mz + sin(mrx*-1 + (float)M_PI/2) * 2.0f;
	ax = AttackPoint_x - tx;
	az = AttackPoint_z - tz;

	//GiUΏہjU|CgɐGĂ΁AĂ
	if( (ax*ax + az*az) < 3.3f*3.3f ){
		if( (AttackPoint_y >= ty)&&(AttackPoint_y <= (ty + HUMAN_HEIGTH)) ){
			return true;
		}
	}

	return false;
}

//! @brief ]r̍U󂯂
//! @param EnemyHuman U󂯂lIuWFNg̃|C^
void ObjectManager::HitZombieAttack(human* EnemyHuman)
{
	if( EnemyHuman == NULL ){ return; }

	//gpĂȂASĂΏȂB
	if( EnemyHuman->GetEnableFlag() == false ){ return; }
	if( EnemyHuman->GetHP() <= 0 ){ return; }

	float tx, ty, tz;

	EnemyHuman->GetPosData(&tx, &ty, &tz, NULL);
	ty += VIEW_HEIGHT;

	//_[WȂǂvZ
	EnemyHuman->HitZombieAttack();

	//GtFNgij\
	SetHumanBlood(tx, ty, tz, HUMAN_DAMAGE_ZOMBIEU);

	//ʉĐ
	GameSound->HitHuman(tx, ty, tz);
}

//! @brief ҂h
//! @param id l̔ԍi0`MAX_HUMAN-1j
//! @return trueF@falseFs
//! @warning Ԃ̂܂ܑh܂
//! @attention Ȑlԍw肳ꂽꍇAw肵lĂꍇA邢͓lԂɑ΂ĎsꍇÅ֐͎s܂B
bool ObjectManager::HumanResuscitation(int id)
{
	if( (id < 0)||(MAX_HUMAN-1 < id) ){ return false; }

	//gpĂȂAĂΏȂB
	if( HumanIndex[id].GetEnableFlag() == false ){ return false; }
	if( HumanIndex[id].GetDeadFlag() == false ){ return false; }

	int id_param, dataid, team;
	signed char p4;
	HumanIndex[id].GetParamData(&id_param, &dataid, &p4, &team);
	if( (id_param < 0)||( TOTAL_PARAMETERINFO_HUMAN-1 < id_param) ){ return false; }	//lԂȂ珈Ȃ
	HumanIndex[id].SetParamData(id_param, dataid, p4, team, true);

	return true;
}

//! @brief Q[NA[EQ[I[o[̔
//! @return Q[NA[F1@Q[I[o[F2@ȂF0
//! @attention Q[NA\ƃQ[I[o[ɐł́A{XOPSƓlɁuQ[NA[vƔ肳܂B
int ObjectManager::CheckGameOverorComplete()
{
	//F
	//
	//@{́AQ[I[o[ɍsAɃQ[NA[IłB
	//@vC[HP 0 ȂΑQ[I[o[ƂĔ肵AG̒HPcĂ҂_ ȂA
	//@2̏ɓĂ͂܂Ȃ΁AIɃQ[NA[ƂȂ܂B
	//
	//@A{XOPS̓Q[NA[̔D悷邽߁AɃQ[NA[̔sĂ܂B
	//@ĂG̐iHPƂājAG̐iHPj 0 Ȃ΁AQ[NA[Ɣ肵܂B
	//@܂̂悤1̊֐ŏ悤ƂɁAQ[NA[ƃQ[I[o[Ŋ֐̂𕪂Ăǂ̂łˁEEB

	//Q[NA[
	int MyTeamid, teamid;
	int TotalEnemyHP = 0;
	HumanIndex[Player_HumanID].GetParamData(NULL, NULL, NULL, &MyTeamid);	//vC[̃`[ԍ擾
	for(int i=0; i<MAX_HUMAN; i++){
		//ĂȂΏȂ
		if( HumanIndex[i].GetEnableFlag() == false ){ continue; }

		//ׂΏۂ̃`[ԍ擾
		HumanIndex[i].GetParamData(NULL, NULL, NULL, &teamid);

		//قȂ`[ԍiGjȂ
		if( teamid != MyTeamid ){
			//Ă΁AGHPƂĉZ
			//if( HumanIndex[i].GetHP() > 0 ){
			if( HumanIndex[i].GetDeadFlag() == false ){
				TotalEnemyHP += HumanIndex[i].GetHP();
			}
		}
	}
	if( TotalEnemyHP == 0 ){	//SGHP 0 Ȃ
		return 1;
	}


	//Q[I[o[
	if( HumanIndex[Player_HumanID].GetEnableFlag() == true ){	//ΏۂLȂ΁@iFZɂύX΍j
		if( HumanIndex[Player_HumanID].GetDeadFlag() == true ){		//vC[SĂ
			return 2;
		}
	}

	return 0;
}

//! @brief IuWFNg̏擾
//! @param camera_x JXW
//! @param camera_y JYW
//! @param camera_z JZW
//! @param camera_rx J̉px
//! @param camera_ry J̏cpx
//! @param color F擾|C^
//! @param infostr 擾|C^
//! @return \񂠂Ftrue@\ȂFfalse
bool ObjectManager::GetObjectInfoTag(float camera_x, float camera_y, float camera_z, float camera_rx, float camera_ry, int *color, char *infostr)
{
	float dist = 50.0f;
	float px, py, pz;
	float rx, ry;
	float r;
	int Player_teamID;

	//
	infostr[0] = NULL;

	//vC[̃`[ԍ擾
	HumanIndex[Player_HumanID].GetParamData(NULL, NULL, NULL, &Player_teamID);

	//l
	for(int i=0; i<MAX_HUMAN; i++){
		//vC[gȂ珈Ȃ
		if( i == Player_HumanID ){ continue; }

		if( HumanIndex[i].GetEnableFlag() == true ){
			HumanIndex[i].GetPosData(&px, &py, &pz, NULL);

			//_ɑΏۂ܂ł̊pxZo
			if( CheckTargetAngle(camera_x, camera_y, camera_z, camera_rx, 0.0f, px, py, pz, dist, &rx, NULL, &r) == true ){
				int team;

				//pxAEɓĂ
				if( fabs(rx) < DegreeToRadian(10) ){
					HumanIndex[i].GetParamData(NULL, NULL, NULL, &team);
					if( team == Player_teamID ){
						*color = d3dg->GetColorCode(0.0f,0.0f,1.0f,1.0f);
						sprintf(infostr, "Human[%d]  HP %d : Friend", i, HumanIndex[i].GetHP());
					}
					else{
						*color = d3dg->GetColorCode(1.0f,0.0f,0.0f,1.0f);
						sprintf(infostr, "Human[%d]  HP %d : Enemy", i, HumanIndex[i].GetHP());
					}
					dist = sqrt(r);
				}
			}
		}
	}

	//
	for(int i=0; i<MAX_WEAPON; i++){
		if( (WeaponIndex[i].GetEnableFlag() == true)&&(WeaponIndex[i].GetUsingFlag() == false) ){
			int lnbs, nbs;

			WeaponIndex[i].GetPosData(&px, &py, &pz, NULL);
			WeaponIndex[i].GetParamData(NULL, &lnbs, &nbs);

			//_ɑΏۂ܂ł̊pxZo
			if( CheckTargetAngle(camera_x, camera_y, camera_z, camera_rx, camera_ry, px, py, pz, dist, &rx, &ry, &r) == true ){
				//pxAEɓĂ
				if( (fabs(rx) < DegreeToRadian(10))&&(fabs(ry) < DegreeToRadian(10)) ){
					*color = d3dg->GetColorCode(0.0f,1.0f,0.0f,1.0f);
					sprintf(infostr, "Weapon[%d]  %d:%d", i, lnbs, (nbs - lnbs));
					dist = sqrt(r);
				}
			}
		}
	}

	//
	for(int i=0; i<MAX_SMALLOBJECT; i++){
		if( SmallObjectIndex[i].GetEnableFlag() == true ){
			SmallObjectIndex[i].GetPosData(&px, &py, &pz, NULL);
			
			//_ɑΏۂ܂ł̊pxZo
			if( CheckTargetAngle(camera_x, camera_y, camera_z, camera_rx, camera_ry, px, py, pz, dist, &rx, &ry, &r) == true ){
				//pxAEɓĂ
				if( (fabs(rx) < DegreeToRadian(10))&&(fabs(ry) < DegreeToRadian(10)) ){
					*color = d3dg->GetColorCode(1.0f,1.0f,0.0f,1.0f);
					sprintf(infostr, "SmallObject[%d]  HP %d", i, SmallObjectIndex[i].GetHP());
					dist = sqrt(r);
				}
			}
		}
	}

	//ݒ肳Ă邩ǂŁALȏꂽB
	if( infostr[0] == NULL ){
		return false;
	}
	return true;
}

//! @brief IuWFNg̎vZ
//! @param cmdF5id ㏸@\iF5Zjlf[^ԍi-1ŋ@\j
//! @param demomode f[h
//! @param camera_rx J̉px
//! @param camera_ry J̏cpx
//! @return  0
//! @attention ʓI cmdF5id ́AF5Zgp̓vC[ԍiGetPlayerID()֐Ŏ擾jAgp -1 w肵܂B
//! @attention demomode ͎Ƀj[ʂŎgp܂BLɂƁAeeE֒e܂B
int ObjectManager::Process(int cmdF5id, bool demomode, float camera_rx, float camera_ry)
{
	//̃t[̐
	for(int i=0; i<MAX_HUMAN; i++){
		Human_ontarget[i] = 0;
		Human_kill[i] = 0;
		Human_headshot[i] = 0;
	}

	//lIuWFNg̏
	for(int i=0; i<MAX_HUMAN; i++){
		bool cmdF5;

		if( i == cmdF5id ){
			cmdF5 = true;
		}
		else{
			cmdF5 = false;
		}

		if( HumanIndex[i].RunFrame(CollD, BlockData, cmdF5) == 2 ){
			//S̃GtFNg
			DeadEffect(&(HumanIndex[i]));
		}

		//
		if( HumanIndex[i].GetMovemode(false) == 2 ){
			//鑫ǉ
			float posx, posy, posz;
			int teamid;
			HumanIndex[i].GetPosData(&posx, &posy, &posz, NULL);
			HumanIndex[i].GetParamData(NULL, NULL, NULL, &teamid);
			GameSound->SetFootsteps(posx, posy, posz, teamid);
		}
	}

	//IuWFNg̏
	for(int i=0; i<MAX_WEAPON; i++){
		WeaponIndex[i].RunFrame(CollD);
	}

	//IuWFNg̏
	for(int i=0; i<MAX_SMALLOBJECT; i++){
		SmallObjectIndex[i].RunFrame();
	}

	if( demomode == false ){
		//eIuWFNg̏
		for(int i=0; i<MAX_BULLET; i++){
			float bx, by, bz, brx, bry;
			int speed, teamid;
			float mx, my, mz;

			CollideBullet(&BulletIndex[i]);		//蔻s
			BulletIndex[i].RunFrame();	//vZ

			if( BulletIndex[i].GetEnableFlag() == true ){
				//e̍WƊpx擾
				BulletIndex[i].GetParamData(NULL, NULL, &speed, &teamid, NULL);
				BulletIndex[i].GetPosData(&bx, &by, &bz, &brx, &bry);
				mx = cos(brx)*cos(bry)*speed;
				my = sin(bry)*speed;
				mz = sin(brx)*cos(bry)*speed;
				GameSound->PassingBullet(bx, by, bz, mx, my, mz, teamid);
			}
		}
	}
	else{
		//SĂ̒eIuWFNg
		for(int i=0; i<MAX_BULLET; i++){
			if( BulletIndex[i].GetEnableFlag() == true ){
				BulletIndex[i].SetEnableFlag(false);
			}
		}
	}

	//𔭖Cۂ̃GtFNgo
	for(int i=0; i<MAX_HUMAN; i++){
		if( Human_ShotFlag[i] == true ){
			ShotWeaponEffect(i);
			Human_ShotFlag[i] = false;
		}
	}

	//GtFNgIuWFNg̏
	for(int i=0; i<MAX_EFFECT; i++){
		int id, face;
		float pos_x, pos_y, pos_z;
		if( CollideBlood(&(EffectIndex[i]), &id, &face, &pos_x, &pos_y, &pos_z) == true ){
			AddMapEffect(id, face, pos_x, pos_y, pos_z, 10.0f, DegreeToRadian(10)*GetRand(18), (int)GAMEFPS * 20, Resource->GetEffectBloodTexture());
			EffectIndex[i].SetEnableFlag(false);
		}
		else{
			EffectIndex[i].RunFrame(camera_rx, camera_ry);
		}
	}

	if( demomode == false ){
		//֒ȅ
		for(int i=0; i<MAX_GRENADE; i++){
			float speed = GrenadeIndex[i].GetSpeed();

			//vZ
			int rcr = GrenadeIndex[i].RunFrame(CollD);

			//oEhE˕ԂȂ
			if( rcr == 1 ){
				if( speed > 3.4f ){
					//W擾AʉĐ
					float x, y, z;
					GrenadeIndex[i].GetPosData(&x, &y, &z, NULL, NULL);
					GameSound->GrenadeBound(x, y, z);
				}
			}

			//Ȃ
			if( rcr == 2 ){
				GrenadeExplosion(&(GrenadeIndex[i]));
			}
		}
	}
	else{
		//SĂ̎֒e
		for(int i=0; i<MAX_GRENADE; i++){
			if( GrenadeIndex[i].GetEnableFlag() == true ){
				GrenadeIndex[i].SetEnableFlag(false);
			}
		}
	}


	//E
	for(int i=0; i<MAX_HUMAN; i++){
		//EŖt[ŏӖ͂Ȃ̂ŁAe2t[1񏈗ɃP`Ă܂@iOOG
		//t[ڂ̎́Af[^ԍ̕B̎́A̕B
		for(int j=(framecnt%2); j<MAX_WEAPON; j+=2){
			PickupWeapon(&HumanIndex[i], &WeaponIndex[j]);
		}
	}

	for(int i=0; i<MAX_HUMAN; i++){
		for(int j=i+1; j<MAX_HUMAN; j++){
			//lm̓蔻ij
			CollideHuman(&HumanIndex[i], &HumanIndex[j]);
		}
	}

	framecnt += 1;

	return 0;
}

//! @brief t[ E|G̐EwbgVbg ̎擾
//! @param id 擾l̃f[^ԍ
//! @param ontarget 󂯎|C^
//! @param kill |G̐󂯎|C^
//! @param headshot G̓ɖ󂯎|C^
//! @return Ftrue@sFfalse
bool ObjectManager::GetHumanShotInfo(int id, int *ontarget, int *kill, int *headshot)
{
	if( (id < 0)||(MAX_HUMAN-1 < id) ){ return false; }
	*ontarget = Human_ontarget[id];
	*kill = Human_kill[id];
	*headshot = Human_headshot[id];
	return true;
}

//! @brief GtFNg\[g
//! @param camera_x JXW
//! @param camera_y JYW
//! @param camera_z JZW
//! @param data ʂ󂯎 effectdata\́@ivfFMAX_EFFECTj
//! @return LȃGtFNg̐
int ObjectManager::SortEffect(float camera_x, float camera_y, float camera_z, effectdata data[])
{
	int cnt = 0;

	//J̋߂A𐔂B
	for(int i=0; i<MAX_EFFECT; i++){
		if( EffectIndex[i].GetEnableFlag() == true ){
			float ex, ey, ez;
			float x, y, z;

			//W擾AvZAf[^ɓo^B
			EffectIndex[i].GetPosData(&ex, &ey, &ez, NULL);
			x = ex - camera_x;
			y = ey - camera_y;
			z = ez - camera_z;
			data[cnt].id = i;
			data[cnt].dist = x*x + y*y + z*z;

			//JEgZ
			cnt += 1;
		}
	}

	//P}\[g
	effectdata temp;
	for(int i=1; i<cnt; i++) {
		int j;
		temp = data[i];
		for(j=i; j>0 && data[j-1].dist<temp.dist; j--){
			data[j] = data[j-1];
		}
		data[j] = temp;
	}

	return cnt;
}

//! @brief IuWFNg̕`揈
//! @param camera_x JXW
//! @param camera_y JYW
//! @param camera_z JZW
//! @param HidePlayer vC[̔\ݒ@i\F0@\F1@rƕ̂ݕ\F2j
void ObjectManager::Render(float camera_x, float camera_y, float camera_z, int HidePlayer)
{
	//[hW_
	d3dg->ResetWorldTransform();

	//l`
	for(int i=0; i<MAX_HUMAN; i++){
		bool DrawArm, player;

		//r̕\
		if( HidePlayer == 0 ){
			DrawArm = false;
		}
		else if( Player_HumanID != i ){	// HidePlayer != 0
			DrawArm = false;
		}
		else if( HidePlayer == 2 ){		// Player_HumanID == i
			DrawArm = true;
		}
		else{							// Player_HumanID == i && HidePlayer == 1
			continue;	//vC[g\ȂȂXLbv
		}

		//vC[ǂ
		if( Player_HumanID == i ){
			player = true;
		}
		else{
			player = false;
		}

		HumanIndex[i].Render(d3dg, Resource, DrawArm, player);

		/*
		//蔻̊ȈՕ\
		float x, y, z;
		HumanIndex[i].GetPosData(&x, &y, &z, NULL);
		if( HumanIndex[i].GetHP() > 0 ){
			d3dg->SetWorldTransform(x, y, z, 0.0f, 0.0f, 1.0f);
			d3dg->Drawline(HUMAN_BULLETCOLLISION_HEAD_R, HUMAN_BULLETCOLLISION_LEG_H + HUMAN_BULLETCOLLISION_UP_H + HUMAN_BULLETCOLLISION_HEAD_H, 0.0f, HUMAN_BULLETCOLLISION_HEAD_R * -1, HUMAN_BULLETCOLLISION_LEG_H + HUMAN_BULLETCOLLISION_UP_H + HUMAN_BULLETCOLLISION_HEAD_H, 0.0f);
			d3dg->Drawline(0.0f, HUMAN_BULLETCOLLISION_LEG_H + HUMAN_BULLETCOLLISION_UP_H + HUMAN_BULLETCOLLISION_HEAD_H, HUMAN_BULLETCOLLISION_HEAD_R, 0.0f, HUMAN_BULLETCOLLISION_LEG_H + HUMAN_BULLETCOLLISION_UP_H + HUMAN_BULLETCOLLISION_HEAD_H, HUMAN_BULLETCOLLISION_HEAD_R * -1);
			d3dg->Drawline(HUMAN_BULLETCOLLISION_UP_R, HUMAN_BULLETCOLLISION_LEG_H + HUMAN_BULLETCOLLISION_UP_H, 0.0f, HUMAN_BULLETCOLLISION_UP_R * -1, HUMAN_BULLETCOLLISION_LEG_H + HUMAN_BULLETCOLLISION_UP_H, 0.0f);
			d3dg->Drawline(0.0f, HUMAN_BULLETCOLLISION_LEG_H + HUMAN_BULLETCOLLISION_UP_H, HUMAN_BULLETCOLLISION_UP_R, 0.0f, HUMAN_BULLETCOLLISION_LEG_H + HUMAN_BULLETCOLLISION_UP_H, HUMAN_BULLETCOLLISION_UP_R * -1);
			d3dg->Drawline(HUMAN_BULLETCOLLISION_LEG_R, HUMAN_BULLETCOLLISION_LEG_H, 0.0f, HUMAN_BULLETCOLLISION_LEG_R * -1, HUMAN_BULLETCOLLISION_LEG_H, 0.0f);
			d3dg->Drawline(0.0f, HUMAN_BULLETCOLLISION_LEG_H, HUMAN_BULLETCOLLISION_LEG_R, 0.0f, HUMAN_BULLETCOLLISION_LEG_H, HUMAN_BULLETCOLLISION_LEG_R * -1);
		}
		*/
	}

	//`
	for(int i=0; i<MAX_WEAPON; i++){
		WeaponIndex[i].Render(d3dg);
	}

	//`
	for(int i=0; i<MAX_SMALLOBJECT; i++){
		SmallObjectIndex[i].Render(d3dg);
	}

	//e`
	for(int i=0; i<MAX_BULLET; i++){
		BulletIndex[i].Render(d3dg);
	}

	//֒e`
	for(int i=0; i<MAX_GRENADE; i++){
		GrenadeIndex[i].Render(d3dg);
	}

	//GtFNg`
	/*
	for(int i=0; i<MAX_EFFECT; i++){
		EffectIndex[i].Render(d3dg);
	}
	*/
	effectdata data[MAX_EFFECT];
	int cnt = SortEffect(camera_x, camera_y, camera_z, data);
	for(int i=0; i<cnt; i++) {
		EffectIndex[ data[i].id ].Render(d3dg);
	}
}

//! @brief f[^̉
void ObjectManager::Cleanup()
{
	//|Cgf[^
	CleanupPointDataToObject();
}