//! @file ai.cpp
//! @brief AIcontrolNX̒`

//--------------------------------------------------------------------------------
// 
// OpenXOPS
// Copyright (c) 2014-2019, OpenXOPS Project / [-_-;](mikan) All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
// * Redistributions of source code must retain the above copyright notice, 
//   this list of conditions and the following disclaimer.
// * Redistributions in binary form must reproduce the above copyright notice, 
//   this list of conditions and the following disclaimer in the documentation 
//   and/or other materials provided with the distribution.
// * Neither the name of the OpenXOPS Project nor the names of its contributors 
//   may be used to endorse or promote products derived from this software 
//   without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL OpenXOPS Project BE LIABLE FOR ANY
// DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
// LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
// ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//--------------------------------------------------------------------------------

#include "ai.h"

//! @brief RXgN^
AIcontrol::AIcontrol(class ObjectManager *in_ObjMgr, int in_ctrlid, class BlockDataInterface *in_blocks, class PointDataInterface *in_Points, class ParameterInfo *in_Param, class Collision *in_CollD, class SoundManager *in_GameSound)
{
	ObjMgr = in_ObjMgr;
	ctrlid = in_ctrlid;
	ctrlhuman = in_ObjMgr->GetHumanObject(in_ctrlid);
	blocks = in_blocks;
	Param = in_Param;
	CollD = in_CollD;
	GameSound = in_GameSound;

	battlemode = AI_NORMAL;
	cautionback_posx = 0.0f;
	cautionback_posz = 0.0f;
	FaceCaution_flag = false;
	FaceCaution_rx = 0.0f;
	total_move = 0.0f;
	waitcnt = 0;
	movejumpcnt = 1*((int)GAMEFPS);
	gotocnt = 0;
	longattack = false;

	MoveNavi = new AIMoveNavi;
	ObjDriver = new AIObjectDriver;
	MoveNavi->SetClass(in_ObjMgr, in_ctrlid, in_Points);
	ObjDriver->SetClass(in_ObjMgr, in_ctrlid);
}

//! @brief fBXgN^
AIcontrol::~AIcontrol()
{
	delete MoveNavi;
	delete ObjDriver;
}

//! @brief ΏۃNXݒ
//! @attention ̊֐ŐݒsȂƁANX̂@\܂B
void AIcontrol::SetClass(class ObjectManager *in_ObjMgr, int in_ctrlid, class BlockDataInterface *in_blocks, class PointDataInterface *in_Points, class ParameterInfo *in_Param, class Collision *in_CollD, class SoundManager *in_GameSound)
{
	ObjMgr = in_ObjMgr;
	ctrlid = in_ctrlid;
	ctrlhuman = in_ObjMgr->GetHumanObject(in_ctrlid);
	blocks = in_blocks;
	Param = in_Param;
	CollD = in_CollD;
	GameSound = in_GameSound;

	MoveNavi->SetClass(in_ObjMgr, in_ctrlid, in_Points);
	ObjDriver->SetClass(in_ObjMgr, in_ctrlid);
}

//! @brief ڕWn_ɈړĂ邩mF
//! @return BFtrue@񓞒BFfalse
bool AIcontrol::CheckTargetPos(bool back)
{
	float target_posx, target_posz;
	int movemode;
	if( back == false ){
		MoveNavi->GetTargetPos(&target_posx, &target_posz, NULL, &movemode, NULL);
	}
	else{
		target_posx = cautionback_posx;
		target_posz = cautionback_posz;
		movemode = AI_NAVI_MOVE_RUN;
	}

	//Zo
	float x = posx - target_posx;
	float z = posz - target_posz;
	float r = x * x + z * z;

	if( movemode == AI_NAVI_MOVE_TRACKING ){	//ǔȂ
		if( r < AI_ARRIVALDIST_TRACKING * AI_ARRIVALDIST_TRACKING ){
			return true;
		}
	}
	else{							//ȊOȂ
		if( r < (AI_ARRIVALDIST_PATH * AI_ARRIVALDIST_PATH) ){
			return true;
		}
	}

	return false;
}

//! @brief ڕWn_Ɉړ
void AIcontrol::MoveTarget(bool back)
{
	float r, atan;
	int paramid;
	HumanParameter Paraminfo;
	bool zombie;

	float target_posx, target_posz;	
	int movemode;
	if( back == false ){
		MoveNavi->GetTargetPos(&target_posx, &target_posz, NULL, &movemode, NULL);
	}
	else{
		target_posx = cautionback_posx;
		target_posz = cautionback_posz;
		movemode = AI_NAVI_MOVE_RUN;
	}

	//]rǂ
	ctrlhuman->GetParamData(&paramid, NULL, NULL, NULL);
	Param->GetHuman(paramid, &Paraminfo);
	if( Paraminfo.type == 2 ){
		zombie = true;
	}
	else{
		zombie = false;
	}

	//xSĂ̓~߂
	ObjDriver->ResetMode();

	//ڕWn_ւ̊px߂
	CheckTargetAngle(posx, 0.0f, posz, rx*-1 + (float)M_PI/2, 0.0f, target_posx, 0.0f, target_posz, 0.0f, &atan, NULL, &r);

	//
	if( atan > DegreeToRadian(0.5f) ){
		ObjDriver->SetModeFlag(AI_CTRL_TURNLEFT);
	}
	if( atan < DegreeToRadian(-0.5f) ){
		ObjDriver->SetModeFlag(AI_CTRL_TURNRIGHT);
	}

	//Oi
	if( zombie == true ){
		if( fabs(atan) < DegreeToRadian(20) ){
			ObjDriver->SetModeFlag(AI_CTRL_MOVEWALK);
		}
	}
	else if( movemode == AI_NAVI_MOVE_RUN ){
		if( fabs(atan) < DegreeToRadian(50) ){
			ObjDriver->SetModeFlag(AI_CTRL_MOVEFORWARD);
		}
	}
	else if( movemode == AI_NAVI_MOVE_RUN2 ){
		if( fabs(atan) < DegreeToRadian(50) ){
			ObjDriver->SetModeFlag(AI_CTRL_MOVEFORWARD);
		}
	}
	else if( movemode == AI_NAVI_MOVE_WALK ){
		if( fabs(atan) < DegreeToRadian(6) ){
			ObjDriver->SetModeFlag(AI_CTRL_MOVEWALK);
		}
	}
	else if( movemode == AI_NAVI_MOVE_TRACKING ){
		if( fabs(atan) < DegreeToRadian(20) ){
			if( r < (AI_ARRIVALDIST_WALKTRACKING * AI_ARRIVALDIST_WALKTRACKING) ){
				ObjDriver->SetModeFlag(AI_CTRL_MOVEWALK);
			}
			else{
				ObjDriver->SetModeFlag(AI_CTRL_MOVEFORWARD);
			}
		}
	}

	//Wv
	if( GetRand(16) == 0 ){
		MoveJump();
	}

	//|ĂAEւ̉]_ɍs
	if( GetRand(28) == 0 ){
		if( ctrlhuman->GetMovemode(true) != 0 ){
			if( ctrlhuman->GetTotalMove() - total_move < 0.1f ){
				if( GetRand(2) == 0 ){ ObjDriver->SetModeFlag(AI_CTRL_TURNRIGHT); }
				else{ ObjDriver->SetModeFlag(AI_CTRL_TURNLEFT); }
			}
		}
	}
	total_move = ctrlhuman->GetTotalMove();
}

//! @brief ڕWn_ɈړiDIȑpj
void AIcontrol::MoveTarget2(bool back)
{
	float atan;

	float target_posx, target_posz;	
	if( back == false ){
		MoveNavi->GetTargetPos(&target_posx, &target_posz, NULL, NULL, NULL);
	}
	else{
		target_posx = cautionback_posx;
		target_posz = cautionback_posz;
	}

	//ڕWn_ւ̊px߂
	CheckTargetAngle(posx, 0.0f, posz, rx*-1 + (float)M_PI/2, 0.0f, target_posx, 0.0f, target_posz, 0.0f, &atan, NULL, NULL);

	//Oړ̏
	if( fabs(atan) < DegreeToRadian(56) ){
		ObjDriver->SetModeFlag(AI_CTRL_MOVEFORWARD);
	}
	if( fabs(atan) > DegreeToRadian(123.5f) ){
		ObjDriver->SetModeFlag(AI_CTRL_MOVEBACKWARD);
	}

	//Eړ̏
	if( (DegreeToRadian(-146) < atan)&&(atan < DegreeToRadian(-33)) ){
		ObjDriver->SetModeFlag(AI_CTRL_TURNRIGHT);
	}
	if( (DegreeToRadian(33) < atan)&&(atan < DegreeToRadian(146)) ){
		ObjDriver->SetModeFlag(AI_CTRL_TURNLEFT);
	}

	//Wv
	if( GetRand(16) == 0 ){
		MoveJump();
	}

	//|ĂAEւ̉]_ɍs
	if( GetRand(28) == 0 ){
		if( ctrlhuman->GetMovemode(true) != 0 ){
			if( ctrlhuman->GetTotalMove() - total_move < 0.1f ){
				if( GetRand(2) == 0 ){ ObjDriver->SetModeFlag(AI_CTRL_TURNRIGHT); }
				else{ ObjDriver->SetModeFlag(AI_CTRL_TURNLEFT); }
			}
		}
	}
	total_move = ctrlhuman->GetTotalMove();
}

//! @brief O㍶E_ɈړiUpj
void AIcontrol::MoveRandom()
{
	int forwardstart, backstart, sidestart;

	if( longattack == false ){
		forwardstart = 80;
		backstart = 90;
		sidestart = 70;
	}
	else{
		forwardstart = 120;
		backstart = 150;
		sidestart = 130;
	}

	//_Ɉړn߂
	if( GetRand(forwardstart) == 0 ){
		ObjDriver->SetModeFlag(AI_CTRL_MOVEFORWARD);
	}
	if( GetRand(backstart) == 0 ){
		ObjDriver->SetModeFlag(AI_CTRL_MOVEBACKWARD);
	}
	if( GetRand(sidestart) == 0 ){
		ObjDriver->SetModeFlag(AI_CTRL_MOVELEFT);
	}
	if( GetRand(sidestart) == 0 ){
		ObjDriver->SetModeFlag(AI_CTRL_MOVERIGHT);
	}

	//Ă炸AԂȂ
	if( ctrlhuman->GetMainWeaponTypeNO() == ID_WEAPON_NONE ){
		// 1/80̊mŉn߂
		if( GetRand(80) == 0 ){
			ObjDriver->SetModeFlag(AI_CTRL_MOVEBACKWARD);
		}
	}

	// 1/3̊mAړtOݒ肳Ă
	if( (GetRand(3) == 0)||(ObjDriver->GetModeFlag(AI_CTRL_MOVEFORWARD | AI_CTRL_MOVEBACKWARD | AI_CTRL_MOVELEFT | AI_CTRL_MOVERIGHT)) ){
		float vx, vz;
		float Dist;

		if( GetRand(2) == 0 ){
			//ÕxNgvZ
			vx = cos(rx*-1 + (float)M_PI/2);
			vz = sin(rx*-1 + (float)M_PI/2);
			if(
				(CollD->CheckALLBlockIntersectDummyRay(posx, posy + HUMAN_MAPCOLLISION_HEIGHT, posz, vx, 0, vz, NULL, NULL, &Dist, HUMAN_MAPCOLLISION_R) == true)||		//̍ɃubNiԂj
				(CollD->CheckALLBlockIntersectDummyRay(posx, posy - 1.0f, posz, vx, 0, vz, NULL, NULL, &Dist, HUMAN_MAPCOLLISION_R) == false)							//ɃubNȂij
			){
				//OitO폜AރtOݒ
				ObjDriver->DelModeFlag(AI_CTRL_MOVEFORWARD);
				ObjDriver->SetModeFlag(AI_CTRL_MOVEBACKWARD);
			}

			//̃xNgvZ
			vx = cos(rx*-1 + (float)M_PI/2 + (float)M_PI);
			vz = sin(rx*-1 + (float)M_PI/2 + (float)M_PI);
			if(
				(CollD->CheckALLBlockIntersectDummyRay(posx, posy + HUMAN_MAPCOLLISION_HEIGHT, posz, vx, 0, vz, NULL, NULL, &Dist, HUMAN_MAPCOLLISION_R) == true)||		//̍ɃubNiԂj
				(CollD->CheckALLBlockIntersectDummyRay(posx, posy - 1.0f, posz, vx, 0, vz, NULL, NULL, &Dist, HUMAN_MAPCOLLISION_R) == false)							//ɃubNȂij
			){
				//ރtO폜AOitOݒ
				ObjDriver->DelModeFlag(AI_CTRL_MOVEBACKWARD);
				ObjDriver->SetModeFlag(AI_CTRL_MOVEFORWARD);
			}
		}
		else{
			//
			vx = cos(rx*-1);
			vz = sin(rx*-1);
			if(
				(CollD->CheckALLBlockIntersectDummyRay(posx, posy + HUMAN_MAPCOLLISION_HEIGHT, posz, vx, 0, vz, NULL, NULL, &Dist, HUMAN_MAPCOLLISION_R) == true)||		//̍ɃubNiԂj
				(CollD->CheckALLBlockIntersectDummyRay(posx, posy - 1.0f, posz, vx, 0, vz, NULL, NULL, &Dist, HUMAN_MAPCOLLISION_R) == false)							//ɃubNȂij
			){
				//EړtO폜AړtOݒ
				ObjDriver->DelModeFlag(AI_CTRL_MOVERIGHT);
				ObjDriver->SetModeFlag(AI_CTRL_MOVELEFT);
			}

			vx = cos(rx*-1 + (float)M_PI);
			vz = sin(rx*-1 + (float)M_PI);
			if(
				(CollD->CheckALLBlockIntersectDummyRay(posx, posy + HUMAN_MAPCOLLISION_HEIGHT, posz, vx, 0, vz, NULL, NULL, &Dist, HUMAN_MAPCOLLISION_R) == true)||		//̍ɃubNiԂj
				(CollD->CheckALLBlockIntersectDummyRay(posx, posy - 1.0f, posz, vx, 0, vz, NULL, NULL, &Dist, HUMAN_MAPCOLLISION_R) == false)							//ɃubNȂij
			){
				//ړtO폜AEړtOݒ
				ObjDriver->DelModeFlag(AI_CTRL_MOVELEFT);
				ObjDriver->SetModeFlag(AI_CTRL_MOVERIGHT);
			}
		}
	}

	//UΏۂȂ
	if( enemyhuman != NULL ){
		float tx, ty, tz;

		enemyhuman->GetPosData(&tx, &ty, &tz, NULL);

		float x = posx - tx;
		float y = posy - ty;
		float z = posz - tz;
		float r = x * x + y * y + z * z;

		//Gɋ߂ÂȂނ
		if( r < 20.0f * 20.0f ){
			ObjDriver->DelModeFlag(AI_CTRL_MOVEFORWARD);
			if( GetRand(70) == 0 ){
				ObjDriver->SetModeFlag(AI_CTRL_MOVEBACKWARD);
			}
		}
	}
}

//! @brief ̏܂킷
void AIcontrol::TurnSeen()
{
	int turnstart, turnstop;

	float target_rx;
	int pointmode;
	MoveNavi->GetTargetPos(NULL, NULL, &target_rx, NULL, &pointmode);

	//ČxȂAꂽ
	if( (battlemode == AI_CAUTION)&&(FaceCaution_flag == true) ){
		float tr;

		//vZ
		tr = FaceCaution_rx - rx;
		for(; tr > (float)M_PI; tr -= (float)M_PI*2){}
		for(; tr < (float)M_PI*-1; tr += (float)M_PI*2){}

		//
		if( tr > DegreeToRadian(2.5f) ){
			ObjDriver->SetModeFlag(AI_CTRL_TURNRIGHT);
		}
		if( tr < DegreeToRadian(-2.5f) ){
			ObjDriver->SetModeFlag(AI_CTRL_TURNLEFT);
		}

		//ɌI΁Aʂ̌xɈڍs
		if( fabs(tr) <= DegreeToRadian(2.5f) ){
			FaceCaution_flag = false;
		}

		return;
	}

	//]̊JnEImݒ
	if( battlemode == AI_ACTION ){
		return;
	}
	else if( battlemode == AI_CAUTION ){
		turnstart = 20;
		turnstop = 20;
	}
	else{
		if( pointmode == AI_NAVI_POINT_TRACKING ){ turnstart = 65; }
		else{ turnstart = 85; }
		turnstop = 18;
	}

	//_ɉ]n߂
	if( GetRand(turnstart) == 0 ){
		ObjDriver->SetModeFlag(AI_CTRL_TURNRIGHT);
	}
	if( GetRand(turnstart) == 0 ){
		ObjDriver->SetModeFlag(AI_CTRL_TURNLEFT);
	}

	if( (battlemode == AI_NORMAL)&&(pointmode == AI_NAVI_POINT_WAIT) ){
		//_Ƀ|Cg̕Ƃ
		//u|Cg̕dv̍Č 
		if( GetRand(80) == 0 ){
			float tr;
			tr = target_rx - rx;
			for(; tr > (float)M_PI; tr -= (float)M_PI*2){}
			for(; tr < (float)M_PI*-1; tr += (float)M_PI*2){}

			if( tr > 0.0f ){
				ObjDriver->SetModeFlag(AI_CTRL_TURNRIGHT);
			}
			if( tr < 0.0f ){
				ObjDriver->SetModeFlag(AI_CTRL_TURNLEFT);
			}
		}
	}

	//]_Ɏ~߂
	if( GetRand(turnstop) == 0 ){
		ObjDriver->DelModeFlag(AI_CTRL_TURNRIGHT);
	}
	if( GetRand(turnstop) == 0 ){
		ObjDriver->DelModeFlag(AI_CTRL_TURNLEFT);
	}
}

//! @brief ̕
bool AIcontrol::StopSeen()
{
	float tr;
	bool returnflag = false;

	float target_rx;
	MoveNavi->GetTargetPos(NULL, NULL, &target_rx, NULL, NULL);

	tr = target_rx - rx;
	for(; tr > (float)M_PI; tr -= (float)M_PI*2){}
	for(; tr < (float)M_PI*-1; tr += (float)M_PI*2){}

	ObjDriver->DelModeFlag(AI_CTRL_TURNRIGHT);
	ObjDriver->DelModeFlag(AI_CTRL_TURNLEFT);

	//
	if( tr > DegreeToRadian(2.5f) ){
		ObjDriver->SetModeFlag(AI_CTRL_TURNRIGHT);
		returnflag = false;
	}
	if( tr < DegreeToRadian(-2.5f) ){
		ObjDriver->SetModeFlag(AI_CTRL_TURNLEFT);
		returnflag = false;
	}

	//ɌĂ邩
	if( fabs(tr) <= DegreeToRadian(2.5f) ){
		returnflag = true;
	}

	return returnflag;
}

//! @brief isɏQ΃Wv
bool AIcontrol::MoveJump()
{
	//~܂ĂΏȂ
	if( ctrlhuman->GetMovemode(false) == 0 ){ return false; }

	float dist_dummy;

	float new_posx, new_posy, new_posz;

	//t߂̓蔻
	new_posx = posx + cos(rx*-1 + (float)M_PI/2) * (AI_CHECKJUMP_DIST + HUMAN_MAPCOLLISION_R);
	new_posy = posy + HUMAN_MAPCOLLISION_HEIGHT;
	new_posz = posz + sin(rx*-1 + (float)M_PI/2) * (AI_CHECKJUMP_DIST + HUMAN_MAPCOLLISION_R);
	if( CollD->CheckALLBlockInside(new_posx, new_posy, new_posz) == true ){
		ObjMgr->MoveJump(ctrlid);
		return true;
	}

	//̑Ŝ̓蔻
	new_posx = posx + cos(rx*-1 + (float)M_PI/2) * AI_CHECKJUMP_DIST;
	new_posy = posy + AI_CHECKJUMP_HEIGHT;
	new_posz = posz + sin(rx*-1 + (float)M_PI/2) * AI_CHECKJUMP_DIST;
	if( CollD->CheckALLBlockInside(new_posx, new_posy, new_posz) == true ){
		ObjMgr->MoveJump(ctrlid);
		return true;
	}
	else if( CollD->CheckALLBlockIntersectRay(new_posx, new_posy, new_posz, 0.0f, 1.0f, 0.0f, NULL, NULL, &dist_dummy, HUMAN_HEIGHT - AI_CHECKJUMP_HEIGHT) == true ){
		ObjMgr->MoveJump(ctrlid);
		return true;
	}

	return false;
}

//! @brief U
//! @todo ]ȓ߂܂鏈
void AIcontrol::Action()
{
	human* EnemyHuman = NULL;
	int paramid;
	HumanParameter Paraminfo;
	bool zombie;
	float posy2;
	float tx, ty, tz;

	EnemyHuman = enemyhuman;

	//W擾
	EnemyHuman->GetPosData(&tx, &ty, &tz, NULL);
	posy2 = posy + VIEW_HEIGHT;
	ty += VIEW_HEIGHT;

	//]rǂ
	ctrlhuman->GetParamData(&paramid, NULL, NULL, NULL);
	Param->GetHuman(paramid, &Paraminfo);
	if( Paraminfo.type == 2 ){
		zombie = true;
	}
	else{
		zombie = false;
	}

	//Ă镐̎ނ擾
	int weaponid = ctrlhuman->GetMainWeaponTypeNO();

	float atanx, atany, r;

	//֒eĂ΁`
	if( weaponid == ID_WEAPON_GRENADE ){
		if( zombie == false ){
			float x = posx - tx;
			float z = posz - tz;
			float r = x * x + z * z;
			float scale;
			if( longattack == false ){ scale = 0.12f; }
			else{ scale = 0.4f; }

			//ɉčς
			ty += (sqrt(r) - 200.0f) * scale;
		}
	}
	else{
		float mx, mz;
		float scale;
		EnemyHuman->GetMovePos(&mx, NULL, &mz);
		if( longattack == false ){ scale = 1.5f; }
		else{
			float x = posx - tx;
			float z = posz - tz;
			float r = x * x + z * z;

			scale = sqrt(r) * 0.12f;
		}

		//G̈ړ
		tx += mx * scale;
		tz += mz * scale;
	}

	//ڕWn_ւ̊px߂
	CheckTargetAngle(posx, posy2, posz, rx*-1 + (float)M_PI/2, ry, tx, ty, tz, 0.0f, &atanx, &atany, &r);

	//ς^C~O
	int randr = LevelParam->aiming;
	if( longattack == false ){ randr += 1; }
	else{ randr += 2; }

	if( randr != 0 ){
		//
		if( atanx > 0.0f ){
			ObjDriver->SetModeFlag(AI_CTRL_TURNLEFT);
			ObjDriver->DelModeFlag(AI_CTRL_TURNRIGHT);
		}
		if( atanx < 0.0f ){
			ObjDriver->SetModeFlag(AI_CTRL_TURNRIGHT);
			ObjDriver->DelModeFlag(AI_CTRL_TURNLEFT);
		}

		//r̊px
		if( zombie == true ){
			//ry = AI_ZOMBIEATTACK_ARMRY;

			//
			if( ry < AI_ZOMBIEATTACK_ARMRY ){
				ObjDriver->SetModeFlag(AI_CTRL_TURNUP);
				ObjDriver->DelModeFlag(AI_CTRL_TURNDOWN);
			}
			if( ry > AI_ZOMBIEATTACK_ARMRY ){
				ObjDriver->SetModeFlag(AI_CTRL_TURNDOWN);
				ObjDriver->DelModeFlag(AI_CTRL_TURNUP);
			}
		}
		else{
			//ԂȂ΁`
			if( weaponid == ID_WEAPON_NONE ){
				if( EnemyHuman->GetMainWeaponTypeNO() == ID_WEAPON_NONE ){	//GԂȂ΁`
					//Ɍ
					ObjDriver->SetModeFlag(AI_CTRL_TURNDOWN);
					ObjDriver->DelModeFlag(AI_CTRL_TURNUP);
				}
				else{														//GĂ΁`
					//Ɍ
					ObjDriver->SetModeFlag(AI_CTRL_TURNUP);
					ObjDriver->DelModeFlag(AI_CTRL_TURNDOWN);
				}
			}
			else{
				//
				if( atany > 0.0f ){
					ObjDriver->SetModeFlag(AI_CTRL_TURNUP);
					ObjDriver->DelModeFlag(AI_CTRL_TURNDOWN);
				}
				if( atany < 0.0f ){
					ObjDriver->SetModeFlag(AI_CTRL_TURNDOWN);
					ObjDriver->DelModeFlag(AI_CTRL_TURNUP);
				}
			}
		}
	}

	//]rȊOŎԂȂ
	if( zombie == false ){
		if( weaponid == ID_WEAPON_NONE ){
			//̊mŌނ
			if( GetRand(80) == 0 ){
				ObjDriver->SetModeFlag(AI_CTRL_MOVEBACKWARD);
			}
		}
	}

	
	if( zombie == true ){	//]r̍U
		float y = posy2 - ty;

		//Ă΁Axɐ؂ւ
		if( ObjDriver->GetModeFlag(AI_CTRL_MOVEFORWARD) ){
			ObjDriver->DelModeFlag(AI_CTRL_MOVEFORWARD);
			ObjDriver->SetModeFlag(AI_CTRL_MOVEWALK);
		}

		//GɌđOi
		if( fabs(atanx) <= DegreeToRadian(25) ){
			if( (fabs(atanx) <= DegreeToRadian(15)) && (r < 24.0f*24.0f) && (actioncnt%50 > 20) ){
				//A
				ObjDriver->SetModeFlag(AI_CTRL_MOVEFORWARD);
				ObjDriver->DelModeFlag(AI_CTRL_MOVEWALK);
			}
			else{
				ObjDriver->SetModeFlag(AI_CTRL_MOVEWALK);
			}
		}

		/*
		//Wv
		if( GetRand(16) == 0 ){
			MoveJump();
		}
		*/

		if( (r < 9.0f*9.0f)&&( fabs(y) < 10.0f) ){
			float x = posx - tx;
			float z = posz - tz;

			//߂܂@iGtj
			EnemyHuman->AddPosOrder(atan2(z, x), 0.0f, 0.5f);

			//G̎__ɓ
			float erx, ery;
			EnemyHuman->GetRxRy(&erx, &ery);
			switch(GetRand(3)){
				case 0: erx -= DegreeToRadian(2); break;
				case 1: erx += DegreeToRadian(2); break;
				default: break;
			}
			switch(GetRand(3)){
				case 0: ery -= DegreeToRadian(2); break;
				case 1: ery += DegreeToRadian(2); break;
				default: break;
			}
			EnemyHuman->SetRxRy(erx, ery);
		}

		if( actioncnt%50 == 0){
			if( ObjMgr->CheckZombieAttack(ctrlhuman, EnemyHuman) == true ){
				ObjMgr->HitZombieAttack(ctrlhuman, EnemyHuman);
			}
		}
	}
	else{					//C
		float ShotAngle;
		if( longattack == false ){
			//G𑨂Ɣ肷Ae덷vZ
			ShotAngle = DegreeToRadian(8);
			if( weaponid != ID_WEAPON_NONE ){
				WeaponParameter wparam;
				Param->GetWeapon(weaponid, &wparam);
				if( wparam.scopemode == 1 ){
					ShotAngle = DegreeToRadian(6);
				}
				if( wparam.scopemode == 2 ){
					ShotAngle = DegreeToRadian(4);
				}
			}

			//AIxƂɒ
			ShotAngle += DegreeToRadian(0.5f) * LevelParam->limitserror;

			if( MoveNavi->GetRun2() == true ){
				ShotAngle *= 1.5f;
			}
		}
		else{
			//G𑨂Ɣ肷Ae덷vZ
			ShotAngle = DegreeToRadian(4);
			if( weaponid != ID_WEAPON_NONE ){
				WeaponParameter wparam;
				Param->GetWeapon(weaponid, &wparam);
				if( wparam.scopemode == 1 ){
					ShotAngle = DegreeToRadian(3);
				}
				if( wparam.scopemode == 2 ){
					ShotAngle = DegreeToRadian(2);
				}
			}

			//AIxƂɒ
			ShotAngle += DegreeToRadian(0.2f) * LevelParam->limitserror;
		}

		//G𑨂Ă
		float atanxy = fabs(atanx) + fabs(atany);
		if( atanxy < ShotAngle ){
			int rand = LevelParam->attack;
			if( longattack == true ){ rand += 1; }

			//C
			if( GetRand(rand) == 0 ){
				ObjMgr->ShotWeapon(ctrlid);
			}
		}
	}

	//ɉċߋE؂ւ
	//@200.0fsb^Őݒlێ
	if( r < 200.0f * 200.0f ){
		longattack = false;
	}
	if( (r > 200.0f * 200.0f)&&(MoveNavi->GetRun2() == false) ){
		longattack = true;
	}

	if( zombie == false ){
		//_Ɉړ
		MoveRandom();
	}

	actioncnt += 1;
}

//! @brief ULZ
bool AIcontrol::ActionCancel()
{
	//퓬tOLȂI
	if( NoFight == true ){
		return true;
	}

	//GSI
	if( enemyhuman->GetDeadFlag() == true ){
		return true;
	}

	//擾
	float tx, ty, tz;
	enemyhuman->GetPosData(&tx, &ty, &tz, NULL);
	float x = posx - tx;
	float y = posy - ty;
	float z = posz - tz;
	float r = x*x + y*y + z*z;

	//߂ĂI
	if( r > 620.0f*620.0f ){
		return true;
	}

	if( longattack == false ){
		//Kȃ^C~OœG邩mF
		if( GetRand(40) == 0 ){
			//ubNՂĂiȂjȂΏI
			if( CheckLookEnemy(enemyhuman, AI_SEARCH_RX, AI_SEARCH_RY, 620.0f, NULL) == false ){
				return true;
			}
		}

		//IɏI
		if( GetRand(550) == 0 ){
			return true;
		}
	}
	else{
		//Kȃ^C~OœG邩mF
		if( GetRand(30) == 0 ){
			//ubNՂĂiȂjȂΏI
			if( CheckLookEnemy(enemyhuman, AI_SEARCH_RX, AI_SEARCH_RY, 620.0f, NULL) == false ){
				return true;
			}
		}

		//IɏI
		if( GetRand(450) == 0 ){
			return true;
		}
	}

	return false;
}

//! @brief 
int AIcontrol::HaveWeapon()
{
	int selectweapon;
	class weapon *weapon[TOTAL_HAVEWEAPON];
	int nbs = 0;

	for(int i=0; i<TOTAL_HAVEWEAPON; i++){
		weapon[i] = NULL;
	}

	//̏擾
	ctrlhuman->GetWeapon(&selectweapon, weapon);

	//Ă΁Ave擾
	if( weapon[selectweapon] != NULL ){
		weapon[selectweapon]->GetParamData(NULL, NULL, &nbs);
	}

	//ĂȂAe0Ȃ
	if( (weapon[selectweapon] == NULL)||(nbs == 0) ){
		//̕w
		int notselectweapon = selectweapon + 1;
		if( notselectweapon == TOTAL_HAVEWEAPON ){ notselectweapon = 0; }

		//̕Ă
		if( weapon[notselectweapon] != NULL ){
			//̒̕e0łȂ
			weapon[notselectweapon]->GetParamData(NULL, NULL, &nbs);
			if( nbs > 0 ){
				//ւ
				ObjMgr->ChangeWeapon(ctrlid);
				return 1;
			}
		}
	}

	return 0;
}

//! @brief ړ]_ɏI
void AIcontrol::CancelMoveTurn()
{
	int forward, back, side, updown, rightleft;

	if( battlemode == AI_ACTION ){			//U
		if( MoveNavi->GetRun2() == true ){	//DIȑ
			ObjDriver->DelModeFlag(AI_CTRL_MOVEFORWARD);
			ObjDriver->DelModeFlag(AI_CTRL_MOVEBACKWARD);
			ObjDriver->DelModeFlag(AI_CTRL_MOVELEFT);
			ObjDriver->DelModeFlag(AI_CTRL_MOVERIGHT);
			ObjDriver->DelModeFlag(AI_CTRL_TURNUP);
			ObjDriver->DelModeFlag(AI_CTRL_TURNDOWN);
			ObjDriver->DelModeFlag(AI_CTRL_TURNLEFT);
			ObjDriver->DelModeFlag(AI_CTRL_TURNRIGHT);
			if( GetRand(3) == 0 ){
				ObjDriver->DelModeFlag(AI_CTRL_MOVEWALK);
			}
			return;
		}
		else{									//DIȑ ȊO
			if( longattack == false ){
				forward = 6;
				back = 6;
				side = 7;
				updown = 5;
				rightleft = 6;
			}
			else{
				forward = 5;
				back = 4;
				side = 5;
				updown = 3;
				rightleft = 3;
			}
		}
	}
	else if( battlemode == AI_CAUTION ){	//x
		forward = 10;
		back = 10;
		side = 10;
		updown = 14;
		rightleft = 20;
	}
	else{
		forward = 12;
		back = 12;
		side = 12;
		updown = 15;
		rightleft = 18;
	}

	//ړ_Ɏ~߂
	if( GetRand(forward) == 0 ){
		ObjDriver->DelModeFlag(AI_CTRL_MOVEFORWARD);
	}
	if( GetRand(back) == 0 ){
		ObjDriver->DelModeFlag(AI_CTRL_MOVEBACKWARD);
	}
	if( GetRand(side) == 0 ){
		ObjDriver->DelModeFlag(AI_CTRL_MOVELEFT);
	}
	if( GetRand(side) == 0 ){
		ObjDriver->DelModeFlag(AI_CTRL_MOVERIGHT);
	}
	if( GetRand(3) == 0 ){
		ObjDriver->DelModeFlag(AI_CTRL_MOVEWALK);
	}

	//]_Ɏ~߂
	if( GetRand(updown) == 0 ){
		ObjDriver->DelModeFlag(AI_CTRL_TURNUP);
	}
	if( GetRand(updown) == 0 ){
		ObjDriver->DelModeFlag(AI_CTRL_TURNDOWN);
	}
	if( GetRand(rightleft) == 0 ){
		ObjDriver->DelModeFlag(AI_CTRL_TURNLEFT);
	}
	if( GetRand(rightleft) == 0 ){
		ObjDriver->DelModeFlag(AI_CTRL_TURNRIGHT);
	}
}

//! @brief [hÊĂ
//! @return ̂ĂF1@[hF2@ւF3@FULL/SEMI؂ւF4@ȂF0
int AIcontrol::ControlWeapon()
{
	int selectweapon;
	class weapon *weapon[TOTAL_HAVEWEAPON];
	int weaponid, lnbs, nbs;
	WeaponParameter paramdata;
	bool blazingmodeS, blazingmodeN;

	for(int i=0; i<TOTAL_HAVEWEAPON; i++){
		weapon[i] = NULL;
	}

	//̏擾
	ctrlhuman->GetWeapon(&selectweapon, weapon);
	if( weapon[selectweapon] == NULL ){ return 0; }
	weapon[selectweapon]->GetParamData(&weaponid, &lnbs, &nbs);

	//̐\擾
	if( Param->GetWeapon(weaponid, &paramdata) == 1 ){ return 0; }

	//XR[v
	ctrlhuman->SetDisableScope();

	//uP[XvȂ牽Ȃ
	if( weaponid == ID_WEAPON_CASE ){ return 0; }

	//퓬ɃOl[hĂ
	if( battlemode == AI_ACTION ){
		if( weaponid == ID_WEAPON_GRENADE ){
			int nextselectweapon, nextnds;

			//̒̕e擾
			nextselectweapon = selectweapon + 1;
			nextnds = 0;
			if( nextselectweapon == TOTAL_HAVEWEAPON ){
				nextselectweapon = 0;
			}
			if( weapon[nextselectweapon] != NULL ){
				weapon[nextselectweapon]->GetParamData(NULL, NULL, &nextnds);
			}

			if( longattack == false ){
				// 1/100̊mŎւ
				if( (GetRand(100) == 0)&&(nextnds > 0) ){
					ObjMgr->ChangeWeapon(ctrlid);
					return 3;
				}
			}
			else{
				// 1/66̊mŎւ
				if( (GetRand(66) == 0)&&(nextnds > 0) ){
					ObjMgr->ChangeWeapon(ctrlid);
					return 3;
				}
			}
		}
	}

	//ce
	if( lnbs == 0 ){
		int ways;

		//m
		if( battlemode == AI_NORMAL ){ ways = 1; }
		else if( battlemode == AI_CAUTION ){ ways = 10; }
		else{ ways = 8; }

		// 1/ways̊mŏ
		if( GetRand(ways) == 0 ){
			int under;

			//[hm
			if( battlemode == AI_NORMAL ){
				ways = 1;
				under = 0;
			}
			else if( battlemode == AI_CAUTION ){
				ways = 5;
				under = 3;
			}
			else{
				if( longattack == false ){
					// ḿ@3/4
					ways = 4;
					under = 2;
				}
				else{
					// ḿ@2/3
					ways = 3;
					under = 1;
				}
			}

			//eΎ̂Ă
			if( nbs == 0 ){
				ObjMgr->DumpWeapon(ctrlid);
				return 1;
			}

			//_ [hs or 
			if( GetRand(ways) <= under ){
				ObjMgr->ReloadWeapon(ctrlid);
				return 2;
			}
			//else{
				ObjMgr->ChangeWeapon(ctrlid);
				return 3;
			//}
		}
	}

	//Aː؂ւ\ȕȂ
	if( paramdata.ChangeWeapon != -1 ){
		//݂̘̕Aːݒ擾
		blazingmodeS = paramdata.blazingmode;

		//Vȕ̘Aːݒ擾
		if( Param->GetWeapon(paramdata.ChangeWeapon, &paramdata) == 1 ){ return 0; }
		blazingmodeN = paramdata.blazingmode;

		if( longattack == false ){
			//ߋUŁASEMIE؂ւFULLɂȂȂ
			if( (blazingmodeS == false)||(blazingmodeN == true) ){
				ObjMgr->ChangeShotMode(ctrlid);	//؂ւ
				return 4;
			}
		}
		else{
			//UŁAFULLE؂ւSEMIɂȂȂ
			if( (blazingmodeS == true)||(blazingmodeN == false) ){
				ObjMgr->ChangeShotMode(ctrlid);	//؂ւ
				return 4;
			}
		}
	}

	return 0;
}

//! @brief ֒e𓊂
//! @return F0@IF1@֒eĂȂF2
//! @attention ֒e𓊂pXɉłBG̍UAction()֐QƂĂB
int AIcontrol::ThrowGrenade()
{
	int selectweapon;
	class weapon *weapon[TOTAL_HAVEWEAPON];
	int weaponid, nbs, i;
	pointdata pdata;
	float posy2;
	float atan_rx, atan_ry;

	for(int i=0; i<TOTAL_HAVEWEAPON; i++){
		weapon[i] = NULL;
	}

	//֒eĂ邩mF
	ctrlhuman->GetWeapon(&selectweapon, weapon);
	for(i=0; i<TOTAL_HAVEWEAPON; i++){
		if( weapon[i] != NULL ){
			weapon[i]->GetParamData(&weaponid, NULL, &nbs);
			if( weaponid == ID_WEAPON_GRENADE ){
				break;
			}
		}
	}

	//֒eɐ؂ւȂA؂ւ
	if( (i != TOTAL_HAVEWEAPON)&&(i != selectweapon) ){
		ObjMgr->ChangeWeapon(ctrlid, i);
	}

	//pXƐl̍擾
	MoveNavi->GetPathPointData(&pdata);
	posy2 = posy + VIEW_HEIGHT;

	//xSĂ̓~߂
	ObjDriver->ResetMode();

	//ڕWn_ւ̊px߂
	CheckTargetAngle(posx, posy2, posz, rx*-1 + (float)M_PI/2, ry, pdata.x, pdata.y, pdata.z, 0.0f, &atan_rx, &atan_ry, NULL);

	//֒eĂȂ
	if( i == TOTAL_HAVEWEAPON ){
		//֒eĂȂꍇłÃt[ł͂̕֌悤B
		//@̏ɂA֒eĂȂԂ ֒e̖[vɊׂꍇA֒epX̕pB
		//@i{XOPS̎dlj

		//
		if( atan_rx > 0.0f ){
			ObjDriver->SetModeFlag(AI_CTRL_TURNLEFT);
		}
		if( atan_rx < 0.0f ){
			ObjDriver->SetModeFlag(AI_CTRL_TURNRIGHT);
		}
		ArmAngle();

		return 2;
	}

	//
	if( atan_rx > 0.0f ){
		ObjDriver->SetModeFlag(AI_CTRL_TURNLEFT);
	}
	if( atan_rx < 0.0f ){
		ObjDriver->SetModeFlag(AI_CTRL_TURNRIGHT);
	}
	if( atan_ry > 0.0f ){
		ObjDriver->SetModeFlag(AI_CTRL_TURNUP);
	}
	if( atan_ry < 0.0f ){
		ObjDriver->SetModeFlag(AI_CTRL_TURNDOWN);
	}

	//
	if( (fabs(atan_rx) < DegreeToRadian(1.5f))&&(fabs(atan_ry) < DegreeToRadian(1.5f)) ){
		//pxݒ
		ctrlhuman->SetRxRy(rx, ry);

		if( ObjMgr->ShotWeapon(ctrlid) != 0 ){
			return 1;
		}
	}

	return 0;
}

//! @brief r̊pxݒ
void AIcontrol::ArmAngle()
{
	ObjDriver->DelModeFlag(AI_CTRL_TURNUP);
	ObjDriver->DelModeFlag(AI_CTRL_TURNDOWN);

	if( ctrlhuman->GetMainWeaponTypeNO() == ID_WEAPON_NONE ){	//Ԃ
		//Ɍ
		ObjDriver->SetModeFlag(AI_CTRL_TURNDOWN);
	}
	else if( (battlemode == AI_CAUTION)&&(cautioncnt > 0) ){	//x
		float addry2 = 0.0f - ry;

		//
		if( addry2 > DegreeToRadian(1.0f) ){
			ObjDriver->SetModeFlag(AI_CTRL_TURNUP);
		}
		if( addry2 < DegreeToRadian(-1.0f) ){
			ObjDriver->SetModeFlag(AI_CTRL_TURNDOWN);
		}
	}
	else{									//펞ŕ폊L
		//
		if( ry < DegreeToRadian(-32) ){
			ObjDriver->SetModeFlag(AI_CTRL_TURNUP);
		}
		if( ry > DegreeToRadian(-28) ){
			ObjDriver->SetModeFlag(AI_CTRL_TURNDOWN);
		}
	}
}

//! @brief GT
int AIcontrol::SearchEnemy()
{
	//퓬tOLȂGȂ
	if( NoFight == true ){
		return 0;
	}

	if( battlemode == AI_ACTION ){ return 0; }

	int weaponid = ctrlhuman->GetMainWeaponTypeNO();
	int weaponscope = 0;
	int searchloops;
	float maxDist;
	float A_rx, A_ry, B_rx, B_ry;

	//Ă΁AXR[v[h擾
	if( weaponid != ID_WEAPON_NONE ){
		WeaponParameter Wparam;

		Param->GetWeapon(weaponid, &Wparam);
		weaponscope = Wparam.scopemode;
	}

	//G̒T񐔂ƒT͈́iƊpxjݒ
	if( battlemode == AI_NORMAL ){
		searchloops = (LevelParam->search) * AI_TOTALHUMAN_SCALE;

		if( weaponscope == 2 ){ maxDist = 50.0f; }
		if( weaponscope == 1 ){ maxDist = 25.0f; }
		else{ maxDist = 0.0f; }
		maxDist += 12.0f*((LevelParam->search)-2) + 350.0f;
		A_rx = DegreeToRadian(60);
		A_ry = DegreeToRadian(110);
		B_rx = DegreeToRadian(40);
		B_ry = DegreeToRadian(60);
	}
	else {	//battlemode == AI_CAUTION
		searchloops = (LevelParam->search) * AI_TOTALHUMAN_SCALE + 4;

		if( weaponscope == 2 ){ maxDist = 80.0f; }
		if( weaponscope == 1 ){ maxDist = 40.0f; }
		else{ maxDist = 0.0f; }
		maxDist += 15.0f*((LevelParam->search)-2) + 420.0f;
		A_rx = DegreeToRadian(80);
		A_ry = DegreeToRadian(130);
		B_rx = DegreeToRadian(50);
		B_ry = DegreeToRadian(80);
	}

	//w񐔁AGT
	for(int i=0; i<searchloops; i++){
		int targetid = GetRand(MAX_HUMAN);

		if( CheckLookEnemy(targetid, A_rx, A_ry, 200.0f, NULL) == true ){
			longattack = false;
			return 1;
		}

		if( CheckLookEnemy(targetid, B_rx, B_ry, maxDist, NULL) == true ){
			if( GetRand(4) == 0 ){
				if( MoveNavi->GetRun2() == true ){ longattack = false; }
				else{ longattack = true; }
				return 2;
			}
		}
	}
	return 0;
}

//! @brief GTiUɋߋTj
int AIcontrol::SearchShortEnemy()
{
	float A_rx, A_ry;
	A_rx = DegreeToRadian(100);
	A_ry = DegreeToRadian(52);

	for(int i=0; i<3; i++){
		int targetid = GetRand(MAX_HUMAN);

		if( CheckLookEnemy(targetid, A_rx, A_ry, 200.0f, NULL) == true ){
			longattack = false;
			return 1;
		}
	}
	return 0;
}

//! @brief G邩
bool AIcontrol::CheckLookEnemy(int id, float search_rx, float search_ry, float maxDist, float *out_minDist)
{
	if( ObjMgr == NULL ){ return false; }

	//l̃IuWFNg擾
	class human* thuman;
	thuman = ObjMgr->GetHumanObject(id);
	if( thuman == NULL ){ return false; }

	//֐I[o[[h
	return CheckLookEnemy(thuman, search_rx, search_ry, maxDist, out_minDist);
}

//! @brief G邩
bool AIcontrol::CheckLookEnemy(class human* thuman, float search_rx, float search_ry, float maxDist, float *out_minDist)
{
	//return false;

	//ȃf[^ȂI
	if( ctrlhuman == NULL ){ return false; }
	if( thuman == NULL ){ return false; }
	if( thuman->GetEnableFlag() == false ){ return false; }
	if( thuman->GetDeadFlag() == true ){ return false; }

	//ƓG̍W擾
	int ctrlteam, targetteam;
	float tx, ty, tz;
	ctrlhuman->GetParamData(NULL, NULL, NULL, &ctrlteam);
	thuman->GetParamData(NULL, NULL, NULL, &targetteam);
	thuman->GetPosData(&tx, &ty, &tz, NULL);

	//ƓGlłȂ
	if( ctrlteam != targetteam ){
		float mrx, mry;
		float Dist2 , Dist;
		float Dist_dummy; 

		//𔻒肵Apx擾
		if( CheckTargetAngle(posx, posy, posz, rx*-1 + (float)M_PI/2, 0.0f, tx, ty, tz, maxDist, &mrx, &mry, &Dist2) == true ){
			//pxAEɓĂ
			if( (fabs(mrx) < search_rx/2)&&(fabs(mry) < search_ry/2) ){
				float vx, vy, vz;

				Dist = sqrt(Dist2);

				//xNg擾
				vx = (tx - posx)/Dist;
				vy = (ty - posy)/Dist;
				vz = (tz - posz)/Dist;

				//ubNՂĂȂ΁@iCœ蔻sAĂȂ΁j
				if( CollD->CheckALLBlockIntersectRay(posx, posy + VIEW_HEIGHT, posz, vx, vy, vz, NULL, NULL, &Dist_dummy, Dist) == false ){
					if( out_minDist != NULL ){ *out_minDist = Dist; }
					enemyhuman = thuman;
					return true;
				}
			}
		}
	}
	return false;
}

//! @brief ̂邩mF
bool AIcontrol::CheckCorpse(int id)
{
	//NXݒ肪ΏȂ
	if( ObjMgr == NULL ){ return false; }
	if( ctrlhuman == NULL ){ return false; }

	//^[Qbg̃NX擾
	class human* thuman;
	thuman = ObjMgr->GetHumanObject(id);
	if( thuman == NULL ){ return false; }
	if( thuman->GetEnableFlag() == false ){ return false; }

	//SĂ
	if( thuman->GetDeadFlag() == true ){

		//`[ԍ擾
		int ctrlteam, targetteam;
		ctrlhuman->GetParamData(NULL, NULL, NULL, &ctrlteam);
		thuman->GetParamData(NULL, NULL, NULL, &targetteam);

		//Ȃ
		if( ctrlteam == targetteam ){
			float tposx, tposy, tposz;
			float atan;

			//W狗擾
			thuman->GetPosData(&tposx, &tposy, &tposz, NULL);

			//ƊpxvZ
			if( CheckTargetAngle(posx, posy, posz, rx*-1 + (float)M_PI/2, 0.0f, tposx, tposy, tposz, 22.0f, &atan, NULL, NULL) == true ){
				if( fabs(atan) < DegreeToRadian(40) ){
					return true;
				}
			}
		}
	}
	return false;
}

//! @brief pXɂړ
void AIcontrol::MovePath()
{
	int movemode, pointmode;
	MoveNavi->GetTargetPos(NULL, NULL, NULL, &movemode, &pointmode);

	if( movemode == AI_NAVI_MOVE_NULL ){			//ُȃpX
		return;
	}

	if( CheckTargetPos(false) == false ){
		MoveTarget(false);
	}
	else{
		if( (pointmode == AI_NAVI_POINT_WAIT)||(pointmode == AI_NAVI_POINT_TRACKING) ){
			TurnSeen();
		}
		else if( pointmode == AI_NAVI_POINT_STOP ){
			/*
			if( (StopSeen() == true)&&(waitcnt < ((int)GAMEFPS)*5) ){
				waitcnt += 1;
			}
			*/
			if( waitcnt < ((int)GAMEFPS)*5 ){
				if( StopSeen() == true ){
					waitcnt += 1;
				}
			}
			else{
				waitcnt = 0;
				MoveNavi->MovePathNextState();
				MoveNavi->MovePathNowState();
			}
		}
		else{	//pointmode == AI_NAVI_POINT_NULL
			waitcnt = 0;
			MoveNavi->MovePathNextState();
			MoveNavi->MovePathNowState();
		}
	}
}

//! @brief UC
//! @return sρFfalse@ύXFtrue
bool AIcontrol::ActionMain()
{
	int newbattlemode = AI_ACTION;

	//U
	Action();

	if( MoveNavi->GetRun2() == true ){				//DIȑ
		//ڕWn_ֈړ
		if( CheckTargetPos(false) == true ){
			newbattlemode = AI_NORMAL;
			MoveNavi->MovePathNextState();
			MoveNavi->MovePathNowState();
		}
		else{
			MoveTarget2(false);
		}
	}
	else{									//DIȑ ȊO
		//UȂA߂̓GT
		if( longattack == true ){
			SearchShortEnemy();
		}
	}

	//UI
	if( ActionCancel() == true ){
		enemyhuman = NULL;

		if( MoveNavi->GetRun2() == true ){
			newbattlemode = AI_NORMAL;
		}
		else{
			newbattlemode = AI_CAUTION;
			cautioncnt = 160;
			FaceCaution_flag = false;
			FaceCaution_rx = 0.0f;
		}
	}

	//ݒ𔻒
	if( battlemode != newbattlemode ){
		battlemode = newbattlemode;
		return true;
	}
	return false;
}

//! @brief xC
//! @return sρFfalse@ύXFtrue
bool AIcontrol::CautionMain()
{
	int newbattlemode = AI_CAUTION;
	float caution_rx;

	//Wƃ`[ԍ擾
	int teamid;
	ctrlhuman->GetParamData(NULL, NULL, NULL, &teamid);

	//eƉ̏󋵂擾
	bool HitFlag = ctrlhuman->CheckHit(&caution_rx);
	soundlist soundlist[MAX_SOUNDMGR_LIST];
	int soundlists = GameSound->GetWorldSound(posx, posy + VIEW_HEIGHT, posz, teamid, soundlist);

	//퓬tOLȂA͕ȂƂɂ
	if( NoFight == true ){
		soundlists = 0;
	}

	//C
	if( enemyhuman != NULL ){		//ɓGĂ
		newbattlemode = AI_ACTION;
		actioncnt = 0;
	}
	else if( SearchEnemy() != 0 ){	//G
		newbattlemode = AI_ACTION;
		actioncnt = 0;
	}
	else if( HitFlag == true ){		//e
		cautioncnt = 160;					//xĊJ
		FaceCaution_flag = true;
		FaceCaution_rx = caution_rx;
	}
	else if( soundlists > 0 ){		//
		cautioncnt = 160;					//xĊJ
	}
	else if( cautioncnt == 0 ){		//xIȂ
		if( CheckTargetPos(true) == false ){				//xJnn_藣Ă邩
			MoveTarget(true);				//xJnn_ɋ߂Â
		}
		else{
			newbattlemode = AI_NORMAL;
			FaceCaution_flag = false;
			FaceCaution_rx = 0.0f;

			//x҂pXȂ玟֐i߂
			pointdata pdata;
			MoveNavi->GetPathPointData(&pdata);
			if( (pdata.p1 == 3)&&(pdata.p2 == 4) ){
				MoveNavi->MovePathNextState();
				MoveNavi->MovePathNowState();
			}
		}
	}
	else if( (cautioncnt < 100)&&(FaceCaution_flag == false) ){		//100t[؂A_ɌxIiJEgF0Ɂj
		if( GetRand(50) == 0 ){ cautioncnt = 0; }
	}
	else{ cautioncnt -= 1; }

	//ǔőΏۂ痣ꂷA_ɌxI
	if( (MoveNavi->GetMoveMode() == AI_TRACKING)&&(GetRand(3) == 0) ){
		float x, z;
		float tx, tz;
		class human *targethuman = ObjMgr->GetHumanObject(MoveNavi->GetTargetHumanID());
		targethuman->GetPosData(&tx, NULL, &tz, NULL);
		x = posx - tx;
		z = posz - tz;
		if( (x*x + z*z) > 25.0f*25.0f ){
			cautioncnt = 0;
		}
	}

	//]Ƙr̊px
	TurnSeen();
	ArmAngle();

	//ݒ𔻒
	if( battlemode != newbattlemode ){
		battlemode = newbattlemode;
		return true;
	}
	return false;
}

//! @brief ʏ탁C
//! @return sρFfalse@ύXFtrue
bool AIcontrol::NormalMain()
{
	int newbattlemode = AI_NORMAL;
	float caution_rx;

	MoveNavi->MovePathNowState();
	enemyhuman = NULL;

	//Wƃ`[ԍ擾
	int teamid;
	ctrlhuman->GetParamData(NULL, NULL, NULL, &teamid);

	//eƉ̏󋵂擾
	bool HitFlag = ctrlhuman->CheckHit(&caution_rx);
	soundlist soundlist[MAX_SOUNDMGR_LIST];
	int soundlists = GameSound->GetWorldSound(posx, posy + VIEW_HEIGHT, posz, teamid, soundlist);

	//퓬tOLȂA͕ȂƂɂ
	if( NoFight == true ){
		soundlists = 0;
	}

	//_pXȂ珈s
	if( MoveNavi->GetMoveMode() == AI_RANDOM ){
		MoveNavi->MovePathNextState();
		MoveNavi->MovePathNowState();
	}

	//֒epX
	if( MoveNavi->GetMoveMode() == AI_GRENADE ){
		if( ThrowGrenade() != 0 ){
			MoveNavi->MovePathNextState();
			MoveNavi->MovePathNowState();
		}
	}

	if( MoveNavi->GetMoveMode() == AI_RUN2 ){		//DIȑ̏
		//GUɓ
		if( SearchEnemy() != 0 ){
			newbattlemode = AI_ACTION;
			//cautionback_posx = posx;
			//cautionback_posz = posz;
		}
		else{
			MovePath();		//ړs
		}
	}
	else{							//DIȑȊȌ
		//xɓ鏈
		if( HitFlag == true ){							//e
			newbattlemode = AI_CAUTION;
			cautioncnt = 160;
			cautionback_posx = posx;
			cautionback_posz = posz;
			FaceCaution_flag = true;
			FaceCaution_rx = caution_rx;
		}
		else if(
			(SearchEnemy() != 0)||						//G
			(soundlists > 0)||							//
			(CheckCorpse( GetRand(MAX_HUMAN) ) == true)	//̂
		){
			newbattlemode = AI_CAUTION;
			cautioncnt = 160;
			cautionback_posx = posx;
			cautionback_posz = posz;
			FaceCaution_flag = false;
			FaceCaution_rx = 0.0f;
		}
		else{
			MovePath();		//ړs
		}
	}

	//r̊pxݒ
	if( MoveNavi->GetMoveMode() != AI_GRENADE ){
		ArmAngle();
	}

	//ݒ𔻒
	if( battlemode != newbattlemode ){
		battlemode = newbattlemode;
		return true;
	}
	return false;
}

//! @brief n֐
void AIcontrol::Init()
{
	//NXݒ肪ΏȂ
	if( ctrlhuman == NULL ){ return; }
	if( blocks == NULL ){ return; }
	if( CollD == NULL ){ return; }

	//gpĂȂlȂ珈Ȃ
	if( ctrlhuman->GetEnableFlag() == false ){ return; }

	//Xe[g
	NoFight = false;
	battlemode = AI_NORMAL;
	enemyhuman = NULL;
	FaceCaution_flag = false;
	FaceCaution_rx = 0.0f;
	total_move = 0.0f;
	waitcnt = 0;
	gotocnt = 0;
	cautioncnt = 0;
	actioncnt = 0;
	longattack = false;

	MoveNavi->Init();
	ObjDriver->Init();

	//AIxƐݒl擾
	int paramid;
	HumanParameter paramdata;
	ctrlhuman->GetParamData(&paramid, NULL, NULL, NULL);
	Param->GetHuman(paramid, &paramdata);
	AIlevel = paramdata.AIlevel;
	Param->GetAIlevel(AIlevel, &LevelParam);

	//̃|Cg
	//MoveNavi->MovePathNextState();
	MoveNavi->MovePathNowState();
}

//! @brief AIxݒ
//! @param level AIx
void AIcontrol::SetAIlevel(int level)
{
	if( (level < -1)||(TOTAL_PARAMETERINFO_AILEVEL <= level) ){ return; }

	if( level == -1 ){
		//AIx擾
		int paramid;
		HumanParameter paramdata;
		ctrlhuman->GetParamData(&paramid, NULL, NULL, NULL);
		Param->GetHuman(paramid, &paramdata);
		AIlevel = paramdata.AIlevel;
	}
	else{
		AIlevel = level;
	}

	//ݒl擾
	Param->GetAIlevel(AIlevel, &LevelParam);
}

//! @brief AIx擾
//! @return AIx
int AIcontrol::GetAIlevel()
{
	return AIlevel;
}

//! @brief w肵ꏊ֑ҋ@
//! @param px XW
//! @param pz ZW
//! @param rx d
//! @attention ړpXɊւ炸Aw肵Wւ̑ҋ@܂BInit()֐ēxs܂Ōɖ߂܂B
void AIcontrol::SetHoldWait(float px, float pz, float rx)
{
	MoveNavi->SetHoldWait(px, pz, rx);
}

//! @brief w肵lǔ
//! @param id l̃f[^ԍ
//! @attention ړpXɊւ炸Aw肵lւ̒ǔ܂BInit()֐ēxs܂Ōɖ߂܂B
void AIcontrol::SetHoldTracking(int id)
{
	MoveNavi->SetHoldTracking(id);
}

//! @brief IɌx
//! @warning DIȑ s̏ꍇÅ֐͉܂B
void AIcontrol::SetCautionMode()
{
	//DIȑȂΉȂ
	if( MoveNavi->GetRun2() == true ){ return; }

	if( battlemode == AI_NORMAL ){
		cautionback_posx = posx;
		cautionback_posz = posz;
	}
	battlemode = AI_CAUTION;
	cautioncnt = 160;
	FaceCaution_flag = false;
	FaceCaution_rx = 0.0f;
}

//! @brief 퓬tOݒ
//! @param flag trueF퓬sȂi퓬j@falseF퓬siʏj
//! @attention tOLɂƓGFȂȂ܂B
void AIcontrol::SetNoFightFlag(bool flag)
{
	NoFight = flag;
}

//! @brief 퓬[h擾
//! @param *mode 퓬[hij󂯎|C^
//! @param *modestr 퓬[h̕󂯎|C^
void AIcontrol::GetBattleMode(int *mode, char *modestr)
{
	if( mode != NULL ){
		*mode = battlemode;
	}
	if( modestr != NULL ){
		switch(battlemode){
			case 0: strcpy(modestr, "AI_DEAD"); break;
			case 1: strcpy(modestr, "AI_ACTION"); break;
			case 2: strcpy(modestr, "AI_CAUTION"); break;
			case 3: strcpy(modestr, "AI_NORMAL"); break;
			default: strcpy(modestr, "");
		}
	}
}

//! @brief UΏۂ̐lf[^ԍ
//! @return lf[^ԍi^[QbgȂꍇ -1j
int AIcontrol::GetEnemyHumanID()
{
	if( enemyhuman == NULL ){
		return -1;
	}
	//else{
		return ObjMgr->GetHumanObjectID(enemyhuman);
	//}
}

//! @brief ړڕWn_i^[Qbgj擾
//! @param posx ڕWn_XW󂯎|C^
//! @param posz ڕWn_ZW󂯎|C^
//! @param movemode ڕWn_ւ̈ړ[h󂯎|C^
void AIcontrol::GetMoveTargetPos(float *posx, float *posz, int *movemode)
{
	MoveNavi->GetTargetPos(posx, posz, NULL, movemode, NULL);

	if( (battlemode == AI_ACTION)||(battlemode == AI_CAUTION) ){
		*posx = cautionback_posx;
		*posz = cautionback_posz;
	}
}

//! @brief ݓǂݍł|Cgf[^pX
//! @param out_data |Cgf[^󂯎|C^
void AIcontrol::GetPathPointData(pointdata *out_data)
{
	MoveNavi->GetPathPointData(out_data);
}

//! @brief n֐
void AIcontrol::Process()
{
	//NXݒ肪ΏȂ
	if( ctrlhuman == NULL ){ return; }
	if( blocks == NULL ){ return; }
	if( CollD == NULL ){ return; }

	//ȐlNXȂ珈Ȃ
	if( ctrlhuman->GetEnableFlag() == false ){ return; }

	//S
	if( ctrlhuman->GetHP() <= 0 ){
		battlemode = AI_DEAD;
		return;
	}

	//HP0łȂ̂ SƂɂȂĂ@EEEԂH
	if( battlemode == AI_DEAD ){
		battlemode = AI_NORMAL;
		MoveNavi->MovePathNowState();
	}

	//WƊpx擾
	ctrlhuman->GetPosData(&posx, &posy, &posz, NULL);
	ctrlhuman->GetRxRy(&rx, &ry);

	//_ɓ~߂
	CancelMoveTurn();

	//UxȂ
	if( (battlemode == AI_ACTION)||(battlemode == AI_CAUTION) ){
		//
		HaveWeapon();
	}

	//vZs
	if( battlemode == AI_ACTION ){			//U
		ActionMain();
	}
	else if( battlemode == AI_CAUTION ){	//x
		CautionMain();
	}
	else{									//펞
		NormalMain();
	}

	//ړE]
	ObjDriver->ControlObject();

	//舵
	ControlWeapon();
}

//! @brief RXgN^
AIMoveNavi::AIMoveNavi(class ObjectManager *in_ObjMgr, int in_ctrlid, class PointDataInterface *in_Points)
{
	ObjMgr = in_ObjMgr;
	ctrlid = in_ctrlid;
	Points = in_Points;

	movemode = AI_WAIT;
	hold = false;
	path_pointid = 0;
	target_humanid = -1;
	target_posx = 0.0f;
	target_posz = 0.0f;
	target_rx = 0.0f;
}

//! @brief fBXgN^
AIMoveNavi::~AIMoveNavi()
{}

//! @brief ΏۃNXݒ
//! @attention ̊֐ŐݒsȂƁANX̂@\܂B
void AIMoveNavi::SetClass(class ObjectManager *in_ObjMgr, int in_ctrlid, class PointDataInterface *in_Points)
{
	ObjMgr = in_ObjMgr;
	ctrlid = in_ctrlid;
	Points = in_Points;
}

//! @brief n֐
void AIMoveNavi::Init()
{
	movemode = AI_NULL;
	hold = false;
	path_pointid = 0;
	target_humanid = -1;

	ObjMgr->GetHumanObject(ctrlid)->GetParamData(NULL, &path_pointid, NULL, NULL);
	MovePathNextState();
}

//! @brief ړڕWn_Kp
//! @return Ftrue@sFfalse
//! @attention ǔɑΏېl̍W𔽉f邽߁A{֐𖈃t[ĂяoāAŐV̈ʒuvZKv܂B
bool AIMoveNavi::MovePathNowState()
{
	if( hold == true ){
		if( movemode == AI_TRACKING ){
			class human *targethuman;
			targethuman = ObjMgr->GetHumanObject(target_humanid);
			targethuman->GetPosData(&target_posx, NULL, &target_posz, &target_rx);
		}
		return true;
	}


	//|Cg̏擾
	pointdata pdata;
	if( Points->Getdata(&pdata, path_pointid) != 0 ){
		movemode = AI_NULL;
		return false;
	}

	//ړpXȂ`
	if( pdata.p1 == 3 ){
		//ړXe[gݒ
		switch(pdata.p2){
			case 0: movemode = AI_WALK; break;
			case 1: movemode = AI_RUN; break;
			case 2: movemode = AI_WAIT; break;
			case 3: movemode = AI_TRACKING; break;
			case 4: movemode = AI_WAIT; break;
			case 5: movemode = AI_STOP; break;
			case 6: movemode = AI_GRENADE; break;
			case 7: movemode = AI_RUN2; break;
			default: break;
		}

		if( movemode == AI_TRACKING ){
			class human *targethuman;

			if( target_humanid == -1 ){
				signed char nextpointp4 = pdata.p3;

				//|Cgilj̏擾
				if( Points->SearchPointdata(&pdata, 0x08, 0, 0, 0, nextpointp4, 0) == 0 ){
					return false;
				}

				//lăNX擾
				targethuman = ObjMgr->SearchHuman(pdata.p4);
				if( targethuman == NULL ){ return false; }

				//l̃f[^ԍ擾
				target_humanid = ObjMgr->GetHumanObjectID(targethuman);
			}

			targethuman = ObjMgr->GetHumanObject(target_humanid);
			targethuman->GetPosData(&target_posx, NULL, &target_posz, &target_rx);
		}
		else{
			//Kp
			target_posx = pdata.x;
			target_posz = pdata.z;
			target_rx = pdata.r;
		}

		return true;
	}

	//_pXȂ
	if( pdata.p1 == 8 ){
		movemode = AI_RANDOM;
		return false;
	}

	movemode = AI_NULL;
	return false;
}

//! @brief ̖ڕWn_
//! @return Ftrue@sFfalse
bool AIMoveNavi::MovePathNextState()
{
	//|Cg̏擾
	pointdata pdata;
	if( Points->Getdata(&pdata, path_pointid) != 0 ){
		movemode = AI_NULL;
		return false;
	}

	signed char nextpointp4 = pdata.p3;

	//_pX
	if( pdata.p1 == 8 ){
		if( GetRand(2) == 0 ){
			nextpointp4 = pdata.p2;
		}
		else{
			nextpointp4 = pdata.p3;
		}
		movemode = AI_RANDOM;
	}

	//|Cg
	if( Points->SearchPointdata(&pdata, 0x08, 0, 0, 0, nextpointp4, 0) == 0 ){
		return false;
	}

	path_pointid = pdata.id;

	return true;
}

//! @brief w肵ꏊ֑ҋ@
//! @param px XW
//! @param pz ZW
//! @param rx d
//! @attention ړpXɊւ炸Aw肵Wւ̑ҋ@܂BInit()֐ēxs܂Ōɖ߂܂B
void AIMoveNavi::SetHoldWait(float px, float pz, float rx)
{
	movemode = AI_WAIT;
	hold = true;
	target_posx = px;
	target_posz = pz;
	target_rx = rx;
}

//! @brief w肵lǔ
//! @param id l̃f[^ԍ
//! @attention ړpXɊւ炸Aw肵lւ̒ǔ܂BInit()֐ēxs܂Ōɖ߂܂B
void AIMoveNavi::SetHoldTracking(int id)
{
	movemode = AI_TRACKING;
	hold = true;
	target_humanid = id;
}

//! @brief ړ[h擾
//! @return ړ[h
int AIMoveNavi::GetMoveMode()
{
	return movemode;
}

//! @brief DIȑtO擾
//! @return DIȑłFtrue@DIȑłȂFfalse
bool AIMoveNavi::GetRun2()
{
	if( movemode == AI_RUN2 ){
		return true;
	}
	//else{
		return false;
	//}
}

//! @brief ^[Qbgilj̃f[^ԍ擾
//! @return l̃f[^ԍ
int AIMoveNavi::GetTargetHumanID()
{
	return target_humanid;
}

//! @brief ݓǂݍł|Cgf[^pX
//! @param out_data |Cgf[^󂯎|C^
void AIMoveNavi::GetPathPointData(pointdata *out_data)
{
	Points->Getdata(out_data, path_pointid);
}

//! @brief ړڕWn_i^[Qbgj擾
//! @param posx ڕWn_XW󂯎|C^
//! @param posz ڕWn_ZW󂯎|C^
//! @param rx ڕWn_̐px󂯎|C^
//! @param out_movemode ڕWn_ւ̈ړ[h󂯎|C^
//! @param out_pointmode ڕWn_̃|Cg[h󂯎|C^
//! @warning {֐ł͍W͍XV܂B MovePathNowState() ֐ōWXVA{֐ĂяoĂB
void AIMoveNavi::GetTargetPos(float *posx, float *posz, float *rx, int *out_movemode, int *out_pointmode)
{
	if( posx != NULL ){ *posx = target_posx; }
	if( posz != NULL ){ *posz = target_posz; }
	if( rx != NULL ){ *rx = target_rx; }

	if( out_movemode != NULL ){
		if( (movemode == AI_WALK)||(movemode == AI_WAIT)||(movemode == AI_STOP) ){
			*out_movemode = AI_NAVI_MOVE_WALK;
		}
		else if( movemode == AI_RUN ){
			*out_movemode = AI_NAVI_MOVE_RUN;
		}
		else if( movemode == AI_RUN2 ){
			*out_movemode = AI_NAVI_MOVE_RUN2;
		}
		else if( movemode == AI_TRACKING ){
			*out_movemode = AI_NAVI_MOVE_TRACKING;
		}
		else{
			*out_movemode = AI_NAVI_MOVE_NULL;
		}
	}

	if( out_pointmode != NULL ){
		if( movemode == AI_WAIT ){
			*out_pointmode = AI_NAVI_POINT_WAIT;
		}
		else if( movemode == AI_STOP ){
			*out_pointmode = AI_NAVI_POINT_STOP;
		}
		else if( movemode == AI_TRACKING ){
			*out_pointmode = AI_NAVI_POINT_TRACKING;
		}
		else if( movemode == AI_GRENADE ){	//֒epX
			*out_pointmode = AI_NAVI_POINT_GRENADE;
		}
		else{								//ړpXEُȃpX
			*out_pointmode = AI_NAVI_POINT_NULL;
		}
	}
}

//! @brief RXgN^
AIObjectDriver::AIObjectDriver(class ObjectManager *in_ObjMgr, int in_ctrlid)
{
	ObjMgr = in_ObjMgr;
	ctrlid = in_ctrlid;

	moveturn_mode = 0;
	addrx = 0.0f;
	addry = 0.0f;
}

//! @brief fBXgN^
AIObjectDriver::~AIObjectDriver()
{}

//! @brief ΏۃNXݒ
//! @attention ̊֐ŐݒsȂƁANX̂@\܂B
void AIObjectDriver::SetClass(class ObjectManager *in_ObjMgr, int in_ctrlid)
{
	ObjMgr = in_ObjMgr;
	ctrlid = in_ctrlid;
}

//! @brief n֐
void AIObjectDriver::Init()
{
	addrx = 0.0f;
	addry = 0.0f;

	ResetMode();
}

//! @brief ړ]tONAixSĂ̓~߂j
void AIObjectDriver::ResetMode()
{
	moveturn_mode = 0;
}

//! @brief ړ]tO ݒ
//! @param flag 샂[h\萔iAIcontrolFlag񋓌^j
void AIObjectDriver::SetModeFlag(int flag)
{
	SetFlag(moveturn_mode, flag);
}

//! @brief ړ]tO 
//! @param flag 샂[h\萔iAIcontrolFlag񋓌^j
void AIObjectDriver::DelModeFlag(int flag)
{
	DelFlag(moveturn_mode, flag);
}

//! @brief ړ]tO 擾
//! @param flag 샂[h\萔iAIcontrolFlag񋓌^j
bool AIObjectDriver::GetModeFlag(int flag)
{
	if( GetFlag(moveturn_mode, flag) == 0 ){
		return false;
	}
	//else{
		return true;
	//}
}

//! @brief ړ]s
//! @attention t[1񂾂ĂяoĂB
void AIObjectDriver::ControlObject()
{
	float rx, ry;

	//ړ̎s
	if( GetFlag(moveturn_mode, AI_CTRL_MOVEFORWARD) ){
		ObjMgr->MoveForward(ctrlid);
	}
	if( GetFlag(moveturn_mode, AI_CTRL_MOVEBACKWARD) ){
		ObjMgr->MoveBack(ctrlid);
	}
	if( GetFlag(moveturn_mode, AI_CTRL_MOVELEFT) ){
		ObjMgr->MoveLeft(ctrlid);
	}
	if( GetFlag(moveturn_mode, AI_CTRL_MOVERIGHT) ){
		ObjMgr->MoveRight(ctrlid);
	}
	if( GetFlag(moveturn_mode, AI_CTRL_MOVEWALK) ){
		ObjMgr->MoveWalk(ctrlid);
	}

	//]̎si]x̉Zj
	if( GetFlag(moveturn_mode, AI_CTRL_TURNUP) ){
		addry += AI_ADDTURNRAD;
	}
	if( GetFlag(moveturn_mode, AI_CTRL_TURNDOWN) ){
		addry -= AI_ADDTURNRAD;
	}
	if( GetFlag(moveturn_mode, AI_CTRL_TURNLEFT) ){
		addrx -= AI_ADDTURNRAD;
	}
	if( GetFlag(moveturn_mode, AI_CTRL_TURNRIGHT) ){
		addrx += AI_ADDTURNRAD;
	}

	//px擾
	ObjMgr->GetHumanObject(ctrlid)->GetRxRy(&rx, &ry);

	//pxɉZ
	rx += addrx;
	ry += addry;

	//c̉]͈͂߂
	if( ry > DegreeToRadian(70) ){ ry = DegreeToRadian(70); }
	if( ry < DegreeToRadian(-70) ){ ry = DegreeToRadian(-70); }

	//pxݒ
	ObjMgr->GetHumanObject(ctrlid)->SetRxRy(rx, ry);

	//]x̌
	addrx *= 0.8f;
	addry *= 0.8f;

	//0.0f֕␳
	if( fabs(addrx) < DegreeToRadian(0.2f) ){ addrx = 0.0f; }
	if( fabs(addry) < DegreeToRadian(0.2f) ){ addry = 0.0f; }
}