//! @file object.h
//! @brief objectNX̐錾

//--------------------------------------------------------------------------------
// 
// OpenXOPS
// Copyright (c) 2014-2020, OpenXOPS Project / [-_-;](mikan) All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
// * Redistributions of source code must retain the above copyright notice, 
//   this list of conditions and the following disclaimer.
// * Redistributions in binary form must reproduce the above copyright notice, 
//   this list of conditions and the following disclaimer in the documentation 
//   and/or other materials provided with the distribution.
// * Neither the name of the OpenXOPS Project nor the names of its contributors 
//   may be used to endorse or promote products derived from this software 
//   without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL OpenXOPS Project BE LIABLE FOR ANY
// DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
// LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
// ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//--------------------------------------------------------------------------------

#ifndef OBJECT_H
#define OBJECT_H

// ӁFxύX́A蔻n̒萔vmF
#define HUMAN_PROGRESSRUN_ACCELERATION	0.7f			//!< l̑Oiijx
#define HUMAN_SIDEWAYSRUN_ACCELERATION 0.5f			//!< l̉x
#define HUMAN_REGRESSRUN_ACCELERATION 0.38f			//!< ľމx
//! l΂ߑOɐiމx
#define HUMAN_PROGRESSRUN_SIDEWAYSRUN_ACCELERATION ((HUMAN_PROGRESSRUN_ACCELERATION + HUMAN_SIDEWAYSRUN_ACCELERATION) / 2)
//! l΂ߌɐiމx
#define HUMAN_REGRESSRUN_SIDEWAYSRUN_ACCELERATION (HUMAN_REGRESSRUN_ACCELERATION)
#define HUMAN_PROGRESSWALK_ACCELERATION	0.35f		//!< lx
#define HUMAN_ATTENUATION			0.5f		//!< l1t[̌@i0.0 < x < 1.0j

#define HUMAN_JUMP_SPEED (2.2f + (HUMAN_DAMAGE_SPEED))	//!< Wv鑬x

#define HUMAN_HEIGHT 20.0f		//!< l̍
#define HUMAN_DAMAGE_HEAD 2.0f	//!< e  ɓꍇ̃_[W{
#define HUMAN_DAMAGE_UP 1.0f	//!< e 㔼g ɓꍇ̃_[W{
#define HUMAN_DAMAGE_LEG 0.7f	//!< e g ɓꍇ̃_[W{
#define HUMAN_DAMAGE_ZOMBIEU 15	//!< ]r̍U󂯂ꍇ̍Œ_[W
#define HUMAN_DAMAGE_ZOMBIEA 5	//!< ]r̍U󂯂ꍇ̒ǉ_[W
#define HUMAN_DAMAGE_SPEED (0.066f + 0.132f)	//!< 
#define HUMAN_DAMAGE_MINSPEED -3.8f	//!< ɂ_[W󂯂Ȃx
#define HUMAN_DAMAGE_MAXSPEED -7.0f	//!< ő嗎x
#define HUMAN_DAMAGE_MAXFALL 120	//!< ɂő_[W
#define MAX_DAMAGE_GRENADE_DISTANCE 80.0f		//!< ֒eɂ_[W󂯂ő勗
#define HUMAN_DAMAGE_GRENADE_HEAD 100			//!< ֒eɂ  ւ̍ő_[W
#define HUMAN_DAMAGE_GRENADE_LEG 80				//!< ֒eɂ  ւ̍ő_[W
#define SMALLOBJECT_DAMAGE_GRENADE 80			//!< ֒eɂ  ւ̍ő_[W

#define WEAPONRECOIL_SCOPE_1_RX 0.4f			//!< XR[v1 C̔ @x@ 0.1f
#define WEAPONRECOIL_SCOPE_1_RYMIN 1.2f			//!< XR[v1 C̔ cŏ@x@ 0.1f
#define WEAPONRECOIL_SCOPE_1_RYMAX 2.0f			//!< XR[v1 C̔ cő@x@ 0.1f
#define WEAPONRECOIL_SCOPE_2_RX 0.6f			//!< XR[v2 C̔ @x@ 0.1f
#define WEAPONRECOIL_SCOPE_2_RYMIN 2.4f			//!< XR[v2 C̔ cŏ@x@ 0.1f
#define WEAPONRECOIL_SCOPE_2_RYMAX 3.6f			//!< XR[v2 C̔ cő@x@ 0.1f

#define ARMRAD_NOWEAPON DegreeToRadian((-90 + 20))			//!< Ԃ玞̘r̕`px
#define ARMRAD_RELOADWEAPON DegreeToRadian(-20)				//!< [h̘r̕`px

#define HUMAN_MAPCOLLISION_R 5.0f							//!< lƃ}bv̓蔻@a
#define HUMAN_MAPCOLLISION_HEIGHT 10.2f						//!< lƃ}bv̓蔻@iFxj
#define HUMAN_MAPCOLLISION_ADD_HEIGHT_A 9.2f				//!< lƃ}bv̓蔻 ǉ@iFW}bv SCHOOL ɍ킹j
#define HUMAN_MAPCOLLISION_ADD_HEIGHT_B 13.2f				//!< lƃ}bv̓蔻 ǉ@iFW}bv SCHOOL ɍ킹j
#define HUMAN_MAPCOLLISION_SLOPEANGLE DegreeToRadian(50)	//!< lƃ}bv̓蔻@oȂΖʂ̊px
#define HUMAN_MAPCOLLISION_SLOPEFORCEANGLE DegreeToRadian(22.62f)		//!< lƃ}bv̓蔻@oȂΖʂlopx
#define HUMAN_DEADLINE -100.0f						//!< lSYWifbhCj
#define HUMAN_DEADADDRY DegreeToRadian(0.75f)		//!< ̂̓|x

#define BULLET_SPEEDSCALE 2.5f				//!< e̔{
#define BULLET_DESTROYFRAME 40			//!< ȅŃt[
#define GRENADE_DESTROYFRAME 100		//!< ֒e̔t[

#ifndef H_LAYERLEVEL
 #define H_LAYERLEVEL 2		//!< Select include file.
#endif
#include "main.h"

#define HUMAN_DEADBODY_COLLISION	//!< @brief l|ۂɃ}bvƓ蔻{邩 @details 萔錾LF蔻{@萔錾iRgjF̂܂ܓ|

//! @brief IuWFNgǗNXiNXj
//! @details 3DōWǗ`sIuWFNgSʂǗNXQ̊NXłB
class object
{
protected:
	class ParameterInfo *Param;	//!< ݒlǗNXւ̃|C^
	float pos_x;		//!< XW
	float pos_y;		//!< YW
	float pos_z;		//!< ZW
	float rotation_x;	//!< ]px
	float model_size;	//!< `TCY
	int id_parameter;	//!< f[^̎
	int id_model;		//!< fFԍ
	int id_texture;		//!< eNX`Fԍ
	bool DarkModelFlag;	//!< fÂ
	bool EnableFlag;	//!< LtO

public:
	object(class ParameterInfo *in_Param = NULL, float x = 0.0f, float y = 0.0f, float z = 0.0f, float rx = 0.0f, float size = 1.0f, bool flag = true);
	~object();
	virtual void SetParameterInfoClass(class ParameterInfo *in_Param);
	virtual void SetPosData(float x, float y, float z, float rx);
	virtual void GetPosData(float *x, float *y, float *z, float *rx);
	virtual void SetEnableFlag(bool flag);
	virtual bool GetEnableFlag();
	virtual void SetModel(int id, float size);
	virtual void GetModel(int *id, float *size);
	virtual void SetTexture(int id);
	virtual int GetTexture();
	virtual void SetDarkModelFlag(bool flag);
	virtual int RunFrame();
	virtual void Render(class D3DGraphics *d3dg);
};

//! @brief lǗNX
class human : public object
{
protected:
	int point_dataid;		//!< |Cg̃f[^ԍ
	signed char point_p4;	//!< |Cg̔Fԍ
	int teamid;				//!< `[ԍ
	float move_x;			//!< Xx
	float move_y;			//!< Yijx
	float move_z;			//!< Zx
	bool move_y_flag;		//!< YړtO
	float rotation_y;		//!< Ŝ̉]px
	float armrotation_y;	//!< r̉]px
	float upmodel_size;		//!< 㔼g`TCY
	float armmodel_size;	//!< r`TCY
	float legmodel_size;	//!< `TCY
	class weapon *weapon[TOTAL_HAVEWEAPON];			//!< 
	int noweapon_bullets[TOTAL_HAVEWEAPON];			//!< 햢̍ve
	int noweapon_loadbullets[TOTAL_HAVEWEAPON];		//!< 햢̑e
	int selectweapon;			//!< A/B̑I
	int selectweaponcnt;		//!< ̐؂ւJEg
	int weaponshotcnt;			//!< ̘A˃JEg
	int weaponreloadcnt;		//!< ̃[hJEg
	int changeweaponidcnt;		//!< ̃Vbg[h؂ւJEg
	int hp;						//!< ̗
	int deadstate;				//!< ̂ɂȂĂ邩
	float add_ry;				//!< ̂̓|x
	float move_rx;				//!< ړpx
	int MoveFlag;				//!< ړ\tO
	int MoveFlag_lt;			//!< iÓjړ\tO
	int scopemode;				//!< XR[vgp[h
	bool HitFlag;				//!< e\tO
	float Hit_rx;				//!< e
	float totalmove;			//!< vړ
	int StateGunsightErrorRange;		//!< Ə̏Ԍ덷
	int ReactionGunsightErrorRange;		//!< Ə̔덷
	bool Invincible;			//!< GtO

	class HumanMotionControl *MotionCtrl;	//!< [V𐧌䂷NXւ̃|C^

	void GunsightErrorRange();
	int CheckAndProcessDead(class Collision *CollD);
	void ControlProcess();
	bool MapCollisionDetection(class Collision *CollD, class BlockDataInterface *inblockdata, bool AddCollisionFlag, float *FallDist, float *nowmove_x, float *nowmove_z);

public:
	human(class ParameterInfo *in_Param = NULL, float x = 0.0f, float y = 0.0f, float z = 0.0f, float rx = 0.0f, int id_param = -1, int dataid = 0, signed char p4 = 0, int team = 0, bool flag = false);
	~human();
	virtual void SetParameterInfoClass(class ParameterInfo *in_Param);
	virtual void SetParamData(int id_param, int dataid, signed char p4, int team, bool init);
	virtual void GetParamData(int *id_param, int *dataid, signed char *p4, int *team);
	virtual void GetMovePos(float *x, float *y, float *z);
	virtual void SetModel(int upmodel, int armmodel[], int legmodel, int walkmodel[], int runmodel[]);
	virtual int GetHP();
	virtual bool SetHP(int in_hp);
	virtual bool GetDeadFlag();
	virtual void SetTeamID(int id);
	virtual bool GetInvincibleFlag();
	virtual void SetInvincibleFlag(bool flag);
	virtual void SetWeapon(class weapon *in_weapon[], int nlnbs[], int nnbs[]);
	virtual int PickupWeapon(class weapon *in_weapon);
	virtual void ChangeWeapon(int id = -1);
	virtual int GetChangeWeaponCnt();
	virtual int GetWeaponReloadCnt();
	virtual int GetChangeWeaponIDCnt();
	virtual void GetWeapon(int *out_selectweapon, class weapon *out_weapon[], int nlnbs[], int nnbs[]);
	virtual int GetMainWeaponTypeNO();
	virtual bool GetWeaponBlazingmode();
	virtual bool ShotWeapon(int *weapon_paramid, int *GunsightErrorRange);
	virtual bool ReloadWeapon();
	virtual bool DumpWeapon();
	virtual int ChangeShotMode();
	virtual void SetMoveForward();
	virtual void SetMoveBack();
	virtual void SetMoveLeft();
	virtual void SetMoveRight();
	virtual void SetMoveWalk();
	virtual int GetMovemode(bool nowdata);
	virtual bool SetEnableScope();
	virtual void SetDisableScope();
	virtual int GetScopeMode();
	virtual void GetRxRy(float *rx, float *ry);
	virtual void SetRxRy(float rx, float ry);
	virtual float GetDeadRy();
	virtual int Jump();
	virtual void AddPosOrder(float rx, float ry, float speed);
	virtual void HitBulletHead(int attacks);
	virtual void HitBulletUp(int attacks);
	virtual void HitBulletLeg(int attacks);
	virtual void HitZombieAttack();
	virtual void HitGrenadeExplosion(int attacks);
	virtual void SetHitFlag(float rx);
	virtual bool CheckHit(float *rx);
	virtual float GetTotalMove();
	virtual int RunFrame(class Collision *CollD, class BlockDataInterface *inblockdata, bool AddCollisionFlag, bool player, bool F5mode);
	virtual int GetGunsightErrorRange();
	virtual void Render(class D3DGraphics *d3dg, class ResourceManager *Resource, bool DrawArm, bool player);
};

//! @brief ǗNX
class weapon : public object
{
protected:
	float move_x;		//!< Xړ
	float move_y;		//!< Yړ
	float move_z;		//!< Zړ
	bool usingflag;		//!< gp\tO
	int bullets;		//!< ve
	int Loadbullets;	//!< e
	bool motionflag;	//!< Wړ\tO

public:
	weapon(class ParameterInfo *in_Param = NULL, float x = 0.0f, float y = 0.0f, float z = 0.0f, float rx = 0.0f, int id_param = 0, int nbs = 0, bool flag = false);
	~weapon();
	virtual void SetPosData(float x, float y, float z, float rx);
	virtual void SetParamData(int id_param, int lnbs, int nbs, bool init);
	virtual void GetParamData(int *id_param, int *lnbs, int *nbs);
	virtual bool GetUsingFlag();
	virtual int Pickup();
	virtual void Dropoff(float x, float y, float z, float rx, float speed);
	virtual int Shot();
	virtual int StartReload();
	virtual int RunReload();
	virtual bool ResetWeaponParam(class ResourceManager *Resource, int id_param, int lnbs, int nbs);
	virtual int RunFrame(class Collision *CollD);
	virtual void Render(class D3DGraphics *d3dg);
};

//! @brief ǗNX
class smallobject : public object
{
protected:
	class MIFInterface *MIFdata;		//!< MIFǗNXւ̃|C^
	float rotation_y;		//!< ]px
	signed char point_p4;	//!< |Cg̔Fԍ
	int hp;					//!< ̗
	float jump_rx;		//!< ΂px
	float move_rx;		//!< ΂ړ
	float add_rx;		//!< ΂]
	float add_ry;		//!< ΂c]
	int jump_cnt;		//!< ΂㏸JEg

public:
	smallobject(class ParameterInfo *in_Param = NULL, class MIFInterface *in_MIFdata = NULL, float x = 0.0f, float y = 0.0f, float z = 0.0f, float rx = 0.0f, int id_param = 0, signed char p4 = 0, bool flag = false);
	~smallobject();
	virtual void SetMIFInterfaceClass(class MIFInterface *in_MIFdata);
	virtual void SetParamData(int id_param, signed char p4, bool init);
	virtual void GetParamData(int *id_param, signed char *p4);
	virtual int GetHP();
	virtual float CollisionMap(class Collision *CollD);
	virtual void HitBullet(int attacks);
	virtual void HitGrenadeExplosion(int attacks);
	virtual void Destruction();
	virtual int RunFrame();
	virtual void Render(D3DGraphics *d3dg);
};

//! @brief eۊǗNX
class bullet : public object
{
protected:
	float rotation_y;	//!< ]px
	int attacks;		//!< U
	int penetration;	//!< ђʗ
	int speed;			//!< e
	int teamid;			//!< `[ԍ
	int humanid;		//!< l̃f[^ԍ
	float ontargetcnt;	//!< ̃JEg
	int cnt;			//!< JEg

public:
	bullet(int modelid = -1, int textureid = -1);
	~bullet();
	virtual void SetPosData(float x, float y, float z, float rx, float ry);
	virtual void SetParamData(int _attacks, int _penetration, int _speed, int _teamid, int _humanid, float _ontargetcnt, bool init);
	virtual void GetPosData(float *x, float *y, float *z, float *rx, float *ry);
	virtual void GetParamData(int *_attacks, int *_penetration, int *_speed, int *_teamid, int *_humanid, float *_ontargetcnt);
	virtual int RunFrame();
	virtual void Render(class D3DGraphics *d3dg);
};

//! @brief ֒eǗNX
class grenade : public bullet
{
	float move_x;		//!< Xړ
	float move_y;		//!< Yړ
	float move_z;		//!< Yړ

public:
	grenade(int modelid = -1, int textureid = -1);
	~grenade();
	void SetParamData(float speed, int _teamid, int _humanid, float _ontargetcnt, bool init);
	void GetParamData(float *_speed, int *_teamid, int *_humanid, float *_ontargetcnt);
	float GetSpeed();
	int RunFrame(class Collision *CollD);
	virtual void Render(D3DGraphics *d3dg);
};

//! @brief GtFNgǗNX
class effect : public object
{
protected:
	float move_x;		//!< Xړ
	float move_y;		//!< Yړ
	float move_z;		//!< Zړ
	float addmove_y;	//!< Yړʂ̉Z
	float rotation_y;	//!< ]px
	float rotation_texture;		//!< ]px
	float addrotation_texture;	//!< ]px̉Z
	float addmodel_size;		//!< `TCY
	int brightness;				//!< 邳
	int addbrightness;			//!< 邳̉Z
	float alpha;				//!< x
	float add_alpha;			//!< x̉Z
	int cnt;			//!< JEg
	int type;			//!< 

public:
	effect(float x = 0.0f, float y = 0.0f, float z = 0.0f, float size = 1.0f, float rotation = 0.0f, int texture = -1, int count = 0);
	~effect();
	virtual void SetParamData(float in_move_x, float in_move_y, float in_move_z, float in_addmove_y, float rotation, float addrotation, float size, float addsize, int count, int settype);
	virtual void SetTexture(int id, int in_brightness, int in_addbrightness, float in_alpha, float in_addalpha);
	virtual void SetRxRy(float rx, float ry);
	virtual int GetTextureID();
	virtual void GetMove(float *mx, float *my, float *mz);
	virtual bool GetCollideMapFlag();
	virtual int RunFrame(float camera_rx, float camera_ry);
	virtual void Render(class D3DGraphics *d3dg);
};

//! @brief l[VNX
//! @details l̃[ViAj[VjsNXłBhumanNXŎgp܂B
//! @attention {NXɐlSۂ̓|郂[V͎Ă܂B
class HumanMotionControl
{
	class ParameterInfo *Param;				//!< ݒlǗNXւ̃|C^
	int id_upmodel;							//!< 㔼g
	int id_armmodel[TOTAL_ARMMODE];			//!< r
	int id_legmodel;						//!< iÎ~j
	int id_walkmodel[TOTAL_WALKMODE];		//!< ij
	int id_runmodel[TOTAL_RUNMODE];			//!< ij
	float reaction_y;				//!< rグ鑊Ίpx
	float armmodel_rotation_y;		//!< r̉]px
	float legrotation_x;			//!< ̉]px
	int walkcnt;					//!< [ṼJEg
	int runcnt;						//!< 郂[ṼJEg
	int armmodelid;					//!< `悷r̃f
	int legmodelid;					//!< `悷鑫̃f

public:
	HumanMotionControl(class ParameterInfo *in_Param = NULL);
	~HumanMotionControl();
	void SetParameterInfoClass(class ParameterInfo *in_Param);
	void SetModel(int upmodel, int armmodel[], int legmodel, int walkmodel[], int runmodel[]);
	void Init(float rx);
	void PickupWeapon(int weapon_paramid);
	void ChangeWeapon(int weapon_paramid);
	void ShotWeapon(int weapon_paramid);
	void ReloadWeapon(int weapon_paramid);
	void DumpWeapon();
	void ChangeShotMode(int weapon_paramid);
	void Jump();
	void RunFrame(float rotation_x, float armrotation_y, int weapon_paramid, int ReloadCnt, int MoveFlag, int hp, bool PlayerFlag);
	void GetRenderMotion(float *arm_rotation_y, float *leg_rotation_x, int *upmodel, int *armmodel, int *legmodel);
};

//! l̑̏Ԃ萔
enum Human_LegState {
	LEG_STOP = 0,
	LEG_WALK,
	LEG_RUN
};

//! l̈ړ\tO
enum Human_MoveFlag {
	MOVEFLAG_FORWARD = 0x01,
	MOVEFLAG_BACK = 0x02,
	MOVEFLAG_LEFT = 0x04,
	MOVEFLAG_RIGHT = 0x08,
	MOVEFLAG_WALK = 0x10,
};

//! GtFNg̎ނ\萔
enum Effect_Type {
	EFFECT_NORMAL = 0x00,			//!< m[}
	EFFECT_NOBILLBOARD = 0x01,		//!< r{[hȂ
	EFFECT_COLLIDEMAP = 0x02		//!< }bvƂ̓蔻
};

#endif