<%@page contentType="text/html;charset=UTF-8" language="java" %>
<%@page import="java.util.List" %>
<%@page import="java.text.SimpleDateFormat"%>
<%@page import="javax.jdo.PersistenceManager" %>
<%@page import="com.google.appengine.api.datastore.Query"%>
<%@page import="com.google.appengine.api.datastore.Entity"%>
<%@page import="com.google.appengine.api.datastore.DatastoreService"%>
<%@page import="com.google.appengine.api.datastore.DatastoreServiceFactory"%>
<%@page import="com.google.appengine.api.datastore.Key"%>
<%@page import="com.google.appengine.api.datastore.FetchOptions"%>
<%@page import="com.google.appengine.api.datastore.Query.FilterOperator"%>
<%@page import="gdsearch.PMF" %>
<%@page import="gdsearch.GameDataDAO"%>
<%@page import="gdsearch.vo.GameData" %>
<%@page import="gdsearch.vo.GameDataTitleIndex"%>

<%
	String prmGenre         = request.getParameter("genre");         // 内容
String prmHard          = request.getParameter("hard");          // ハード名
String prmTitle         = request.getParameter("title");         // タイトル
String prmSaleYearStart = request.getParameter("saleYearStart"); // 発売年（開始年）
String prmSaleYearEnd   = request.getParameter("saleYearEnd");   // 発売年（終了年）
String prmDisplayNum    = request.getParameter("DisplayNum");    // 表示件数
String prmSortKey       = request.getParameter("SortKey");       // ソート
%>

<%!// 検索実行後に選択した条件を保持するための関数
public String chkSelected(String param, String value) {
    if(value.equals(param)) {
       return "selected=\"selected\"";
    }
    return "";
}%>


<%@page import="java.text.DateFormat"%>
<%@page import="java.util.Date"%>
<%@page import="java.util.ArrayList"%><html>
<head>
<title>検索画面</title>
<link rel=stylesheet type="text/css" href="http://homepage2.nifty.com/gamedatabase/styleseet_gdrtp.css">
<link rel=stylesheet type="text/css" href="http://homepage2.nifty.com/gamedatabase/software/styleseet_ntm2vb.css">

<script type="text/javascript">
function btnSearchSubmit(){
    var frmSearch=document.frmSearch;
//    frmSearch.btnSearch.disabled = true;
    frmSearch.submit();
}
</script>

</head>

<!-- body onLoad="document.frmSearch.btnSearch.disabled = false" -->
<body onLoad="document.frmSearch.btnSearch.disabled = false">

<div class="D0">検索フォーム</div>

<form name="frmSearch" method="GET" action="/gdsearch.jsp" >

<table><tbody><tr><td valign="TOP" width="100%">
<table border="0" cellpadding="1" cellspacing="1">
<tbody>
<tr class="TI"><th>タイトル</th>
  <td class="VB">
    <input name="title" size="40" type="text">
    <input value="検索" name="btnSearch" onclick="btnSearchSubmit()" type="button">
  </td>
</tr>
<tr class="TI"><th>内容</th>
  <td class="VB">
    <select name="genre" >
      <option value=""                                        >全て</option>
      <option value="SPT" <%=chkSelected(prmGenre, "SPT" )%>>SPT</option>
      <option value="ACT" <%=chkSelected(prmGenre, "ACT" )%>>ACT</option>
      <option value="PZL" <%=chkSelected(prmGenre, "PZL" )%>>PZL</option>
      <option value="STG" <%=chkSelected(prmGenre, "STG" )%>>STG</option>
      <option value="SLT" <%=chkSelected(prmGenre, "SLT" )%>>SLT</option>
      <option value="ADV" <%=chkSelected(prmGenre, "ADV" )%>>ADV</option>
    </select>
  </td>
</tr>
<tr class="TI"><th>ハード</th>
  <td class="VB">
    <select name="hard" >
      <option value=""                                                               >全て</option>
      <option value="GAME BOY"        <%=chkSelected(prmHard, "GAME BOY" )%>>GAME BOY</option>
      <option value="Viutual BOY"     <%=chkSelected(prmHard, "Viutual BOY" )%>>Viutual BOY</option>
      <option value="GAMEBOY ADVANCE" <%=chkSelected(prmHard, "GAMEBOY ADVANCE" )%>>GAMEBOY ADVANCE</option>
      <option value="NINTENDO DS"     <%=chkSelected(prmHard, "NINTENDO DS" )%>>NINTENDO DS</option>
    </select>
  </td>
</tr>
<tr class="TI"><th>発売年</th>
  <td class="VB">
    <select name="saleYearStart" >
      <option value="" ></option>
<%
	for(int year = 1983; year <= 2009; year++) {
%>
      <option value="<%=year%>" <%=chkSelected(prmSaleYearStart, "" + year )%>><%=year%></option>
<%
	}
%>
    </select>年～
    <select name="saleYearEnd" >
      <option value="" ></option>
<%
	for(int year = 1983; year <= 2009; year++) {
%>
      <option value="<%=year%>" <%=chkSelected(prmSaleYearEnd, "" + year )%>><%=year%></option>
<%
	}
%>
    </select>年
  </td>
</tr>

<tr class="TI"><th>表示</th>
  <td class="VB">
   <strong>表示件数</strong>
    <select name="DisplayNum">
      <option value="20" <%=chkSelected(prmDisplayNum, "20" )%>>20</option>
      <option value="30" <%=chkSelected(prmDisplayNum, "30" )%>>30</option>
      <option value="50" <%=chkSelected(prmDisplayNum, "50" )%>>50</option>
   </select>
   <strong>ソート</strong>
    <select name="SortKey">
      <option value="saledate ASC"  <%=chkSelected(prmSortKey, "saledate ASC" )%>>発売日(新しい順)</option>
      <option value="saledate DESC" <%=chkSelected(prmSortKey, "saledate DESC")%>>発売日(古い順)</option>
      <option value="price ASC"     <%=chkSelected(prmSortKey, "price ASC"    )%>>値段(安い順)</option>
      <option value="price DESC"    <%=chkSelected(prmSortKey, "price DESC"   )%>>値段(高い順)</option>
      <option value="genre ASC"     <%=chkSelected(prmSortKey, "genre ASC"    )%>>内容(昇順)</option>
      <option value="genre DESC"    <%=chkSelected(prmSortKey, "genre DESC"   )%>>内容(降順)</option>
      <option value="code ASC"      <%=chkSelected(prmSortKey, "code ASC"     )%>>型番(昇順)</option>
      <option value="code DESC"     <%=chkSelected(prmSortKey, "code DESC"    )%>>型番(降順)</option>
      <option value="title ASC"     <%=chkSelected(prmSortKey, "title ASC"    )%>>タイトル(昇順)</option>
      <option value="title DESC"    <%=chkSelected(prmSortKey, "title DESC"   )%>>タイトル(降順)</option>
     </select>
  </td>
</tr>
</tbody>
</table>
</table>

</form>


<div class="D0">検索結果</div>

<table><tbody><tr><td valign="TOP" width="100%">
<table border="0" cellpadding="1" cellspacing="1">
<tbody><tr class="TI"><th>発売日</th>
    <th>タイトル</th>
    <th>販売, 発売/開発/著作</th>
    <th>内<br>容</th><th>型番</th><th>値<br>段</th></tr>
<%
	// クエリ生成
    Query qryGd   = new Query(GameData.class.getSimpleName());
    Query qryGdti = new Query(GameDataTitleIndex.class.getSimpleName());

    // ハード名による絞込み
    if(null != prmHard && "" != prmHard) {
        qryGd.addFilter("hard", FilterOperator.EQUAL, prmHard);
    }

    // 内容による絞込み
    if(null != prmGenre && "" != prmGenre) {
        qryGd.addFilter("genre", FilterOperator.EQUAL, prmGenre);
    }

    // 表示件数の設定
    int dispnum = 20; // 初期値
    if(null != request.getParameter("DisplayNum")) {
        dispnum = Integer.parseInt(request.getParameter("DisplayNum"));
    }

    // ソート順の設定
    if(null != prmSortKey) {
        String sortKey = prmSortKey.replaceAll("^(.+) .+$", "$1");
        String sortDir = prmSortKey.replaceAll("^.+ (.+)$", "$1");
        if(sortDir.equals("DESC")) {
            qryGd.addSort(sortKey, Query.SortDirection.DESCENDING);
        } else {
            qryGd.addSort(sortKey, Query.SortDirection.ASCENDING);
        }
    }

    // データストアサービスの取得
    DatastoreService service = DatastoreServiceFactory.getDatastoreService();
    // データベースからデータを取得
    List<Entity> lstGameData = service.prepare(qryGd).asList(FetchOptions.Builder.withOffset(0).limit(dispnum));

    // タイトルによる絞込み
    if(null != prmTitle && "" != prmTitle) {
//        qryGd.addFilter("title", FilterOperator.EQUAL, prmTitle);
//        qryGd.addFilter("title", FilterOperator.GREATER_THAN_OR_EQUAL, title);
//        qryGd.addFilter("title", FilterOperator.LESS_THAN            , title + "\ufffd"); // "\ufffd"はUNICODEの最大値
    }


    // 発売年による絞込み
    if( (null == prmSaleYearStart || "" == prmSaleYearStart) ||
        (null == prmSaleYearEnd   || "" == prmSaleYearEnd  )) {
    } else {
        DateFormat df = new SimpleDateFormat("yyyy/MM/dd");
        Date startDate = df.parse(prmSaleYearStart +"/01/01");
        Date endDate   = df.parse(prmSaleYearEnd   +"/12/31");
        List<Entity> lstTemp = new ArrayList<Entity>();
        for (Entity gd : lstGameData) {
            Date saledate = (Date)gd.getProperty("saledate");
            if(startDate.getTime() <= saledate.getTime() && saledate.getTime() <= endDate.getTime() ) {
                lstTemp.add(gd);
            }
        }
        lstGameData = lstTemp;
    }

    // 検索結果の表示
    SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
    for (Entity gd : lstGameData) {
%>
   <tr class="VB"><td><%= sdf.format(gd.getProperty("saledate")) %></td>
   <td><span class="EN"><%= gd.getProperty("title2") %></span><br><%= gd.getProperty("title") %></td>
   <td><span class="EN"><%= gd.getProperty("maker2") %></span><br><%= gd.getProperty("maker") %></td>
   <td><%= gd.getProperty("genre") %></td><td class="TP"><%= gd.getProperty("code") %></td><td class="Yn"><%= gd.getProperty("price") %></td></tr>
<%
    }
%>
</tbody>
</table>
</table>
</body>
</html>