package gdsearch.vo;

import java.util.Date;

import javax.jdo.annotations.*;

import com.google.appengine.api.datastore.Entity;

/**
 * GameDataを格納するクラス
 */
@PersistenceCapable(identityType = IdentityType.APPLICATION, detachable="true")
public class GameData {
    @PrimaryKey
    @Persistent(valueStrategy = IdGeneratorStrategy.IDENTITY)
    private Long id;
    @Persistent
    private String code;
    @Persistent
    private String hard;
    @Persistent
    private String title;
    @Persistent
    private String title2;
    @Persistent
    private String maker;
    @Persistent
    private String maker2;
    @Persistent
    private String genre;
    @Persistent
    private String media;
    @Persistent
    private int    price;
    @Persistent
    private Date   saledate;
    @Persistent
    private String restrict;
    @Persistent
    private String comment;

    public GameData() {}

    public Long   getId()       { return id;       }
    public String getCode()     { return code;     }
    public String getHard()     { return hard;     }
    public String getTitle()    { return title;    }
    public String getTitle2()   { return title2;   }
    public String getMaker()    { return maker;    }
    public String getMaker2()   { return maker2;   }
    public String getGenre()    { return genre;    }
    public String getMedia()    { return media;    }
    public int    getPrice()    { return price;    }
    public Date   getSaleDate() { return saledate; }
    public String getRestrict() { return restrict; }
    public String getComment()  { return comment;  }

    public Entity getEntity() {
        Entity ety = new Entity("GameData");
        ety.setProperty("code"    , code     );
        ety.setProperty("hard"    , hard     );
        ety.setProperty("title"   , title    );
        ety.setProperty("title2"  , title2   );
        ety.setProperty("maker"   , maker    );
        ety.setProperty("maker2"  , maker2   );
        ety.setProperty("genre"   , genre    );
        ety.setProperty("media"   , media    );
        ety.setProperty("price"   , price    );
        ety.setProperty("saledate", saledate );
        ety.setProperty("restrict", restrict );
        ety.setProperty("comment" , comment  );
        return ety;
    }

    public void setCode    (String code    ) { this.code     = code;     }
    public void setHard    (String hard    ) { this.hard     = hard;     }
    public void setTitle   (String title   ) { this.title    = title;    }
    public void setTitle2  (String title2  ) { this.title2   = title2;   }
    public void setMaker   (String maker   ) { this.maker    = maker;    }
    public void setMaker2  (String maker2  ) { this.maker2   = maker2;   }
    public void setGenre   (String genre   ) { this.genre    = genre;    }
    public void setMedia   (String media   ) { this.media    = media;    }
    public void setPrice   (int    price   ) { this.price    = price;    }
    public void setSaleDate(Date   saledate) { this.saledate = saledate; }
    public void setRestrict(String restrict) { this.restrict = restrict; }
    public void setComment (String comment ) { this.comment  = comment;  }

    public void setAllByEntity(Entity ety) {
        setCode    ((String)ety.getProperty("code"    ));
        setHard    ((String)ety.getProperty("hard"    ));
        setTitle   ((String)ety.getProperty("title"   ));
        setTitle2  ((String)ety.getProperty("title2"  ));
        setMaker   ((String)ety.getProperty("maker"   ));
        setMaker2  ((String)ety.getProperty("maker2"  ));
        setGenre   ((String)ety.getProperty("genre"   ));
        setMedia   ((String)ety.getProperty("media"   ));
        setSaleDate(  (Date)ety.getProperty("saledate"));
        setRestrict((String)ety.getProperty("restrict"));
        setComment ((String)ety.getProperty("comment" ));
    }

}