<%@page contentType="text/html;charset=UTF-8" language="java" %>
<%@page import="java.util.*" %>
<%@page import="java.text.SimpleDateFormat"%>
<%@page import="javax.jdo.PersistenceManager"%>
<%@page import="com.google.appengine.api.datastore.Entity"%>
<%@page import="gdsearch.PMF"%>
<%@page import="gdsearch.GameDataDAO"%>
<%@page import="gdsearch.vo.GameDataSearchCondition"%>

<%
String prmGenre         = request.getParameter("genre");         // 内容
String prmHard          = request.getParameter("hard");          // ハード名
String prmKeyword       = request.getParameter("keyword");       // キーワード
String prmSaleYearStart = request.getParameter("saleYearStart"); // 発売年（開始年）
String prmSaleYearEnd   = request.getParameter("saleYearEnd");   // 発売年（終了年）
String prmDisplayStart  = request.getParameter("DisplayStart");  // 表示開始件数
String prmDisplayNumber = request.getParameter("DisplayNumber"); // 表示件数
String prmSortKey       = request.getParameter("SortKey");       // ソート

String encVideogames = "";
String encBooks = "";
String encMusics = "";
if(null == prmKeyword || "" == prmKeyword) {
    prmKeyword ="";
    encVideogames = URLEncoder.encode("RPG"     , "UTF-8");
    encBooks      = URLEncoder.encode("ファミ通", "UTF-8");
    encMusics     = URLEncoder.encode("ゲーム"  , "UTF-8");
} else {
    encVideogames = URLEncoder.encode(prmKeyword, "UTF-8");
    encBooks      = URLEncoder.encode(prmKeyword, "UTF-8");
    encMusics     = URLEncoder.encode(prmKeyword, "UTF-8");
}

List<Entity> lstGameData = new ArrayList<Entity>();
// 検索ボタンで遷移してきた場合は検索結果を取得し、検索履歴を記録する
if(null != prmSortKey) {
    // パラメータから検索条件を設定
    GameDataSearchCondition gdsc = new GameDataSearchCondition(request);
    // DBに登録
    PersistenceManager pm = PMF.get().getPersistenceManager();
    try {
        pm.makePersistent(gdsc); // オブジェクトの内容をDBに登録
    } finally {
        pm.close();
    }

    // 検索結果の取得
    GameDataDAO dao = new GameDataDAO();
    lstGameData = dao.getSearchResult(gdsc);

}
%>


<%@page import="java.net.URLEncoder"%><html>
<head>

<title>検索画面</title>
<meta http-equiv="content-type" content="text/html; charset=utf-8">
<meta http-equiv="content-style-type" content="text/css">
<meta http-equiv="content-script-type" content="text/javascript">
<meta http-equiv="keyword" content="任天堂,Nintendo,セガ,SEGA,日本電気,NEC,マイクロソフト,Microsoft,エス・エヌ・ケイ,SNK,スリーディーオー,3DO,バンダイ,BANDAI,ファミリーコンピューター,ファミコン,Family Computer,Famicom,スーパーファミコン,SUPER FAMICOM,ニンテンドウ64,ニンテンドー64,NINTENDO 64,ロクヨン,ゲームキューブ,GAME CUBE,ウィー,Wii,メガドライブ,MEGA DRIVE,セガサターン,SEGA SATURN,ドリームキャスト,Dreamcast,XBOX,エックスボックス,XBOX 360,エックスボックスサンロクマル,PC Engine,PCエンジン,PC-FX,ネオジオ,NEO GEO,レーザーアクティブ,LaserActive,プレイディア,Playdia,ゲームボーイ,GAME BOY,GAMEBOY ADVANCE,ゲームボーイアドバンス,ニンテンドーDS,NINTENDO DS,プレイステーションポータブル,PlayStation Portable,ワンダースワン,WonderSwan,ゲームギア,GAME GEAR,FC,SFC,N64,GC,NGC,MD,SS,DC,XB,XB360,PCE,GB,VB,GBA,NDS,PSP,WS,GG">
<meta http-equiv="description" content="コンピューターゲームのデータベースサイトです">

<link rel=stylesheet type="text/css" href="http://homepage2.nifty.com/gamedatabase/software/styleseet__search.css">

<script type="text/javascript">
function btnSearchSubmit(){
    var frmSearch=document.frmSearch;
    frmSearch.btnSearch.disabled = true;
    frmSearch.submit();
}
</script>
</head>

<body>
<div class="ht">
  <table width="100%" class="ht">
    <tr>
      <td class="ht">
        <a href="http://homepage2.nifty.com/gamedatabase/index.html"">GAME Data Room</a> &gt; GAME DATA Search
      </td>
      <td align="right" class="ht">
        <img src="../img/appengine-silver-120x30.gif" alt="Google App Engine">
        ※ 一日の使用回数に制限があるので使えなくなることがあります。
      </td>
</table>
</div>

<form name="frmSearch" method="GET" action="index.jsp" >
<input type="hidden" name="DisplayStart" value="0">

<table><tbody><tr>

<td valign="TOP" width="100%">
<table border="0" cellpadding="1" cellspacing="1">
<tbody>
<tr class="TI"><th>タイトル 型番<br/>販売, 発売/開発/著作</th>
  <td class="VB">
    <input name="keyword" value="<%= prmKeyword %>" size="40" type="text">
    <input name="btnSearch" value="検索" onclick="btnSearchSubmit()" type="button">
  </td>
</tr>
<tr class="TI"><th>内容</th>
  <td class="VB">
    <select name="genre" >
      <option value=""                                        >全て</option>
      <option value="AADV" <%= chkSelected(prmGenre, "AADV" ) %>>AADV</option>
      <option value="ACT"  <%= chkSelected(prmGenre, "ACT"  ) %>>ACT</option>
      <option value="ADV"  <%= chkSelected(prmGenre, "ADV"  ) %>>ADV</option>
      <option value="ARPG" <%= chkSelected(prmGenre, "ARPG" ) %>>ARPG</option>
      <option value="DB"   <%= chkSelected(prmGenre, "DB"   ) %>>DB</option>
      <option value="Etc"  <%= chkSelected(prmGenre, "Etc"  ) %>>Etc</option>
      <option value="MV"   <%= chkSelected(prmGenre, "MV"   ) %>>MV</option>
      <option value="PZL"  <%= chkSelected(prmGenre, "PZL"  ) %>>PZL</option>
      <option value="QIZ"  <%= chkSelected(prmGenre, "QIZ"  ) %>>QIZ</option>
      <option value="RCG"  <%= chkSelected(prmGenre, "RCG"  ) %>>RCG</option>
      <option value="RPG"  <%= chkSelected(prmGenre, "RPG"  ) %>>RPG</option>
      <option value="SLT"  <%= chkSelected(prmGenre, "SLT"  ) %>>SLT</option>
      <option value="SNV"  <%= chkSelected(prmGenre, "SNV"  ) %>>SNV</option>
      <option value="SPT"  <%= chkSelected(prmGenre, "SPT"  ) %>>SPT</option>
      <option value="STG"  <%= chkSelected(prmGenre, "STG"  ) %>>STG</option>
      <option value="TBL"  <%= chkSelected(prmGenre, "TBL"  ) %>>TBL</option>
      <option value="VIS"  <%= chkSelected(prmGenre, "VIS"  ) %>>VIS</option>
      <option value="格闘" <%= chkSelected(prmGenre, "格闘" ) %>>格闘</option>
      <option value="音楽" <%= chkSelected(prmGenre, "音楽" ) %>>音楽</option>
      <option value="教育" <%= chkSelected(prmGenre, "教育" ) %>>教育</option>
      <option value="占い" <%= chkSelected(prmGenre, "占い" ) %>>占い</option>
      <option value="競馬" <%= chkSelected(prmGenre, "競馬" ) %>>競馬</option>
      <option value="釣り" <%= chkSelected(prmGenre, "釣り" ) %>>釣り</option>
    </select>
  </td>
</tr>
<tr class="TI"><th>ハード</th>
  <td class="VB">
    <select name="hard" >
      <option value=""                                                                          >全て</option>
      <optgroup label="家庭用ゲーム機"></optgroup>
      <optgroup label="任天堂">
      <option value="Family Computer"       <%= chkSelected(prmHard, "Family Computer"      ) %>>Family Computer</option>
      <option value="SUPER FAMICOM"         <%= chkSelected(prmHard, "SUPER FAMICOM"        ) %>>SUPER FAMICOM</option>
      <option value="NINTENDO 64"           <%= chkSelected(prmHard, "NINTENDO 64"          ) %>>NINTENDO 64</option>
      <option value="GAME CUBE"             <%= chkSelected(prmHard, "GAME CUBE"            ) %>>GAME CUBE</option>
      <option value="Wii"                   <%= chkSelected(prmHard, "Wii"                  ) %>>Wii</option>
      </optgroup>
      <optgroup label="ソニー">
      <option value="PlayStation"           <%= chkSelected(prmHard, "PlayStation"          ) %>>PlayStation</option>
      <option value="PlayStation2"          <%= chkSelected(prmHard, "PlayStation2"         ) %>>PlayStation2</option>
      <option value="PLAYSTATION3"          <%= chkSelected(prmHard, "PLAYSTATION3"         ) %>>PLAYSTATION3</option>
      </optgroup>
      <optgroup label="マイクロソフト">
      <option value="XBOX"                  <%= chkSelected(prmHard, "XBOX"                 ) %>>XBOX</option>
      <option value="XBOX 360"              <%= chkSelected(prmHard, "XBOX 360"             ) %>>XBOX 360</option>
      </optgroup>
      <optgroup label="セガ">
      <option value="SEGA 8bit"             <%= chkSelected(prmHard, "SEGA 8bit"            ) %>>SEGA 8bit</option>
      <option value="MEGA DRIVE"            <%= chkSelected(prmHard, "MEGA DRIVE"           ) %>>MEGA DRIVE</option>
      <option value="SEGA SATURN"           <%= chkSelected(prmHard, "SEGA SATURN"          ) %>>SEGA SATURN</option>
      <option value="Dreamcast"             <%= chkSelected(prmHard, "Dreamcast"            ) %>>Dreamcast</option>
      </optgroup>
      <optgroup label="NEC">
      <option value="PC Engine"             <%= chkSelected(prmHard, "PC Engine"            ) %>>PC Engine</option>
      <option value="PC-FX"                 <%= chkSelected(prmHard, "PC-FX"                ) %>>PC-FX</option>
      </optgroup>
      <optgroup label="エポック社">
      <option value="CASSETTE VISION"       <%= chkSelected(prmHard, "CASSETTE VISION"      ) %>>CASSETTE VISION</option>
      <option value="Super Cassette Vision" <%= chkSelected(prmHard, "Super Cassette Vision") %>>Super Cassette Vision</option>
      </optgroup>
      <optgroup label="その他">
      <option value="NEO GEO"               <%= chkSelected(prmHard, "NEO GEO"              ) %>>NEO GEO</option>
      <option value="3DO"                   <%= chkSelected(prmHard, "3DO"                  ) %>>3DO</option>
      <option value="LaserActive"           <%= chkSelected(prmHard, "LaserActive"          ) %>>LaserActive</option>
      <option value="Playdia"               <%= chkSelected(prmHard, "Playdia"              ) %>>Playdia</option>
      <option value="JAGUAR"                <%= chkSelected(prmHard, "JAGUAR"               ) %>>JAGUAR</option>
      </optgroup>
      <optgroup label="携帯ゲーム機"></optgroup>
      <optgroup label="任天堂">
      <option value="GAME BOY"              <%= chkSelected(prmHard, "GAME BOY"             ) %>>GAME BOY</option>
      <option value="Viutual BOY"           <%= chkSelected(prmHard, "Viutual BOY"          ) %>>Viutual BOY</option>
      <option value="GAMEBOY ADVANCE"       <%= chkSelected(prmHard, "GAMEBOY ADVANCE"      ) %>>GAMEBOY ADVANCE</option>
      <option value="NINTENDO DS"           <%= chkSelected(prmHard, "NINTENDO DS"          ) %>>NINTENDO DS</option>
      </optgroup>
      <optgroup label="ソニー">
      <option value="PlayStation Portable"  <%= chkSelected(prmHard, "PlayStation Portable" ) %>>PlayStation Portable</option>
      </optgroup>
      <optgroup label="セガ">
      <option value="GAME GEAR"             <%= chkSelected(prmHard, "GAME GEAR"            ) %>>GAME GEAR</option>
      </optgroup>
      <optgroup label="その他">
      <option value="LYNX"                  <%= chkSelected(prmHard, "LYNX"                 ) %>>LYNX</option>
      <option value="WonderSwan"            <%= chkSelected(prmHard, "WonderSwan"           ) %>>WonderSwan</option>
      <option value="NEO GEO POCKET"        <%= chkSelected(prmHard, "NEO GEO POCKET"       ) %>>NEO GEO POCKET</option>
      </optgroup>
      <optgroup label="バーチャルコンソール">
      <option value="VC Family Computer"    <%= chkSelected(prmHard, "VC Family Computer"   ) %>>VC Family Computer</option>
      <option value="VC SUPER FAMICOM"      <%= chkSelected(prmHard, "VC SUPER FAMICOM"     ) %>>VC SUPER FAMICOM</option>
      <option value="VC NINTENDO 64"        <%= chkSelected(prmHard, "VC NINTENDO 64"       ) %>>VC NINTENDO 64</option>
      <option value="VC Sega Master System" <%= chkSelected(prmHard, "VC Sega Master System") %>>VC Sega Master System</option>
      <option value="VC MEGA DRIVE"         <%= chkSelected(prmHard, "VC MEGA DRIVE"        ) %>>VC MEGA DRIVE</option>
      <option value="VC PC Engine"          <%= chkSelected(prmHard, "VC PC Engine"         ) %>>VC PC Engine</option>
      <option value="VC MSX"                <%= chkSelected(prmHard, "VC MSX"               ) %>>VC MSX</option>
      <option value="VC Arcade"             <%= chkSelected(prmHard, "VC Arcade"            ) %>>VC Arcade</option>
      <option value="VC NEO GEO"            <%= chkSelected(prmHard, "VC NEO GEO"           ) %>>VC NEO GEO</option>
      </optgroup>
      <optgroup label="ネットワークゲームアーカイブス">
      <option value="NWGA PlayStation"      <%= chkSelected(prmHard, "NWGA PlayStation"     ) %>>NWGA PlayStation</option>
      </optgroup>
    </select>
  </td>
</tr>
<tr class="TI"><th nowrap>発売年</th>
  <td class="VB">
    <select name="saleYearStart" >
      <option value="" ></option>
<%
    // 1981年から今年まで表示する
    SimpleDateFormat yyyy = new SimpleDateFormat("yyyy");
    int thisYear = Integer.parseInt(yyyy.format(new Date()));

    for(int year = 1981; year <= thisYear; year++) {
%>
      <option value="<%= year %>" <%= chkSelected(prmSaleYearStart, "" + year )%>><%= year %></option>
<%
    }
%>
    </select>年～
    <select name="saleYearEnd" >
      <option value="" ></option>
<%
    for(int year = 1981; year <= thisYear; year++) {
%>
      <option value="<%= year %>" <%= chkSelected(prmSaleYearEnd  , "" + year )%>><%= year %></option>
<%
    }
%>
    </select>年
  </td>
</tr>

<tr class="TI"><th>表示</th>
  <td class="VB">
   <strong>表示件数</strong>
    <select name="DisplayNumber">
      <option value="20"  <%= chkSelected(prmDisplayNumber, "20" ) %>>20</option>
      <option value="50"  <%= chkSelected(prmDisplayNumber, "50" ) %>>50</option>
      <option value="100" <%= chkSelected(prmDisplayNumber, "100") %>>100</option>
   </select>
   <strong>ソート</strong>
    <select name="SortKey">
      <option value="saledate ASC"  <%= chkSelected(prmSortKey, "saledate ASC" ) %>>発売日(古い順)</option>
      <option value="saledate DESC" <%= chkSelected(prmSortKey, "saledate DESC") %>>発売日(新しい順)</option>
      <option value="price ASC"     <%= chkSelected(prmSortKey, "price ASC"    ) %>>値段(安い順)</option>
      <option value="price DESC"    <%= chkSelected(prmSortKey, "price DESC"   ) %>>値段(高い順)</option>
      <option value="genre ASC"     <%= chkSelected(prmSortKey, "genre ASC"    ) %>>内容(昇順)</option>
      <option value="genre DESC"    <%= chkSelected(prmSortKey, "genre DESC"   ) %>>内容(降順)</option>
      <option value="code ASC"      <%= chkSelected(prmSortKey, "code ASC"     ) %>>型番(昇順)</option>
      <option value="code DESC"     <%= chkSelected(prmSortKey, "code DESC"    ) %>>型番(降順)</option>
      <option value="title ASC"     <%= chkSelected(prmSortKey, "title ASC"    ) %>>タイトル(昇順)</option>
      <option value="title DESC"    <%= chkSelected(prmSortKey, "title DESC"   ) %>>タイトル(降順)</option>
      <option value="hard ASC"      <%= chkSelected(prmSortKey, "hard ASC"     ) %>>ハード(昇順)</option>
      <option value="hard DESC"     <%= chkSelected(prmSortKey, "hard DESC"    ) %>>ハード(降順)</option>
      <option value="maker ASC"     <%= chkSelected(prmSortKey, "maker ASC"    ) %>>メーカー(昇順)</option>
      <option value="maker DESC"    <%= chkSelected(prmSortKey, "maker DESC"   ) %>>メーカー(降順)</option>
     </select>
  </td>
</tr>
</tbody>
</table>
</td>

<td>
<table cellpadding="0" cellspacing="0">
<tbody>
  <tr>
    <td><iframe src="http://rcm-jp.amazon.co.jp/e/cm?t=sorceriandata-22&o=9&p=9&l=st1&mode=videogames-jp&search=<%= encVideogames %>&fc1=FFFFFF&lt1=_blank&lc1=A0FF00&bg1=602890&f=ifr" marginwidth="0" marginheight="0" width="178" height="120" frameborder="0" style="border:none;" scrolling="no"></iframe></td>
    <td><iframe src="http://rcm-jp.amazon.co.jp/e/cm?t=sorceriandata-22&o=9&p=9&l=st1&mode=books-jp&search=<%= encBooks %>&fc1=FFFFFF&lt1=_blank&lc1=A0FF00&bg1=602890&f=ifr" marginwidth="0" marginheight="0" width="178" height="120" frameborder="0" style="border:none;" scrolling="no"></iframe></td>
    <td><iframe src="http://rcm-jp.amazon.co.jp/e/cm?t=sorceriandata-22&o=9&p=9&l=st1&mode=music-jp&search=<%= encMusics %>&fc1=FFFFFF&lt1=_blank&lc1=A0FF00&bg1=602890&f=ifr" marginwidth="0" marginheight="0" width="178" height="120" frameborder="0" style="border:none;" scrolling="no"></iframe></td>
  </tr>
</tbody>
</table>
</td>

</tr></tbody></table>
</form>

<div align="center" class="VB">
<%
    // 検索ボタンで遷移してきた場合は検索結果を表示する
    if(null != prmSortKey) {
%>
<%
        if(Integer.parseInt(prmDisplayStart) > 0) {
%>
  <a href ="<%= getBackPager(request) %>"> ＜＜前の<%= prmDisplayNumber %>件</a>
<%
        }
%>
<%
        if(Integer.parseInt(prmDisplayNumber) == lstGameData.size()) {
%>
  <a href ="<%= getNextPager(request) %>"> 次の<%= prmDisplayNumber %>件＞＞</a>
<%
        }
%>
</div>


<table><tbody><tr>
<td valign="TOP" width="100%">
<table border="0" cellpadding="1" cellspacing="1">
<tbody>
  <tr class="TI">
    <th>ハード</th>
    <th>発売日</th>
    <th>タイトル</th>
    <th>販売, 発売/開発/著作</th>
    <th>内<br>容</th><th>媒体<br>GS</th><th>R</th><th>型番</th><th>値<br>段</th>
    <th>備考</th>
  </tr>
<%
        // 検索結果の表示
        for (Entity ety : lstGameData) {
%>
   <tr class="VB">
   <td><%= getHardUrl(ety) %></td>
   <td><%= getSaleDateUrl(ety) %></td>
   <td><span class="EN"><%= ety.getProperty("title2") %></span><br><%= ety.getProperty("title") %></td>
   <td><span class="EN"><%= ety.getProperty("maker2") %></span><br><%= ety.getProperty("maker") %></td>
   <td><%= ety.getProperty("genre") %></td><td><%= ety.getProperty("media") %></td><td><%= ety.getProperty("restrict") %></td><td><%= ety.getProperty("code") %></td><td class="Yn"><%= ety.getProperty("price") %></td>
   <td><%= ety.getProperty("comment") %></td>
   </tr>
<%
        }
%>
</tbody>
</table>
</td>
</tr></tbody></table>

<div align="center" class="VB">
<%
        if(Integer.parseInt(prmDisplayStart) > 0) {
%>
  <a href ="<%= getBackPager(request) %>"> ＜＜前の<%= prmDisplayNumber %>件</a>
<%
        }
%>
<%
        if(Integer.parseInt(prmDisplayNumber) == lstGameData.size()) {
%>
  <a href ="<%= getNextPager(request) %>"> 次の<%= prmDisplayNumber %>件＞＞</a>
<%
        }
%>
<%
    }
%>

</div>
<br/>
<table class="HS" width="100%">
<tbody><tr><td class="HS" width="41%"></td><td class="HS">│</td>
    <td class="HS" nowrap="nowrap" align="center" width="16%"><a href="http://homepage2.nifty.com/gamedatabase/index.html" class="bld">サイト トップへ戻る</a></td><td class="HS">│</td>
    <td class="HS" align="RIGHT" width="41%"></td></tr>
</tbody></table>

</body>

</html>

<%!
/**
 * 検索実行後に選択した条件を保持するための関数
 */
public String chkSelected(String param, String value) {
    if(value.equals(param)) {
       return "selected=\"selected\"";
    }
    return "";
}

/**
 * Pagerのリンクを表示する関数
 */
public String getBackPager(HttpServletRequest request) {
    int displayStart  = Integer.parseInt(request.getParameter("DisplayStart" ));
    int displayNumber = Integer.parseInt(request.getParameter("DisplayNumber"));
    return getPagerUrl(request, displayStart - displayNumber);
}
public String getNextPager(HttpServletRequest request) {
    int displayStart  = Integer.parseInt(request.getParameter("DisplayStart" ));
    int displayNumber = Integer.parseInt(request.getParameter("DisplayNumber"));
    return getPagerUrl(request, displayStart + displayNumber);
}
private String getPagerUrl(HttpServletRequest request, int displayStart) {
    String result = "index.jsp";
    result += "?DisplayStart="  + Integer.toString(displayStart);
    result += "&keyword="       + request.getParameter("keyword");
    result += "&genre="         + request.getParameter("genre");
    result += "&hard="          + request.getParameter("hard");
    result += "&saleYearStart=" + request.getParameter("saleYearStart");
    result += "&saleYearEnd="   + request.getParameter("saleYearEnd");
    result += "&DisplayNumber=" + request.getParameter("DisplayNumber");
    result += "&SortKey="       + request.getParameter("SortKey");

    return result;
}

/**
 * 各ハード名に該当するリンクのURLを取得
 */
public String getHardUrl(Entity ety) {
    String hard   = (String)ety.getProperty("hard");

    GameDataDAO dao = new GameDataDAO();
    String url = dao.getGameDataUrl(hard);

    String result = hard;
    if(url != "") {
        result = "<a href=\"http://homepage2.nifty.com/gamedatabase/software/" + url + "\">" + hard + "</a>";
    }

    return result;
}
/**
 * 各ハード名の発売日に該当するURLを取得
 */
public String getSaleDateUrl(Entity ety) {
    String hard   = (String)ety.getProperty("hard");
    Date saledate = (Date)ety.getProperty("saledate");
    SimpleDateFormat sdf     = new SimpleDateFormat("yyyy/MM/dd");
    SimpleDateFormat sdfYear = new SimpleDateFormat("yyyy");

    String strSaleDate = sdf.format(saledate);
    String strSaleYear = sdfYear.format(saledate);

    GameDataDAO dao = new GameDataDAO();
    String url = dao.getGameDataUrl(hard + " " + strSaleYear);

    String result = strSaleDate;
    if(url != "") {
        result = "<a href=\"http://homepage2.nifty.com/gamedatabase/software/" + url + "\">" + strSaleDate + "</a>";
    }

    return result;
}
%>