
/**************************************************
opengate server test program 

Copyright (C) 2005 Opengate Project Team
Written by Yoshiaki Watanabe
Modified Katsuhiko Eguchi, 2005 

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Email: watanaby@is.saga-u.ac.jp
**************************************************/

#include	"opengatesrv.h"
#include <sqlite3.h>

/********************/
/*  main routine    */
/********************/
int  main(int argc, char **argv)
{
  char userid[USERMAXLN];
  char clientAddr4[ADDRMAXLN];
  char macAddr[ADDRMAXLN];
  char language[WORDMAXLN];
  char closeTime[WORDMAXLN];
  int duration;
  int durationEntered;  
  char *pErrMsg;
  sqlite3 *db;
  sqlite3_stmt *stmt;

  printf("This is a test program for accessing sqlite db\n");

  /******************************************/
  /* First Test: stand-alone sqlite3 access */
  printf("FIRST TEST:\n");
  printf(" create and access /tmp/testsqlite3.db \n");
  printf(" please remove /tmp/testsqlite3.db after test\n");
  
  printf("sqlite3_open\n");
  if(sqlite3_open("/tmp/testsqlite3.db",&db)!=SQLITE_OK){
    printf("ERR at %s#%d: sqlite3_open\n",__FILE__,__LINE__);
    sqlite3_close(db);
    return 1;
  }
      
  printf("sqlite3_exec(create)\n");
  if(sqlite3_exec(db, "CREATE TABLE testTable (id TEXT PRIMARY KEY,test TEXT)", 
		  NULL, NULL, &pErrMsg)!=SQLITE_OK){
    printf("ERR at %s#%d: sqlite3_exec: %s\n",__FILE__,__LINE__,pErrMsg);
    printf(" Remove '/tmp/testsqlite3.db' and retry, when 'ERR..testTable already exists'\n");
    sqlite3_close(db);
    return 1;
  }

  printf("sqlite3_exec(insert)\n");
  if(sqlite3_exec(db, "INSERT INTO testTable (test) values ('tttt')", 
		  NULL, NULL, &pErrMsg)!=SQLITE_OK){
    printf("ERR at %s#%d: sqlite3_exec: %s\n",__FILE__,__LINE__,pErrMsg);
    sqlite3_close(db);
    return 1;
  }

  printf("sqlite3_prepare\n");
  if(sqlite3_prepare(db, "SELECT test FROM testTable WHERE test='tttt'", 
		     BUFFMAXLN, &stmt, NULL)!=SQLITE_OK){
    printf("ERR at %s#%d: sqlite3_prepare:%s\n",__FILE__,__LINE__,
	   sqlite3_errmsg(db));

    /* finalize */
    sqlite3_finalize(stmt);
    sqlite3_close(db);
    return 1;
  }

  printf("sqlite3_step\n");
  if(sqlite3_step(stmt)==SQLITE_ROW){
    printf("%s", (char*)sqlite3_column_text(stmt, 0));
    printf(" <== should be 'tttt'\n");
  }else{
    sqlite3_finalize(stmt);
    sqlite3_close(db);
    return 1;
  }
  
  /* finalize */
  sqlite3_finalize(stmt);
  sqlite3_close(db);
  
  printf("end of first test\n\n");

  /************************************/
  /* Second Test: get opengate config */

  printf("SECOND TEST\n");
  printf("create and access db file defined in conf file\n");

  /* prepare config file */
  OpenConfFile();
 
  /* start log */
  errToSyslog(atoi(GetConfValue("Syslog/Enable")));
  openlog(argv[0], LOG_PID, atoi(GetConfValue("Syslog/Facility")));

  /* init config */
  InitConf();

  /* put session begin to db */
  PutSessionBeginToDb("testcookie", "testuser", 
		      "192.168.0.123", "2001::1", 
		      "00:11:22:33:44:55", 
		      "10000", "10002",
		      600, 600,
		      1, "ja");
  /* put session end to db */
  PutSessionEndToDb("testcookie", "HTTP");

  /* get data from db */
  GetSessionInfoFromDb("testcookie", userid, 
		       clientAddr4, macAddr, 
		       &duration, &durationEntered, language, closeTime);

  /* dump getting data */
  printf("%s, %s, %s, %d, %d, %s\n",  userid, clientAddr4, macAddr, 
	 duration, durationEntered, language);

  printf("<== sholud be 'testuser, 192.168.0.123, 00:11:22:33:44:55, 600, 600, ja'\n");

  printf("end of second test\n\n");
  return 0;
}
