//******************************************************************************
//
// MIDITrail / MTPianoKeyboardDesignMod
//
// sAmL[{[hfUCModNX
//
// Copyright (C) 2012 Yossiepon Oniichan. All Rights Reserved.
//
//******************************************************************************

#include "StdAfx.h"
#include "DXColorUtil.h"
#include "MTConfFile.h"
#include "MTPianoKeyboardDesignMod.h"
#include "MTNoteRippleMod.h"
#include "MTNoteLyrics.h"


//******************************************************************************
// p[^`
//******************************************************************************
//eNX`WZoFrbg}bvTCY = 562 x 562
#define TEXTURE_POINT(x, y)  (D3DXVECTOR2((float)x/561.0f, (float)y/561.0f))

//******************************************************************************
// RXgN^
//******************************************************************************
MTPianoKeyboardDesignMod::MTPianoKeyboardDesignMod(void)
{
	//_Initialize()ŊNX̏Ă΂邽߁ANX̃RXgN^͌ĂяoȂ
	_Initialize();
}

//******************************************************************************
// fXgN^
//******************************************************************************
MTPianoKeyboardDesignMod::~MTPianoKeyboardDesignMod(void)
{
}

//******************************************************************************
// 
//******************************************************************************
int MTPianoKeyboardDesignMod::Initialize(
		const TCHAR* pSceneName,
		SMSeqData* pSeqData
	)
{
	int result = 0;

	//NX̏Ăяo
	MTPianoKeyboardDesign::Initialize(pSceneName, pSeqData);

	m_KeyboardDispNum = m_PortList.GetSize();

	//ݒt@Cǂݍ
	result = _LoadConfFile(pSceneName);
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// VOL[{[htOݒ
//******************************************************************************
void MTPianoKeyboardDesignMod::SetKeyboardSingle()
{
	m_isKeyboardSingle = true;
	m_KeyboardDispNum = 1;

	for (int i = 0; i < SM_MAX_PORT_NUM; i++) {
		m_PortIndex[i] = 0;
	}
}

//******************************************************************************
// VOL[{[htO擾
//******************************************************************************
bool MTPianoKeyboardDesignMod::IsKeyboardSingle()
{
	return m_isKeyboardSingle;
}
//******************************************************************************
// L[{[h\擾
//******************************************************************************
int MTPianoKeyboardDesignMod::GetKeyboardDispNum()
{
	return m_KeyboardDispNum;
}

//******************************************************************************
// m[gL[{[hCfbNX擾
//******************************************************************************
int MTPianoKeyboardDesignMod::GetKeyboardIndex(const SMNote &note)
{
	return m_PortIndex[note.portNo];
}

//******************************************************************************
// |[gXgTCY擾
//******************************************************************************
int MTPianoKeyboardDesignMod::GetPortListSize()
{
	return m_PortList.GetSize();
}

//******************************************************************************
// m[g|[gԍ擾
//******************************************************************************
unsigned char MTPianoKeyboardDesignMod::GetPortNo(const SMNote &note)
{
	if (m_isKeyboardSingle) {
		return 0;
	}
	else {
		return note.portNo;
	}
}

//******************************************************************************
// L[{[hCfbNX|[gԍ擾
//******************************************************************************
unsigned char MTPianoKeyboardDesignMod::GetPortNoFromKeyboardIndex(int index)
{
	unsigned char portNo;

	m_PortList.GetPort(index, &portNo);

	return portNo;
}

//******************************************************************************
// 
//******************************************************************************
void MTPianoKeyboardDesignMod::_Initialize()
{
	//NX̏Ăяo
	MTPianoKeyboardDesign::_Initialize();

	m_isKeyboardSingle = false;
	m_KeyboardDispNum = 0;

	for (int i = 0; i < 16; i++) {
		m_ActiveKeyColorList[i] = DXColorUtil::MakeColorFromHexRGBA(_T("FF0000FF")); //ݒt@C
	}

	return;
}

//******************************************************************************
// L[{[hW擾
//******************************************************************************
D3DXVECTOR3 MTPianoKeyboardDesignMod::GetKeyboardBasePos(
		int keyboardIndex,
		float angle
	)
{
	float ox, oy, oz = 0.0f;

	//[pxɂĕ`@؂ւ
	angle += angle < 0.0f ? 360.0f : 0.0f;
	bool flip = !((angle > 120.0f) && (angle < 300.0f));

	//|[gPʂ̌_W
	ox = GetPortOriginX();
	oy = GetPortOriginY(keyboardIndex, flip);
	oz = GetPortOriginZ(keyboardIndex, flip);

	return D3DXVECTOR3(ox, oy, oz);
}

//******************************************************************************
// |[g_XW擾
//******************************************************************************
float MTPianoKeyboardDesignMod::GetPortOriginX()
{
	// angle: 120`300(rotateX: 90, rotateZ: 90)
	//             +z
	//              |
	// -x<----------0---------->+x
	//              | -RippleMargin
	//         +----+----+
	//         |    |    |  @:OriginX
	//         |    |    |
	//         |    |    |
	//         |    |    |
	//         @----+----+
	//    Note #0   |  #127
	//             -z

	// angle: 0`120or 300`360(rotateX: -90, rotateZ: 90)
	//             +z
	//              |
	//    Note #0   |  #127
	//         +----+----+
	//         |    |    |  @:OriginX
	//         |    |    |
	//         |    |    |
	//         |    |    |
	//         @----+----+
	//              | +RippleMargin
	// -x<----------0---------->+x
	//              |
	//             -z

	float originX = -GetPlaybackSectionHeight() / 2.0f;

	//Ղ1/2̕Ɉړ
	originX += GetWhiteKeyStep() * GetKeyboardResizeRatio() / 2.0f;

	return originX;
}

//******************************************************************************
// |[g_YW擾
//******************************************************************************
float MTPianoKeyboardDesignMod::GetPortOriginY(
		int keyboardIndex,
		bool flip
	)
{
	// angle: 120`300(rotateX: 90, rotateZ: 90)
	//      +y                                    
	//       |                                    
	//       |                             Ch.15  
	//       |                                    
	//       |            +--------------+        
	//       |      portC +--------------@ Ch.0   
	//       |                             Ch.15  
	//       |                                    
	// +z<---0---------------------------------------------->-z
	//       |            +--------------+        
	//       |      portB +--------------@ Ch.0   
	//       |                             Ch.15  
	//       |                                    
	//       |            +--------------+          @:OriginY(for portA,B,C)
	//       |      portA +--------------@ Ch.0   
	//       |                                    
	//      -y                                    

	// angle: 0`120or 300`360(rotateX: -90, rotateZ: 90)
	//                                           +y
	//                                     Ch.15  |
	//                                            |
	//                    +--------------+        |
	//              portA +--------------@ Ch.0   |
	//                                     Ch.15  |
	//                                            |
	// +z<----------------------------------------0-------------->-z
	//                    +--------------+        |
	//              portB +--------------@ Ch.0   |
	//                                     Ch.15  |
	//                                            |
	//                    +--------------+        |
	//              portC +--------------@ Ch.0   |
	//                                            |
	//                                            | @:OriginY(for portA,B,C)
	//                                           -y

	float portWidth = GetPortWidth();

	int keyboardDispNum = GetKeyboardDispNum();

	float originY;

	if (!flip) {
		originY = -portWidth * (float)(keyboardDispNum - keyboardIndex * 2) / 2.0f;

		//`lԊu62.5%̍
		originY -= GetChStep() * 0.625f;
	}
	else {
		originY = portWidth * (float)(keyboardDispNum - (keyboardIndex + 1) * 2) / 2.0f;

		//`lԊu37.5%̍
		originY += GetChStep() * 0.375f;
	}

	return originY;
}

//******************************************************************************
// |[g_ZW擾
//******************************************************************************
float MTPianoKeyboardDesignMod::GetPortOriginZ(
		int keyboardIndex,
		bool flip
	)
{
	// angle: 120`300(rotateX: 90, rotateZ: 90)
	//             +z
	//              |
	// -x<----------0---------->+x
	//              | -RippleMargin
	//         +----+----+
	//         |    |    |  @:OriginZ
	//         |    |    |
	//         |    |    |
	//         |    |    |
	//         @----+----+
	//    Note #0   |  #127
	//             -z

	// angle: 0`120or 300`360(rotateX: -90, rotateZ: 90)
	//             +z
	//              |
	//    Note #0   |  #127
	//         +----+----+
	//         |    |    |  @:OriginZ
	//         |    |    |
	//         |    |    |
	//         |    |    |
	//         @----+----+
	//              | +RippleMargin
	// -x<----------0---------->+x
	//              |
	//             -z

	float originZ;

	if (!flip) {
		originZ = -(GetWhiteKeyLen() * GetKeyboardResizeRatio() + GetRippleMargin());
	}
	else {
		originZ = GetRippleMargin();
	}

	return originZ;
}

//******************************************************************************
// m[g{bNX擾
//******************************************************************************
float MTPianoKeyboardDesignMod::GetNoteBoxHeight()
{
	return m_NoteBoxHeight;
}

//******************************************************************************
// m[g{bNX擾
//******************************************************************************
float MTPianoKeyboardDesignMod::GetNoteBoxWidth()
{
	return m_NoteBoxWidth;
}

//******************************************************************************
// m[gԊu擾
//******************************************************************************
float MTPianoKeyboardDesignMod::GetNoteStep()
{
	return m_NoteStep;
}

//******************************************************************************
// `lԊu擾
//******************************************************************************
float MTPianoKeyboardDesignMod::GetChStep()
{
	return m_ChStep;
}

//******************************************************************************
// L[{[h擾
//******************************************************************************
float MTPianoKeyboardDesignMod::GetKeyboardHeight()
{
	return GetBlackKeyHeight();
}

//******************************************************************************
// L[{[h擾
//******************************************************************************
float MTPianoKeyboardDesignMod::GetKeyboardWidth()
{
	return GetWhiteKeyStep() * (float)(SM_MAX_NOTE_NUM - 53);
}

//******************************************************************************
// Obh擾
//******************************************************************************
float MTPianoKeyboardDesignMod::GetGridHeight()
{
	return GetNoteStep() * 127.0f;
}

//******************************************************************************
// Obh擾
//******************************************************************************
float MTPianoKeyboardDesignMod::GetGridWidth()
{
	return GetChStep() * 15.0f;
}

//******************************************************************************
// |[g擾
//******************************************************************************
float MTPianoKeyboardDesignMod::GetPortHeight()
{
	return GetGridHeight();
}

//******************************************************************************
// |[g擾
//******************************************************************************
float MTPianoKeyboardDesignMod::GetPortWidth()
{
	return GetChStep() * 16.0f;
}

//******************************************************************************
// Đʍ擾
//******************************************************************************
float MTPianoKeyboardDesignMod::GetPlaybackSectionHeight()
{
	return GetGridHeight() + GetNoteBoxHeight();
}

//******************************************************************************
// Đʕ擾
//******************************************************************************
float MTPianoKeyboardDesignMod::GetPlaybackSectionWidth()
{
	return GetGridWidth() + GetNoteBoxWidth();
}

//******************************************************************************
// g`Ԋu擾
//******************************************************************************
float MTPianoKeyboardDesignMod::GetRippleSpacing()
{
	return m_RippleSpacing;
}

//******************************************************************************
// g`}[W擾
//******************************************************************************
float MTPianoKeyboardDesignMod::GetRippleMargin()
{
	return GetRippleSpacing() * (MTNOTELYRICS_MAX_LYRICS_NUM + MTNOTERIPPLE_MAX_RIPPLE_NUM);
}

//******************************************************************************
// L[{[hTCY擾
//******************************************************************************
float MTPianoKeyboardDesignMod::GetKeyboardResizeRatio()
{
	//L[{[h̑΍WɓKp郊TCY
	return GetPlaybackSectionHeight() / GetKeyboardWidth();
}

//******************************************************************************
// L[J[擾
//******************************************************************************
D3DXCOLOR MTPianoKeyboardDesignMod::GetActiveKeyColor(
		unsigned char chNo,
		unsigned char noteNo,
		unsigned long elapsedTime,
		D3DXCOLOR* pNoteColor
	)
{
	D3DXCOLOR color;
	float r,g,b,a = 0.0f;
	float rate = 0.0f;
	unsigned long duration = 0;

	//          on     off
	//    |---+......+---- offɂȂ甒̐Fɖ߂
	//      |   :      :
	//      |   :  +---+     offɂȂ܂ŒԐF̂܂
	//      |   : /:   :
	//      |   :/ :   :
	//    |   +  :   :     L[̐Fiԁj
	//      |   :\ :   :
	//      |   : \:   :
	//      |   :  +---+     offɂȂ܂ŒԐF̂܂
	//      |   :  :   :
	//    |---+  :   +---- offɂȂ獕̐Fɖ߂
	//   ---+---*------*-------> +t
	//      |   on :   off
	//          <-->duration

	if ((pNoteColor != NULL) && (m_ActiveKeyColorType == NoteColor)) {
		//m[gFw肳Ăꍇ
		color = *pNoteColor;
	}
	else {
		//ȊO̓ftHgFƂ
		color = m_ActiveKeyColorList[chNo];
	}

	duration = (unsigned long)m_ActiveKeyColorDuration;
	rate     = m_ActiveKeyColorTailRate;

	if (elapsedTime < duration) {
		rate = ((float)elapsedTime / (float)duration) * m_ActiveKeyColorTailRate;
	}

	if (GetKeyType(noteNo) == KeyBlack) {
		r = color.r - ((color.r) * rate);
		g = color.g - ((color.g) * rate);
		b = color.b - ((color.b) * rate);
		a = color.a;
	}
	else {
		r = color.r + ((1.0f - color.r) * rate);
		g = color.g + ((1.0f - color.g) * rate);
		b = color.b + ((1.0f - color.b) * rate);
		a = color.a;
	}
	color = D3DXCOLOR(r, g, b, a);

	return color;
}

//******************************************************************************
// ݒt@Cǂݍ
//******************************************************************************
int MTPianoKeyboardDesignMod::_LoadConfFile(
		const TCHAR* pSceneName
	)
{
	int result = 0;
	TCHAR key[21] = {_T('\0')};
	TCHAR hexColor[16] = {_T('\0')};
	unsigned long i = 0;
	MTConfFile confFile;

	//NX̓ǂݍݏĂяo
	result = MTPianoKeyboardDesign::_LoadConfFile(pSceneName);
	if (result != 0) goto EXIT;

	//ݒt@CJ
	result = confFile.Initialize(pSceneName);
	if (result != 0) goto EXIT;

	//----------------------------------
	//XP[
	//----------------------------------
	result = confFile.SetCurSection(_T("Scale"));
	if (result != 0) goto EXIT;

	result = confFile.GetFloat(_T("NoteBoxHeight"), &m_NoteBoxHeight, 0.1f);
	if (result != 0) goto EXIT;
	result = confFile.GetFloat(_T("NoteBoxWidth"), &m_NoteBoxWidth, 0.1f);
	if (result != 0) goto EXIT;
	result = confFile.GetFloat(_T("NoteStep"), &m_NoteStep, 0.1f);
	if (result != 0) goto EXIT;
	result = confFile.GetFloat(_T("ChStep"), &m_ChStep, 0.5f);
	if (result != 0) goto EXIT;

	//----------------------------------
	//F
	//----------------------------------
	result = confFile.SetCurSection(_T("PianoKeyboard"));
	if (result != 0) goto EXIT;

	//̃L[F擾
	for (i = 0; i < 16; i++) {
		_stprintf_s(key, 21, _T("Ch-%02d-ActiveKeyColor"), i+1);
		result = confFile.GetStr(key, hexColor, 16, _T("FF0000FF"));
		if (result != 0) goto EXIT;

		m_ActiveKeyColorList[i] = DXColorUtil::MakeColorFromHexRGBA(hexColor);
	}

	//----------------------------------
	//g
	//----------------------------------
	result = confFile.SetCurSection(_T("Ripple"));
	if (result != 0) goto EXIT;

	//g`Ԋu
	result = confFile.GetFloat(_T("Spacing"), &m_RippleSpacing, 0.002f);
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}


