//******************************************************************************
//
// MIDITrail / MTBackgroundImage
//
// wi摜`NX
//
// Copyright (C) 2016 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#include "StdAfx.h"
#include "shlwapi.h"
#include "MTParam.h"
#include "MTConfFile.h"
#include "MTBackgroundImage.h"


//******************************************************************************
// RXgN^
//******************************************************************************
MTBackgroundImage::MTBackgroundImage(void)
{
	m_pTexture = NULL;
	ZeroMemory(&m_ImgInfo, sizeof(D3DXIMAGE_INFO));
	m_hWnd = NULL;
	m_isEnable = true;
	m_isFilterLinear = true;
}

//******************************************************************************
// fXgN^
//******************************************************************************
MTBackgroundImage::~MTBackgroundImage(void)
{
	Release();
}

//******************************************************************************
// wi摜
//******************************************************************************
int MTBackgroundImage::Create(
		LPDIRECT3DDEVICE9 pD3DDevice,
		HWND hWnd
	)
{
	int result = 0;
	unsigned long vertexNum = 0;
	unsigned long indexNum = 0;
	MTBACKGROUNDIMAGE_VERTEX* pVertex = NULL;
	unsigned long* pIndex = NULL;

	Release();

	m_hWnd = hWnd;

	//ݒt@C
	result = _InitConfFile();
	if (result != 0) goto EXIT;

	//eNX`ǂݍ
	result = _LoadTexture(pD3DDevice);
	if (result != 0) goto EXIT;

	//eNX`𐶐Ȃꍇ͉Ȃ
	if (m_pTexture == NULL) goto EXIT;

	//v~eBu
	result = m_Primitive.Initialize(
					sizeof(MTBACKGROUNDIMAGE_VERTEX),	//_TCY
					_GetFVFFormat(),			//_FVFtH[}bg
					D3DPT_TRIANGLESTRIP			//v~eBu
				);
	if (result != 0) goto EXIT;

	//_obt@
	vertexNum = 4;
	result = m_Primitive.CreateVertexBuffer(pD3DDevice, vertexNum);
	if (result != 0) goto EXIT;

	//CfbNXobt@
	indexNum = 4;
	result = m_Primitive.CreateIndexBuffer(pD3DDevice, indexNum);
	if (result != 0) goto EXIT;

	//obt@̃bN
	result = m_Primitive.LockVertex((void**)&pVertex);
	if (result != 0) goto EXIT;
	result = m_Primitive.LockIndex(&pIndex);
	if (result != 0) goto EXIT;

	//obt@ɒ_ƃCfbNX
	result = _CreateVertexOfBackground(
					pVertex,		//_obt@݈ʒu
					pIndex			//CfbNXobt@݈ʒu
				);
	if (result != 0) goto EXIT;

	//obt@̃bN
	result = m_Primitive.UnlockVertex();
	if (result != 0) goto EXIT;
	result = m_Primitive.UnlockIndex();
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// `
//******************************************************************************
int MTBackgroundImage::Draw(
		LPDIRECT3DDEVICE9 pD3DDevice
	)
{
	int result = 0;
	DWORD value = 0;

	if (!m_isEnable) goto EXIT;
	if (m_pTexture == NULL) goto EXIT;

	//Zobt@ꎞIɖ
	pD3DDevice->GetRenderState(D3DRS_ZENABLE, &value);
	pD3DDevice->SetRenderState(D3DRS_ZENABLE, FALSE);

	//eNX`Xe[Wݒ
	//  J[ZF1gp  1FeNX`
	pD3DDevice->SetTextureStageState(0, D3DTSS_COLOROP,   D3DTOP_SELECTARG1);
	pD3DDevice->SetTextureStageState(0, D3DTSS_COLORARG1, D3DTA_TEXTURE);
	// At@ZF1gp  1FeNX`
	pD3DDevice->SetTextureStageState(0, D3DTSS_ALPHAOP,   D3DTOP_SELECTARG1);
	pD3DDevice->SetTextureStageState(0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE);

	//eNX`tB^
	if (m_isFilterLinear) {
		pD3DDevice->SetSamplerState(0, D3DSAMP_MINFILTER, D3DTEXF_LINEAR);
		pD3DDevice->SetSamplerState(0, D3DSAMP_MAGFILTER, D3DTEXF_LINEAR);
	}
	else {
		//sNZ{ŕ`悷ꍇ{PȂ悤ɂ
		pD3DDevice->SetSamplerState(0, D3DSAMP_MINFILTER, D3DTEXF_POINT);
		pD3DDevice->SetSamplerState(0, D3DSAMP_MAGFILTER, D3DTEXF_POINT);
	}

	//`
	result = m_Primitive.Draw(pD3DDevice, m_pTexture);
	if (result != 0) goto EXIT;

	//Zobt@LԂ߂
	pD3DDevice->SetRenderState(D3DRS_ZENABLE, value);

EXIT:;
	return result;
}

//******************************************************************************
// 
//******************************************************************************
void MTBackgroundImage::Release()
{
	m_Primitive.Release();
	
	if (m_pTexture != NULL) {
		m_pTexture->Release();
		m_pTexture = NULL;
	}
}

//******************************************************************************
// wi摜_
//******************************************************************************
int MTBackgroundImage::_CreateVertexOfBackground(
		MTBACKGROUNDIMAGE_VERTEX* pVertex,
		unsigned long* pIndex
	)
{
	int result = 0;
	BOOL bresult = 0;
	RECT rect;
	unsigned long i = 0;
	unsigned long cw = 0;
	unsigned long ch = 0;
	float ratio_cwh = 0.0f;
	float ratio_iwh = 0.0f;
	float x1 = 0.0f;
	float x2 = 0.0f;
	float y1 = 0.0f;
	float y2 = 0.0f;

	//NCAg̈̃TCY擾
	bresult = GetClientRect(m_hWnd, &rect);
	if (!bresult) {
		result = YN_SET_ERR("Windows API error.", GetLastError(), 0);
		goto EXIT;
	}
	cw = rect.right - rect.left;
	ch = rect.bottom - rect.top;

	ratio_cwh = (float)cw / (float)ch;
	ratio_iwh = (float)m_ImgInfo.Width / (float)m_ImgInfo.Height;

	// NCAg̈摜̏̕ꍇ
	//     |----- cw -----|
	//  ---0--------------+-- +x
	//   | |              |
	//   | +--------------+
	//  ch |    image     |
	//   | +--------------+
	//   | |              |
	//  ---+--------------+
	//     |
	//    +y
	if (ratio_cwh < ratio_iwh) {
		x1 = 0.0f;
		x2 = (float)cw;
		y1 = ((float)ch - ((float)cw / ratio_iwh)) / 2.0f;
		y2 = (float)ch - y1;
		
		//sNZ{ŕ`悷ꍇ̓jAtB^ă{PȂ悤ɂ
		if (cw == m_ImgInfo.Width) {
			m_isFilterLinear = false;
		}
	}
	// NCAg̈摜̕c̏ꍇ
	//     |----- cw -----|
	//  ---0--+--------+--+-- +x
	//   | |  |        |  |
	//   | |  |        |  |
	//  ch |  | image  |  |
	//   | |  |        |  |
	//   | |  |        |  |
	//  ---+--+--------+--+
	//     |
	//    +y
	else {
		x1 = ((float)cw - ((float)ch * ratio_iwh)) / 2.0f;
		x2 = (float)cw - x1 - 1.0f;
		y1 = 0.0f;
		y2 = (float)ch - 1.0f;
		
		//sNZ{ŕ`悷ꍇ̓jAtB^ă{PȂ悤ɂ
		if (ch == m_ImgInfo.Height) {
			m_isFilterLinear = false;
		}
	}

	//sNZ{ŕ`悷ꍇz肵čW𒲐
	x1 -= 0.5f;
	x2 -= 0.5f;
	y1 -= 0.5f;
	y2 -= 0.5f;

	//_W
	pVertex[0].p = D3DXVECTOR3(x1, y1, 0.0f);
	pVertex[1].p = D3DXVECTOR3(x2, y1, 0.0f);
	pVertex[2].p = D3DXVECTOR3(x1, y2, 0.0f);
	pVertex[3].p = D3DXVECTOR3(x2, y2, 0.0f);

	//e_̃fBt[YF
	for (i = 0; i < 4; i++) {
		//e_̏Z
		pVertex[i].rhw = 1.0f;
		//e_̃fBt[YF
		pVertex[i].c = D3DXCOLOR(1.0f, 1.0f, 1.0f, 1.0f);
	}

	//e_̃eNX`W
	pVertex[0].t = D3DXVECTOR2(0.0f, 0.0f);
	pVertex[1].t = D3DXVECTOR2(1.0f, 0.0f);
	pVertex[2].t = D3DXVECTOR2(0.0f, 1.0f);
	pVertex[3].t = D3DXVECTOR2(1.0f, 1.0f);

	//CfbNXFTRIANGLESTRIP
	pIndex[0] = 0;
	pIndex[1] = 1;
	pIndex[2] = 2;
	pIndex[3] = 3;

EXIT:;
	return result;
}

//******************************************************************************
// ݒt@C
//******************************************************************************
int MTBackgroundImage::_InitConfFile()
{
	int result = 0;
	TCHAR userConfFilePath[_MAX_PATH] = {_T('\0')};

	result = YNPathUtil::GetAppDataDirPath(userConfFilePath, _MAX_PATH);
	if (result != 0) goto EXIT;

	_tcscat_s(userConfFilePath, _MAX_PATH, MT_USER_CONFFILE_DIR);
	_tcscat_s(userConfFilePath, _MAX_PATH, MT_USER_CONFFILE_GRAPHIC);

	result = m_ConfFile.Initialize(userConfFilePath);
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// eNX`摜ǂݍ
//******************************************************************************
int MTBackgroundImage::_LoadTexture(
		LPDIRECT3DDEVICE9 pD3DDevice
	)
{
	int result = 0;
	HRESULT hresult = D3D_OK;
	TCHAR imageFilePath[_MAX_PATH] = {_T('\0')};

	//rbg}bvt@C
	result = m_ConfFile.SetCurSection(_T("Background-image"));
	if (result != 0) goto EXIT;
	result = m_ConfFile.GetStr(_T("ImageFilePath"), imageFilePath, _MAX_PATH, _T(""));
	if (result != 0) goto EXIT;

	//t@CwȂ牽Ȃ
	if (_tcslen(imageFilePath) == 0) goto EXIT;

	//t@C݂Ȃꍇ͉Ȃ
	if (!PathFileExists(imageFilePath)) goto EXIT;

	//ǂݍމ摜̏cTCY擾Ă
	hresult = D3DXGetImageInfoFromFile(imageFilePath, &m_ImgInfo);
	if (FAILED(hresult)) {
		result = YN_SET_ERR("DirectX API error.", hresult, 0);
		goto EXIT;
	}

	//eNX`摜Ƃēǂݍ
	//  sNZ{ŕ`悷ꍇɃ{PȂ悤ɂ邽
	//  摜TCYw肵ēǂݍ
	hresult = D3DXCreateTextureFromFileEx(
					pD3DDevice,			//foCX
					imageFilePath,		//t@CpX
					m_ImgInfo.Width,	//isNZjFڎw
					m_ImgInfo.Height,	//isNZjFڎw
					1,					//~bvx
					0,					//gp@
					D3DFMT_A8R8G8B8,	//sNZtH[}bg
					D3DPOOL_MANAGED,	//eNX`zu惁NX
					D3DX_FILTER_NONE,	//tB^Ow
					D3DX_FILTER_NONE,	//tB^Owi~bvj
					0xFF000000,			//F̎wFs
					NULL,				//\[XC[W
					NULL,				//256Fpbg
					&m_pTexture			//쐬ꂽeNX`IuWFNg
				);
	if (FAILED(hresult)) {
		result = YN_SET_ERR("DirectX API error.", hresult, 0);
		goto EXIT;
	}

EXIT:;
	return result;
}

//******************************************************************************
// \ݒ
//******************************************************************************
void MTBackgroundImage::SetEnable(
		bool isEnable
	)
{
	m_isEnable = isEnable;
}


