//******************************************************************************
//
// MIDITrail / MTPianoKeyboardCtrlMod
//
// sAmL[{[hModNX
//
// Copyright (C) 2012 Yossiepon Oniichan. All Rights Reserved.
//
//******************************************************************************

#include "StdAfx.h"
#include "YNBaseLib.h"
#include "MTPianoKeyboardCtrlMod.h"
#include "MTPianoKeyboardMod.h"

using namespace YNBaseLib;


//******************************************************************************
// p[^`
//******************************************************************************
#define MTPIANOKEYBOARD_MAX_ACTIVENOTE_NUM (256)


//******************************************************************************
// RXgN^
//******************************************************************************
MTPianoKeyboardCtrlMod::MTPianoKeyboardCtrlMod(void)
{
	m_MaxKeyboardIndex = 0;
	ZeroMemory(m_KeyDownRateMod, sizeof(float) * SM_MAX_CH_NUM* SM_MAX_CH_NUM * SM_MAX_NOTE_NUM);
}

//******************************************************************************
// fXgN^
//******************************************************************************
MTPianoKeyboardCtrlMod::~MTPianoKeyboardCtrlMod(void)
{
	Release();
}

//******************************************************************************
// 
//******************************************************************************
int MTPianoKeyboardCtrlMod::Create(
		LPDIRECT3DDEVICE9 pD3DDevice,
		const TCHAR* pSceneName,
		SMSeqData* pSeqData,
		MTNotePitchBend* pNotePitchBend,
		bool isSingleKeyboard
	)
{
	int result = 0;
	unsigned long index = 0;
	unsigned long keyboardIndex = 0;
	unsigned char portNo = 0;
	SMTrack track;

	Release();

	if (pSeqData == NULL) {
		result = YN_SET_ERR("Program error.", 0, 0);
		goto EXIT;
	}

	//m[gfUCIuWFNg
	result = m_NoteDesignMod.Initialize(pSceneName, pSeqData);
	if (result != 0) goto EXIT;

	//L[{[hfUC
	result = m_KeyboardDesignMod.Initialize(pSceneName, pSeqData);
	if (result != 0) goto EXIT;

	//V[PXf[^F|[gXg擾
	result = pSeqData->GetPortList(&m_PortList);
	if (result != 0) goto EXIT;

	for (index = 0; index < SM_MAX_PORT_NUM; index++) {
		m_KeyboardIndex[index] = -1;
	}

	//VOL[{[hłȂꍇ
	if (!isSingleKeyboard) {
		//|[gԍɏ̃L[{[hCfbNXU
		//|[g 0 3 5 ɏo͂ꍇ̃CfbNX͂ꂼ 0, 1, 2
		for (index = 0; index < m_PortList.GetSize(); index++) {
			m_PortList.GetPort(index, &portNo);
			m_KeyboardIndex[portNo] = keyboardIndex;
			keyboardIndex++;
			if(keyboardIndex == m_KeyboardDesignMod.GetKeyboardMaxDispNum()){
				break;
			}
		}
		m_MaxKeyboardIndex = (unsigned char)keyboardIndex;
	}
	//VOL[{[h̏ꍇ
	else {
		//L[{[hfUCVO[hɐݒ
		m_KeyboardDesignMod.SetKeyboardSingle();
		//|[gƃL[{[h̑Ή1:1ɌŒ
		m_KeyboardIndex[0] = 0;
		m_MaxKeyboardIndex = 1;
	}

	//gbN擾
	result = pSeqData->GetMergedTrack(&track);
	if (result != 0) goto EXIT;

	//m[gXg擾FstartTime, endTime ̓A^C(msec)
	result = track.GetNoteListWithRealTime(&m_NoteListRT, pSeqData->GetTimeDivision());
	if (result != 0) goto EXIT;

	//m[gz񐶐
	result = _CreateNoteStatus();
	if (result != 0) goto EXIT;

	//L[{[h
	result = _CreateKeyboards(pD3DDevice, pSceneName, pSeqData);
	if (result != 0) goto EXIT;

	//sb`xh
	m_pNotePitchBend = pNotePitchBend;

	//VOL[{[htO
	m_isSingleKeyboard = isSingleKeyboard;

EXIT:;
	return result;
}

//******************************************************************************
// L[{[h`IuWFNg
//******************************************************************************
int MTPianoKeyboardCtrlMod::_CreateKeyboards(
		LPDIRECT3DDEVICE9 pD3DDevice,
		const TCHAR* pSceneName,
		SMSeqData* pSeqData
	)
{
	int result = 0;
	unsigned char index = 0;
	LPDIRECT3DTEXTURE9 pTexture = NULL;

	for (index = 0; index < m_MaxKeyboardIndex; index++) {
		try {
			m_pPianoKeyboard[index] = new MTPianoKeyboardMod;
		}
		catch (std::bad_alloc) {
			result = YN_SET_ERR("Could not allocate memory.", 0, 0);
			goto EXIT;
		}

		result = m_pPianoKeyboard[index]->Create(pD3DDevice, pSceneName, pSeqData, pTexture);
		if (result != 0) goto EXIT;

		//擪IuWFNgō쐬eNX`ėp
		pTexture = m_pPianoKeyboard[index]->GetTexture();
	}

EXIT:;
	return result;
}

//******************************************************************************
// ړ
//******************************************************************************
int MTPianoKeyboardCtrlMod::Transform(
		LPDIRECT3DDEVICE9 pD3DDevice,
		float rollAngle
	)
{
	int result = 0;
	unsigned char portNo = 0;
	unsigned char chNo = 0;
	int index;
	D3DXVECTOR3 basePosVector;
	D3DXVECTOR3 playbackPosVector;

	//ANeBu|[gtONA
	for (index = 0; index < SM_MAX_PORT_NUM; index++) {
		m_isActivePort[index] = false;
	}

	//ݔm[g̒_XV
	result = _TransformActiveNotes(pD3DDevice);
	if (result != 0) goto EXIT;

	//ړxNgFĐʂɒǏ]
	playbackPosVector = m_NoteDesignMod.GetWorldMoveVector();
	playbackPosVector.x += m_NoteDesignMod.GetPlayPosX(m_CurTickTime);

	unsigned char lastPortNo = 0;

	if (!m_isSingleKeyboard) {
		//VOL[{[hłȂꍇAŏI|[gԍ擾
		m_PortList.GetPort(m_PortList.GetSize()-1, &lastPortNo);
	}
	else {
		//VOL[{[h̏ꍇAŏI|[gԍ0Œ
		lastPortNo = 0;
	}

	for(portNo = 0; portNo <= lastPortNo; portNo ++) {

		//|[gԍL[{[hCfbNX擾
		//VOL[{[h̏ꍇACfbNX0Œ
		int keyboardIndex = !m_isSingleKeyboard ? m_KeyboardIndex[portNo] : 0;

		if(keyboardIndex == -1) {
			continue;
		}

		//ړxNgFL[{[hW
		basePosVector = m_KeyboardDesignMod.GetKeyboardBasePos(keyboardIndex, rollAngle);

		//ړxNgFsb`xhVtg𔽉f
		basePosVector.x += GetMaxPitchBendShift(portNo);

		//L[{[hړ
		result = m_pPianoKeyboard[keyboardIndex]->Transform(pD3DDevice, basePosVector, playbackPosVector, rollAngle);
		if (result != 0) goto EXIT;
	}

EXIT:;
	return result;
}

//******************************************************************************
// m[gԍXV
//******************************************************************************
int MTPianoKeyboardCtrlMod::_UpdateNoteStatus(
		unsigned long playTimeMSec,
		unsigned long keyDownDuration,
		unsigned long keyUpDuration,
		SMNote note,
		NoteStatus* pNoteStatus
	)
{
	int result= 0;

	//m[gONOiL[~j
	if (playTimeMSec < note.startTime) {
		pNoteStatus->keyStatus = BeforeNoteON;
		if (keyDownDuration == 0) {
			pNoteStatus->keyDownRate = 0.0f;
		}
		else {
			pNoteStatus->keyDownRate = 1.0f - ((float)(note.startTime - playTimeMSec) / (float)keyDownDuration);
		}
	}
	//m[gONOFF܂
	else if ((note.startTime <= playTimeMSec) && (playTimeMSec <= note.endTime)) {
		pNoteStatus->keyStatus = NoteON;
		pNoteStatus->keyDownRate = 1.0f;
	}
	//m[gOFFiL[㏸j
	else if ((note.endTime < playTimeMSec) && (playTimeMSec <= (note.endTime + keyUpDuration))) {
		pNoteStatus->keyStatus = AfterNoteOFF;
		if (keyUpDuration == 0) {
			pNoteStatus->keyDownRate = 0.0f;
		}
		else {
			pNoteStatus->keyDownRate = 1.0f - ((float)(playTimeMSec - note.endTime) / (float)keyUpDuration);
		}
	}
	//m[gOFFiL[Aς݁j
	else {
		//m[gj
		//̃L[Zbg
		result = m_pPianoKeyboard[_GetKeyboardIndexFromNote(note)]->ResetKey(note.noteNo);
		if (result != 0) goto EXIT;

		pNoteStatus->isActive = false;
		pNoteStatus->keyStatus = BeforeNoteON;
		pNoteStatus->index = 0;
		pNoteStatus->keyDownRate = 0.0f;
	}

	//ԍXVAł
	if (pNoteStatus->isActive) {
		//ANeBu|[gtO𗧂Ă
		m_isActivePort[note.portNo] = true;
	}

EXIT:;
	return result;
}

//******************************************************************************
// m[g̒_XV
//******************************************************************************
int MTPianoKeyboardCtrlMod::_UpdateVertexOfActiveNotes(
		LPDIRECT3DDEVICE9 pD3DDevice
	)
{
	int result = 0;
	unsigned long i = 0;
	unsigned long elapsedTime = 0;
	SMNote note;
	D3DXCOLOR noteColor;
	unsigned char notePortNo;

	ZeroMemory(m_KeyDownRateMod, sizeof(float) * SM_MAX_CH_NUM* SM_MAX_CH_NUM * SM_MAX_NOTE_NUM);

	//m[gɂĒ_XV
	for (i = 0; i < MTPIANOKEYBOARD_MAX_ACTIVENOTE_NUM; i++) {
		//łȂ΃XLbv
		if (!(m_pNoteStatus[i].isActive)) continue;

		//m[g擾
		result = m_NoteListRT.GetNote(m_pNoteStatus[i].index, &note);
		if (result != 0) goto EXIT;

		//Jňoߎ
		elapsedTime = 0;
		if (m_pNoteStatus[i].keyStatus == NoteON) {
			elapsedTime = m_PlayTimeMSec - note.startTime;
		}

		//m[g̐F
		noteColor = m_NoteDesignMod.GetNoteBoxColor(note.portNo, note.chNo, note.noteNo);

		//VOL[{[hłȂꍇ
		if (!m_isSingleKeyboard) {
			//m[g̃|[gԍ擾
			notePortNo = note.portNo;
		}
		//VOL[{[h̏ꍇ
		else {
			//m[g̃|[gԍ0Œ
			notePortNo = 0;
		}

		//ΏۃL[]
		//  łɓm[gɑ΂Ē_XVĂꍇ
		//  OꍇɌ蒸_XV
		if (m_KeyDownRateMod[notePortNo][note.chNo][note.noteNo] < m_pNoteStatus[i].keyDownRate) {
			//`l̃L[Ԃ|[gʂɏW񂷂
			result = m_pPianoKeyboard[_GetKeyboardIndexFromNote(note)]->PushKey(
																		note.chNo,
																		note.noteNo,
																		m_pNoteStatus[i].keyDownRate,
																		elapsedTime,
																		&noteColor
																	);
			if (result != 0) goto EXIT;
			m_KeyDownRateMod[notePortNo][note.chNo][note.noteNo] = m_pNoteStatus[i].keyDownRate;
		}
	}

EXIT:;
	return result;
}

//******************************************************************************
// `
//******************************************************************************
int MTPianoKeyboardCtrlMod::Draw(
		LPDIRECT3DDEVICE9 pD3DDevice
   )
{
	int result = 0;
	unsigned char index = 0;
	unsigned long count = 0;
	unsigned long dispNum = 0;

	if (!m_isEnable) goto EXIT;

	//_OXe[gݒFZobt@ւ̏݃It
//	pD3DDevice->SetRenderState(D3DRS_ZWRITEENABLE, FALSE);

	//L[{[h̕`
	for (index = 0; index < m_MaxKeyboardIndex; index++) {

		result = m_pPianoKeyboard[index]->Draw(pD3DDevice);
		if (result != 0) goto EXIT;
	}

	//_OXe[gݒFZobt@ւ̏݃I
//	pD3DDevice->SetRenderState(D3DRS_ZWRITEENABLE, TRUE);

EXIT:;
	return result;
}

//******************************************************************************
// Zbg
//******************************************************************************
void MTPianoKeyboardCtrlMod::Reset()
{
	int result = 0;
	unsigned long i = 0;
	SMNote note;

	m_PlayTimeMSec = 0;
	m_CurTickTime = 0;
	m_CurNoteIndex = 0;

	for (i = 0; i < MTPIANOKEYBOARD_MAX_ACTIVENOTE_NUM; i++) {
		if (m_pNoteStatus[i].isActive) {
			result = m_NoteListRT.GetNote(m_pNoteStatus[i].index, &note);
			//if (result != 0) goto EXIT;

			//̃L[Zbg
			result = m_pPianoKeyboard[_GetKeyboardIndexFromNote(note)]->ResetKey(note.noteNo);
			//if (result != 0) goto EXIT;
		}
		m_pNoteStatus[i].isActive = false;
		m_pNoteStatus[i].keyStatus = BeforeNoteON;
		m_pNoteStatus[i].index = 0;
		m_pNoteStatus[i].keyDownRate = 0.0f;
	}

	return;
}

int MTPianoKeyboardCtrlMod::_GetKeyboardIndexFromNote(const SMNote &note)
{
	//VOL[{[hłȂꍇ
	if (!m_isSingleKeyboard) {
		//m[g̃sAmԍ擾
		return m_KeyboardIndex[note.portNo];
	}
	//VOL[{[h̏ꍇ
	else {
		//m[g̃sAmԍ0Œ
		return 0;
	}
}

//******************************************************************************
// sb`xhVtg̍őʂ߂
//******************************************************************************
float MTPianoKeyboardCtrlMod::GetMaxPitchBendShift(unsigned char portNo) {

	float max = 0.0f;
	float cur = 0.0f;

	//VOL[{[hłȂꍇAw̃|[gԍ狁߂
	//VOL[{[h̏ꍇAV[PXɊ܂܂|[gԍׂĂ狁߂
	int portListSize = !m_isSingleKeyboard ? 1 : m_PortList.GetSize();

	for (int i = 0; i < portListSize; i++) {

		if (m_isSingleKeyboard) {
			m_PortList.GetPort(i, &portNo);
		}

		if (!m_isActivePort[portNo]) {
			continue;
		}

		for (unsigned char chNo = 0; chNo < SM_MAX_CH_NUM; chNo++) {

			float pitchBendShift = _GetPichBendShiftPosX(portNo, chNo);
			if(max < fabs(pitchBendShift)) {

				cur = pitchBendShift;
				max = fabs(pitchBendShift);
			}
		}
	}

	return cur;
}