//******************************************************************************
//
// MIDITrail / MTTimeIndicatorRing
//
// ^CCWP[^O`NX
//
// Copyright (C) 2019 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

// MEMO:
// uĐĂƂvwĐʂ`悷B

#pragma once

#include <d3d9.h>
#include <d3dx9.h>
#include "SMIDILib.h"
#include "DXPrimitive.h"
#include "MTNoteDesignRing.h"

using namespace SMIDILib;


//******************************************************************************
// ^CCWP[^O`NX
//******************************************************************************
class MTTimeIndicatorRing
{
public:

	//RXgN^^fXgN^
	MTTimeIndicatorRing(void);
	virtual ~MTTimeIndicatorRing(void);

	//
	int Create(LPDIRECT3DDEVICE9 pD3DDevice, const TCHAR* pSceneName, SMSeqData* pSeqData);

	//XV
	int Transform(LPDIRECT3DDEVICE9 pD3DDevice, D3DXVECTOR3 camVector, float rollAngle);

	//`
	int Draw(LPDIRECT3DDEVICE9 pD3DDevice);

	//
	void Release();

	//t`bN^Co^
	void SetCurTickTime(unsigned long curTickTime);

	//Zbg
	void Reset();

	//݈ʒu擾
	float GetPos();

	//ړxNg擾
	D3DXVECTOR3 GetMoveVector();

private:

	DXPrimitive m_PrimitiveLine;
	float m_CurPos;
	MTNoteDesignRing m_NoteDesign;

	unsigned long m_CurTickTime;

	//_obt@\
	struct MTTIMEINDICATOR_VERTEX {
		D3DXVECTOR3 p;	//_W
		D3DXVECTOR3 n;	//@
		DWORD		c;	//fBt[YF
	};

	//_obt@FVFtH[}bg
	DWORD _GetFVFFormat(){ return (D3DFVF_XYZ | D3DFVF_NORMAL | D3DFVF_DIFFUSE); }

	int _CreatePrimitiveLine(LPDIRECT3DDEVICE9 pD3DDevice);
	int _CreateVertexOfIndicatorLine(MTTIMEINDICATOR_VERTEX* pVertex, unsigned long* pIndex);

};


