//******************************************************************************
//
// MIDITrail / MTNoteBoxMod
//
// m[g{bNX`ModNX
//
// Copyright (C) 2012 Yossiepon Oniichan. All Rights Reserved.
//
//******************************************************************************

#pragma once

#include "MTNoteBox.h"
#include "MTNoteDesignMod.h"


//******************************************************************************
// p[^`
//******************************************************************************
//ő|[g
#define MT_NOTEBOX_MAX_PORT_NUM  (8)


//******************************************************************************
// m[g{bNX`ModNX
//******************************************************************************
class MTNoteBoxMod : public MTNoteBox
{
public:

	//RXgN^^fXgN^
	MTNoteBoxMod(void);
	virtual ~MTNoteBoxMod(void);

	//
	virtual int Create(
			LPDIRECT3DDEVICE9 pD3DDevice,
			const TCHAR* pSceneName,
			SMSeqData* pSeqData,
			MTNotePitchBend* pNotePitchBend
		);

	//XV
	virtual int Transform(LPDIRECT3DDEVICE9 pD3DDevice, float rollAngle);

	//tԐݒ
	void SetPlayTimeMSec(unsigned long playTimeMsec);

	//
	virtual void Release();

	//Zbg
	virtual void Reset();

protected:

	//L[
	enum KeyStatus {
		BeforeNoteON,
		NoteON,
		AfterNoteOFF
	};

	//m[g\
	struct NoteStatusMod {
		bool isActive;
		bool isHide;
		unsigned long index;
		KeyStatus keyStatus;
		float keyDownRate;
	};

	//m[gXg
	SMNoteList m_NoteListRT;

	//m[gǗ
	unsigned long m_PlayTimeMSec;
	float m_KeyDownRate[MT_NOTEBOX_MAX_PORT_NUM][SM_MAX_CH_NUM][SM_MAX_NOTE_NUM];

	//m[gfUC
	MTNoteDesignMod *m_pNoteDesignMod;

	//m[gԏ
	NoteStatusMod* m_pNoteStatusMod;

	virtual int _UpdateStatusOfActiveNotes(LPDIRECT3DDEVICE9 pD3DDevice);
	virtual int _UpdateVertexOfActiveNotes(LPDIRECT3DDEVICE9 pD3DDevice);

	virtual int _CreateNoteDesign();
	virtual int _CreateNoteStatus();

	int _CreateVertexOfNote(
			SMNote note,
			MTNOTEBOX_VERTEX* pVertex,
			unsigned long vertexOffset,
			unsigned long* pIbIndex,
			float keyDownRate = 0.0f,
			bool isEnablePitchBend = false
		);

	int _UpdateNoteStatus(
			unsigned long playTimeMSec,
			unsigned long decayDuration,
			unsigned long releaseDuration,
			SMNote note,
			NoteStatusMod* pNoteStatus
		);
};


