//******************************************************************************
//
// MIDITrail / MTNoteDesignRingMod
//
// m[gfUCOModNX
//
// Copyright (C) 2019 Yossiepon Oniichan. All Rights Reserved.
//
//******************************************************************************

#pragma once

#include "MTNoteDesignMod.h"
#include "MTNoteDesignRing.h"

using namespace SMIDILib;


//******************************************************************************
// m[gfUCOModNX
//******************************************************************************
class MTNoteDesignRingMod : public MTNoteDesignMod, public MTNoteDesignRing
{
public:

	//RXgN^^fXgN^
	MTNoteDesignRingMod(void);
	virtual ~MTNoteDesignRingMod(void);

	virtual int Initialize(const TCHAR* pSceneName, SMSeqData* pSeqData);

	//m[g{bNXSW擾
	virtual D3DXVECTOR3 GetNoteBoxCenterPosX(
		unsigned long curTickTime,
		unsigned char portNo,
		unsigned char chNo,
		unsigned char noteNo,
		short pitchBendValue = 0,				//ȗFsb`xh
		unsigned char pitchBendSensitivity = 0	//ȗFsb`xhx
	);

	//m[g{bNX_W擾
	virtual void GetNoteBoxVirtexPos(
		unsigned long curTickTime,
		unsigned char portNo,
		unsigned char chNo,
		unsigned char noteNo,
		D3DXVECTOR3* pVector0,	//YZ+Xč
		D3DXVECTOR3* pVector1,	//YZ+XĉE
		D3DXVECTOR3* pVector2,	//YZ+Xč
		D3DXVECTOR3* pVector3,	//YZ+XĉE
		short pitchBendValue = 0,				//ȗFsb`xh
		unsigned char pitchBendSensitivity = 0	//ȗFsb`xhx
	);

	//m[g{bNX_W擾
	virtual void GetActiveNoteBoxVirtexPos(
		unsigned long curTickTime,
		unsigned char portNo,
		unsigned char chNo,
		unsigned char noteNo,
		D3DXVECTOR3* pVector0,	//YZ+Xč
		D3DXVECTOR3* pVector1,	//YZ+XĉE
		D3DXVECTOR3* pVector2,	//YZ+Xč
		D3DXVECTOR3* pVector3,	//YZ+XĉE
		short pitchBendValue = 0,				//ȗFsb`xh
		unsigned char pitchBendSensitivity = 0,	//ȗFsb`xhx
		unsigned long elapsedTime = 0            //ȗFoߎԁi~bj
	);

	//m[g{bNX_W擾
	virtual void GetActiveNoteBoxVirtexPos(
		unsigned long curTickTime,
		unsigned char portNo,
		unsigned char chNo,
		unsigned char noteNo,
		D3DXVECTOR3* pVector0,	//YZ+Xč
		D3DXVECTOR3* pVector1,	//YZ+XĉE
		D3DXVECTOR3* pVector2,	//YZ+Xč
		D3DXVECTOR3* pVector3,	//YZ+XĉE
		short pitchBendValue = 0,				//ȗFsb`xh
		unsigned char pitchBendSensitivity = 0,	//ȗFsb`xhx
		float rate = 0.0f						//ȗFTCY䗦
	);

	//Cuj^pm[g{bNX_W擾
	virtual void GetNoteBoxVirtexPosLive(
		unsigned long elapsedTime,	//oߎԁi~bj
		unsigned char portNo,
		unsigned char chNo,
		unsigned char noteNo,
		D3DXVECTOR3* pVector0,	//YZ+Xč
		D3DXVECTOR3* pVector1,	//YZ+XĉE
		D3DXVECTOR3* pVector2,	//YZ+Xč
		D3DXVECTOR3* pVector3,	//YZ+XĉE
		short pitchBendValue = 0,				//ȗFsb`xh
		unsigned char pitchBendSensitivity = 0	//ȗFsb`xhx
	);

	//|[g_W擾
	virtual float GetPortOriginY(unsigned char portNo);
	virtual float GetPortOriginZ(unsigned char portNo);

	//EWzuړxNg擾
	virtual D3DXVECTOR3 GetWorldMoveVector();

private:

	virtual int _LoadConfFile(const TCHAR* pSceneName);
};


