//******************************************************************************
//
// MIDITrail / MTPianoKeyboardCtrl
//
// sAmL[{[hNX
//
// Copyright (C) 2010-2013 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#include "StdAfx.h"
#include "YNBaseLib.h"
#include "MTPianoKeyboard.h"
#include "MTPianoKeyboardCtrl.h"

using namespace YNBaseLib;


//******************************************************************************
// p[^`
//******************************************************************************
#define MTPIANOKEYBOARD_MAX_ACTIVENOTE_NUM (256)


//******************************************************************************
// RXgN^
//******************************************************************************
MTPianoKeyboardCtrl::MTPianoKeyboardCtrl(void)
{
	unsigned char chNo = 0;

	for (chNo = 0; chNo < SM_MAX_CH_NUM; chNo++) {
		m_pPianoKeyboard[chNo] = NULL;
	}
	m_PlayTimeMSec = 0;
	m_CurTickTime = 0;
	m_CurNoteIndex = 0;
	m_pNoteStatus = NULL;
	m_isEnable = true;
	m_isSkipping = false;
	m_isSingleKeyboard = false;
	ZeroMemory(m_KeyDownRate, sizeof(float) * SM_MAX_CH_NUM * SM_MAX_NOTE_NUM);
}

//******************************************************************************
// fXgN^
//******************************************************************************
MTPianoKeyboardCtrl::~MTPianoKeyboardCtrl(void)
{
	Release();
}

//******************************************************************************
// 
//******************************************************************************
int MTPianoKeyboardCtrl::Create(
		LPDIRECT3DDEVICE9 pD3DDevice,
		const TCHAR* pSceneName,
		SMSeqData* pSeqData,
		MTNotePitchBend* pNotePitchBend,
		bool isSingleKeyboard
	)
{
	int result = 0;
	SMTrack track;

	Release();

	if (pSeqData == NULL) {
		result = YN_SET_ERR("Program error.", 0, 0);
		goto EXIT;
	}

	//m[gfUCIuWFNg
	result = m_NoteDesign.Initialize(pSceneName, pSeqData);
	if (result != 0) goto EXIT;

	//L[{[hfUC
	result = m_KeyboardDesign.Initialize(pSceneName, pSeqData);
	if (result != 0) goto EXIT;

	//gbN擾
	result = pSeqData->GetMergedTrack(&track);
	if (result != 0) goto EXIT;

	//m[gXg擾FstartTime, endTime ̓A^C(msec)
	result = track.GetNoteListWithRealTime(&m_NoteListRT, pSeqData->GetTimeDivision());
	if (result != 0) goto EXIT;

	//m[gz񐶐
	result = _CreateNoteStatus();
	if (result != 0) goto EXIT;

	//L[{[h
	result = _CreateKeyboards(pD3DDevice, pSceneName, pSeqData);
	if (result != 0) goto EXIT;

	//sb`xh
	m_pNotePitchBend = pNotePitchBend;

	//VOL[{[htO
	m_isSingleKeyboard = isSingleKeyboard;

EXIT:;
	return result;
}

//******************************************************************************
// m[gz񐶐
//******************************************************************************
int MTPianoKeyboardCtrl::_CreateNoteStatus()
{
	int result = 0;
	unsigned long i = 0;

	//m[gz񐶐
	try {
		m_pNoteStatus = new NoteStatus[MTPIANOKEYBOARD_MAX_ACTIVENOTE_NUM];
	}
	catch (std::bad_alloc) {
		result = YN_SET_ERR("Could not allocate memory.", 0, 0);
		goto EXIT;
	}

	//m[gԃXg
	for (i = 0; i < MTPIANOKEYBOARD_MAX_ACTIVENOTE_NUM; i++) {
		m_pNoteStatus[i].isActive = false;
		m_pNoteStatus[i].keyStatus = BeforeNoteON;
		m_pNoteStatus[i].index = 0;
		m_pNoteStatus[i].keyDownRate = 0.0f;
	}

EXIT:;
	return result;
}

//******************************************************************************
// L[{[h`IuWFNg
//******************************************************************************
int MTPianoKeyboardCtrl::_CreateKeyboards(
		LPDIRECT3DDEVICE9 pD3DDevice,
		const TCHAR* pSceneName,
		SMSeqData* pSeqData
	)
{
	int result = 0;
	unsigned char chNo = 0;
	LPDIRECT3DTEXTURE9 pTexture = NULL;

	for (chNo = 0; chNo < SM_MAX_CH_NUM; chNo++) {
		try {
			m_pPianoKeyboard[chNo] = new MTPianoKeyboard;
		}
		catch (std::bad_alloc) {
			result = YN_SET_ERR("Could not allocate memory.", 0, 0);
			goto EXIT;
		}

		result = m_pPianoKeyboard[chNo]->Create(pD3DDevice, pSceneName, pSeqData, pTexture);
		if (result != 0) goto EXIT;

		//擪IuWFNgō쐬eNX`ėp
		pTexture = m_pPianoKeyboard[chNo]->GetTexture();
	}

EXIT:;
	return result;
}

//******************************************************************************
// ړ
//******************************************************************************
int MTPianoKeyboardCtrl::Transform(
		LPDIRECT3DDEVICE9 pD3DDevice,
		float rollAngle
	)
{
	int result = 0;
	unsigned char portNo = 0;
	unsigned char chNo = 0;
	D3DXVECTOR3 moveVector;

	//ݔm[g̒_XV
	result = _TransformActiveNotes(pD3DDevice);
	if (result != 0) goto EXIT;

	//eL[{[ḧړ
	for (chNo = 0; chNo < SM_MAX_CH_NUM; chNo++) {

		//ړxNgFL[{[hW
		moveVector = m_KeyboardDesign.GetKeyboardBasePos(portNo, chNo);

		//ړxNgFsb`xhVtg𔽉f
		moveVector.x += _GetPichBendShiftPosX(portNo, chNo);

		//ړxNgFĐʂɒǏ]
		moveVector.y += m_NoteDesign.GetPlayPosX(m_CurTickTime);

		//L[{[hړ
		result = m_pPianoKeyboard[chNo]->Transform(pD3DDevice, moveVector, rollAngle);
		if (result != 0) goto EXIT;
	}

EXIT:;
	return result;
}

//******************************************************************************
// m[g̒_
//******************************************************************************
int MTPianoKeyboardCtrl::_TransformActiveNotes(
		LPDIRECT3DDEVICE9 pD3DDevice
	)
{
	int result = 0;

	//XLbvȂ牽Ȃ
	if (m_isSkipping) goto EXIT;

	//m[g̏ԍXV
	result = _UpdateStatusOfActiveNotes(pD3DDevice);
	if (result != 0) goto EXIT;

	//m[g̒_XV
	result = _UpdateVertexOfActiveNotes(pD3DDevice);
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// m[g̏ԍXV
//******************************************************************************
int MTPianoKeyboardCtrl::_UpdateStatusOfActiveNotes(
		LPDIRECT3DDEVICE9 pD3DDevice
	)
{
	int result = 0;
	unsigned long i = 0;
	unsigned long keyDownDuration = 0;
	unsigned long keyUpDuration = 0;
	bool isFound = false;
	bool isRegist = false;
	SMNote note;

	//L[㏸~(msec)
	keyDownDuration = m_KeyboardDesign.GetKeyDownDuration();
	keyUpDuration   = m_KeyboardDesign.GetKeyUpDuration();

	//m[gXV
	for (i = 0; i < MTPIANOKEYBOARD_MAX_ACTIVENOTE_NUM; i++) {
		if (m_pNoteStatus[i].isActive) {
			//m[g擾
			result = m_NoteListRT.GetNote(m_pNoteStatus[i].index, &note);
			if (result != 0) goto EXIT;

			//m[gԍXV
			result = _UpdateNoteStatus(
							m_PlayTimeMSec,
							keyDownDuration,
							keyUpDuration,
							note,
							&(m_pNoteStatus[i])
						);
			if (result != 0) goto EXIT;
		}
	}

	//O񌟍Iʒu甭Jnm[g
	while (m_CurNoteIndex < m_NoteListRT.GetSize()) {
		//m[g擾
		result = m_NoteListRT.GetNote(m_CurNoteIndex, &note);
		if (result != 0) goto EXIT;

		//tԂL[JnԁiJnOjɂǂĂȂΌI
		if (note.startTime > keyDownDuration) {
			if (m_PlayTimeMSec < (note.startTime - keyDownDuration)) break;
		}

		//m[go^
		isRegist = false;
		if (note.startTime < keyDownDuration) {
			isRegist = true;
		}
		else if (((note.startTime - keyDownDuration) <= m_PlayTimeMSec)
		      && (m_PlayTimeMSec <= (note.endTime + keyUpDuration))) {
			isRegist = true;
		}

		//m[go^
		//  L[~^㏸̏o^ΏۂƂĂ邽
		//  m[gŕGgꍇ邱Ƃɒӂ
		if (isRegist) {
			//łɓCfbNXœo^ς݂̏ꍇ͉Ȃ
			isFound = false;
			for (i = 0; i < MTPIANOKEYBOARD_MAX_ACTIVENOTE_NUM; i++) {
				if ((m_pNoteStatus[i].isActive)
				 && (m_pNoteStatus[i].index == m_CurNoteIndex)) {
					isFound = true;
					break;
				}
			}
			//󂢂ĂƂɒǉ
			if (!isFound) {
				for (i = 0; i < MTPIANOKEYBOARD_MAX_ACTIVENOTE_NUM; i++) {
					if (!(m_pNoteStatus[i].isActive)) {
						m_pNoteStatus[i].isActive = true;
						m_pNoteStatus[i].keyStatus = BeforeNoteON;
						m_pNoteStatus[i].index = m_CurNoteIndex;
						m_pNoteStatus[i].keyDownRate = 0.0f;
						break;
					}
				}
			}
			//m[gԍXV
			result = _UpdateNoteStatus(
							m_PlayTimeMSec,
							keyDownDuration,
							keyUpDuration,
							note,
							&(m_pNoteStatus[i])
						);
			if (result != 0) goto EXIT;
		}
		m_CurNoteIndex++;
	}

EXIT:;
	return result;
}

//******************************************************************************
// m[gԍXV
//******************************************************************************
int MTPianoKeyboardCtrl::_UpdateNoteStatus(
		unsigned long playTimeMSec,
		unsigned long keyDownDuration,
		unsigned long keyUpDuration,
		SMNote note,
		NoteStatus* pNoteStatus
	)
{
	int result= 0;
	unsigned char targetChNo = 0;

	//m[gONOiL[~j
	if (playTimeMSec < note.startTime) {
		pNoteStatus->keyStatus = BeforeNoteON;
		if (keyDownDuration == 0) {
			pNoteStatus->keyDownRate = 0.0f;
		}
		else {
			pNoteStatus->keyDownRate = 1.0f - ((float)(note.startTime - playTimeMSec) / (float)keyDownDuration);
		}
	}
	//m[gONOFF܂
	else if ((note.startTime <= playTimeMSec) && (playTimeMSec <= note.endTime)) {
		pNoteStatus->keyStatus = NoteON;
		pNoteStatus->keyDownRate = 1.0f;
	}
	//m[gOFFiL[㏸j
	else if ((note.endTime < playTimeMSec) && (playTimeMSec <= (note.endTime + keyUpDuration))) {
		pNoteStatus->keyStatus = AfterNoteOFF;
		if (keyUpDuration == 0) {
			pNoteStatus->keyDownRate = 0.0f;
		}
		else {
			pNoteStatus->keyDownRate = 1.0f - ((float)(playTimeMSec - note.endTime) / (float)keyUpDuration);
		}
	}
	//m[gOFFiL[Aς݁j
	else {
		//m[gj
		//TODO: |[gΉ
		if (note.portNo == 0) {
			//VOL[{[hł͕`l̃L[Ԃ擪`lɏW񂷂
			targetChNo = note.chNo;
			if (m_isSingleKeyboard) {
				targetChNo = 0;
			}
			result = m_pPianoKeyboard[targetChNo]->ResetKey(note.noteNo);
			if (result != 0) goto EXIT;
		}
		pNoteStatus->isActive = false;
		pNoteStatus->keyStatus = BeforeNoteON;
		pNoteStatus->index = 0;
		pNoteStatus->keyDownRate = 0.0f;
	}

EXIT:;
	return result;
}

//******************************************************************************
// m[g̒_XV
//******************************************************************************
int MTPianoKeyboardCtrl::_UpdateVertexOfActiveNotes(
		LPDIRECT3DDEVICE9 pD3DDevice
	)
{
	int result = 0;
	unsigned long i = 0;
	unsigned long elapsedTime = 0;
	SMNote note;
	unsigned char targetChNo = 0;
	D3DXCOLOR noteColor;

	ZeroMemory(m_KeyDownRate, sizeof(float) * SM_MAX_CH_NUM * SM_MAX_NOTE_NUM);

	//m[gɂĒ_XV
	for (i = 0; i < MTPIANOKEYBOARD_MAX_ACTIVENOTE_NUM; i++) {
		//łȂ΃XLbv
		if (!(m_pNoteStatus[i].isActive)) continue;

		//m[g擾
		result = m_NoteListRT.GetNote(m_pNoteStatus[i].index, &note);
		if (result != 0) goto EXIT;

		//Jňoߎ
		elapsedTime = 0;
		if (m_pNoteStatus[i].keyStatus == NoteON) {
			elapsedTime = m_PlayTimeMSec - note.startTime;
		}

		//L[̏ԍXV
		//  TODO: |[gΉ
		if (note.portNo == 0) {
			//VOL[{[hł͕`l̃L[Ԃ擪`lɏW񂷂
			targetChNo = note.chNo;
			if (m_isSingleKeyboard) {
				targetChNo = 0;
			}
			
			//m[g̐F
			noteColor = m_NoteDesign.GetNoteBoxColor(note.portNo, note.chNo, note.noteNo);
			
			//ΏۃL[]
			//  łɓm[gɑ΂Ē_XVĂꍇ
			//  OꍇɌ蒸_XV
			if (m_KeyDownRate[targetChNo][note.noteNo] < m_pNoteStatus[i].keyDownRate) {
				result = m_pPianoKeyboard[targetChNo]->PushKey(
														note.noteNo,
														m_pNoteStatus[i].keyDownRate,
														elapsedTime,
														&noteColor
													);
				if (result != 0) goto EXIT;
				m_KeyDownRate[targetChNo][note.noteNo] = m_pNoteStatus[i].keyDownRate;
			}
		}
	}

EXIT:;
	return result;
}

//******************************************************************************
// `
//******************************************************************************
int MTPianoKeyboardCtrl::Draw(
		LPDIRECT3DDEVICE9 pD3DDevice
   )
{
	int result = 0;
	unsigned char chNo = 0;
	unsigned long count = 0;
	unsigned long dispNum = 0;

	if (!m_isEnable) goto EXIT;

	//L[{[hő\
	dispNum = SM_MAX_CH_NUM;
	if (m_KeyboardDesign.GetKeyboardMaxDispNum() < dispNum) {
		dispNum = m_KeyboardDesign.GetKeyboardMaxDispNum();
	}

	//L[{[h̕`
	for (chNo = 0; chNo < SM_MAX_CH_NUM; chNo++) {
		//L[{[h\̐mF
		count++;
		if (dispNum < count) break;

		//L[{[h`
		result = m_pPianoKeyboard[chNo]->Draw(pD3DDevice);
		if (result != 0) goto EXIT;
	}

EXIT:;
	return result;
}

//******************************************************************************
// sb`xhfFL[{[hVtg
//******************************************************************************
float MTPianoKeyboardCtrl::_GetPichBendShiftPosX(
		unsigned char portNo,
		unsigned char chNo
	)
{
	float shift = 0.0f;
	short pitchBendValue = 0;
	unsigned char pitchBendSensitivity = SM_DEFAULT_PITCHBEND_SENSITIVITY;

	//`l̃sb`xh
	pitchBendValue =       m_pNotePitchBend->GetValue(portNo, chNo);
	pitchBendSensitivity = m_pNotePitchBend->GetSensitivity(portNo, chNo);

	//sb`xhɂL[{[hVtg
	shift = m_KeyboardDesign.GetPitchBendShift(pitchBendValue, pitchBendSensitivity);

	return shift;
}

//******************************************************************************
// 
//******************************************************************************
void MTPianoKeyboardCtrl::Release()
{
	unsigned char chNo = 0;

	for (chNo = 0; chNo < SM_MAX_CH_NUM; chNo++) {
		if (m_pPianoKeyboard[chNo] != NULL) {
			m_pPianoKeyboard[chNo]->Release();
			delete m_pPianoKeyboard[chNo];
			m_pPianoKeyboard[chNo] = NULL;
		}
	}

// >>> modify 20120728 yossiepon begin
	//20120728 yossiepon: delete  delete[] ɏC
	delete[] m_pNoteStatus;
	m_pNoteStatus = NULL;
// <<< modify 20120728 yossiepon end
}

//******************************************************************************
// Jg`bN^Cݒ
//******************************************************************************
void MTPianoKeyboardCtrl::SetCurTickTime(
		unsigned long curTickTime
	)
{
	m_CurTickTime = curTickTime;
}

//******************************************************************************
// tԐݒ
//******************************************************************************
void MTPianoKeyboardCtrl::SetPlayTimeMSec(
		unsigned long playTimeMsec
	)
{
	m_PlayTimeMSec = playTimeMsec;
}

//******************************************************************************
// Zbg
//******************************************************************************
void MTPianoKeyboardCtrl::Reset()
{
	int result = 0;
	unsigned long i = 0;
	SMNote note;
	unsigned char targetChNo = 0;

	m_PlayTimeMSec = 0;
	m_CurTickTime = 0;
	m_CurNoteIndex = 0;

	for (i = 0; i < MTPIANOKEYBOARD_MAX_ACTIVENOTE_NUM; i++) {
		if (m_pNoteStatus[i].isActive) {
			result = m_NoteListRT.GetNote(m_pNoteStatus[i].index, &note);
			//if (result != 0) goto EXIT;

			//TODO: |[gΉ
			if (note.portNo == 0) {
				//VOL[{[hł͕`l̃L[Ԃ擪`lɏW񂷂
				targetChNo = note.chNo;
				if (m_isSingleKeyboard) {
					targetChNo = 0;
				}
				result = m_pPianoKeyboard[targetChNo]->ResetKey(note.noteNo);
				//if (result != 0) goto EXIT;
			}
		}
		m_pNoteStatus[i].isActive = false;
		m_pNoteStatus[i].keyStatus = BeforeNoteON;
		m_pNoteStatus[i].index = 0;
		m_pNoteStatus[i].keyDownRate = 0.0f;
	}

	return;
}

//******************************************************************************
// \ݒ
//******************************************************************************
void MTPianoKeyboardCtrl::SetEnable(
		bool isEnable
	)
{
	m_isEnable = isEnable;
}

//******************************************************************************
// XLbvԐݒ
//******************************************************************************
void MTPianoKeyboardCtrl::SetSkipStatus(
		bool isSkipping
	)
{
	m_isSkipping = isSkipping;
}


