//******************************************************************************
//
// MIDITrail / MTScenePianoRollRingMod
//
// sAm[OV[`ModNX
//
// Copyright (C) 2019 Yossiepon Oniichan. All Rights Reserved.
//
//******************************************************************************

#include "stdafx.h"
#include <windows.h>
#include <mmsystem.h>
#include "Commdlg.h"
#include "YNBaseLib.h"
#include "DXColorUtil.h"
#include "MTConfFile.h"
#include "MTScenePianoRollRingMod.h"

using namespace YNBaseLib;


//******************************************************************************
// RXgN^
//******************************************************************************
MTScenePianoRollRingMod::MTScenePianoRollRingMod()
{
}

//******************************************************************************
// fXgN^
//******************************************************************************
MTScenePianoRollRingMod::~MTScenePianoRollRingMod()
{
	Release();
}

//******************************************************************************
// ̎擾
//******************************************************************************
const TCHAR* MTScenePianoRollRingMod::GetName()
{
	return _T("PianoRollRing");
}

//******************************************************************************
// V[
//******************************************************************************
int MTScenePianoRollRingMod::Create(
		HWND hWnd,
		LPDIRECT3DDEVICE9 pD3DDevice,
		SMSeqData* pSeqData
	)
{
	int result = 0;

	Release();

	//NX̃V[Ăяo
	result = MTScenePianoRollRing::Create(hWnd, pD3DDevice, pSeqData);
	if (result != 0) goto EXIT;

	//----------------------------------
	// `IuWFNg
	//----------------------------------
	//m[g{bNX
	result = m_NoteBoxMod.Create(pD3DDevice, GetName(), pSeqData, &m_NotePitchBend);
	if (result != 0) goto EXIT;

	//m[gg䐶
	result = m_NoteRippleMod.Create(pD3DDevice, GetName(), pSeqData, &m_NotePitchBend);
	if (result != 0) goto EXIT;

	//ObhO
	result = m_GridRingMod.Create(pD3DDevice, GetName(), pSeqData);
	if (result != 0) goto EXIT;

	//^CCWP[^
	result = m_TimeIndicatorMod.Create(pD3DDevice, GetName(), pSeqData);
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// ϊ
//******************************************************************************
int MTScenePianoRollRingMod::Transform(
		LPDIRECT3DDEVICE9 pD3DDevice
	)
{
	int result = 0;
	float rollAngle = 0.0f;
	D3DXVECTOR3 camVector;

	//NX̕ϊĂяo
	result = MTScenePianoRollRing::Transform(pD3DDevice);
	if (result != 0) goto EXIT;

	//JW擾
	m_FirstPersonCam.GetPosition(&camVector);

	//]px擾
	rollAngle = m_FirstPersonCam.GetManualRollAngle();

	//m[g{bNXXV
	result = m_NoteBoxMod.Transform(pD3DDevice, rollAngle);
	if (result != 0) goto EXIT;

	//ObhOXV
	result = m_GridRingMod.Transform(pD3DDevice, rollAngle);
	if (result != 0) goto EXIT;

	//^CCWP[^XV
	result = m_TimeIndicatorMod.Transform(pD3DDevice, camVector, rollAngle);
	if (result != 0) goto EXIT;

	//m[ggXV
	result = m_NoteRippleMod.Transform(pD3DDevice, camVector, rollAngle);
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// `
//******************************************************************************
int MTScenePianoRollRingMod::Draw(
		LPDIRECT3DDEVICE9 pD3DDevice
	)
{
	int result = 0;

	if (pD3DDevice == NULL) {
		result = YN_SET_ERR("Program error.", 0, 0);
		goto EXIT;
	}

	//XV
	result = Transform(pD3DDevice);
	if (result != 0) goto EXIT;

	//wi摜`
	result = m_BackgroundImage.Draw(pD3DDevice);
	if (result != 0) goto EXIT;

	//ObhO`
	result = m_GridRingMod.Draw(pD3DDevice);
	if (result != 0) goto EXIT;

	//m[g{bNX`
	result = m_NoteBoxMod.Draw(pD3DDevice);
	if (result != 0) goto EXIT;

	//sN`{[h`
	result = m_PictBoard.Draw(pD3DDevice);
	if (result != 0) goto EXIT;

	//`
	result = m_Stars.Draw(pD3DDevice);
	if (result != 0) goto EXIT;

	//bV`
	result = m_MeshCtrl.Draw(pD3DDevice);
	if (result != 0) goto EXIT;

	//^CCWP[^`
	result = m_TimeIndicatorMod.Draw(pD3DDevice);
	if (result != 0) goto EXIT;

	//m[gg`
	result = m_NoteRippleMod.Draw(pD3DDevice);
	if (result != 0) goto EXIT;

	//_bV{[h`FWϊςݒ_p邽߈ԍŌɕ`悷
	result = m_Dashboard.Draw(pD3DDevice);
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// j
//******************************************************************************
void MTScenePianoRollRingMod::Release()
{
	m_NoteBoxMod.Release();
	m_GridRingMod.Release();
	m_TimeIndicatorMod.Release();
	m_NoteRippleMod.Release();

	MTScenePianoRollRing::Release();
}

//******************************************************************************
// V[PTbZ[WM
//******************************************************************************
int MTScenePianoRollRingMod::OnRecvSequencerMsg(
	unsigned long param1,
	unsigned long param2
)
{
	int result = 0;
	SMMsgParser parser;

	parser.Parse(param1, param2);

	//tԒʒm
	if (parser.GetMsg() == SMMsgParser::MsgPlayStatus) {
		if (parser.GetPlayStatus() == SMMsgParser::StatusStop) {
			//~iIj
		}
		else if (parser.GetPlayStatus() == SMMsgParser::StatusPlay) {
			//t
		}
		else if (parser.GetPlayStatus() == SMMsgParser::StatusPause) {
			//ꎞ~
		}
	}
	//t`bN^Cʒm
	else if (parser.GetMsg() == SMMsgParser::MsgPlayTime) {
		m_Dashboard.SetPlayTimeMSec(parser.GetPlayTimeMSec());
		m_FirstPersonCam.SetCurTickTime(parser.GetPlayTickTime());
		// Viewpoint̓ǂݏɎxႪôŁAm_TimeIndicator ɂʒm
		m_TimeIndicator.SetCurTickTime(parser.GetPlayTickTime());
		m_TimeIndicatorMod.SetCurTickTime(parser.GetPlayTickTime());
		m_NoteRippleMod.SetPlayTimeMSec(parser.GetPlayTimeMSec());
		m_NoteRippleMod.SetCurTickTime(parser.GetPlayTickTime());
		m_PictBoard.SetCurTickTime(parser.GetPlayTickTime());
		m_NoteBoxMod.SetPlayTimeMSec(parser.GetPlayTimeMSec());
		m_NoteBoxMod.SetCurTickTime(parser.GetPlayTickTime());
	}
	//e|ύXʒm
	else if (parser.GetMsg() == SMMsgParser::MsgTempo) {
		m_Dashboard.SetTempoBPM(parser.GetTempoBPM());
	}
	//ߔԍʒm
	else if (parser.GetMsg() == SMMsgParser::MsgBar) {
		m_Dashboard.SetBarNo(parser.GetBarNo());
	}
	//qLύXʒm
	else if (parser.GetMsg() == SMMsgParser::MsgBeat) {
		m_Dashboard.SetBeat(parser.GetBeatNumerator(), parser.GetBeatDenominator());
	}
	//m[gOFFʒm
	else if (parser.GetMsg() == SMMsgParser::MsgNoteOff) {
		//m_NoteRippleMod.SetNoteOff(parser.GetPortNo(), parser.GetChNo(), parser.GetNoteNo());
	}
	//m[gONʒm
	else if (parser.GetMsg() == SMMsgParser::MsgNoteOn) {
		m_Dashboard.SetNoteOn();
		//m_NoteRippleMod.SetNoteOn(parser.GetPortNo(), parser.GetChNo(), parser.GetNoteNo(), parser.GetVelocity());
	}
	//sb`xhʒm
	else if (parser.GetMsg() == SMMsgParser::MsgPitchBend) {
		m_NotePitchBend.SetPitchBend(parser.GetPortNo(), parser.GetChNo(), parser.GetPitchBendValue(), parser.GetPitchBendSensitivity());
	}
	//XLbvJnʒm
	else if (parser.GetMsg() == SMMsgParser::MsgSkipStart) {
		if (parser.GetSkipStartDirection() == SMMsgParser::SkipBack) {
			m_NotePitchBend.Reset();
		}
		m_NoteBoxMod.Reset();
		m_NoteBoxMod.SetSkipStatus(true);
		m_NoteRippleMod.Reset();
		m_NoteRippleMod.SetSkipStatus(true);
		m_IsSkipping = true;
	}
	//XLbvIʒm
	else if (parser.GetMsg() == SMMsgParser::MsgSkipEnd) {
		m_Dashboard.SetNotesCount(parser.GetSkipEndNotesCount());
		m_NoteBoxMod.SetSkipStatus(false);
		m_NoteRippleMod.SetSkipStatus(false);
		m_IsSkipping = false;
	}

	//EXIT:;
	return result;
}

//******************************************************************************
// Zbg
//******************************************************************************
void MTScenePianoRollRingMod::_Reset()
{
	MTScenePianoRollRing::_Reset();

	m_TimeIndicatorMod.Reset();
	m_NoteBoxMod.Reset();
	m_NoteRippleMod.Reset();
}

//******************************************************************************
// \ʐݒ
//******************************************************************************
void MTScenePianoRollRingMod::SetEffect(
		MTScene::EffectType type,
		bool isEnable
	)
{
	switch (type) {
		case EffectRipple:
			m_NoteRippleMod.SetEnable(isEnable);
			break;
		case EffectTimeIndicator:
			m_TimeIndicatorMod.SetEnable(isEnable);
			break;
		case EffectGridBox:
			m_GridRingMod.SetEnable(isEnable);
			break;
		default:
			MTScenePianoRollRing::SetEffect(type, isEnable);
			break;
	}

	return;
}
