//******************************************************************************
//
// MIDITrail / MTTimeIndicator
//
// ^CCWP[^`NX
//
// Copyright (C) 2010-2013 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

// MEMO:
// uĐĂƂvwĐʂ`悷B

#pragma once

#include <d3d9.h>
#include <d3dx9.h>
#include "SMIDILib.h"
#include "DXPrimitive.h"
#include "MTNoteDesign.h"

using namespace SMIDILib;


//******************************************************************************
// ^CCWP[^`NX
//******************************************************************************
class MTTimeIndicator
{
public:

	//RXgN^^fXgN^
	MTTimeIndicator(void);
	virtual ~MTTimeIndicator(void);

	//
	int Create(LPDIRECT3DDEVICE9 pD3DDevice, const TCHAR* pSceneName, SMSeqData* pSeqData);

	//XV
	int Transform(LPDIRECT3DDEVICE9 pD3DDevice, D3DXVECTOR3 camVector, float rollAngle);

	//`
	int Draw(LPDIRECT3DDEVICE9 pD3DDevice);

	//
	void Release();

	//t`bN^Co^
	void SetCurTickTime(unsigned long curTickTime);

	//Zbg
	void Reset();

	//݈ʒu擾
	float GetPos();

	//ړxNg擾
	D3DXVECTOR3 GetMoveVector();

private:

	DXPrimitive m_Primitive;
	DXPrimitive m_PrimitiveLine;
	float m_CurPos;
	MTNoteDesign m_NoteDesign;
	bool m_isEnableLine;

	unsigned long m_CurTickTime;

	//_obt@\
	struct MTTIMEINDICATOR_VERTEX {
		D3DXVECTOR3 p;	//_W
		D3DXVECTOR3 n;	//@
		DWORD		c;	//fBt[YF
	};

	//_obt@FVFtH[}bg
	DWORD _GetFVFFormat(){ return (D3DFVF_XYZ | D3DFVF_NORMAL | D3DFVF_DIFFUSE); }

	int _CreatePrimitive(LPDIRECT3DDEVICE9 pD3DDevice);
	int _CreatePrimitiveLine(LPDIRECT3DDEVICE9 pD3DDevice);
	int _CreateVertexOfIndicator(MTTIMEINDICATOR_VERTEX* pVertex, unsigned long* pIbIndex);
	int _CreateVertexOfIndicatorLine(MTTIMEINDICATOR_VERTEX* pVertex);

};


