//******************************************************************************
//
// MIDITrail / MTGamePadCtrl
//
// Q[pbhNX
//
// Copyright (C) 2019 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

// MEMO:
// XInputpăQ[pbh̏Ԃ擾B

#pragma once

#include <XInput.h>


//******************************************************************************
// p[^`
//******************************************************************************

//gK[ON臒l(0-255)
#define MT_GAME_PAD_TRRIGER_ON_THRESHOLD		(250)


//******************************************************************************
// Q[pbhNX
//******************************************************************************
class MTGamePadCtrl
{
public:
	
	//RXgN^^fXgN^
	MTGamePadCtrl(void);
	virtual ~MTGamePadCtrl();
	
	//
	int Initialize(int userIndex);
	
	//ԍXV
	int UpdateState();
	
	//{^Ԏ擾
	bool GetState_DPadUp();
	bool GetState_DPadDown();
	bool GetState_DPadLeft();
	bool GetState_DPadRight();
	bool GetState_A();
	bool GetState_B();
	bool GetState_X();
	bool GetState_Y();
	bool GetState_LShoulder();
	bool GetState_RShoulder();
	bool GetState_LTrigger();
	bool GetState_RTrigger();
	bool GetState_Start();
	bool GetState_Back();
	
	//XeBbNԎ擾(0.0 - 1.0)
	float GetState_ThumbLX();
	float GetState_ThumbLY();
	float GetState_ThumbRX();
	float GetState_ThumbRY();
	
	//{^mF
	bool DidPressNow_A();
	bool DidPressNow_B();
	bool DidPressNow_X();
	bool DidPressNow_Y();
	bool DidPressNow_LShoulder();
	bool DidPressNow_RShoulder();
	bool DidPressNow_LTrigger();
	bool DidPressNow_RTrigger();
	bool DidPressNow_Start();
	bool DidPressNow_Back();
	
private:
	
	//[UCfbNX
	int m_UserIndex;
	
	//Q[pbhڑ
	bool m_isConnected;
	
	//Q[pbh
	XINPUT_GAMEPAD m_PrevGamePadState;
	XINPUT_GAMEPAD m_CurGamePadState;

	//XeBbN
	float m_ThumbLX;
	float m_ThumbLY;
	float m_ThumbRX;
	float m_ThumbRY;

	void _NormalizeLStickState();
	void _NormalizeRStickState();

};






