//******************************************************************************
//
// MIDITrail / MTGraphicCfgDlg
//
// OtBbNݒ_CAONX
//
// Copyright (C) 2010-2019 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#include "StdAfx.h"
#include "resource.h"
#include "Commdlg.h"
#include "MTParam.h"
#include "MTGraphicCfgDlg.h"


//******************************************************************************
// OtBbNݒ_CAONX p^`
//******************************************************************************
//m[gg嗦 ŏl/ől
#define MT_QNOTE_LENGTH_MAG_MIN		(0)
#define MT_QNOTE_LENGTH_MAG_MAX		(1000)

//******************************************************************************
// EBhEvV[Wpp[^ݒ
//******************************************************************************
MTGraphicCfgDlg* MTGraphicCfgDlg::m_pThis = NULL;

//******************************************************************************
// RXgN^
//******************************************************************************
MTGraphicCfgDlg::MTGraphicCfgDlg(void)
{
	unsigned long type = 0;

	m_pThis = this;
	m_hWnd = NULL;
	m_MultiSampleType = 0;
	m_hComboMultiSampleType = NULL;
	m_hEditImageFilePath = NULL;
	m_hEditQuarterNoteLengthMag = NULL;
	m_ImageFilePath[0] = _T('\0');
	m_QuarterNoteLengthMag = 100;
	m_isChanged = false;

	for (type = 0; type < DX_MULTI_SAMPLE_TYPE_MAX; type++) {
		m_MultSampleTypeSupport[type] = false;
	}

	return;
}

//******************************************************************************
// fXgN^
//******************************************************************************
MTGraphicCfgDlg::~MTGraphicCfgDlg(void)
{
}

//******************************************************************************
// EBhEvV[W
//******************************************************************************
INT_PTR CALLBACK MTGraphicCfgDlg::_WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	return m_pThis->_WndProcImpl(hWnd, message, wParam, lParam);
}

//******************************************************************************
// EBhEvV[WF
//******************************************************************************
INT_PTR MTGraphicCfgDlg::_WndProcImpl(
		HWND hDlg,
		UINT message,
		WPARAM wParam,
		LPARAM lParam
	)
{
	int result = 0;
	BOOL bresult = FALSE;

	UNREFERENCED_PARAMETER(lParam);

	switch (message) {
		case WM_INITDIALOG:
			result = _OnInitDlg(hDlg);
			if (result != 0) goto EXIT;
			bresult = TRUE;
			break;
		case WM_COMMAND:
			if (LOWORD(wParam) == IDOK) {
				result = _Save();
				if (result != 0) goto EXIT;
				EndDialog(hDlg, LOWORD(wParam));
				bresult = TRUE;
			}
			else if (LOWORD(wParam) == IDCANCEL) {
				EndDialog(hDlg, LOWORD(wParam));
				bresult = TRUE;
			}
			else if (LOWORD(wParam) == IDC_BTN_BROWSE) {
				result = _OnBtnBrowse();
				if (result != 0) goto EXIT;
			}
			break;
	}

EXIT:;
	if (result != 0) {
		YN_SHOW_ERR(hDlg);
	}
	return (INT_PTR)bresult;
}

//******************************************************************************
// A`GCAVOT|[gݒ
//******************************************************************************
void MTGraphicCfgDlg::SetAntialiasSupport(
		unsigned long multiSampleType,	//2-16
		bool isSupport
	)
{
	if ((DX_MULTI_SAMPLE_TYPE_MIN <= multiSampleType)
	 && (multiSampleType <= DX_MULTI_SAMPLE_TYPE_MAX)) {
		m_MultSampleTypeSupport[multiSampleType] = isSupport;
	}
	return;
}

//******************************************************************************
// \
//******************************************************************************
int MTGraphicCfgDlg::Show(
		HWND hParentWnd
	)
{
	int result = 0;
	INT_PTR dresult = 0;
	HINSTANCE hInstance = NULL;

	//AvP[VCX^Xnh擾
	hInstance = (HINSTANCE)(LONG_PTR)GetWindowLongPtr(hParentWnd, GWLP_HINSTANCE);
	if (hInstance == NULL) {
		result = YN_SET_ERR("Windows API error.", GetLastError(), (DWORD64)hParentWnd);
		goto EXIT;
	}

	//_CAO\
	dresult = DialogBox(
					hInstance,							//CX^Xnh
					MAKEINTRESOURCE(IDD_GRAPHIC_CFG),	//_CAO{bNXev[g
					hParentWnd,							//eEBhEnh
					_WndProc							//_CAO{bNXvV[W
				);
	if ((dresult == 0) || (dresult == -1)) {
		result = YN_SET_ERR("Windows API error.", GetLastError(), (DWORD64)hInstance);
		goto EXIT;
	}

EXIT:;
	return result;
}

//******************************************************************************
// _CAO\O
//******************************************************************************
int MTGraphicCfgDlg::_OnInitDlg(
		HWND hDlg
	)
{
	int result = 0;

	m_hWnd = hDlg;
	m_isChanged = false;

	//ݒt@C
	result = _InitConfFile();
	if (result != 0) goto EXIT;

	//ݒt@Cǂݍ
	result = _LoadConf();
	if (result != 0) goto EXIT;

	//}`TvʑIR{{bNX
	m_hComboMultiSampleType = GetDlgItem(hDlg, IDC_COMBO_MULTISAMPLETYPE);
	result = _InitComboMultiSampleType(m_hComboMultiSampleType, m_MultiSampleType);
	if (result != 0) goto EXIT;

	//wi摜t@CpX
	m_hEditImageFilePath = GetDlgItem(hDlg, IDC_EDIT_IMAGE_FILE_PATH);
	result = _InitBackgroundImageFilePath();
	if (result != 0) goto EXIT;

	//lg嗦
	m_hEditQuarterNoteLengthMag = GetDlgItem(hDlg, IDC_EDIT_QUARTER_NOTE_LENGTH_MAG);
	result = _InitQuarterNote();
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// ݒt@C
//******************************************************************************
int MTGraphicCfgDlg::_InitConfFile()
{
	int result = 0;
	TCHAR userConfFilePath[_MAX_PATH] = {_T('\0')};

	result = YNPathUtil::GetAppDataDirPath(userConfFilePath, _MAX_PATH);
	if (result != 0) goto EXIT;

	_tcscat_s(userConfFilePath, _MAX_PATH, MT_USER_CONFFILE_DIR);
	_tcscat_s(userConfFilePath, _MAX_PATH, MT_USER_CONFFILE_GRAPHIC);

	result = m_ConfFile.Initialize(userConfFilePath);
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// ݒt@Cǂݍ
//******************************************************************************
int MTGraphicCfgDlg::_LoadConf()
{
	int result = 0;
	int multiSampleType = 0;

	//A`GCAXݒl擾
	result = m_ConfFile.SetCurSection(_T("Anti-aliasing"));
	if (result != 0) goto EXIT;

	result = m_ConfFile.GetInt(
					_T("MultiSampleType"),
					&multiSampleType,
					MT_GRAPHIC_MULTI_SAMPLE_TYPE_DEF
				);
	if (result != 0) goto EXIT;

	//l̓A`GCAXOFFɂ
	if ((DX_MULTI_SAMPLE_TYPE_MIN <= multiSampleType)
	 && (multiSampleType <= DX_MULTI_SAMPLE_TYPE_MAX)) {
		m_MultiSampleType = multiSampleType;
	}
	else {
		m_MultiSampleType = 0;
	}

	//wi摜t@CpXݒl擾
	result = m_ConfFile.SetCurSection(_T("Background-image"));
	if (result != 0) goto EXIT;

	result = m_ConfFile.GetStr(_T("ImageFilePath"), m_ImageFilePath, _MAX_PATH, _T(""));
	if (result != 0) goto EXIT;

	//lg嗦ݒl擾
	result = m_ConfFile.SetCurSection(_T("QuarterNote"));
	if (result != 0) goto EXIT;
	
	result = m_ConfFile.GetInt(_T("LengthMagnification"), &m_QuarterNoteLengthMag, 100);
	if (result != 0) goto EXIT;
	
EXIT:;
	return result;
}

//******************************************************************************
// foCXIR{{bNX
//******************************************************************************
int MTGraphicCfgDlg::_InitComboMultiSampleType(
		HWND hCombo,
		unsigned long selMultiSampleType
	)
{
	int result = 0;
	LRESULT lresult = 0;
	int comboIndex = 0;
	int selectedIndex = -1;
	unsigned long type = 0;
	bool isSupportAA = false;
	TCHAR itemStr[256];

	//A`GCAVOT|[gmF
	for (type = DX_MULTI_SAMPLE_TYPE_MIN; type <= DX_MULTI_SAMPLE_TYPE_MAX; type++) {
		if (m_MultSampleTypeSupport[type]) {
			isSupportAA = true;
		}
	}

	//擪ڂo^
	if (isSupportAA) {
		_stprintf_s(itemStr, 256, _T("OFF"));
	}
	else {
		_stprintf_s(itemStr, 256, _T("Not supported"));
	}
	lresult = SendMessage(hCombo, CB_ADDSTRING, 0, (LPARAM)itemStr);
	if ((lresult == CB_ERR) || (lresult == CB_ERRSPACE)) {
		result = YN_SET_ERR("Windows API error.", GetLastError(), 0);
		goto EXIT;
	}
	lresult = SendMessage(hCombo, CB_SETITEMDATA, comboIndex, 0);
	if (lresult == CB_ERR) {
		result = YN_SET_ERR("Windows API error.", GetLastError(), (DWORD)comboIndex);
		goto EXIT;
	}
	selectedIndex = comboIndex;
	comboIndex++;

	//}`Tvʂǉo^
	for (type = DX_MULTI_SAMPLE_TYPE_MIN; type <= DX_MULTI_SAMPLE_TYPE_MAX; type++) {
		if (m_MultSampleTypeSupport[type]) {
			//}`TvOʂR{{bNXɒǉ
			_stprintf_s(itemStr, 256, _T("%dx"), type);
			lresult = SendMessage(hCombo, CB_ADDSTRING, 0, (LPARAM)itemStr);
			if ((lresult == CB_ERR) || (lresult == CB_ERRSPACE)) {
				result = YN_SET_ERR("Windows API error.", GetLastError(), 0);
				goto EXIT;
			}
			lresult = SendMessage(hCombo, CB_SETITEMDATA, comboIndex, type);
			if (lresult == CB_ERR) {
				result = YN_SET_ERR("Windows API error.", GetLastError(), (DWORD)comboIndex);
				goto EXIT;
			}
			if (type == selMultiSampleType) {
				selectedIndex = comboIndex;
			}
			comboIndex++;
		}
	}

	//IԐݒ
	lresult = SendMessage(hCombo, CB_SETCURSEL, selectedIndex, 0);
	if (lresult == CB_ERR) {
		result = YN_SET_ERR("Windows API error.", GetLastError(), selectedIndex);
		goto EXIT;
	}

	//A`GCAVOT|[gĂȂΕsɂ
	if (!isSupportAA) {
		EnableWindow(hCombo, FALSE);
	}

EXIT:;
	return result;
}

//******************************************************************************
// wi摜t@CpX
//******************************************************************************
int MTGraphicCfgDlg::_InitBackgroundImageFilePath()
{
	int result = 0;
	BOOL bresult = FALSE;

	//GfBbg{bNXɓ͉\ő啶ݒ
	SendMessage(m_hEditImageFilePath, EM_SETLIMITTEXT, (WPARAM)_MAX_PATH, 0);

	//GfBbg{bNXɃt@CpXݒ
	bresult = SetWindowText(m_hEditImageFilePath, m_ImageFilePath);
	if (!bresult) {
		result = YN_SET_ERR("Windows API error.", GetLastError(), 0);
		goto EXIT;
	}

EXIT:;
	return result;
}

//******************************************************************************
// lݒ菉
//******************************************************************************
int MTGraphicCfgDlg::_InitQuarterNote()
{
	int result = 0;
	BOOL bresult = FALSE;
	TCHAR str[32] = { _T('\0') };

	//GfBbg{bNXɓ͉\ő啶ݒFő4("1000")
	SendMessage(m_hEditQuarterNoteLengthMag, EM_SETLIMITTEXT, (WPARAM)4, 0);
	
	//GfBbg{bNXɎlg嗦̐lݒ
	_stprintf_s(str, 32, _T("%d"), m_QuarterNoteLengthMag);
	bresult = SetWindowText(m_hEditQuarterNoteLengthMag, str);
	if (!bresult) {
		result = YN_SET_ERR("Windows API error.", GetLastError(), m_QuarterNoteLengthMag);
		goto EXIT;
	}

EXIT:;
	return result;
}

//******************************************************************************
// ݒۑ
//******************************************************************************
int MTGraphicCfgDlg::_Save()
{
	int result = 0;
	int apiresult = 0;
	LRESULT lresult = 0;
	unsigned long selectedIndex = 0;
	unsigned long selectedMultiSampleType = 0;
	TCHAR filePath[_MAX_PATH] = {_T('\0')};
	TCHAR strMag[32] = { _T('\0') };
	int mag = 0;

	//------------------------------
	//A`GCAVO
	//------------------------------
	//Iڂ̃CfbNX擾
	lresult = SendMessage(m_hComboMultiSampleType, CB_GETCURSEL, 0, 0);
	if ((lresult == CB_ERR) || (lresult < 0)) {
		result = YN_SET_ERR("Windows API error.", GetLastError(), 0);
		goto EXIT;
	}
	selectedIndex = (unsigned long)lresult;

	//Iڂ̃[Uf[^擾F}`Tv
	lresult = SendMessage(m_hComboMultiSampleType, CB_GETITEMDATA, selectedIndex, 0);
	if (lresult == CB_ERR) {
		result = YN_SET_ERR("Windows API error.", GetLastError(), selectedIndex);
		goto EXIT;
	}
	selectedMultiSampleType = (unsigned long)lresult;

	//A`GCAXݒۑ
	result = m_ConfFile.SetCurSection(_T("Anti-aliasing"));
	if (result != 0) goto EXIT;
	result = m_ConfFile.SetInt(_T("MultiSampleType"), selectedMultiSampleType);
	if (result != 0) goto EXIT;

	//ύXmF
	if (m_MultiSampleType != selectedMultiSampleType) {
		m_isChanged = true;
	}
	m_MultiSampleType = selectedMultiSampleType;

	//------------------------------
	//wi摜t@CpX
	//------------------------------
	//wi摜t@CpXGfBbg{bNX擾
	apiresult = GetWindowText(m_hEditImageFilePath, filePath, _MAX_PATH);
	if (apiresult == 0) {
		//eLXg܂̓EBhEnh̏ꍇ
		filePath[0] = _T('\0');
	}

	//wi摜t@CpXݒۑ
	result = m_ConfFile.SetCurSection(_T("Background-image"));
	if (result != 0) goto EXIT;
	result = m_ConfFile.SetStr(_T("ImageFilePath"), filePath);
	if (result != 0) goto EXIT;

	//ύXmF
	if (_tcscmp(m_ImageFilePath, filePath) != 0) {
		m_isChanged = true;
	}
	_tcscpy_s(m_ImageFilePath, _MAX_PATH, filePath);
	
	//------------------------------
	//lg嗦
	//------------------------------
	//lg嗦擾
	apiresult = GetWindowText(m_hEditQuarterNoteLengthMag, strMag, 32);
	if (apiresult == 0) {
		//eLXg܂̓EBhEnh̏ꍇ
		mag = 100;
	}
	else {
		mag = _tstoi(strMag);
	}

	//NbsO
	if (mag < MT_QNOTE_LENGTH_MAG_MIN) {
		mag = MT_QNOTE_LENGTH_MAG_MIN;
	}
	if (mag > MT_QNOTE_LENGTH_MAG_MAX) {
		mag = MT_QNOTE_LENGTH_MAG_MAX;
	}
	
	//lg嗦ۑ
	result = m_ConfFile.SetCurSection(_T("QuarterNote"));
	if (result != 0) goto EXIT;
	result = m_ConfFile.SetInt(_T("LengthMagnification"), mag);
	if (result != 0) goto EXIT;

	//ύXmF
	if (m_QuarterNoteLengthMag != mag) {
		m_isChanged = true;
	}
	m_QuarterNoteLengthMag = mag;

EXIT:;
	return result;
}

//******************************************************************************
// p[^ύXmF
//******************************************************************************
bool MTGraphicCfgDlg::IsChanged()
{
	return m_isChanged;
}

//******************************************************************************
// wi摜t@CpX uEY{^
//******************************************************************************
int MTGraphicCfgDlg::_OnBtnBrowse()
{
	int result = 0;
	BOOL bresult = FALSE;
	TCHAR filePath[_MAX_PATH] = {_T('\0')};
	bool isSelected = false;

	//t@CI_CAO\
	result = _SelectImageFile(filePath, _MAX_PATH, &isSelected);
	if (result != 0) goto EXIT;

	//t@CȈꍇ͉Ȃ
	if (!isSelected) goto EXIT;

	//GfBbg{bNXɃt@CpXݒ
	bresult = SetWindowText(m_hEditImageFilePath, filePath);
	if (!bresult) {
		result = YN_SET_ERR("Windows API error.", GetLastError(), 0);
		goto EXIT;
	}

EXIT:;
	return result;
}

//******************************************************************************
// 摜t@CI
//******************************************************************************
int MTGraphicCfgDlg::_SelectImageFile(
		TCHAR* pFilePath,
		unsigned long bufSize,
		bool* pIsSelected
	)
{
	int result = 0;
	BOOL apiresult = FALSE;
	OPENFILENAME ofn;

	if ((pFilePath == NULL) || (bufSize == 0) || (pIsSelected ==NULL)) {
		result = YN_SET_ERR("Program error.", 0, 0);
		goto EXIT;
	}

	pFilePath[0] = _T('\0');
	ZeroMemory(&ofn, sizeof(OPENFILENAME));
	ofn.lStructSize = sizeof(OPENFILENAME);
	ofn.hwndOwner   = m_hWnd;
	ofn.lpstrFilter = _T("Image file (*.jpg *.png *.bmp)\0*.jpg;*.png;*.bmp\0");
	ofn.lpstrFile   = pFilePath;
	ofn.nMaxFile    = bufSize;
	ofn.lpstrTitle  = _T("Select image file.");
	ofn.Flags       = OFN_FILEMUSTEXIST;  //OFN_HIDEREADONLY

	//t@CI_CAO\
	apiresult = GetOpenFileName(&ofn);
	if (!apiresult) {
		//LZ܂̓G[FG[̓`FbNȂ
		*pIsSelected = false;
		goto EXIT;
	}

	*pIsSelected = true;

EXIT:;
	return result;
}

