//******************************************************************************
//
// MIDITrail / MTWindowSizeCfgDlg
//
// EBhETCYݒ_CAONX
//
// Copyright (C) 2010-2019 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#include "StdAfx.h"
#include "MTParam.h"
#include "MTWindowSizeCfgDlg.h"


//******************************************************************************
// EBhEvV[Wpp[^ݒ
//******************************************************************************
MTWindowSizeCfgDlg* MTWindowSizeCfgDlg::m_pThis = NULL;

//******************************************************************************
// RXgN^
//******************************************************************************
MTWindowSizeCfgDlg::MTWindowSizeCfgDlg(void)
{
	m_pThis = this;
	m_hSizeList = NULL;
	m_hEditWidth = NULL;
	m_hEditHeight = NULL;
	m_hCheckApplyToView = NULL;
	m_isSaved = false;
}

//******************************************************************************
// fXgN^
//******************************************************************************
MTWindowSizeCfgDlg::~MTWindowSizeCfgDlg(void)
{
}

//******************************************************************************
// EBhEvV[W
//******************************************************************************
INT_PTR CALLBACK MTWindowSizeCfgDlg::_WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	return m_pThis->_WndProcImpl(hWnd, message, wParam, lParam);
}

//******************************************************************************
// EBhEvV[WF
//******************************************************************************
INT_PTR MTWindowSizeCfgDlg::_WndProcImpl(
		HWND hDlg,
		UINT message,
		WPARAM wParam,
		LPARAM lParam
	)
{
	int result = 0;
	BOOL bresult = FALSE;

	UNREFERENCED_PARAMETER(lParam);

	switch (message) {
		case WM_INITDIALOG:
			result = _OnInitDlg(hDlg);
			if (result != 0) goto EXIT;
			bresult = TRUE;
			break;
		case WM_COMMAND:
			if (LOWORD(wParam) == IDOK) {
				m_isSaved = true;
				result = _Save();
				if (result != 0) goto EXIT;
				EndDialog(hDlg, LOWORD(wParam));
				bresult = TRUE;
			}
			else if (LOWORD(wParam) == IDCANCEL) {
				EndDialog(hDlg, LOWORD(wParam));
				bresult = TRUE;
			}
			//Xg{bNX
			else if (LOWORD(wParam) == IDC_WINDOWSIZE_LIST) {
				//Iԕω
				if  (HIWORD(wParam) == LBN_SELCHANGE){
					result = _OnSizeListChanged();
					if (result != 0) goto EXIT;
				}
			}
			break;
	}

EXIT:;
	if (result != 0) {
		YN_SHOW_ERR(hDlg);
	}
	return (INT_PTR)bresult;
}

//******************************************************************************
// \
//******************************************************************************
int MTWindowSizeCfgDlg::Show(
		HWND hParentWnd
	)
{
	int result = 0;
	INT_PTR dresult = 0;
	HINSTANCE hInstance = NULL;

	m_isSaved = false;

	//AvP[VCX^Xnh擾
	hInstance = (HINSTANCE)(LONG_PTR)GetWindowLongPtr(hParentWnd, GWLP_HINSTANCE);
	if (hInstance == NULL) {
		result = YN_SET_ERR("Windows API error.", GetLastError(), (DWORD64)hParentWnd);
		goto EXIT;
	}

	//_CAO\
	dresult = DialogBox(
					hInstance,							//CX^Xnh
					MAKEINTRESOURCE(IDD_WINDOWSIZE_CFG),//_CAO{bNXev[g
					hParentWnd,							//eEBhEnh
					_WndProc							//_CAO{bNXvV[W
				);
	if ((dresult == 0) || (dresult == -1)) {
		result = YN_SET_ERR("Windows API error.", GetLastError(), (DWORD64)hInstance);
		goto EXIT;
	}

EXIT:;
	return result;
}

//******************************************************************************
// ύXmF
//******************************************************************************
bool MTWindowSizeCfgDlg::IsChanged()
{
	//{͒l̕ωmFׂ
	return m_isSaved;
}

//******************************************************************************
// _CAO\O
//******************************************************************************
int MTWindowSizeCfgDlg::_OnInitDlg(
		HWND hDlg
	)
{
	int result = 0;

	//ݒt@C
	result = _InitConfFile();
	if (result != 0) goto EXIT;

	//EBhEnh擾
	m_hSizeList = GetDlgItem(hDlg, IDC_WINDOWSIZE_LIST);
	m_hEditWidth = GetDlgItem(hDlg, IDC_EDIT_WIDTH);
	m_hEditHeight = GetDlgItem(hDlg, IDC_EDIT_HEIGHT);
	m_hCheckApplyToView = GetDlgItem(hDlg, IDC_CHECK_APPLY_TO_VIEW);

	//EBhETCYIR{{bNX
	result = _InitSizeList();
	if (result != 0) goto EXIT;

	//EBhETCYGfBbg{bNX
	result = _InitSizeEditbox();
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// ݒt@C
//******************************************************************************
int MTWindowSizeCfgDlg::_InitConfFile()
{
	int result = 0;
	TCHAR userConfFilePath[_MAX_PATH] = {_T('\0')};

	result = YNPathUtil::GetAppDataDirPath(userConfFilePath, _MAX_PATH);
	if (result != 0) goto EXIT;

	_tcscat_s(userConfFilePath, _MAX_PATH, MT_USER_CONFFILE_DIR);
	_tcscat_s(userConfFilePath, _MAX_PATH, MT_USER_CONFFILE_VIEW);

	result = m_ConfFile.Initialize(userConfFilePath);
	if (result != 0) goto EXIT;

	result = m_ConfFile.SetCurSection(_T("WindowSize"));
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// EBhETCYIXg{bNX
//******************************************************************************
int MTWindowSizeCfgDlg::_InitSizeList()
{
	int result = 0;
	LRESULT lresult = 0;
	BOOL bresult = FALSE;
	unsigned long index = 0;
	int selectedIndex = -1;
	int curWidth = 0;
	int curHeight = 0;
	DEVMODE devMode;
	TCHAR caption[64];
	MTWindowSizeItem item;
	MTWindowSizeList::iterator itr;
	bool isExist = false;

	//EBhETCY擾
	result = _GetConfWindowSize(&curWidth, &curHeight);
	if (result != 0) goto EXIT;

	m_SizeList.clear();

	for (index = 0; ; index++) {

		//OtBbNX[h擾
		bresult = EnumDisplaySettings(
						NULL,		//擾ΏۃfBXvCfoCX
						index,		//OtBbN[hCfbNX
						&devMode	//擾OtBbNX[h
					);
		if (!bresult) {
			//[hꗗ擾
			break;
		}

		//rbg[x32bitȊO͖
		if (devMode.dmBitsPerPel != 32) {
			continue;
		}

		//łɃXgo^ς݂mF
		isExist = false;
		for (itr = m_SizeList.begin(); itr != m_SizeList.end(); itr++) {
			if ((itr->width == devMode.dmPelsWidth)
			 && (itr->height == devMode.dmPelsHeight)) {
				isExist = true;
				break;
			}
		}

		//Xgo^
		if (!isExist) {
			item.width = devMode.dmPelsWidth;
			item.height = devMode.dmPelsHeight;
			m_SizeList.push_back(item);
			
			//LvV쐬
			_stprintf_s(caption, 64, _T("%d x %d  32bit"), item.width, item.height);

			//EBhETCYXg{bNXɒǉ
			lresult = SendMessage(m_hSizeList, LB_ADDSTRING, 0, (LPARAM)caption);
			if ((lresult == LB_ERR) || (lresult == LB_ERRSPACE)) {
				result = YN_SET_ERR("Windows API error.", GetLastError(), (DWORD64)m_hSizeList);
				goto EXIT;
			}

			if ((item.width == curWidth) && (item.height == curHeight)) {
				selectedIndex = (int)(m_SizeList.size() - 1);
			}
		}
	}

	//XgvTCYꍇ͑IԂɂ
	if (selectedIndex >= 0) {
		lresult = SendMessage(m_hSizeList, LB_SETCURSEL, selectedIndex, 0);
		if (lresult == LB_ERR) {
			result = YN_SET_ERR("Windows API error.", GetLastError(), selectedIndex);
			goto EXIT;
		}
	}

EXIT:;
	return result;
}

//******************************************************************************
// EBhETCYGfBbg{bNX
//******************************************************************************
int MTWindowSizeCfgDlg::_InitSizeEditbox()
{
	int result = 0;
	LRESULT lresult = 0;
	int width = 0;
	int height = 0;
	int maxsize = 0;
	int applyToViewArea = 0;

	//EBhETCY擾
	result = _GetConfWindowSize(&width, &height);
	if (result != 0) goto EXIT;

	//͉\ő啶ݒF5 99,999܂
	maxsize = sizeof(TCHAR) * MT_WINDOW_SIZE_CHAR_MAX;
	SendMessage(m_hEditWidth, EM_SETLIMITTEXT, (WPARAM)maxsize, 0);
	SendMessage(m_hEditHeight, EM_SETLIMITTEXT, (WPARAM)maxsize, 0);

	//GfBbg{bNXɃEBhETCY̐lݒ
	result = _UpdateSizeEditBox(width, height);
	if (result != 0) goto EXIT;

	//r[̈KptO擾
	result = m_ConfFile.GetInt(_T("ApplyToViewArea"), &applyToViewArea, 0);
	if (result != 0) goto EXIT;

	//r[̈Kp`FbN{bNX
	if (applyToViewArea == 0) {
		SendMessage(m_hCheckApplyToView, BM_SETCHECK, BST_UNCHECKED, 0);
	}
	else {
		SendMessage(m_hCheckApplyToView, BM_SETCHECK, BST_CHECKED, 0);
	}

EXIT:;
	return result;
}

//******************************************************************************
// EBhETCYݒl擾
//******************************************************************************
int MTWindowSizeCfgDlg::_GetConfWindowSize(
		int* pWidth,
		int* pHeight
	)
{
	int result = 0;
	int width = 0;
	int height = 0;

	if ((pWidth == NULL) || (pHeight == NULL)) {
		result = YN_SET_ERR("Program error.", 0, 0);
		goto EXIT;
	}

	//EBhETCYݒl擾
	result = m_ConfFile.GetInt(_T("Width"), &width, 0);
	if (result != 0) goto EXIT;
	result = m_ConfFile.GetInt(_T("Height"), &height, 0);
	if (result != 0) goto EXIT;

	//TCYُȏꍇ͏ÑEBhETCYɍXV
	if ((width <= 0)
	  || (height <= 0)
	  || (width > MT_WINDOW_SIZE_MAX)
	  || (height > MT_WINDOW_SIZE_MAX)) {
		width = 800;
		height = 600;
	}

	*pWidth = width;
	*pHeight = height;

EXIT:;
	return result;
}

//******************************************************************************
// EBhETCYۑ
//******************************************************************************
int MTWindowSizeCfgDlg::_Save()
{
	int result = 0;
	int apiresult = 0;
	LRESULT lresult = 0;
	int width = 0;
	int height = 0;
	int applyToViewArea = 0;
	TCHAR str[32] = {_T('\0')};

	//
	apiresult = GetWindowText(m_hEditWidth, str, 32);
	if (apiresult == 0) {
		//eLXg܂̓EBhEnh̏ꍇ
		width = 0;
	}
	else {
		width = _tstoi(str);
	}

	//
	apiresult = GetWindowText(m_hEditHeight, str, 32);
	if (apiresult == 0) {
		//eLXg܂̓EBhEnh̏ꍇ
		height = 0;
	}
	else {
		height = _tstoi(str);
	}

	//NbsO
	if (width < MT_WINDOW_SIZE_MIN) {
		width = MT_WINDOW_SIZE_MIN;
	}
	if (height < MT_WINDOW_SIZE_MIN) {
		height = MT_WINDOW_SIZE_MIN;
	}

	//ݒۑ
	result = m_ConfFile.SetInt(_T("Width"), width);
	if (result != 0) goto EXIT;
	result = m_ConfFile.SetInt(_T("Height"), height);
	if (result != 0) goto EXIT;

	//r[̈Kp`FbN{bNXݒۑ
	lresult = SendMessage(m_hCheckApplyToView, BM_GETCHECK, 0, 0);
	if (lresult == BST_CHECKED) {
		applyToViewArea = 1;
	}
	result = m_ConfFile.SetInt(_T("ApplyToViewArea"), applyToViewArea);
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// EBhETCYXg{bNXIԕω
//******************************************************************************
int MTWindowSizeCfgDlg::_OnSizeListChanged()
{
	int result = 0;
	LRESULT lresult = 0;
	int selectedIndex = 0;
	MTWindowSizeItem item;
	MTWindowSizeList::iterator itr;

	//Iڂ̃CfbNX擾
	lresult = SendMessage(m_hSizeList, LB_GETCURSEL, 0, 0);
	if (lresult == LB_ERR) {
		//Ȉꍇ͉Ȃ
		goto EXIT;
	}
	else if (lresult < 0) {
		result = YN_SET_ERR("Windows API error.", GetLastError(), (DWORD64)m_hSizeList);
		goto EXIT;
	}

	//ITCY擾
	selectedIndex = (unsigned long)lresult;
	itr = m_SizeList.begin();
	advance(itr, selectedIndex);
	item = *itr;

	//GfBbg{bNXɃEBhETCY̐lݒ
	result = _UpdateSizeEditBox(item.width, item.height);
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// EBhETCYGfBbg{bNXXV
//******************************************************************************
int MTWindowSizeCfgDlg::_UpdateSizeEditBox(
		int width,
		int height
	)
{
	int result = 0;
	BOOL bresult = FALSE;
	TCHAR str[32] = {_T('\0')};

	//
	_stprintf_s(str, 32, _T("%d"), width);
	bresult = SetWindowText(m_hEditWidth, str);
	if (!bresult) {
		result = YN_SET_ERR("Windows API error.", GetLastError(), width);
		goto EXIT;
	}

	//
	_stprintf_s(str, 32, _T("%d"), height);
	bresult = SetWindowText(m_hEditHeight, str);
	if (!bresult) {
		result = YN_SET_ERR("Windows API error.", GetLastError(), height);
		goto EXIT;
	}

EXIT:;
	return result;
}

