//******************************************************************************
//
// MIDITrail / MTNoteRippleMod
//
// m[gg`ModNX
//
// Copyright (C) 2012 Yossiepon Oniichan. All Rights Reserved.
//
//******************************************************************************

#include "StdAfx.h"
#include "YNBaseLib.h"
#include "MTNoteRippleMod.h"
#include "MTNoteLyrics.h"
#include <new>

using namespace YNBaseLib;

//******************************************************************************
// RXgN^
//******************************************************************************
MTNoteRippleMod::MTNoteRippleMod(void) : MTNoteRipple()
{
	m_PlayTimeMSec = 0;
	m_CurNoteIndex = 0;
	m_pNoteStatusMod = NULL;
	ZeroMemory(m_KeyDownRate, sizeof(float) * MTNOTERIPPLE_MAX_PORT_NUM * SM_MAX_CH_NUM * SM_MAX_NOTE_NUM);
}

//******************************************************************************
// fXgN^
//******************************************************************************
MTNoteRippleMod::~MTNoteRippleMod(void)
{
	Release();
}

//******************************************************************************
// m[gg䐶
//******************************************************************************
int MTNoteRippleMod::Create(
		LPDIRECT3DDEVICE9 pD3DDevice,
		const TCHAR* pSceneName,
		SMSeqData* pSeqData,
		MTNotePitchBend* pNotePitchBend
   )
{
	int result = 0;
	SMTrack track;

	Release();

	//// NX̐Ăяo
	//result = MTNoteRipple::Create(pD3DDevice, pSceneName, pSeqData, pNotePitchBend);
	//if (result != 0) goto EXIT;

	//m[gfUCModIuWFNg
	result = m_NoteDesignMod.Initialize(pSceneName, pSeqData);
	if (result != 0) goto EXIT;

	//gbN擾
	result = pSeqData->GetMergedTrack(&track);
	if (result != 0) goto EXIT;

	//m[gXg擾FstartTime, endTime ̓A^C(msec)
	result = track.GetNoteListWithRealTime(&m_NoteListRT, pSeqData->GetTimeDivision());
	if (result != 0) goto EXIT;

	// NX̐Ăяo
	result = MTNoteRipple::Create(pD3DDevice, pSceneName, pSeqData, pNotePitchBend);
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// g̒_XV
//******************************************************************************
int MTNoteRippleMod::_TransformRipple(
		LPDIRECT3DDEVICE9 pD3DDevice
   )
{
	int result = 0;

	//XLbvȂ牽Ȃ
	if (m_isSkipping) goto EXIT;

	//g̏ԍXV
	result = _UpdateStatusOfRipple(pD3DDevice);
	if (result != 0) goto EXIT;

	//g̒_XV
	result = _UpdateVertexOfRipple(pD3DDevice);
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// g̏ԍXV
//******************************************************************************
int MTNoteRippleMod::_UpdateStatusOfRipple(
		LPDIRECT3DDEVICE9 pD3DDevice
	)
{
	int result = 0;
	unsigned long i = 0;
	bool isFound = false;
	bool isRegist = false;
	SMNote note;

	//gfBPCE[X(msec)
	unsigned long decayDuration = m_NoteDesignMod.GetRippleDecayDuration();
	unsigned long releaseDuration   = m_NoteDesignMod.GetRippleReleaseDuration();

	//m[gXV
	for (i = 0; i < MTNOTERIPPLE_MAX_RIPPLE_NUM; i++) {
		if (m_pNoteStatusMod[i].isActive) {
			//m[g擾
			result = m_NoteListRT.GetNote(m_pNoteStatusMod[i].index, &note);
			if (result != 0) goto EXIT;

			//m[gԍXV
			result = _UpdateNoteStatus(
							m_PlayTimeMSec,
							decayDuration,
							releaseDuration,
							note,
							&(m_pNoteStatusMod[i])
						);
			if (result != 0) goto EXIT;
		}
	}

	//O񌟍Iʒu甭Jnm[g
	while (m_CurNoteIndex < m_NoteListRT.GetSize()) {
		//m[g擾
		result = m_NoteListRT.GetNote(m_CurNoteIndex, &note);
		if (result != 0) goto EXIT;

		//tԂL[JnԁiJnOjɂǂĂȂΌI
		if (m_PlayTimeMSec < note.startTime) {
			break;
		}

		//m[go^
		isRegist = false;
		if ((note.startTime <= m_PlayTimeMSec) && (m_PlayTimeMSec <= note.endTime) && (note.lyric[0] == '\0')) {
			isRegist = true;
		}

		//m[go^
		//  L[~^㏸̏o^ΏۂƂĂ邽
		//  m[gŕGgꍇ邱Ƃɒӂ
		if (isRegist) {
			//łɓCfbNXœo^ς݂̏ꍇ͉Ȃ
			isFound = false;
			for (i = 0; i < MTNOTERIPPLE_MAX_RIPPLE_NUM; i++) {
				if ((m_pNoteStatusMod[i].isActive)
				 && (m_pNoteStatusMod[i].index == m_CurNoteIndex)) {
					isFound = true;
					break;
				}
			}
			//󂢂ĂƂɒǉ
			if (!isFound) {
				for (i = 0; i < MTNOTERIPPLE_MAX_RIPPLE_NUM; i++) {
					if (!(m_pNoteStatusMod[i].isActive)) {
						m_pNoteStatusMod[i].isActive = true;
						m_pNoteStatusMod[i].keyStatus = BeforeNoteON;
						m_pNoteStatusMod[i].index = m_CurNoteIndex;
						m_pNoteStatusMod[i].keyDownRate = 0.0f;
						break;
					}
				}
			}
			//m[gԍXV
			result = _UpdateNoteStatus(
							m_PlayTimeMSec,
							decayDuration,
							releaseDuration,
							note,
							&(m_pNoteStatusMod[i])
						);
			if (result != 0) goto EXIT;
		}
		m_CurNoteIndex++;
	}

EXIT:;
	return result;
}

//******************************************************************************
// m[gԍXV
//******************************************************************************
int MTNoteRippleMod::_UpdateNoteStatus(
		unsigned long playTimeMSec,
		unsigned long decayDuration,
		unsigned long releaseDuration,
		SMNote note,
		NoteStatusMod* pNoteStatus
	)
{
	int result= 0;

	//Im[g
	if(playTimeMSec > note.endTime) {
		//m[gj
		pNoteStatus->isActive = false;
		pNoteStatus->keyStatus = BeforeNoteON;
		pNoteStatus->index = 0;
		pNoteStatus->keyDownRate = 0.0f;

		goto EXIT;
	}

	unsigned long noteLen = note.endTime - note.startTime;

	float decayRatio = 0.3f;
	float sustainRatio = 0.4f;
	float releaseRatio = 0.3f;

	//gfBPCԂ蒷ꍇAfBPCԂ܂łɏC
	if(noteLen < decayDuration) {

		//decayDuration = noteLen;
		//releaseDuration = 0;

		//decayRatio = 0.3f;
		//sustainRatio = 0.0f;
		//releaseRatio = 0.0f;
	}
	//gfBPC{[XԂ蒷ꍇA[XJnԂfBPCԌoߒɏC
	else if(noteLen < (decayDuration + releaseDuration)) {

		releaseDuration = noteLen - decayDuration;
		decayRatio = 0.5f;
		sustainRatio = 0.0f;
		releaseRatio = 0.5f;
	}
	//igfBPC{[Xԁj~Qȓ̏ꍇA؂ւ_fBPCIԂƃ[XJnԂ̒Ԃɂ
	else if(noteLen < (decayDuration + releaseDuration) * 2) {

		unsigned long midTime = (note.startTime + decayDuration) / 2 + (note.endTime - releaseDuration) / 2;

		decayDuration = midTime - note.startTime;
		releaseDuration = note.endTime - midTime;

		decayRatio = 0.5f;
		sustainRatio = 0.0f;
		releaseRatio = 0.5f;
	}

	//m[gONij
	if (playTimeMSec < (note.startTime + decayDuration)) {
		pNoteStatus->keyStatus = BeforeNoteON;
		if (decayDuration == 0) {
			pNoteStatus->keyDownRate = 0.0f;
		}
		else {
			pNoteStatus->keyDownRate = decayRatio * (float)(playTimeMSec - note.startTime) / (float)decayDuration;
		}
	}
	//m[gONォ烊[XO܂
	else if (((note.startTime + decayDuration) <= playTimeMSec)
			&& (playTimeMSec <= (note.endTime - releaseDuration))) {
		pNoteStatus->keyStatus = NoteON;

		unsigned long denominator = noteLen - (decayDuration + releaseDuration);
		if(denominator > 0) {
			pNoteStatus->keyDownRate = decayRatio + sustainRatio
					* (float)(playTimeMSec - (note.startTime + decayDuration)) / (float)denominator;
		} else {
			pNoteStatus->keyDownRate = decayRatio + sustainRatio;
		}
	}
	//m[gOFFOi[Xj
	else if (((note.endTime - releaseDuration) < playTimeMSec) && (playTimeMSec <= note.endTime)) {
		pNoteStatus->keyStatus = AfterNoteOFF;
		if (releaseDuration == 0) {
			pNoteStatus->keyDownRate = 1.0f;
		}
		else {
			pNoteStatus->keyDownRate = decayRatio + sustainRatio + releaseRatio
					* (float)(playTimeMSec - (note.endTime - releaseDuration)) / (float)releaseDuration;
		}
	}

EXIT:;
	return result;
}

//******************************************************************************
// g̒_XV
//******************************************************************************
int MTNoteRippleMod::_UpdateVertexOfRipple(
		LPDIRECT3DDEVICE9 pD3DDevice
	)
{
	int result = 0;
	MTNOTERIPPLE_VERTEX* pVertex = NULL;
	D3DXMATRIX mtxWorld;
	unsigned long i = 0;
	unsigned long j = 0;
	unsigned long activeNoteNum = 0;
	bool isTimeout = false;

	if (pD3DDevice == NULL) {
		result = YN_SET_ERR("Program error.", 0, 0);
		goto EXIT;
	}

	//obt@̃bN
	result = m_Primitive.LockVertex((void**)&pVertex);
	if (result != 0) goto EXIT;

	ZeroMemory(m_KeyDownRate, sizeof(float) * MTNOTERIPPLE_MAX_PORT_NUM * SM_MAX_CH_NUM * SM_MAX_NOTE_NUM);

	// g㏑
	unsigned long overwriteTimes = m_NoteDesignMod.GetRippleOverwriteTimes();

	//m[g̔gɂĒ_XV
	for (i = 0; i < MTNOTERIPPLE_MAX_RIPPLE_NUM; i++) {
		if (m_pNoteStatusMod[i].isActive) {
			//m[g擾
			SMNote note;
			result = m_NoteListRT.GetNote(m_pNoteStatusMod[i].index, &note);
			if (result != 0) goto EXIT;

			//ΏۃL[]
			//  łɓm[gɑ΂Ē_XVĂꍇ
			//  OꍇɌ蒸_XV
			if ((note.portNo < MTNOTERIPPLE_MAX_PORT_NUM)
			 && (m_KeyDownRate[note.portNo][note.chNo][note.noteNo] < m_pNoteStatusMod[i].keyDownRate)) {
				//_XVFg̕`ʒuƃTCYς
				for(j = 0; j < overwriteTimes; j++) {
					_SetVertexPosition(
							&(pVertex[activeNoteNum*6]),	//_obt@݈ʒu
							note,							//m[g
							&(m_pNoteStatusMod[i]),			//m[g
							i								//m[gԓo^CfbNXʒu
						);
			 		activeNoteNum++;
			 	}

				m_KeyDownRate[note.portNo][note.chNo][note.noteNo] = m_pNoteStatusMod[i].keyDownRate;
			}

		}
	}
	m_ActiveNoteNum = activeNoteNum;

	//obt@̃bN
	result = m_Primitive.UnlockVertex();
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// `
//******************************************************************************
int MTNoteRippleMod::Draw(
		LPDIRECT3DDEVICE9 pD3DDevice
   )
{
	int result = 0;

	if (pD3DDevice == NULL) {
		result = YN_SET_ERR("Program error.", 0, 0);
		goto EXIT;
	}

	if (!m_isEnable) goto EXIT;

	//eNX`Xe[Wݒ
	//  J[ZFZ  1FeNX`  2F|S
	pD3DDevice->SetTextureStageState(0, D3DTSS_COLOROP,   D3DTOP_MODULATE);
	pD3DDevice->SetTextureStageState(0, D3DTSS_COLORARG1, D3DTA_TEXTURE);
	pD3DDevice->SetTextureStageState(0, D3DTSS_COLORARG2, D3DTA_DIFFUSE);
	// At@ZF1gp  1F|S
	pD3DDevice->SetTextureStageState(0, D3DTSS_ALPHAOP,   D3DTOP_MODULATE);
	pD3DDevice->SetTextureStageState(0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE);
	pD3DDevice->SetTextureStageState(0, D3DTSS_ALPHAARG2, D3DTA_DIFFUSE);

	//eNX`tB^
	pD3DDevice->SetSamplerState(0, D3DSAMP_MINFILTER, D3DTEXF_LINEAR);
	pD3DDevice->SetSamplerState(0, D3DSAMP_MAGFILTER, D3DTEXF_LINEAR);

	//_OXe[gݒFZ
	pD3DDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_ONE);
	pD3DDevice->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_SRCALPHA);

	//v~eBu`
	if (m_ActiveNoteNum > 0) {
		//obt@ŜłȂg̐ɍ킹ĕ`悷v~eBu炷
		result = m_Primitive.Draw(pD3DDevice, m_pTexture, 2 * m_ActiveNoteNum);
		if (result != 0) goto EXIT;
	}

	//_OXe[gݒFʏ̃At@
	pD3DDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA);
	pD3DDevice->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_SRCALPHA);

EXIT:;
	return result;
}

//******************************************************************************
// 
//******************************************************************************
void MTNoteRippleMod::Release()
{
	if(m_pNoteStatusMod != NULL) {
		delete [] m_pNoteStatusMod;
		m_pNoteStatusMod = NULL;
	}

	MTNoteRipple::Release();
}

//******************************************************************************
// m[gz񐶐
//******************************************************************************
int MTNoteRippleMod::_CreateNoteStatus()
{
	int result = 0;
	unsigned long i = 0;

	//m[gz񐶐
	try {
		m_pNoteStatusMod = new NoteStatusMod[MTNOTERIPPLE_MAX_RIPPLE_NUM];
	}
	catch (std::bad_alloc) {
		result = YN_SET_ERR("Could not allocate memory.", 0, 0);
		goto EXIT;
	}

	for (i = 0; i < MTNOTERIPPLE_MAX_RIPPLE_NUM; i++) {
		m_pNoteStatusMod[i].isActive = false;
		m_pNoteStatusMod[i].keyStatus = BeforeNoteON;
		m_pNoteStatusMod[i].index = 0;
		m_pNoteStatusMod[i].keyDownRate = 0.0f;
	}

EXIT:;
	return result;
}

//******************************************************************************
// _
//******************************************************************************
int MTNoteRippleMod::_CreateVertex(
		LPDIRECT3DDEVICE9 pD3DDevice
	)
{
	int result = 0;
	unsigned long vertexNum = 0;
	MTNOTERIPPLE_VERTEX* pVertex = NULL;

	// g㏑
	unsigned long overwriteTimes = m_NoteDesignMod.GetRippleOverwriteTimes();

	//v~eBu
	result = m_Primitive.Initialize(
					sizeof(MTNOTERIPPLE_VERTEX),//_TCY
					_GetFVFFormat(),			//_FVFtH[}bg
					D3DPT_TRIANGLELIST			//v~eBu
				);
	if (result != 0) goto EXIT;

	//_obt@
	vertexNum = 6 * MTNOTERIPPLE_MAX_RIPPLE_NUM * overwriteTimes;
	result = m_Primitive.CreateVertexBuffer(pD3DDevice, vertexNum);
	if (result != 0) goto EXIT;

	//obt@̃bN
	result = m_Primitive.LockVertex((void**)&pVertex);
	if (result != 0) goto EXIT;

	ZeroMemory(pVertex, sizeof(MTNOTERIPPLE_VERTEX) * 6 * MTNOTERIPPLE_MAX_RIPPLE_NUM * overwriteTimes);

	//obt@̃bN
	result = m_Primitive.UnlockVertex();
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// _̍Wݒ
//******************************************************************************
int MTNoteRippleMod::_SetVertexPosition(
		MTNOTERIPPLE_VERTEX* pVertex,
		SMNote note,
		NoteStatusMod* pNoteStatus,
		unsigned long rippleNo
	)
{
	int result = 0;
	unsigned long i = 0;
	float rh, rw = 0.0f;
	float spacing = 0.0f;
	float alpha = 0.0f;
	D3DXVECTOR3 center;
	D3DXCOLOR color;
	short pbValue = 0;
	unsigned char pbSensitivity = SM_DEFAULT_PITCHBEND_SENSITIVITY;

	pbValue =       m_pNotePitchBend->GetValue(note.portNo, note.chNo);
	pbSensitivity = m_pNotePitchBend->GetSensitivity(note.portNo, note.chNo);

	//m[g{bNXSW擾
	center = m_NoteDesign.GetNoteBoxCenterPosX(
					m_CurTickTime,
					note.portNo,
					note.chNo,
					note.noteNo,
					pbValue,
					pbSensitivity
				);

	//gTCY
	rh = m_NoteDesignMod.GetRippleHeight(pNoteStatus->keyDownRate);
	rw = m_NoteDesignMod.GetRippleWidth(pNoteStatus->keyDownRate);

	//g`Ԋu
	spacing = m_NoteDesignMod.GetRippleSpacing();

	//`ImF
	if ((rh <= 0.0f) || (rw <= 0.0f)) {
		goto EXIT;
	}

	//gĐʏォJɏĕ`悷
	//܂g䓯mꕽʏŏdȂȂ悤ɕ`悷
	//  Zt@CeBOɂĔ邿₩
	//  OtBbNJ[hɂČۂقȂ
	if (center.x < m_CamVector.x) {
		center.x -= spacing * (MTNOTELYRICS_MAX_LYRICS_NUM + MTNOTERIPPLE_MAX_RIPPLE_NUM - (rippleNo + 1));
	}
	else {
		center.x -= spacing * (MTNOTELYRICS_MAX_LYRICS_NUM + rippleNo + 1);
	}

	//_W
	pVertex[0].p = D3DXVECTOR3(center.x, center.y+(rh/2.0f), center.z+(rw/2.0f));
	pVertex[1].p = D3DXVECTOR3(center.x, center.y+(rh/2.0f), center.z-(rw/2.0f));
	pVertex[2].p = D3DXVECTOR3(center.x, center.y-(rh/2.0f), center.z+(rw/2.0f));
	pVertex[3].p = pVertex[2].p;
	pVertex[4].p = pVertex[1].p;
	pVertex[5].p = D3DXVECTOR3(center.x, center.y-(rh/2.0f), center.z-(rw/2.0f));

	//@
	for (i = 0; i < 6; i++) {
		pVertex[i].n = D3DXVECTOR3(-1.0f, 0.0f, 0.0f);
	}

	//xXɗƂ
	alpha = m_NoteDesignMod.GetRippleAlpha(pNoteStatus->keyDownRate);

	//e_̃fBt[YF
	for (i = 0; i < 6; i++) {
		color = m_NoteDesign.GetNoteBoxColor(
			note.portNo,
			note.chNo,
			note.noteNo
		);
		pVertex[i].c = D3DXCOLOR(color.r, color.g, color.b, alpha);
	}

	//eNX`W
	pVertex[0].t = D3DXVECTOR2(0.0f, 0.0f);
	pVertex[1].t = D3DXVECTOR2(1.0f, 0.0f);
	pVertex[2].t = D3DXVECTOR2(0.0f, 1.0f);
	pVertex[3].t = pVertex[2].t;
	pVertex[4].t = pVertex[1].t;
	pVertex[5].t = D3DXVECTOR2(1.0f, 1.0f);

EXIT:
	return result;
}

//******************************************************************************
// }eA쐬
//******************************************************************************
void MTNoteRippleMod::_MakeMaterial(
		D3DMATERIAL9* pMaterial
	)
{
	ZeroMemory(pMaterial, sizeof(D3DMATERIAL9));
	
	//gU
	pMaterial->Diffuse.r = 1.0f;
	pMaterial->Diffuse.g = 1.0f;
	pMaterial->Diffuse.b = 1.0f;
	pMaterial->Diffuse.a = 1.0f;
	//Fe̐F
	pMaterial->Ambient.r = 0.5f;
	pMaterial->Ambient.g = 0.5f;
	pMaterial->Ambient.b = 0.5f;
	pMaterial->Ambient.a = 1.0f;
	//ʔˌ
	pMaterial->Specular.r = 0.2f;
	pMaterial->Specular.g = 0.2f;
	pMaterial->Specular.b = 0.2f;
	pMaterial->Specular.a = 1.0f;
	//ʔˌ̑Nx
	pMaterial->Power = 10.0f;
	//F
	pMaterial->Emissive.r = 0.5f;
	pMaterial->Emissive.g = 0.5f;
	pMaterial->Emissive.b = 0.5f;
	pMaterial->Emissive.a = 1.0f;
}

//******************************************************************************
// tԐݒ
//******************************************************************************
void MTNoteRippleMod::SetPlayTimeMSec(
		unsigned long playTimeMsec
	)
{
	m_PlayTimeMSec = playTimeMsec;
}

//******************************************************************************
// Zbg
//******************************************************************************
void MTNoteRippleMod::Reset()
{
	unsigned long i = 0;

	m_PlayTimeMSec = 0;
	m_CurTickTime = 0;
	m_CurNoteIndex = 0;
	m_ActiveNoteNum = 0;

	for (i = 0; i < MTNOTERIPPLE_MAX_RIPPLE_NUM; i++) {
		m_pNoteStatusMod[i].isActive = false;
		m_pNoteStatusMod[i].keyStatus = BeforeNoteON;
		m_pNoteStatusMod[i].index = 0;
		m_pNoteStatusMod[i].keyDownRate = 0.0f;
	}

	return;
}
