//******************************************************************************
//
// MIDITrail / MTNoteBox
//
// m[g{bNX`NX
//
// Copyright (C) 2010-2012 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

// MEMO:
// m[g{bNX`悷B

#pragma once

#include <d3d9.h>
#include <d3dx9.h>
#include "SMIDILib.h"
#include "DXPrimitive.h"
#include "MTNoteDesign.h"
#include "MTNotePitchBend.h"

using namespace SMIDILib;


//******************************************************************************
// p[^`
//******************************************************************************
//ő唭m[g`搔
#define MTNOTEBOX_MAX_ACTIVENOTE_NUM  (100)

// TODO: ő唭m[g`搔ςɂ
//   OɃV[PXf[^̍ő哯𒲍Ă
//   mۂobt@TCYύXł
//   łobt@TCY͏_œIɕύX\ł


//******************************************************************************
// m[g{bNX`NX
//******************************************************************************
class MTNoteBox
{
public:

	//RXgN^^fXgN^
	MTNoteBox(void);
	virtual ~MTNoteBox(void);

	//
// >>> modify 20120728 yossiepon begin
	virtual int Create(
// <<< modify 20120728 yossiepon end
			LPDIRECT3DDEVICE9 pD3DDevice,
			const TCHAR* pSceneName,
			SMSeqData* pSeqData,
			MTNotePitchBend* pNotePitchBend
		);

	//XV
// >>> modify 20120728 yossiepon begin
	virtual int Transform(LPDIRECT3DDEVICE9 pD3DDevice, float rollAngle);
// <<< modify 20120728 yossiepon end

	//`
	int Draw(LPDIRECT3DDEVICE9 pD3DDevice);

	//
// >>> modify 20120728 yossiepon begin
	virtual void Release();
// <<< modify 20120728 yossiepon end

	//t`bN^Co^
	void SetCurTickTime(unsigned long curTickTime);

	//Zbg
// >>> modify 20120728 yossiepon begin
	virtual void Reset();
// <<< modify 20120728 yossiepon end

	//XLbv
	void SetSkipStatus(bool isSkipping);

private:

	//m[g\
	struct NoteStatus {
		bool isActive;
		bool isHide;
		unsigned long index;
		unsigned long startTime;
	};

// >>> modify access level to protected 20161224 yossiepon begin
protected:
// <<< modify 20161224 yossiepon end

	//_obt@\
	struct MTNOTEBOX_VERTEX {
		D3DXVECTOR3 p;	//_W
		D3DXVECTOR3 n;	//@
		DWORD		c;	//fBt[YF
	};

// >>> modify access level to protected 20161224 yossiepon begin
// <<< modify 20161224 yossiepon end

	//m[gfUC
	MTNoteDesign m_NoteDesign;

	//m[gXg
	SMNoteList m_NoteList;

	//Sm[g{bNX
	DXPrimitive m_PrimitiveAllNotes;

	//m[g{bNX
	DXPrimitive m_PrimitiveActiveNotes;
	unsigned long m_CurTickTime;
	unsigned long m_CurNoteIndex;
	unsigned long m_ActiveNoteNum;

// >>> modify access level 20161224 yossiepon begin
private:
// <<< modify 20161224 yossiepon end

	NoteStatus* m_pNoteStatus;

	//XLbv
	bool m_isSkipping;

// >>> modify access level to protected 20161224 yossiepon begin
protected:
// <<< modify 20161224 yossiepon end

	//sb`xh
	MTNotePitchBend* m_pNotePitchBend;

// >>> modify access level 20161224 yossiepon begin
private:
// <<< modify 20161224 yossiepon end

	//_obt@FVFtH[}bg
	DWORD _GetFVFFormat(){ return (D3DFVF_XYZ | D3DFVF_NORMAL | D3DFVF_DIFFUSE); }

	int _CreateAllNoteBox(LPDIRECT3DDEVICE9 pD3DDevice);
	int _CreateActiveNoteBox(LPDIRECT3DDEVICE9 pD3DDevice);

// >>> modify access level to protected 20161224 yossiepon begin
protected:
// <<< modify 20161224 yossiepon end

// >>> modify 20120728 yossiepon begin
	virtual int _CreateNoteStatus();
// <<< modify 20120728 yossiepon end

	int _CreateVertexOfNote(
			SMNote note,
			MTNOTEBOX_VERTEX* pVertex,
			unsigned long vertexOffset,
			unsigned long* pIbIndex,
			unsigned long elapsedTime = 0xFFFFFFFF,
			bool isEnablePitchBend = false
		);

// >>> modify access level 20161224 yossiepon begin
private:
// <<< modify 20161224 yossiepon end

	unsigned long _GetVertexIndexOfNote(unsigned long index);

	void _MakeMaterial(D3DMATERIAL9* pMaterial);
	void _MakeMaterialForActiveNote(D3DMATERIAL9* pMaterial);

// >>> modify access level to protected 20161224 yossiepon begin
protected:
// <<< modify 20161224 yossiepon end

	int _TransformActiveNotes(LPDIRECT3DDEVICE9 pD3DDevice);
// >>> modify 20120728 yossiepon begin
	virtual int _UpdateStatusOfActiveNotes(LPDIRECT3DDEVICE9 pD3DDevice);
	virtual int _UpdateVertexOfActiveNotes(LPDIRECT3DDEVICE9 pD3DDevice);
// <<< modify 20120728 yossiepon end

	int _HideNoteBox(unsigned long index);
	int _ShowNoteBox(unsigned long index);

};


