//******************************************************************************
//
// MIDITrail / MTSceneTitle
//
// ^CgV[`NX
//
// Copyright (C) 2010 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#pragma once

#include <d3d9.h>
#include <d3dx9.h>
#include "DXCamera.h"
#include "DXDirLight.h"
#include "MTScene.h"
#include "MTLogo.h"
#include "SMIDILib.h"

using namespace SMIDILib;


//******************************************************************************
// p[^`
//******************************************************************************
//JZW
#define MTSCENETITLE_CAMERA_POSZ  (-80.0f)

//JZWω
#define MTSCENETITLE_CAMERA_POSZ_DELTA  (0.05f)


//******************************************************************************
// ^CgV[`NX
//******************************************************************************
class MTSceneTitle : public MTScene
{
public:

	//RXgN^^fXgN^l
	MTSceneTitle(void);
	virtual ~MTSceneTitle(void);

	//̎擾
	const TCHAR* GetName();

	//
	int Create(
			HWND hWnd,
			LPDIRECT3DDEVICE9 pD3DDevice,
			SMSeqData* pSeqData
		);

	//ϊ
	int Transform(LPDIRECT3DDEVICE9 pD3DDevice);

	//`
	int Draw(LPDIRECT3DDEVICE9 pD3DDevice);

	//j
	void Release();

private:

	//JʒuZ
	float m_CamPosZ;

	//J
	DXCamera m_Camera;

	//Cg
	DXDirLight m_DirLight;

	//S`IuWFNg
	MTLogo m_Logo;

};

