//******************************************************************************
//
// MIDITrail / MTPianoKeyboardDesignMod
//
// sAmL[{[hfUCModNX
//
// Copyright (C) 2012 Yossiepon Oniichan. All Rights Reserved.
//
//******************************************************************************

#pragma once

#include "MTPianoKeyboardDesign.h"


//******************************************************************************
// sAmL[{[hfUCModNX
//******************************************************************************
class MTPianoKeyboardDesignMod : public MTPianoKeyboardDesign
{
public:

	//RXgN^^fXgN^
	MTPianoKeyboardDesignMod(void);
	virtual ~MTPianoKeyboardDesignMod(void);

	//
	virtual int Initialize(const TCHAR* pSceneName, SMSeqData* pSeqData);

	//L[{[hW擾
	D3DXVECTOR3 GetKeyboardBasePos(
			int keyboardIndex,
			float angle
		);

	//|[g_W擾
	float GetPortOriginX();
	float GetPortOriginY(int keyboardIndex, bool flip);
	float GetPortOriginZ(int keyboardIndex, bool flip);

	//m[g{bNXE擾
	float GetNoteBoxHeight();
	float GetNoteBoxWidth();

	//m[gԊu擾
	float GetNoteStep();

	//`lԊu擾
	float GetChStep();

	//L[{[hE擾
	float GetKeyboardHeight();
	float GetKeyboardWidth();

	//ObhE擾
	float GetGridHeight();
	float GetGridWidth();

	//|[gE擾
	float GetPortHeight();
	float GetPortWidth();

	//ĐʍE擾
	float GetPlaybackSectionHeight();
	float GetPlaybackSectionWidth();

	//g`Ԋu擾
	float GetRippleSpacing();

	//g`}[W擾
	float GetRippleMargin();

	//L[{[hTCY擾
	float GetKeyboardResizeRatio();

	//L[J[擾
	D3DXCOLOR GetActiveKeyColor(
			unsigned char chNo,
			unsigned char noteNo,
			unsigned long elapsedTime,
			D3DXCOLOR* pNoteColor = NULL
		);

protected:

	virtual void _Initialize();
	virtual int _LoadConfFile(const TCHAR* pSceneName);

private:

	//m[g{bNX
	float m_NoteBoxHeight;
	//m[g{bNX
	float m_NoteBoxWidth;
	//m[gԊu
	float m_NoteStep;
	//`lԊu
	float m_ChStep;

	//g`Ԋu
	float m_RippleSpacing;

	//L[F
	D3DXCOLOR m_ActiveKeyColorList[16];

};


