//******************************************************************************
//
// MIDITrail / MTScene
//
// MIDITrail V[NX
//
// Copyright (C) 2010-2016 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#pragma once

#include "DXScene.h"
#include "SMIDILib.h"
#include <string>
#include <map>

using namespace SMIDILib;

#pragma warning(disable:4251)


//******************************************************************************
// MIDITrail V[NX
//******************************************************************************
class MTScene : public DXScene
{
public:

	enum EffectType {
		EffectPianoKeyboard,
		EffectRipple,
		EffectPitchBend,
		EffectStars,
		EffectCounter,
		EffectBackgroundImage,
		EffectFileName,
// >>> add 20180404 yossiepon begin
		EffectTimeIndicator,
		EffectGridBox,
// <<< add 20180404 yossiepon end
	};

	typedef std::map<std::string, float>  MTViewParamMap;
	typedef std::pair<std::string, float> MTViewParamMapPair;

public:

	//RXgN^^fXgN^
	MTScene(void);
	virtual ~MTScene(void);

	//̎擾
	virtual const TCHAR* GetName();

	//
	virtual int Create(
					HWND hWnd,
					LPDIRECT3DDEVICE9 pD3DDevice,
					SMSeqData* pSeqData
				);

	//ϊ
	virtual int Transform(LPDIRECT3DDEVICE9 pD3DDevice);

	//`
	virtual int Draw(LPDIRECT3DDEVICE9 pD3DDevice);

	//j
	virtual void Release();

	//EBhENbNCxgM
	virtual int OnWindowClicked(
					UINT button,
					WPARAM wParam,
					LPARAM lParam
				);

	//tJnCxgM
	virtual int OnPlayStart(LPDIRECT3DDEVICE9 pD3DDevice);

	//tICxgM
	virtual int OnPlayEnd(LPDIRECT3DDEVICE9 pD3DDevice);

	//V[PTbZ[WM
	virtual int OnRecvSequencerMsg(
					unsigned long param1,
					unsigned long param2
				);

	//߂
	virtual int Rewind();

	//_擾^o^
	virtual void GetDefaultViewParam(MTViewParamMap* pParamMap);
	virtual void GetViewParam(MTViewParamMap* pParamMap);
	virtual void SetViewParam(MTViewParamMap* pParamMap);

	//_Zbg
	virtual void ResetViewpoint();

	//\ʐݒ
	virtual void SetEffect(EffectType type, bool isEnable);

	//txݒ
	virtual void SetPlaySpeedRatio(unsigned long ratio);

	//p[^o^^擾
	int SetParam(const char* pKey, const char* pValue);
	const char* GetParam(const char* pKey);

protected:

	typedef std::map<std::string, std::string> MTSceneParamDictionary;
	typedef std::pair<std::string, std::string> MTSceneParamDictionaryPair;

	//V[p[^
	MTSceneParamDictionary m_SceneParamDictionary;

};

#pragma warning(default:4251)


