/* Copyright 1995, 1996, 1998, 1999, 2000, 2003, 2004, 2005
   Free Software Foundation, Inc.

 * SPDX-License-Identifier:	GPL-2.0+
 */

#include "config.h"
#if defined(CONFIG_ARMV7M)
	.syntax	unified
	.arch	armv7-m
	.thumb
	.thumb_func
	.type 	__ashrdi3, %function
	.type	__aeabi_lasr, %function
#endif
	
#ifdef __ARMEB__
#define al r1
#define ah r0
#else
#define al r0
#define ah r1
#endif

.globl __ashrdi3
.globl __aeabi_lasr
__ashrdi3:
__aeabi_lasr:
#ifdef __thumb__
	lsr	al, r2
	mov	r3, ah
	asr	ah, r2
	sub	r2, #32
	@ If r2 is negative at this point the following step would OR
	@ the sign bit into all of AL.  That's not what we want...
	bmi	1f
	mov	ip, r3
	asr	r3, r2
	orr	al, r3
	mov	r3, ip
1:
	neg	r2, r2
	lsl	r3, r2
	orr	al, r3
	mov	pc, lr
#else
	subs	r3, r2, #32
	rsb	ip, r2, #32
	movmi	al, al, lsr r2
	movpl	al, ah, asr r3
	orrmi	al, al, ah, lsl ip
	mov	ah, ah, asr r2
	mov	pc, lr
#endif
