/* Copyright 1995, 1996, 1998, 1999, 2000, 2003, 2004, 2005
   Free Software Foundation, Inc.

 * SPDX-License-Identifier:	GPL-2.0+
 */

#include "config.h"
#if defined(CONFIG_ARMV7M)
	.syntax	unified
	.arch	armv7-m
	.thumb
	.thumb_func
	.type	__lshrdi3, %function
	.type	__aeabi_llsr, %function
#endif

#ifdef __ARMEB__
#define al r1
#define ah r0
#else
#define al r0
#define ah r1
#endif

.globl __lshrdi3
.globl __aeabi_llsr
__lshrdi3:
__aeabi_llsr:
#ifdef __thumb__
	lsr	al, r2
	mov	r3, ah
	lsr	ah, r2
	mov	ip, r3
	sub	r2, #32
	lsr	r3, r2
	orr	al, r3
	neg	r2, r2
	mov	r3, ip
	lsl	r3, r2
	orr	al, r3
	mov	pc, lr
#else
	subs	r3, r2, #32
	rsb	ip, r2, #32
	movmi	al, al, lsr r2
	movpl	al, ah, lsr r3
	orrmi	al, al, ah, lsl ip
	mov	ah, ah, lsr r2
	mov	pc, lr
#endif
