/*
 * Copyright (C) 2011 Yoshinori Sato
 * (C) Copyright 2000-2003
 *     Wolfgang Denk, DENX Software Engineering, wd@denx.de.
 *
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#include <common.h>
#include <spi.h>
#include <mmc.h>
#include <asm/io.h>
#include <asm/processor.h>
#include <asm/sections.h>
#include <linux/usb/r8a66597.h>

int checkboard(void)
{
	puts("BOARD: Ultimate 62N\n");
	return 0;
}

void sdram_init(void)
{
	*(volatile unsigned char *)0x00083c00 = 0x00;
	*(volatile unsigned char *)0x00083c10 = 0x00;
	*(volatile unsigned char *)0x00083c16 = 0x00;
	*(volatile unsigned short *)0x00083c24 = 0x0588;
	*(volatile unsigned char *)0x00083c20 = 0x01;
	while(*(volatile unsigned char *)0x00083c50 & 0x08);

	*(volatile unsigned char *)0x00083c00 = 0x10;
	*(volatile unsigned short *)0x00083c48 = 0x0020;
	while(*(volatile unsigned char *)0x00083c50 & 0x01);
	
	*(volatile unsigned long *)0x00083c44 = 0x00020202;
	*(volatile unsigned char *)0x00083c40 = 0x00;

	*(volatile unsigned short *)0x00083c14 = 0x32e0;
	*(volatile unsigned char *)0x00083c02 = 0x01;
	*(volatile unsigned char *)0x00083c16 = 0x01;
	*(volatile unsigned char *)0x00083c10 = 0x00;

	*(volatile unsigned char *)0x00083c00 = 0x11;
	memset(__bss_start, 0, (void *)&__bss_end - (void *)__bss_start);
}

int board_early_init_f(void)
{
	*(volatile unsigned long *)0x00080010 &= ~0x00008000;
	*(volatile unsigned long *)0x00080014 &= ~0xc0000000;
	*(volatile unsigned char *)0x0008c062 |= 0x02;
	*(volatile unsigned char *)0x0008c10f |= 0x02;
	*(volatile unsigned char *)0x0008c06b |= 0x04;
	*(volatile unsigned char *)0x0008c008 |= 0x10;

#if defined(CONFIG_SH_ETHER)
	*(volatile unsigned long *)0x00080014 &= ~0x00008000;
#endif
#if defined(CONFIG_SPI_FLASH) || defined(CONFIG_MMC_SPI)
	*(volatile unsigned char *)0x0008c063 |= 0x01;
	*(volatile unsigned long *)0x00080014 &= ~0x00010000;
	*(volatile unsigned char *)0x0008c111 |= 0x0e;
#endif
#if defined(CONFIG_SPI_FLASH)
	*(volatile unsigned char *)0x0008c023 |= 0x02;
	*(volatile unsigned char *)0x0008c003 |= 0x02;
#endif
#if defined(CONFIG_MMC_SPI)
	*(volatile unsigned char *)0x0008c006 |= 0x01;
	*(volatile unsigned char *)0x0008c026 |= 0x01;
#endif
#if defined(CONFIG_USB_R8A66597_HCD)
	*(volatile unsigned long *)0x00080014 &= ~0x00040000;
	*(volatile unsigned char *)0x0008c115 = 0x1d;
	*(volatile unsigned char *)0x0008c061 |= 0xa0;
#endif
#if defined(CONFIG_USB_GADGET_R8A66597)
	*(volatile unsigned long *)0x00080014 &= ~0x00080000;
	*(volatile unsigned char *)0x0008c114 = 0x1c;
	*(volatile unsigned char *)0x0008c061 |= 0x50;
#endif
	sdram_init();
	return 0;
}

int board_late_init(void)
{
	int i;
	DECLARE_GLOBAL_DATA_PTR;
#if defined(CONFIG_MMC_SPI)
	mmc_initialize(gd->bd);
#endif

#if defined(CONFIG_USB_GADGET_R8A66597)
	static struct r8a66597_platdata r8a66597pd = {
		.port_power = NULL,
		.buswait = 0,
		.on_chip = ON_CHIP_RX600,
		.xtal = 0,
		.vif = 1,
		.wr0_shorted_to_wr1 = 0,
	};
	r8a66597_probe(&r8a66597pd);
#endif
	for (i = 0; i < 200; i++) {
		if (i & 1)
			*(volatile unsigned char *)0x0008c028 |= 0x10;
		else
			*(volatile unsigned char *)0x0008c028 &= ~0x10;
		udelay(300);
	}
	*(volatile unsigned char *)0x0008c028 &= ~0x10;
	return 0;
}

#if defined(CONFIG_SPI_FLASH) || defined(CONFIG_MMC_SPI)
int spi_cs_is_valid(unsigned int bus, unsigned int cs)
{
	return (bus == 1) && ((cs == 0) || (cs == 1));
}

void spi_cs_activate(struct spi_slave *slave)
{
	switch(slave->cs) {
	case 0:
		*(volatile unsigned char *)0x0008c023 &= ~0x02;
		break;
	case 1:
		*(volatile unsigned char *)0x0008c026 &= ~0x01;
		break;
	}
}

void spi_cs_deactivate(struct spi_slave *slave)
{
	switch(slave->cs) {
	case 0:
		*(volatile unsigned char *)0x0008c023 |= 0x02;
		break;
	case 1:
		*(volatile unsigned char *)0x0008c026 |= 0x01;
		break;
	}
}
#endif
