/**************************************************************************
  This code is only a stub.
 **************************************************************************/


package org.omegat.util;

/**
 * A class to retrieve some platform information.
 * 
 * @author: Zoltan Bartko bartkozoltan@bartkozoltan.com
 * @author Alex Buloichik (alex73mail@gmail.com)
 */
public final class Platform {
    public enum OsType {
        // os.arch=amd64, os.name=Linux, os.version=3.0.0-12-generic
        LINUX64,
        // os.arch=i386, os.name=Linux, os.version=3.0.0-12-generic
        LINUX32,
        // os.arch=x86_64, os.name=Mac OS X, os.version=10.6.8
        MAC64,
        // os.arch=i386, os.name=Mac OS X, os.version=10.6.8
        MAC32,
        // os.arch=amd64, os.name=Windows 7, os.version=6.1
        WIN64,
        // os.arch=x86, os.name=Windows 7, os.version=6.1
        WIN32,
        // unknown system
        OTHER
    }

    private static OsType osType = OsType.OTHER;

    static {
        String osName = System.getProperty("os.name");
        String osArch = System.getProperty("os.arch");
        if (osName != null && osArch != null) {
            if (osName.startsWith("Linux")) {
                osType = osArch.contains("64") ? OsType.LINUX64 : OsType.LINUX32;
            } else if (osName.startsWith("Mac")) {
                osType = osArch.contains("64") ? OsType.MAC64 : OsType.MAC32;
            } else if (osName.startsWith("Windows")) {
                osType = osArch.contains("64") ? OsType.WIN64 : OsType.WIN32;
            }
        }
    }

    private Platform() {
    }

    public static OsType getOsType() {
        return osType;
    }

    public static final boolean isWebStart() {
        return System.getProperty("javawebstart.version") != null;
    }
}
