/**************************************************************************
 Moenizer - Allow to set background image for OmegaT.
 
 Copyright (C) 2014 Yu Tang
               Home page: http://sourceforge.jp/users/yu-tang/
               Support center: http://sourceforge.jp/users/yu-tang/pf/Moenizer/

 This file is part of plugin for OmegaT.
 http://www.omegat.org/

 License: GNU GPL version 3 or (at your option) any later version.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **************************************************************************/

package jp.sourceforge.users.yutang.omegat.plugin.moenizer;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.omegat.core.Core;
import org.omegat.util.gui.UIThreadsUtil;
import org.omegat.util.Log;
import org.openide.awt.Mnemonics;

/**
 *
 * @author Yu Tang
 */
public class MenuHandler implements ActionListener {

    private final String ACTION_COMMAND_NAME = "optionsMoenizerMenuItem";

    private JMenuItem menuMoenizer = null;
    private final Runnable runner;

    public MenuHandler(Runnable runner) {
        this.runner = runner;
        this.menuMoenizer = getMoenizerMenu();
    }

    private JMenuItem getMoenizerMenu() {
        JMenu optionsMenu = Core.getMainWindow().getMainMenu().getOptionsMenu();

        // Check if setting menu item for Moenizer exists
        Component[] menuComponents = optionsMenu.getMenuComponents();
        for (Component c : menuComponents) {
            if (c instanceof JMenuItem) {
                JMenuItem m = (JMenuItem) c;
                if (ACTION_COMMAND_NAME.equals(m.getActionCommand())) {
                    return m;
                }
            }
        }

        // Create menu item and add it to the parent menu
        JMenuItem item = createMenuItem(L10n.Key.MOENIZER_MENU_LABEL,
                                          L10n.Key.MOENIZER_MENU_TOOLTIP);
        return optionsMenu.add(item);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        // Logging user action
        Log.logInfoRB("LOG_MENU_CLICK", ACTION_COMMAND_NAME);

        // execute action
        if (runner != null) {
            UIThreadsUtil.executeInSwingThread(runner);
        }
    }

    private JMenuItem createMenuItem(final L10n.Key titleKey, final L10n.Key tooltipKey) {
        JMenuItem result = new JMenuItem();
        Mnemonics.setLocalizedText(result, L10n.get(titleKey));
        result.setToolTipText(L10n.get(tooltipKey));
        result.setActionCommand(ACTION_COMMAND_NAME);
        result.addActionListener(this);
        return result;
    }

}
