/**************************************************************************
 Moenizer - Allow to set background image for OmegaT.
 
 Copyright (C) 2013-2014 Yu Tang
               Home page: http://sourceforge.jp/users/yu-tang/
               Support center: http://sourceforge.jp/users/yu-tang/pf/Moenizer/

 This file is part of plugin for OmegaT.
 http://www.omegat.org/

 License: GNU GPL version 3 or (at your option) any later version.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **************************************************************************/

package jp.sourceforge.users.yutang.omegat.plugin.moenizer;

import groovy.util.ConfigObject;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.events.IApplicationEventListener;
import org.omegat.util.Log;

/**
 * allow to set background image
 * 
 * @author Yu-Tang
 */
public class Moenizer implements IApplicationEventListener {

    private static boolean instantiated = false;

    private MoeUI ui;
    private MoeConfig config;
    private ThemeChanger themeChanger;
    private MenuHandler menu;

    public static void loadPlugins() {
        try {
            // Not initialize in console mode
            if (!instantiated) {
                CoreEvents.registerApplicationEventListener(new Moenizer());
                instantiated = true;
            } else {
                throw new RuntimeException("Moenizer plugin could be instantiated only once.");
            }
        } catch (Throwable ex) {
            String msg = ex.getMessage();
            Log.logErrorRB("LD_ERROR", msg);
            Core.pluginLoadingError(msg);
        }
   }

    public static void unloadPlugins() {
        // do nothing
    }

    @Override
    public void onApplicationStartup() {
        try {
            config = new MoeConfig(MoeUtil.getMoeConfigFile());
            ui = MoeUI.getInstance();
            menu = new MenuHandler(new Runnable() {
                @Override
                public void run() {
                    showSettingDialog();
                }
            });
            themeChanger = new ThemeChanger(ui);
            themeChanger.setTheme(config.getCurrentConfig());

            // この時点でコンポーネントの透過設定をしても反映されない（タイミング？）。
            // Workaround として、invokeLater でキューに突っ込んで、後で処理する。
            SwingUtilities.invokeLater(new Runnable() {
                @Override
                public void run() {
                    CoreEvents.unregisterApplicationEventListener(Moenizer.this);
                    themeChanger.apply();
                }
            });
            //CoreEvents.unregisterApplicationEventListener(this); // ここで発行すると、スレッドエラーになるので注意
        } catch (Exception e) {
            Log.log("Error raised at " + this.getClass().getCanonicalName() + ".onApplicationStartup()\n" + e);
            e.printStackTrace();
        }
    }

    @Override
    public void onApplicationShutdown() {
        // not used.
    }

    private void showSettingDialog() {
        //@@TODO 前処理 -- 自動保存中断など
        Set<ConfigObject> sortedConfigs = config.getSortedConfigs();
        MoeConfigEditDialog dialog = new MoeConfigEditDialog(sortedConfigs, themeChanger);
        dialog.setSize(400, 200); //@@TODO remain size
        dialog.setLocationRelativeTo(null); // positioning at the center of the screen
        dialog.setVisible(true);
        onConfigUpdate();
        //@@TODO 後処理 -- 自動保存再開など
    }

    private void onConfigUpdate() {
        Log.log("-- onConfigUpdate()"); //@@TODO 要・実装
    }

}
