/**************************************************************************
 Moenizer - Allow to set background image for OmegaT.
 
 Copyright (C) 2014 Yu Tang
               Home page: http://sourceforge.jp/users/yu-tang/
               Support center: http://sourceforge.jp/users/yu-tang/pf/Moenizer/

 This file is part of plugin for OmegaT.
 http://www.omegat.org/

 License: GNU GPL version 3 or (at your option) any later version.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **************************************************************************/

package jp.sourceforge.users.yutang.omegat.plugin.moenizer;

import groovy.util.ConfigObject;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import jp.sourceforge.users.yutang.omegat.plugin.moenizer.effect.Effect;
import org.omegat.util.Log;

/**
 *
 * @author Yu-Tang
 */
public class ThemeChanger {
    
    private final int THREAD_NUM = 2;
    private final MoeUI model;
    private ConfigObject theme = null;
    private ScheduledThreadPoolExecutor service = null;

    public ThemeChanger(MoeUI ui) {
        this.model = ui;
    }

    public void setTheme(ConfigObject theme) {
        this.theme = theme;

        // check constraints
        //@@TODO 整合性チェック。たとえば、mainWindow 対象の処理が複数ある、など
        //@@TODO MainWindow の透過除外パーツに、後続指定のペインを含める
    }

    public void apply() {
        // immediately shutdown old tasks
        if (service != null) {
            service.shutdownNow();
            service = null;
        }

        // no theme, no effects
        if (theme == null || !theme.containsKey("effects")) { //@@TODO literal to const
            return;
        }

        // get effect list (ArrayList)
        List<ConfigObject> effects = (List<ConfigObject>) theme.get("effects"); //@@TODO literal to const
        if (effects.isEmpty()) {
            return;
        }

        service = new ScheduledThreadPoolExecutor(THREAD_NUM);

        // apply effects
        for (Map conf: effects) {
            try {
                Effect.Type type = conf.containsKey("type") ?
                        (Effect.Type) conf.get("type") : Effect.Type.Basic;
                Effect effect = Effect.create(type, conf);
                effect.invoke(model, service);
            } catch (Exception ex) {
                ex.printStackTrace();
                Log.log("Error on ThemeChanger#apply(): " + ex.getMessage());
            }
        }
    }
}
