/**************************************************************************
 Moenizer - Allow to set background image for OmegaT.
 
 Copyright (C) 2014 Yu Tang
               Home page: http://sourceforge.jp/users/yu-tang/
               Support center: http://sourceforge.jp/users/yu-tang/pf/Moenizer/

 This file is part of plugin for OmegaT.
 http://www.omegat.org/

 License: GNU GPL version 3 or (at your option) any later version.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **************************************************************************/

package jp.sourceforge.users.yutang.omegat.plugin.moenizer;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicRootPaneUI;

/**
 * 背景をカスタマイズ可能な <code>RootPaneUI</code> です。
 * OmegaT のメインウィンドウ（フレーム）の内部構成は、次のような階層構造に
 * なっています。
 * <pre>
 * JRootPane
 *     + layeredPane (JLayeredPane)
 *     |   + JMenuBar
 *     |   + contentPane (Component)
 *     + glassPane (Component)
 * </pre>
 * 本クラスは、この中の <code>JRootPane</code> 用の UI 代替クラスです。
 * 本来の <code>UI</code> を本クラスのインスタンスで置き換えることにより、
 * 背景をカスタマイズします。
 * 
 * @author Yu-Tang
 */
public class MoeRootPaneUI extends BasicRootPaneUI implements IMoePaneUI {

    private MoeUIDelegator uiDelegator = null;

    public MoeRootPaneUI() {
        super();
        uiDelegator = new MoeUIDelegator();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);

        uiDelegator.setComponent(c);
    }

    @Override
    public BufferedImage getBackgroundImage() {
        return uiDelegator.getBackgroundImage();
    }

    @Override
    public void setBackgroundImage(BufferedImage image) {
        uiDelegator.setBackgroundImage(image);
    }

    @Override
    public Color getBackgroundColor() {
        return uiDelegator.getBackgroundColor();
    }

    @Override
    public void setBackgroundColor(Color color) {
        uiDelegator.setBackgroundColor(color);
    }

    @Override
    public void setMarginTop(int marginTop) {
        uiDelegator.setMarginTop(marginTop);
    }

    public void setOpacity(float opacity) {
        uiDelegator.setOpacity(opacity);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        uiDelegator.paintBackground(g);
    }
}
