/**************************************************************************
 Moenizer - Allow to set background image for OmegaT.
 
 Copyright (C) 2014 Yu Tang
               Home page: http://sourceforge.jp/users/yu-tang/
               Support center: http://sourceforge.jp/users/yu-tang/pf/Moenizer/

 This file is part of plugin for OmegaT.
 http://www.omegat.org/

 License: GNU GPL version 3 or (at your option) any later version.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **************************************************************************/

package jp.sourceforge.users.yutang.omegat.plugin.moenizer.effect;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import javax.imageio.ImageIO;
import jp.sourceforge.users.yutang.omegat.plugin.moenizer.MoeUI;
import jp.sourceforge.users.yutang.omegat.plugin.moenizer.MoeUI.Parts;
import org.omegat.util.Log;

/**
 *
 * @author Yu-Tang
 */
public class BasicEffect extends Effect {

    private final String KEY_TARGET = "target";
    private final String KEY_OPACITY = "opacity";
    private final String KEY_IMAGE = "image";
    private final String KEY_PATH = "path";
    private final String KEY_BGCOLOR = "bgColor";
    private final String KEY_EXCLUDE = "exclude";

    private Parts target = Parts.MainWindow;
    private float opacity = 0.5f;
    private String image = "";
    private Color bgColor = null;
    private List<Parts> exclude = new ArrayList<Parts>();

    public BasicEffect(Map<String, Object> config) {
        target = get(KEY_TARGET, config, target);
        if (config.containsKey(KEY_IMAGE)) {
            Map conf = (Map) config.get(KEY_IMAGE);
            image = get(KEY_PATH, conf, image);
            opacity = get(KEY_OPACITY, conf, opacity);
        }
        Integer rgb = get(KEY_BGCOLOR, config, null);
        if (rgb != null) {
            bgColor = new Color(rgb);
        }
        exclude = get(KEY_EXCLUDE, config, exclude);
    }

    @Override
    public void invoke(MoeUI ui, ScheduledThreadPoolExecutor service) {
        EnumSet<Parts> excludeParts = EnumSet.noneOf(Parts.class);
        for (Parts part: EnumSet.allOf(Parts.class)) {
            if (exclude.contains(part)) {
                excludeParts.add(part);
            }
        }

        if (!image.isEmpty()) {
            try {
                String lcased = image.toLowerCase();
                if (lcased.startsWith("http://") || lcased.startsWith("https://")) {
                    ui.setBackground(target, ImageIO.read(new URL(image)));
                } else {
                    ui.setBackground(target, ImageIO.read(new File(image)));
                }
            } catch (MalformedURLException ex) {
                Log.log(ex.getMessage());
            } catch (IOException ex) {
                Log.log(ex.getMessage());
            }
        }

        ui.setOpacity(target, opacity);

        ui.setBackground(target, bgColor);

        ui.transparent(target, excludeParts);
    }
    
}
