/**************************************************************************
 Stats2Excel - open Statistics with Excel from standard Tools menu.
 
 Copyright (C) 2013 Yu Tang
               Home page: http://sourceforge.jp/users/yu-tang/
               Support center: http://sourceforge.jp/users/yu-tang/pf/

 This file is part of plugin for OmegaT.
 http://www.omegat.org/

 License: GNU GPL version 3 or (at your option) any later version.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **************************************************************************/

package jp.sourceforge.users.yutang.omegat.plugin.stats2excel;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.omegat.gui.stat.StatisticsWindow;
import org.omegat.util.Log;
import org.omegat.util.StaticUtils;

/**
 *
 * @author Yu Tang
 */
public class SplashStatisticsWindow extends StatisticsWindow {

    private ScheduledExecutorService service = null;
    private boolean isErrorOnDisplay = false;
    private boolean isWindowClosing = false;

    public SplashStatisticsWindow(STAT_TYPE statType) {
        super(statType);
        
        this.addWindowListener(new WindowAdapter() {

            @Override
            public void windowClosing(WindowEvent e) {
                isWindowClosing = true;
                if (service != null && !service.isShutdown()) {
                    service.shutdown();
                    service = null;
                }
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
                if (! isWindowClosing) {
                    dispose();
                }
            }
        });
        setSize(400, 100);
    }

    @Override
    public void displayData(String result) {
        try {
            if (result == null) {
                throw new Exception("Error: Statistcs result is empty.");
            }

            setText(L10n.getProgressMsgLaunchingExcel());

            String title = StaticUtils.format(
                    L10n.getExcelWindowTitle(),
                    getTitle());
            ExcelModel.setWindowTitle(title);
            ExcelModel.display(result);
        } catch (Exception ex) {
            isErrorOnDisplay = true;
            Log.log(ex);
            setText(ex.getMessage());
        }
    }

    @Override
    public void finishData() {
        if (isErrorOnDisplay) {
            return;
        }

        service = Executors.newSingleThreadScheduledExecutor();
        service.scheduleWithFixedDelay(new Runnable() {

        @Override
        public void run() {
            try {
                if (ExcelModel.activate()) {
                    service.shutdown();
                    service = null;
                }
            } catch (IOException ex) {
                Log.log(ex);
                setText(ex.getLocalizedMessage());
                service.shutdown();
                service =null;
            } catch (InterruptedException ex) {
                Log.log(ex);
                setText(ex.getLocalizedMessage());
                service.shutdown();
                service =null;
            }
        }
        }, 0, 500, TimeUnit.MILLISECONDS);
    }

    private void setText(String text) {
        super.displayData(text);
    }
}
