/**************************************************************************
 Stats2Excel - open Statistics with Excel from standard Tools menu.
 
 Copyright (C) 2013-2014 Yu Tang
               Home page: http://sourceforge.jp/users/yu-tang/
               Support center: http://sourceforge.jp/users/yu-tang/pf/

 This file is part of plugin for OmegaT.
 http://www.omegat.org/

 License: GNU GPL version 3 or (at your option) any later version.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **************************************************************************/

package jp.sourceforge.users.yutang.omegat.plugin.stats2excel;

import java.util.Comparator;
import java.util.ResourceBundle;
import org.apache.lucene.util.StringHelper;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.util.Log;
import static org.omegat.util.Platform.OsType.WIN32;
import static org.omegat.util.Platform.OsType.WIN64;
import static org.omegat.util.Platform.getOsType;
import org.omegat.util.StaticUtils;

/**
 * open Statistics with Excel from standard Tools menu
 *
 * @author Yu Tang
 */
public class Stats2Excel {

    private static final String __VERSION_KEY = "version";
    
    public static void loadPlugins() {
        try {
            final String OMT_VERSION = ResourceBundle.getBundle(
                    "org/omegat/Version").getString(__VERSION_KEY);
            if (! isAvailableOmTVersion(OMT_VERSION)) {
                throw new RuntimeException(L10n.getLoadingErrorVersionTooOld());
            }

            if (! isWindows()) {
                throw new RuntimeException(L10n.getLoadingErrorWrongPlatform());
            }

            // Not initialize in console mode.
            CoreEvents.registerApplicationEventListener(
                    StatsController.getInstance());
        } catch (Throwable ex) {
            String msg = StaticUtils.format(L10n.getLoadingErrorFormat(), 
                    ex.getMessage());
            Log.logErrorRB(msg);
            Core.pluginLoadingError(msg);
        }
   }
    
    public static void unloadPlugins() {
        // do nothing
    }

    private static boolean isWindows() {
        switch (getOsType()) {
            case WIN64:
            case WIN32:
                return true;
        }
        return false;
    }

    private static boolean isAvailableOmTVersion(String version) {
        Comparator<String> comp = StringHelper.getVersionComparator();
        return (comp.compare(version, "3.0.7") >= 0);
    }

}