/*
 * The MIT License (MIT)
 * 
 * Copyright (c) 2014 Yuki SAKAI
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 ******************************************************************************/

/*******************************************************************************
 * Include ********************************************************************/
#if !defined(REMPIC_H__)
#  include <rempic.h>
#endif
#if !defined(_STDIO_H_) && !defined(_STDIO_H)
#  include <stdio.h>
#endif
#if !defined(_STRING_H_) && !defined(_STRING_H)
#  include <string.h>
#endif
#if !defined(_STDLIB_H_) && !defined(_STDLIB_H)
#  include <stdlib.h>
#endif
#if !defined(_UNISTD_H_) && !defined(_UNISTD_H)
#  include <unistd.h>
#endif

/*//========================================================================\\*
 *|| GIF check                                                              ||*
 *\\========================================================================//*/
/*******************************************************************************
 * gif check(gif) *************************************************************/
void gif_chk (int fd, picInfo *pinfo)
{
  unsigned int  masize;
  unsigned char *ifpot, *ifoff, br;
  off_t         rlen, off_set;
  int           i, rrtn;
  
  pinfo->fm = 0;
  /*******************************************************************
   * Get File size and allocate memory ******************************/
  masize = MIN((unsigned int)pinfo->fsize, (unsigned int)MAXMALLOCSIZE);
  
  if (masize<=20) {pinfo->fm = 1; return ;}
  if ((ifpot=(unsigned char *)malloc_init (masize))==NULL) {return ;}
  ifoff = ifpot;
  br = rlen = off_set = 0;

  
  /*-Get packet info from input file and dividing flow Start--------*/
  while ((rrtn=read (fd, ifoff, (masize-rlen)))>=0) {
    rlen = (off_t)rrtn + rlen;
    if (rlen<0) {free (ifpot); return;}
    ifoff = ifpot;
    if (off_set==0 && rlen==0) {pinfo->fm = 1; br=1; break;}

    /*-Get packet info from read data Start-------------------------*/
    if (off_set==0) { /* Signature Check */
      if (!(*(ifoff+0)==0x47 && *(ifoff+1)==0x49 && *(ifoff+2)==0x46)) {pinfo->fm = 1; return ;}
      else if (!((*(ifoff+3)==0x38 && *(ifoff+4)==0x37 && *(ifoff+5)==0x61) ||
		 (*(ifoff+3)==0x38 && *(ifoff+4)==0x39 && *(ifoff+5)==0x61))) {pinfo->fm = 1; return ;}
      pinfo->img_x = (unsigned int)(*(ifoff+7))<<8|(unsigned int)(*(ifoff+6));
      pinfo->img_y = (unsigned int)(*(ifoff+9))<<8|(unsigned int)(*(ifoff+8));
      if (1 && FLGCHK(flags, FLGDEBUGMODE)) {printf ("img_x: %ld, img_y: %ld\n", pinfo->img_x, pinfo->img_y);}
      break;
    }
    
    /*-Get packet info from read data End---------------------------*/
    for (i=0; i<rlen; i++) {*(ifpot+i) = *(ifoff+i);}
    ifoff = ifpot + rlen;
  }
  if (pinfo->img_x==0 || pinfo->img_y==0) {pinfo->fm = 1;}
  /*-Get packet info from input file and dividing flow End----------*/
  free (ifpot);

  return ;
}

