/*
 * The MIT License (MIT)
 * 
 * Copyright (c) 2014 Yuki SAKAI
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 ******************************************************************************/

/*******************************************************************************
 * Include ********************************************************************/
#if !defined(REMPIC_H__)
#  include <rempic.h>
#endif
#if !defined(_STDIO_H_) && !defined(_STDIO_H)
#  include <stdio.h>
#endif
#if !defined(_STRING_H_) && !defined(_STRING_H)
#  include <string.h>
#endif
#if !defined(_SYS_TYPES_H_) && !defined(_SYS_TYPES_H)
#  include <sys/types.h>
#endif
#if !defined(_DIRENT_H_) && !defined(_DIRENT_H)
#  include <dirent.h>
#endif
#if !defined(_ERRNO_H_) && !defined(_ERRNO_H)
#  include <errno.h>
#endif


/*******************************************************************************
 * Open directory *************************************************************/
int open_dir (spname *pspn)
{
  struct dirent entry, *result;
  DIR           *dfd;
  int           i;

  if (pspn->ft!=SPFTDIR) {return PPRABORT;}

  errno = 0;
  if ((dfd=opendir ((char *)pspn->path))==NULL) {
    switch (errno) {
    case EACCES : fprintf (patherr, "%s: Can't access this directory\n", pspn->path); break;
    case EMFILE : fprintf (patherr, "%s: Can't open file descriptor\n" , pspn->path); break;
    case ENFILE : fprintf (patherr, "%s: Many file is open\n"          , pspn->path); break;
    case ENOENT : fprintf (patherr, "%s: No such file or directory\n"  , pspn->path); break;
    case ENOMEM : fprintf (patherr, "%s: Empty memory\n"               , pspn->path); break;
    case ENOTDIR: fprintf (patherr, "%s: Path is not directory\n"      , pspn->path); break;
    }
    return PPRALLKILL;
    if (errno==ENOMEM) {
      return PPRALLKILL;
    }
    return PPRABORT;
  }

  /*****************************************************************************
   * path Count in directory **************************************************/
  pspn->fnum = 0;
  while (1) {
    errno = 0;
    if (readdir_r (dfd, &entry, &result)!=0) {
      switch (errno) {
      case EBADF : fprintf (patherr, "%s: Can't read dir\n" , pspn->path); break;
      case ENOENT: fprintf (patherr, "%s: Don't open dir\n" , pspn->path); break;
      case EFAULT: fprintf (patherr, "%s: Open dir failed\n", pspn->path); break;
      }
      closedir (dfd);
      return PPRABORT;
    } else if (result==NULL) {break;}

    if (result->d_name[strlen (result->d_name)-1]=='/') {result->d_name[strlen (result->d_name)-1] = 0;}

    if      (strcmp (result->d_name, "." )==0) {continue;}
    else if (strcmp (result->d_name, "..")==0) {continue;}

    if (result->d_name[0]=='.' && !FLGCHK(flags, FLGALLFILES)) {continue;}
    pspn->fnum++;
  }
  
  /*****************************************************************************
   * Get path name init *******************************************************/
  if (pspn->fnum==0) {pspn->farray = NULL; return PPRABORT;}
  else if ((pspn->farray=malloc_init ((sizeof (spname)*pspn->fnum)))==NULL) {
    fprintf (stderr, "Memory allocate error for path name\n");
    return PPRALLKILL;
  }
  rewinddir (dfd);
  i = 0;

  /*****************************************************************************
   * Get path name ************************************************************/
  while (1) {
    errno = 0;
    if (readdir_r (dfd, &entry, &result)!=0) {
      switch (errno) {
      case EBADF : fprintf (patherr, "%s: Can't read dir\n" , pspn->path); break;
      case ENOENT: fprintf (patherr, "%s: Don't open dir\n" , pspn->path); break;
      case EFAULT: fprintf (patherr, "%s: Open dir failed\n", pspn->path); break;
      }
      closedir (dfd);
      return PPRABORT;
    } else if (result==NULL) {

      break;}

    if (result->d_name[strlen (result->d_name)-1]=='/') {result->d_name[strlen (result->d_name)-1] = 0;}

    if      (strcmp (result->d_name, "." )==0) {continue;}                 /* skip "." path          */
    else if (strcmp (result->d_name, "..")==0) {continue;}                 /* skip ".." path         */
    if (result->d_name[0]=='.' && !FLGCHK(flags, FLGALLFILES)) {continue;} /* skip? ".hogehoge" path */

    snprintf ((char *)pspn->farray[i].path, MAXPATHLEN-1, "%s/%s", pspn->path, result->d_name);
    i++;
  }

  closedir (dfd);
  return 1;
}





