/*
 * The MIT License (MIT)
 * 
 * Copyright (c) 2014 Yuki SAKAI
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 ******************************************************************************/

/*******************************************************************************
 * Include ********************************************************************/
#if !defined(REMPIC_H__)
#  include <rempic.h>
#endif
#if !defined(_SYS_PARAM_H_) && !defined(_SYS_PARAM_H)
#  include <sys/param.h>
#endif
#if !defined(_STRING_H_) && !defined(_STRING_H)
#  include <string.h>
#endif
#if !defined(_STDLIB_H_) && !defined(_STDLIB_H)
#  include <stdlib.h>
#endif
#if !defined(_UNISTD_H_) && !defined(_UNISTD_H)
#  include <unistd.h>
#endif


/*******************************************************************************
 * Size transfer **************************************************************/
static off_t SizeTransfer (char *str)
{
  char chk;
  int rlen, shift;
  unsigned int idx, isize;
  double dsize;
  
  shift = chk = 0;
  rlen = strlen (str);
  for (idx=0; idx<rlen; idx++) {
    if (idx==(rlen-1)) {
      if ('0'<=str[idx] && str[idx]<='9') {}
      else if (str[idx]=='k' || str[idx]=='K') {shift=10; str[idx]=0x00;}
      else if (str[idx]=='m' || str[idx]=='M') {shift=20; str[idx]=0x00;}
      else if (str[idx]=='g' || str[idx]=='G') {shift=30; str[idx]=0x00;}
    } else {
      if ('0'<=str[idx] && str[idx]<='9') {}
      else if (chk==0 && str[idx]=='.')   {chk = 1;}
      else {return -1;}
    }
  }
  dsize   = strtod (str, NULL);
  isize   = (int)(dsize * (double)(1<<shift));
  /*printf ("size: %u\n", isize);*/
  return (off_t)isize;
}

/*******************************************************************************
 * Option *********************************************************************/
int opt_proc (int argc, char **argv)
{
  int i;
  int ch;

  /*****************************************************************************
   * Option init **************************************************************/
  pname          = *argv;
  patherr        = stdout;
  debugout       = stdout;
  TargetFileType = 0;
  UpperSize = LowerSize = 0;

  /*****************************************************************************
   * Get Option ***************************************************************/
  while ((ch = getopt (argc, argv, "abrS:s:X:x:Y:y:Dh?"))>=0) {
    switch (ch) {
    case 'a': FLGSET(&flags, FLGALLFILES);     break;
    case 'b': FLGSET(&flags, FLGRMPICBADFILE); break;
    case 'r': FLGSET(&flags, FLGRECURSIVE);    break;
    case 's': FLGSET(&flags, FLGRMLOWERSIZE);  if ((LowerSize = SizeTransfer (optarg))==-1) {usage ();}; break;
    case 'S': FLGSET(&flags, FLGRMUPPERSIZE);  if ((UpperSize = SizeTransfer (optarg))==-1) {usage ();}; break;
    case 'x': FLGSET(&flags, FLGRMLOWERX);     LowerX    = (unsigned int)atoi (optarg); break;
    case 'X': FLGSET(&flags, FLGRMUPPERX);     UpperX    = (unsigned int)atoi (optarg); break;
    case 'y': FLGSET(&flags, FLGRMLOWERY);     LowerY    = (unsigned int)atoi (optarg); break;
    case 'Y': FLGSET(&flags, FLGRMUPPERY);     UpperY    = (unsigned int)atoi (optarg); break;
    case 'D': FLGSET(&flags, FLGDEBUGMODE);    break;
    case 'h': case '?': default:
      usage ();
    }
  }
  argc -= optind;
  argv += optind;

  /*****************************************************************************
   * Option After process *****************************************************/
  if (TargetFileType==0) {TargetFileType = GEXTGRAPHICALL;}

  FirstPathNum = argc;
  if ((patharray=malloc_init ((sizeof (spname)*argc)))==NULL) {
    fprintf (stderr, "Memory allocate error for path name\n");
    return 0;
  }
  for (i=0; i<argc; i++) {
    memcpy ((patharray+i)->path, *(argv+i), MIN(MAXPATHLEN, strlen (*(argv+i))));
    if ((patharray+i)->path[strlen (*(argv+i))-1]=='/') {
      (patharray+i)->path[strlen (*(argv+i))-1] = 0;
    }
  }

  return 1;
}
